/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.pur.business.PurOrderBillHelper;

public final class PurInStockHelper {
    private static Log logger = LogFactory.getLog(PurInStockHelper.class);
    private static IAppCache SCM_PUR_INSTOCK_CACHE = AppCache.get((String)"scm-pur-instock");

    public static void tryProxySaveKeyUpdate(String proxyEntity, DynamicObject[] dynamicObjects) {
        boolean needExecute = Boolean.FALSE;
        for (DynamicObject bill : dynamicObjects) {
            if (!PurInStockHelper.tryExecuteInStockUpdate(bill.getString("id")).booleanValue()) continue;
            needExecute = Boolean.TRUE;
        }
        if (needExecute) {
            PurInStockHelper.proxySaveKeyUpdate(proxyEntity, dynamicObjects);
        }
    }

    public static void proxySaveKeyUpdate(String proxyEntity, DynamicObject[] dynamicObjects) {
        ArrayList<Object> newdyns = new ArrayList<Object>(dynamicObjects.length);
        DynamicObjectCollection entrycol = null;
        for (DynamicObject dyn : dynamicObjects) {
            boolean iswriteoff = false;
            entrycol = dyn.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entrycol) {
                BigDecimal unmatchqty = entry.getBigDecimal("unmatchqty");
                BigDecimal qty = entry.getBigDecimal("qty");
                if (unmatchqty == null || unmatchqty.compareTo(BigDecimal.ZERO) == 0 || unmatchqty.compareTo(qty) >= 0) continue;
                iswriteoff = true;
                break;
            }
            if (iswriteoff) continue;
            newdyns.add(dyn.getPkValue());
        }
        if (newdyns.size() > 0) {
            logger.info("\u8c03\u7528iscsave\uff1a" + Arrays.toString(newdyns.toArray()));
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            OperationResult result = OperationServiceHelper.executeOperate((String)"iscsave", (String)proxyEntity, (DynamicObject[])BusinessDataServiceHelper.load((Object[])newdyns.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)proxyEntity)), (OperateOption)option);
            logger.info("\u8c03\u7528iscsave\u662f\u5426\u6210\u529f:" + result.isSuccess() + result.getSuccessPkIds());
        }
    }

    public static void deletePurInStockExecuteCache(String pkValue) {
        SCM_PUR_INSTOCK_CACHE.remove(pkValue);
    }

    public static Boolean tryExecuteInStockUpdate(String pkValue) {
        boolean check = false;
        String canExecute = (String)SCM_PUR_INSTOCK_CACHE.get(pkValue, String.class);
        if (!"false".equalsIgnoreCase(canExecute)) {
            SCM_PUR_INSTOCK_CACHE.put(pkValue, (Object)"false");
            check = true;
        }
        return check;
    }

    public static void updateAutoConfirmStatus(DynamicObject[] dyns) {
        HashSet<String> poEntryIds = new HashSet<String>(16);
        DynamicObjectCollection entryCol = null;
        for (DynamicObject dyn : dyns) {
            entryCol = dyn.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entryCol) {
                poEntryIds.add(entry.getString("poentryid"));
            }
        }
        DynamicObject[] unConfirmOrders = PurOrderBillHelper.getUnConfirmOrder(poEntryIds);
        if (unConfirmOrders != null && unConfirmOrders.length > 0) {
            PurOrderBillHelper.changePurOrderStatus(unConfirmOrders);
        }
    }
}

