/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.DiscountTypeEnum;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.util.BussinessTypeUtils;
import kd.scm.common.util.ParamUtil;
import kd.scm.pur.business.bean.InvoiceBillDecomposeData;
import kd.scm.pur.business.bean.InvoiceBillPushData;
import kd.scm.pur.business.bean.PushApBillResp;
import kd.scm.pur.common.PurInvoiceUtil;

public final class PurInvoiceHelper {
    private static Log log = LogFactory.getLog(PurInvoiceHelper.class);
    private static final String IM_PURINBILL = "im_purinbill";
    private static final String IM_PURRECEIVEBILL = "im_purreceivebill";
    private static final String PM_PURACCEPTBILL = "pm_puracceptbill";
    private static final String IM_MDC_OMCMPLINBILL = "im_mdc_omcmplinbill";
    private static final String PM_PURORDER_ENTRY = "billentry";
    private static final String IM_PURINBILL_ENTRY = "billentry";
    private static final String AP_FINAPBILL = "ap_finapbill";

    public static List<PushApBillResp> batchPushApBill(DynamicObject[] bills) {
        ArrayList<PushApBillResp> result = new ArrayList<PushApBillResp>(8);
        InvoiceBillDecomposeData decomposeData = PurInvoiceHelper.decomposeBySrcType(bills);
        HashMap<Long, InvoiceBillPushData> instockInvoiceEntryData = new HashMap<Long, InvoiceBillPushData>(8);
        instockInvoiceEntryData.putAll(PurInvoiceHelper.assembleInvoiceEntryData("pur_instock", decomposeData.getSrmInvoiceBillEntryMap(), decomposeData.getPurinbillEntryIdListMap(), instockInvoiceEntryData));
        instockInvoiceEntryData.putAll(PurInvoiceHelper.assembleInvoiceEntryData("pur_return", decomposeData.getSrmInvoiceBillEntryMap(), decomposeData.getPurinReturnbillEntryIdListMap(), instockInvoiceEntryData));
        HashMap<Long, InvoiceBillPushData> receiptInvoiceEntryData = new HashMap<Long, InvoiceBillPushData>(8);
        receiptInvoiceEntryData.putAll(PurInvoiceHelper.assembleInvoiceEntryData("pur_receipt", decomposeData.getSrmInvoiceBillEntryMap(), decomposeData.getReciveEntryIdListMap(), receiptInvoiceEntryData));
        receiptInvoiceEntryData.putAll(PurInvoiceHelper.assembleInvoiceEntryData("pur_receipt", decomposeData.getSrmInvoiceBillEntryMap(), decomposeData.getReceiveacceptbillEntryIdListMap(), receiptInvoiceEntryData));
        if (instockInvoiceEntryData.isEmpty() && receiptInvoiceEntryData.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u4e0d\u7b26\u5408\u751f\u6210\u5e94\u4ed8\u7684\u6761\u4ef6:\u672a\u627e\u5230\u5165\u5e93\u6216\u6536\u8d27\u6e90\u5355\u3002", (String)"PurInvoiceHelper_7", (String)"scm-pur-business", (Object[])new Object[0]));
        }
        String ruleId = PurInvoiceHelper.getRuleId();
        HashSet<String> billnoSet = new HashSet<String>(8);
        for (DynamicObject bill : bills) {
            List<String> receiveacceptbillEntryIdList;
            Map<Long, List<String>> receiveacceptbillEntryIdListMap;
            List<String> reciveEntryIdList;
            InvoiceBillPushData invoiceRecBillPushData;
            Long pkId = bill.getLong("id");
            Boolean linetypecontrolcriterion = decomposeData.getSrmInvoiceLinetypecontrolcriterionMap().get(pkId);
            InvoiceBillPushData invoiceInBillPushData = (InvoiceBillPushData)instockInvoiceEntryData.get(pkId);
            if (invoiceInBillPushData != null) {
                String sourceEntity = IM_PURINBILL;
                String invoiceBussinessNum = invoiceInBillPushData.getBussinessTypeNumber();
                if (BussinessTypeUtils.isOmBussinessType((String)invoiceBussinessNum)) {
                    ruleId = null;
                    sourceEntity = IM_MDC_OMCMPLINBILL;
                }
                invoiceInBillPushData.setLinetypecontrolcriterion(linetypecontrolcriterion);
                invoiceInBillPushData.setRuleId(ruleId);
                invoiceInBillPushData.setBillKey(sourceEntity);
                invoiceInBillPushData.setEntryKey("billentry");
                PurInvoiceHelper.buildResult(result, billnoSet, bill, pkId, invoiceInBillPushData);
            }
            if ((invoiceRecBillPushData = (InvoiceBillPushData)receiptInvoiceEntryData.get(pkId)) == null) continue;
            invoiceRecBillPushData.setLinetypecontrolcriterion(linetypecontrolcriterion);
            invoiceRecBillPushData.setRuleId(null);
            Map<Long, List<String>> reciveEntryIdListMap = decomposeData.getReciveEntryIdListMap();
            if (!CollectionUtils.isEmpty(reciveEntryIdListMap) && !CollectionUtils.isEmpty(reciveEntryIdList = reciveEntryIdListMap.get(pkId))) {
                invoiceRecBillPushData.setBillKey(IM_PURRECEIVEBILL);
                invoiceRecBillPushData.setEntryKey("billentry");
                PurInvoiceHelper.buildResult(result, billnoSet, bill, pkId, invoiceRecBillPushData);
            }
            if (CollectionUtils.isEmpty(receiveacceptbillEntryIdListMap = decomposeData.getReceiveacceptbillEntryIdListMap()) || CollectionUtils.isEmpty(receiveacceptbillEntryIdList = receiveacceptbillEntryIdListMap.get(pkId))) continue;
            invoiceRecBillPushData.setBillKey(PM_PURACCEPTBILL);
            invoiceRecBillPushData.setEntryKey("billentry");
            PurInvoiceHelper.buildResult(result, billnoSet, bill, pkId, invoiceRecBillPushData);
        }
        return result;
    }

    private static void buildResult(List<PushApBillResp> result, Set<String> billnoSet, DynamicObject bill, Long pkId, InvoiceBillPushData invoiceInBillPushData) {
        String billno = bill.getString("billno");
        try {
            billnoSet.addAll(PurInvoiceHelper.doPushApBill(bill, invoiceInBillPushData));
            PushApBillResp resp = new PushApBillResp(pkId, billnoSet, true, "");
            result.add(resp);
        }
        catch (Throwable e) {
            PushApBillResp resp = new PushApBillResp(pkId, billnoSet, false, billno + e.getMessage());
            result.add(resp);
        }
    }

    private static InvoiceBillDecomposeData decomposeBySrcType(DynamicObject[] bills) {
        InvoiceBillDecomposeData result = new InvoiceBillDecomposeData();
        for (DynamicObject bill : bills) {
            DynamicObjectCollection cols = bill.getDynamicObjectCollection("entryentity1");
            DynamicProperty linetype1 = cols.getDynamicObjectType().getProperty("linetype1");
            ArrayList<String> purinbillEntryIdList = new ArrayList<String>(8);
            ArrayList<String> purinReturnbillEntryIdList = new ArrayList<String>(8);
            ArrayList<String> reciveEntryIdList = new ArrayList<String>(8);
            ArrayList<String> receiveacceptbillEntryIdList = new ArrayList<String>(8);
            HashMap<String, DynamicObject> srmInvoiceEntryMap = new HashMap<String, DynamicObject>(8);
            boolean linetypecontrolcriterion = false;
            Long pkId = bill.getLong("id");
            block14: for (DynamicObject row : cols) {
                if ("1".equals(row.get("isentrypay"))) continue;
                String srcBillType = row.getString("srcbilltype1");
                String srcEntryid = row.getString("srcentryid1");
                srmInvoiceEntryMap.put(srcEntryid, row);
                switch (srcBillType) {
                    case "pur_instock": 
                    case "scp_instock": {
                        purinbillEntryIdList.add(srcEntryid);
                        break;
                    }
                    case "pur_return": 
                    case "scp_return": {
                        purinReturnbillEntryIdList.add(srcEntryid);
                        break;
                    }
                    case "pur_receipt": 
                    case "scp_receipt": {
                        if (linetype1 != null) {
                            DynamicObject value = (DynamicObject)linetype1.getValue((Object)row);
                            if (value != null && value.getBoolean("acceptance")) {
                                receiveacceptbillEntryIdList.add(srcEntryid);
                                if (linetypecontrolcriterion || !"1".equals(value.getString("controlcriterion"))) continue block14;
                                linetypecontrolcriterion = true;
                                break;
                            }
                            reciveEntryIdList.add(srcEntryid);
                            break;
                        }
                        reciveEntryIdList.add(srcEntryid);
                        break;
                    }
                }
            }
            result.getSrmInvoiceLinetypecontrolcriterionMap().put(pkId, linetypecontrolcriterion);
            if (!CollectionUtils.isEmpty(purinbillEntryIdList)) {
                result.getPurinbillEntryIdListMap().put(pkId, purinbillEntryIdList);
            }
            if (!CollectionUtils.isEmpty(purinReturnbillEntryIdList)) {
                result.getPurinReturnbillEntryIdListMap().put(pkId, purinReturnbillEntryIdList);
            }
            if (!CollectionUtils.isEmpty(reciveEntryIdList)) {
                result.getReciveEntryIdListMap().put(pkId, reciveEntryIdList);
            }
            if (!CollectionUtils.isEmpty(srmInvoiceEntryMap)) {
                result.getSrmInvoiceBillEntryMap().put(pkId, srmInvoiceEntryMap);
            }
            if (CollectionUtils.isEmpty(receiveacceptbillEntryIdList)) continue;
            result.getReceiveacceptbillEntryIdListMap().put(pkId, receiveacceptbillEntryIdList);
        }
        return result;
    }

    private static Set<String> doPushApBill(DynamicObject bill, InvoiceBillPushData invoiceBillPushData) {
        List<Map<String, Object>> paramsInv;
        List<Map<String, Object>> params;
        List<Object> targetBillIds;
        Set<String> billnoSet = new HashSet<String>(8);
        Map<String, DynamicObject> erpRecInvoiceEntryMap = invoiceBillPushData.getErpInvoiceEntryMap();
        Map<Long, Collection<Long>> imRecBillPushData = invoiceBillPushData.getErpStockBillMap();
        Map<String, String> srcBillidMap = invoiceBillPushData.getSrcBillidMap();
        String ruleId = invoiceBillPushData.getRuleId();
        String billKey = invoiceBillPushData.getBillKey();
        String entryKey = invoiceBillPushData.getEntryKey();
        Boolean linetypecontrolcriterion = invoiceBillPushData.getLinetypecontrolcriterion();
        if (!imRecBillPushData.isEmpty() && !(targetBillIds = PurInvoiceHelper.doPushApBill(billKey, entryKey, params = PurInvoiceHelper.assemblePushParams(imRecBillPushData, erpRecInvoiceEntryMap, linetypecontrolcriterion), paramsInv = PurInvoiceHelper.assembleInvoiceParams(bill), ruleId)).isEmpty()) {
            billnoSet = PurInvoiceHelper.doWriteBackInvoice(targetBillIds, AP_FINAPBILL, srcBillidMap, bill);
        }
        return billnoSet;
    }

    private static String getRuleId() {
        String apbillbotprule;
        String ruleId = null;
        Object billParam = ParamUtil.getBillParam((String)"pur_invoice", (String)"apbillbotprule");
        if (billParam != null && StringUtils.isNotBlank((CharSequence)(apbillbotprule = (String)billParam))) {
            ruleId = apbillbotprule;
        }
        return ruleId;
    }

    private static Map<Long, InvoiceBillPushData> assembleInvoiceEntryData(String purBillKey, Map<Long, Map<String, DynamicObject>> srmInvoiceBillEntryMap, Map<Long, List<String>> purbillEntryIdListMap, Map<Long, InvoiceBillPushData> result) {
        String purBillProperyties = "id,businesstype.number businesstype,materialentry.id entryId,materialentry.srcbillid srcbillid, materialentry.srcentryid srcEntryId";
        if ("pur_receipt".equals(purBillKey)) {
            purBillProperyties = "id,businesstype.number businesstype,materialentry.id entryId,materialentry.srcbillid srcbillid, materialentry.srcentryid srcEntryId,materialentry.linetype.acceptance acceptance";
        }
        if (purbillEntryIdListMap != null && !purbillEntryIdListMap.isEmpty()) {
            ArrayList<String> purinbillEntryIdList = new ArrayList<String>(8);
            for (Map.Entry<Long, List<String>> entrySet : purbillEntryIdListMap.entrySet()) {
                purinbillEntryIdList.addAll((Collection)entrySet.getValue());
            }
            if (purinbillEntryIdList.isEmpty()) {
                return result;
            }
            DynamicObjectCollection purInbills = QueryServiceHelper.query((String)purBillKey, (String)purBillProperyties, (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", PurInvoiceHelper.getLongList(purinbillEntryIdList))});
            Map<Object, List<DynamicObject>> purEntryInbills = purInbills.stream().collect(Collectors.groupingBy(bill -> bill.getString("entryId")));
            for (Map.Entry<Long, List<String>> entrySet : purbillEntryIdListMap.entrySet()) {
                Map<String, DynamicObject> erpInvoiceEntryMapOrigin;
                Map<Long, Collection<Long>> erpStockBillMapOrigin;
                Map<String, String> srcBillidMap;
                Long billid = entrySet.getKey();
                ArrayList<DynamicObject> purInvoiceInbills = new ArrayList<DynamicObject>(8);
                List<String> value = entrySet.getValue();
                List<Long> entryIdList = PurInvoiceHelper.getLongList(value);
                for (Long entryId : entryIdList) {
                    String entryIdStr = String.valueOf(entryId);
                    List<DynamicObject> list = purEntryInbills.get(entryIdStr);
                    if (list == null) continue;
                    purInvoiceInbills.addAll(list);
                }
                DynamicObject purBill = (DynamicObject)purInvoiceInbills.get(0);
                String businesstype = purBill.getString("businesstype");
                Map<String, String> srcEntryidMap = PurInvoiceHelper.assembleErpStockBillMap(purInvoiceInbills);
                Map<Long, Collection<Long>> assembleErpStockBillMap = PurInvoiceHelper.assembleBillPushData(purInvoiceInbills);
                Map<String, DynamicObject> erpInvoiceEntryMap = PurInvoiceHelper.replaceErpInvoiceEntryMap(purInvoiceInbills, srmInvoiceBillEntryMap.get(billid));
                InvoiceBillPushData invoiceBillPushData = result.get(billid);
                if (invoiceBillPushData == null) {
                    invoiceBillPushData = new InvoiceBillPushData();
                }
                if (!CollectionUtils.isEmpty(srcBillidMap = invoiceBillPushData.getSrcBillidMap())) {
                    srcEntryidMap.putAll(srcBillidMap);
                }
                if (!CollectionUtils.isEmpty(erpStockBillMapOrigin = invoiceBillPushData.getErpStockBillMap())) {
                    assembleErpStockBillMap.putAll(erpStockBillMapOrigin);
                }
                if (!CollectionUtils.isEmpty(erpInvoiceEntryMapOrigin = invoiceBillPushData.getErpInvoiceEntryMap())) {
                    erpInvoiceEntryMap.putAll(erpInvoiceEntryMapOrigin);
                }
                invoiceBillPushData.setBussinessTypeNumber(businesstype);
                invoiceBillPushData.setSrcBillidMap(srcEntryidMap);
                invoiceBillPushData.setErpStockBillMap(assembleErpStockBillMap);
                invoiceBillPushData.setErpInvoiceEntryMap(erpInvoiceEntryMap);
                result.put(billid, invoiceBillPushData);
            }
        }
        return result;
    }

    private static Map<String, String> assembleErpStockBillMap(List<DynamicObject> objects) {
        LinkedHashMap<String, String> stockPushData = new LinkedHashMap<String, String>(16);
        for (DynamicObject temp : objects) {
            String srcEntryId = temp.getString("srcEntryId");
            String entryId = temp.getString("entryId");
            if (!StringUtils.isNotBlank((CharSequence)srcEntryId)) continue;
            stockPushData.put(srcEntryId, entryId);
        }
        return stockPushData;
    }

    private static Map<String, DynamicObject> replaceErpInvoiceEntryMap(List<DynamicObject> purInvoiceInbills, Map<String, DynamicObject> srmInvoiceEntryMap) {
        LinkedHashMap<String, DynamicObject> stockPushData = new LinkedHashMap<String, DynamicObject>(16);
        for (DynamicObject temp : purInvoiceInbills) {
            stockPushData.put(temp.getString("srcEntryId"), srmInvoiceEntryMap.get(temp.getString("entryId")));
        }
        return stockPushData;
    }

    private static Map<Long, Collection<Long>> assembleBillPushData(List<DynamicObject> objects) {
        LinkedHashMap<Long, Collection<Long>> stockPushData = new LinkedHashMap<Long, Collection<Long>>(16);
        for (DynamicObject temp : objects) {
            if (StringUtils.isBlank((CharSequence)temp.getString("srcEntryId"))) continue;
            Long srcbillid = temp.getLong("srcbillid");
            Long srcEntryId = temp.getLong("srcEntryId");
            ArrayList<Long> longList = (ArrayList<Long>)stockPushData.get(srcbillid);
            if (longList != null) {
                longList.add(srcEntryId);
                continue;
            }
            longList = new ArrayList<Long>(16);
            longList.add(srcEntryId);
            stockPushData.put(srcbillid, longList);
        }
        return stockPushData;
    }

    @Deprecated
    public static Set<String> originToApBIll(DynamicObject dynamicObject, Map<String, String> extParamMap) {
        return PurInvoiceHelper.executePushApBill(dynamicObject, extParamMap);
    }

    @Deprecated
    public static String singleToApBill(DynamicObject bill, Map<String, String> extParamMap) {
        StringBuilder message = new StringBuilder();
        try {
            Set<String> executePushApBill = PurInvoiceHelper.executePushApBill(bill, extParamMap);
            if (!executePushApBill.isEmpty()) {
                message.append(MessageFormat.format(ResManager.loadKDString((String)"\u751f\u6210\u5e94\u4ed8\u6210\u529f\uff0c\u5e94\u4ed8\u5355\u53f7\u4e3a{0}\u3002", (String)"PurInvoiceHelper_0", (String)"scm-pur-business", (Object[])new Object[0]), executePushApBill));
            }
        }
        catch (KDException exception) {
            message.append(ResManager.loadKDString((String)"\u751f\u6210\u5e94\u4ed8\u5931\u8d25\uff0c\u539f\u56e0\u5982\u4e0b\uff1a", (String)"PurInvoiceHelper_1", (String)"scm-pur-business", (Object[])new Object[0])).append(exception.getMessage());
            throw new KDException(new ErrorCode("exception", message.toString()), new Object[0]);
        }
        return message.toString();
    }

    private static Set<String> executePushApBill(DynamicObject bill, Map<String, String> extParamMap) {
        HashSet<String> billnoSet = new HashSet<String>(16);
        List<PushApBillResp> results = PurInvoiceHelper.batchPushApBill(new DynamicObject[]{bill});
        if (CollectionUtils.isEmpty(results)) {
            return billnoSet;
        }
        PushApBillResp pushApBillResp = results.get(0);
        if (!pushApBillResp.getIsPushSuccess().booleanValue()) {
            throw new KDException(new ErrorCode("exception", pushApBillResp.getMessage()), new Object[0]);
        }
        billnoSet.addAll(pushApBillResp.getBillnoSet());
        return billnoSet;
    }

    private static List<Map<String, Object>> assemblePushParams(Map<Long, Collection<Long>> pushData, Map<String, DynamicObject> invoiceEntryMap, Boolean isPmAcceptBill) {
        ArrayList<Map<String, Object>> resultParams = new ArrayList<Map<String, Object>>();
        DynamicObject materRows = invoiceEntryMap.values().stream().findFirst().get();
        DynamicObjectType materRowsDynamicObjectType = materRows.getDynamicObjectType();
        DynamicProperty qty = materRowsDynamicObjectType.getProperty("qty1");
        DynamicProperty actprice = materRowsDynamicObjectType.getProperty("actprice1");
        DynamicProperty actchecktaxprice = materRowsDynamicObjectType.getProperty("actchecktaxprice");
        DynamicProperty actcheckprice = materRowsDynamicObjectType.getProperty("actcheckprice");
        DynamicProperty actcheckamount = materRowsDynamicObjectType.getProperty("actcheckamount");
        DynamicProperty actchecktaxamount = materRowsDynamicObjectType.getProperty("actchecktaxamount");
        DynamicProperty taxprice = materRowsDynamicObjectType.getProperty("taxprice1");
        DynamicProperty deductamount = materRowsDynamicObjectType.getProperty("deductamount");
        DynamicProperty afterdeductdiscounttype = materRowsDynamicObjectType.getProperty("afterdeductdiscounttype");
        DynamicProperty afterdeductdctrate = materRowsDynamicObjectType.getProperty("afterdeductdctrate");
        DynamicProperty afterdeductamount = materRowsDynamicObjectType.getProperty("afterdeductamount");
        DynamicProperty afterdeducttaxamount = materRowsDynamicObjectType.getProperty("afterdeducttaxamount");
        DynamicProperty afterdeductdctamount = materRowsDynamicObjectType.getProperty("afterdeductdctamount");
        StringBuilder exceptionMessage = new StringBuilder();
        for (Map.Entry<Long, Collection<Long>> entry : pushData.entrySet()) {
            for (Long entryId : entry.getValue()) {
                HashMap<String, Serializable> param = new HashMap<String, Serializable>();
                param.put("sourBillId", entry.getKey());
                param.put("sourBillEntryId", entryId);
                DynamicObject row = invoiceEntryMap.get(String.valueOf(entryId));
                HashMap<String, Object> tarValueMap = new HashMap<String, Object>();
                try {
                    if (!isPmAcceptBill.booleanValue()) {
                        tarValueMap.put("quantity", qty.getValue((Object)row));
                    }
                    tarValueMap.put("price", actcheckprice.getValue((Object)row));
                    BigDecimal acttaxpriceValue = (BigDecimal)actchecktaxprice.getValue((Object)row);
                    tarValueMap.put("pricetax", acttaxpriceValue.compareTo(BigDecimal.ZERO) == 0 ? taxprice.getValue((Object)row) : acttaxpriceValue);
                    tarValueMap.put("e_pricetaxtotal", actchecktaxamount.getValue((Object)row));
                    tarValueMap.put("e_amount", actcheckamount.getValue((Object)row));
                    Object deductamountObj = deductamount.getValue((Object)row);
                    BigDecimal deductamountBigDecimal = BigDecimal.ZERO;
                    if (deductamountObj != null) {
                        deductamountBigDecimal = (BigDecimal)deductamountObj;
                    }
                    if (deductamountBigDecimal.signum() != 0) {
                        Object value = afterdeductdiscounttype.getValue((Object)row);
                        if (value != null) {
                            String discountmode = DiscountTypeEnum.fromApBillVal((String)value.toString());
                            tarValueMap.put("discountmode", discountmode);
                        }
                        tarValueMap.put("discountrate", afterdeductdctrate.getValue((Object)row));
                        tarValueMap.put("e_pricetaxtotal", afterdeducttaxamount.getValue((Object)row));
                        tarValueMap.put("e_amount", afterdeductamount.getValue((Object)row));
                    }
                }
                catch (Exception exception) {
                    exceptionMessage.append(exception.getMessage());
                }
                param.put("tarFieldValueMap", tarValueMap);
                resultParams.add(param);
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("exceptionMessage:{}", (Object)exceptionMessage);
        }
        return resultParams;
    }

    private static List<Map<String, Object>> assembleInvoiceParams(DynamicObject bill) {
        ArrayList<Map<String, Object>> resultParams = new ArrayList<Map<String, Object>>(8);
        DynamicObjectCollection invCols = bill.getDynamicObjectCollection("entryentity");
        StringBuilder exceptionMessage = new StringBuilder();
        for (DynamicObject row : invCols) {
            HashMap<String, String> param = new HashMap<String, String>(8);
            try {
                String invsource = row.getString("invsource");
                if ("2".equals(invsource)) {
                    String invserialnum = row.getString("invserialnum");
                    param.put("i_srctype", "invcloud");
                    param.put("i_serialno", invserialnum);
                }
            }
            catch (Exception exception) {
                exceptionMessage.append(exception.getMessage());
            }
            resultParams.add(param);
        }
        if (log.isWarnEnabled()) {
            log.warn("exceptionMessage:{}", (Object)exceptionMessage);
        }
        return resultParams;
    }

    private static List<Long> getLongList(List<String> srcIds) {
        ArrayList<Long> list = new ArrayList<Long>(srcIds.size());
        for (String srcId : srcIds) {
            list.add(Long.parseLong(srcId));
        }
        return list;
    }

    private static List<Object> doPushApBill(String target, String targetEntryEntity, List<Map<String, Object>> params, List<Map<String, Object>> invParams, String ruleId) {
        List<Object> resultList = new ArrayList<Object>();
        try {
            resultList = ruleId == null ? (List)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"ApAPIPushECService", (String)"purInvoicePushApEntry", (Object[])new Object[]{target, targetEntryEntity, params, invParams}) : (List)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"ApAPIPushECService", (String)"purInvoicePushApEntry", (Object[])new Object[]{target, targetEntryEntity, params, invParams, ruleId});
        }
        catch (KDException exception) {
            if (exception.getMessage() == null || exception.getMessage().isEmpty()) {
                throw new KDException(new ErrorCode("exception", ((Object)((Object)exception)).getClass().getName()), new Object[0]);
            }
            SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)exception);
            throw exception;
        }
        catch (Throwable throwable) {
            SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)throwable);
        }
        return resultList;
    }

    private static Set<String> doWriteBackInvoice(List<Object> targetPks, String targetEntity, Map<String, String> srcBillidMap, DynamicObject invoiceDy) {
        String srcbillEntryid = "";
        String billno = null;
        HashSet<String> billnoSet = new HashSet<String>(targetPks.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)targetEntity, (String)"id,billno,sourcebillid, detailentry.corebillid corebillid,detailentry.e_sourcebillid e_sourcebillid, detailentry.e_sourcebillentryid e_sourcebillentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", targetPks)}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                billno = row.getString("billno");
                srcbillEntryid = row.getString("e_sourcebillentryid");
                String srcpurEntryid = srcBillidMap.get(srcbillEntryid);
                log.info("\u5e94\u4ed8\u5355\u7f16\u53f7\uff1a{},\u5e93\u5b58\u5165\u5e93\u6216\u8005\u6536\u8d27\u5355\u636eid:{},\u5bf9\u5e94\u7684\u53d1\u7968\u7b7e\u6536\u7f16\u7801\uff1a{},\u534f\u540c\u5165\u5e93\u5355\u5206\u5f55id:{}", new Object[]{billno, srcbillEntryid, invoiceDy.getString("billno"), srcpurEntryid});
                DynamicObjectCollection cols = invoiceDy.getDynamicObjectCollection("entryentity1");
                DynamicObjectType dynamicObjectType = cols.getDynamicObjectType();
                for (DynamicObject entry : cols) {
                    if (!dynamicObjectType.getProperty("srcentryid1").getValue((Object)entry).equals(srcpurEntryid)) continue;
                    dynamicObjectType.getProperty("isentrypay").setValue((Object)entry, (Object)"1");
                    dynamicObjectType.getProperty("entrypaybillno").setValue((Object)entry, (Object)billno);
                    dynamicObjectType.getProperty("entrypaytype").setValue((Object)entry, (Object)"1");
                }
                billnoSet.add(billno);
            }
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])new DynamicObject[]{invoiceDy});
        return billnoSet;
    }

    public static String checkPurInvoiceData(DynamicObject[] dynamicObjects) {
        StringBuilder checkMessage = new StringBuilder();
        for (DynamicObject bill : dynamicObjects) {
            String billno = bill.getString("billno");
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("entryentity1");
            if (rows != null && !rows.isEmpty()) {
                String isentrypay = ((DynamicObject)rows.stream().findFirst().get()).getString("isentrypay");
                if ("1".equals(isentrypay)) {
                    checkMessage.append(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e{0}\u5df2\u751f\u6210\u4e0b\u6e38\u5355\u636e\u3002", (String)"PurInvoiceHelper_3", (String)"scm-pur-business", (Object[])new Object[0]), billno)).append('\n');
                }
                HashSet<String> poBillSet = new HashSet<String>(rows.size());
                for (DynamicObject row : rows) {
                    String pobillId = row.getString("pobillid1");
                    if (pobillId.isEmpty() || "0".equals(pobillId)) continue;
                    poBillSet.add(pobillId);
                }
                for (String poBillId : poBillSet) {
                    if (!PurInvoiceUtil.checkIsGoodsBizTypeId(poBillId)) continue;
                    throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e{0}\uff0c\u4e1a\u52a1\u7c7b\u578b\u4e3a\u975e\u5546\u54c1\u7c7b\u91c7\u8d2d\u624d\u80fd\u751f\u6210\u5e94\u4ed8\u3002", (String)"PurInvoiceHelper_4", (String)"scm-pur-business", (Object[])new Object[0]), billno));
                }
            }
            String cfmstatus = bill.getString("cfmstatus");
            String billstatus = bill.getString("billstatus");
            if (!"B".equals(cfmstatus)) {
                checkMessage.append(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e{0}\uff0c\u7b7e\u6536\u72b6\u6001\u4e0d\u662f\u5df2\u7b7e\u6536\uff0c\u4e0d\u80fd\u751f\u6210\u4e0b\u6e38\u5355\u636e\u3002", (String)"PurInvoiceHelper_5", (String)"scm-pur-business", (Object[])new Object[0]), billno)).append('\n');
                continue;
            }
            if ("C".equals(billstatus)) continue;
            checkMessage.append(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e{0}\uff0c\u5355\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u4e0d\u80fd\u7b7e\u6536\u3002", (String)"PurInvoiceHelper_6", (String)"scm-pur-business", (Object[])new Object[0]), billno)).append('\n');
        }
        return checkMessage.toString();
    }
}

