/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.helper.transfer.SDKTransferHelper;
import kd.scm.common.helper.transfer.SRMTransferDataHelper;
import kd.scm.common.helper.transfer.entity.TransferInfo;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.pur.business.PurBillHelper;
import kd.scm.pur.business.PurReplenishReqHelper;
import kd.scm.pur.business.transfer.CreateOrderSupportDefault;
import kd.scm.pur.common.domain.WriteOffQtyRow;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public final class PurOrderBillHelper {
    private static final Log log = LogFactory.getLog((String)PurOrderBillHelper.class.getName());

    public static void updateScheduleQty(Map<Long, Map<String, BigDecimal>> paramMap) {
        DynamicObject[] orders;
        for (DynamicObject bill : orders = BusinessDataServiceHelper.load((String)"pur_order", (String)"id,billno,materialentry.scheduleqty,materialentry.schedulebaseqty,", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", paramMap.keySet())})) {
            DynamicObjectCollection billDynamicObjectCollection = bill.getDynamicObjectCollection("materialentry");
            DynamicProperty scheduleqty = billDynamicObjectCollection.getDynamicObjectType().getProperty("scheduleqty");
            DynamicProperty schedulebaseqty = billDynamicObjectCollection.getDynamicObjectType().getProperty("schedulebaseqty");
            for (DynamicObject row : billDynamicObjectCollection) {
                Long entryId = row.getLong("id");
                Map<String, BigDecimal> dataMap = paramMap.get(entryId);
                if (dataMap == null || dataMap.isEmpty()) continue;
                scheduleqty.setValue((Object)row, (Object)((BigDecimal)scheduleqty.getValue((Object)row)).add(dataMap.get("scheduleqty")));
                schedulebaseqty.setValue((Object)row, (Object)((BigDecimal)schedulebaseqty.getValue((Object)row)).add(dataMap.get("schedulebaseqty")));
            }
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])orders);
    }

    public static Map<String, String> assembleCreateOrderExtEntryPro() {
        LinkedHashMap<String, String> sdkEntryMap = new LinkedHashMap<String, String>(16);
        TransferInfo transferInfo = SRMTransferDataHelper.getTransferInfo((String)"srmcreateorder");
        Map transferTypeMap = transferInfo.getTransferTypeMap();
        if (!transferTypeMap.isEmpty()) {
            String number = transferTypeMap.getOrDefault("number", "SCM_PUR_CREATEORDER_SUPPORT");
            String anInterface = transferTypeMap.getOrDefault("interface", "kd.sdk.scm.pur.extpoint.ICreateOrderSupport");
            Class type = null;
            try {
                type = TypesContainer.getOrRegister((String)anInterface);
                sdkEntryMap.putAll(SDKTransferHelper.getSDKEntryMap((String)number, (Class)type, CreateOrderSupportDefault.class));
            }
            catch (Throwable throwable) {
                log.error(throwable);
            }
        }
        return sdkEntryMap;
    }

    public static Map<Long, Boolean> verifySrcQtyCanUnClose(Map<Long, BigDecimal> srcEntryVerifyQtyMap) {
        HashMap<Long, Boolean> resultmap = new HashMap<Long, Boolean>(srcEntryVerifyQtyMap.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pur_order", (String)"materialentry.id entryid,materialentry.qty qty,materialentry.scheduleqty scheduleqty,materialentry.sumrefundqty sumrefundqty,materialentry.iscontrolqty,materialentry.saloutqtydown,materialentry.saloutqtyup", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", srcEntryVerifyQtyMap.keySet())}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long entryid = row.getLong("entryid");
                BigDecimal verifyQty = srcEntryVerifyQtyMap.get(entryid);
                if (verifyQty == null) continue;
                BigDecimal qty = row.getBigDecimal("qty");
                BigDecimal scheduleqty = row.getBigDecimal("scheduleqty");
                BigDecimal sumrefundqty = row.getBigDecimal("sumrefundqty");
                if (qty.add(sumrefundqty).subtract(scheduleqty).subtract(verifyQty).compareTo(BigDecimal.ZERO) >= 0) {
                    resultmap.put(entryid, Boolean.TRUE);
                    continue;
                }
                resultmap.put(entryid, Boolean.FALSE);
            }
        }
        return resultmap;
    }

    public static void queryLogisticsNumber(Set<String> billNoSet) {
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"pur_order", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "in", billNoSet)}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
            }
        }
    }

    public static Map<Long, Boolean> verifyRowCanDeliverySchedule(Map<Long, Collection<Long>> checkMap) {
        if (log.isInfoEnabled()) {
            log.info("verifyRowCanDeliverySchedule:checkMap" + checkMap);
        }
        Map<Long, Boolean> verifyRowTarget = PurBillHelper.verifyRowTarget("scp_order", "materialentry", checkMap);
        if (log.isInfoEnabled()) {
            log.info("verifyRowCanDeliverySchedule#verifyRowTarget:before" + SerializationUtils.toJsonString(verifyRowTarget));
        }
        ArrayList listEntryIds = new ArrayList(1024);
        verifyRowTarget.keySet().forEach(row -> listEntryIds.add(row.toString()));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"scp_saloutstock", (String)"materialentry.srcentryid srcentryid", (QFilter[])new QFilter[]{new QFilter("materialentry.dsentryid", "!=", (Object)" ").and(new QFilter("materialentry.srcentryid", "in", listEntryIds))}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row2 = dataSet.next();
                String srcentryid = row2.getString("srcentryid");
                verifyRowTarget.remove(Long.parseLong(srcentryid));
            }
        }
        if (log.isInfoEnabled()) {
            log.info("verifyRowCanDeliverySchedule#verifyRowTarget:after" + SerializationUtils.toJsonString(verifyRowTarget));
        }
        return verifyRowTarget;
    }

    public static Map<Long, Boolean> verifyCanSalOutStock(Map<Long, Collection<Long>> checkMap) {
        if (log.isInfoEnabled()) {
            log.info("verifyCanSalOutStock#checkMap" + checkMap);
        }
        return PurBillHelper.verifyRowTarget("pur_order", "materialentry", checkMap);
    }

    public static DynamicObject[] getUnConfirmOrder(Set<String> poEntryIds) {
        QFilter qFilter = new QFilter("materialentry.poentryid", "in", poEntryIds);
        qFilter.and("cfmstatus", "=", (Object)"A");
        String selectFields = "id,billno,cfmstatus,entryentity.id,materialentry.poentryid";
        return BusinessDataServiceHelper.load((String)"pur_order", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    public static void changePurOrderStatus(DynamicObject[] orders) {
        for (DynamicObject dyo : orders) {
            String cfmStatus = dyo.getString("cfmstatus");
            if (!ConfirmStatusEnum.UNCONFIRM.getVal().equals(cfmStatus)) continue;
            dyo.set("cfmstatus", (Object)ConfirmStatusEnum.AUTOCONFIRM.getVal());
        }
        if (orders.length > 0) {
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])orders);
        }
    }

    public static void assembleJointXKReqUpdate(DynamicObject[] orderBills) {
        HashMap<Long, WriteOffQtyRow> writeOffQtyRowMap = new HashMap<Long, WriteOffQtyRow>(64);
        StringBuilder exceptionMessage = new StringBuilder();
        WriteOffQtyRow writeOffQtyRow = null;
        for (DynamicObject bill : orderBills) {
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : rows) {
                String srcEntryIdString = row.getString("srcentryid");
                Long srcEntryId = null;
                try {
                    srcEntryId = Long.parseLong(srcEntryIdString);
                }
                catch (RuntimeException runtimeException) {
                    exceptionMessage.append(runtimeException.getMessage());
                }
                if (srcEntryId == null) continue;
                BigDecimal qty = row.getBigDecimal("qty");
                BigDecimal basicQty = row.getBigDecimal("basicqty");
                writeOffQtyRow = (WriteOffQtyRow)writeOffQtyRowMap.get(srcEntryId);
                if (writeOffQtyRow == null) {
                    writeOffQtyRow = new WriteOffQtyRow();
                }
                writeOffQtyRow.addQtyValue(qty);
                writeOffQtyRow.addBasicQtyValue(basicQty);
                writeOffQtyRowMap.put(srcEntryId, writeOffQtyRow);
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("exceptionMessage:{}", (Object)exceptionMessage);
        }
        if (!writeOffQtyRowMap.isEmpty()) {
            DynamicObject[] dynamicObjects;
            for (DynamicObject bill : dynamicObjects = BusinessDataServiceHelper.load((String)"pur_replenishreq", (String)"billno,orderstatus,material,unit,baseunit,orderedbaseqty,orderedqty,ordernum", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", writeOffQtyRowMap.keySet())})) {
                bill.set("orderstatus", (Object)"C");
            }
            PurReplenishReqHelper.updateErpOrderQty(dynamicObjects, writeOffQtyRowMap);
        }
    }

    public static void assembleJointXKDeleteReq(Collection<Object> list) {
        Map<Long, WriteOffQtyRow> writeOffQtyRowMap = PurOrderBillHelper.getEmptyWriteData(list);
        if (!writeOffQtyRowMap.isEmpty()) {
            DynamicObject[] dynamicObjects;
            for (DynamicObject bill : dynamicObjects = BusinessDataServiceHelper.load((String)"pur_replenishreq", (String)"billno,orderstatus,material,unit,baseunit,orderedbaseqty,orderedqty,ordernum", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", writeOffQtyRowMap.keySet())})) {
                bill.set("orderstatus", (Object)"A");
            }
            PurReplenishReqHelper.updateErpOrderQty(dynamicObjects, writeOffQtyRowMap);
        }
    }

    public static void assembleJointClearOrder(Collection<Object> list) {
        Map<Long, WriteOffQtyRow> writeOffQtyRowMap = PurOrderBillHelper.getEmptyWriteData(list);
        if (!writeOffQtyRowMap.isEmpty()) {
            DynamicObject[] dynamicObjects;
            for (DynamicObject bill : dynamicObjects = BusinessDataServiceHelper.load((String)"pur_replenishreq", (String)"billno,orderstatus,material,unit,baseunit,orderedbaseqty,orderedqty,ordernum", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", writeOffQtyRowMap.keySet())})) {
                bill.set("orderstatus", (Object)"A");
            }
            PurReplenishReqHelper.updateErpOrderQty(dynamicObjects, writeOffQtyRowMap);
            PurReplenishReqHelper.clearErpOrderNumber(dynamicObjects, writeOffQtyRowMap);
        }
    }

    private static Map<Long, WriteOffQtyRow> getEmptyWriteData(Collection<Object> list) {
        HashMap<Long, WriteOffQtyRow> writeOffQtyRowMap = new HashMap<Long, WriteOffQtyRow>(64);
        Long srcEntryId = null;
        for (Object object : list) {
            JSONObject entity = JSONObject.fromObject((Object)object);
            JSONArray entryList = JSONArray.fromObject((Object)entity.get("entryentity"));
            for (Object entry : entryList) {
                JSONObject entryMap = JSONObject.fromObject(entry);
                if (entryMap == null || entryMap.isEmpty()) continue;
                Object srcEntryIdString = entryMap.get("srcentryid");
                Object jointdatachannelid = entryMap.get("jointdatachannelid");
                if (srcEntryIdString != null && !"".equals(srcEntryIdString) && !" ".equals(srcEntryIdString)) {
                    srcEntryId = Long.parseLong(srcEntryIdString.toString());
                }
                writeOffQtyRowMap.put(srcEntryId, new WriteOffQtyRow());
            }
        }
        return writeOffQtyRowMap;
    }
}

