/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.pur.business.PurDeliveryScheduleHelper;

public final class PurSalOutStockHelper {
    public static FormShowParameter assembleShowParameter(String entityNumber, String formNumber, List<Long> pkSet) {
        ListShowParameter formShowParameter = null;
        if (pkSet != null && !pkSet.isEmpty()) {
            if (pkSet.size() > 1) {
                formShowParameter = new ListShowParameter();
                formShowParameter.setCustomParam("isOpenNewTab", (Object)Boolean.TRUE);
                formShowParameter.setBillFormId(entityNumber);
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", pkSet));
            } else {
                formShowParameter = new BillShowParameter();
                formShowParameter.setFormId(formNumber);
                ((BillShowParameter)formShowParameter).setPkId((Object)pkSet.get(0));
                ((BillShowParameter)formShowParameter).setBillStatus(BillOperationStatus.VIEW);
            }
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        }
        return formShowParameter;
    }

    public static void writeBackRelateOutStockQty(List<DynamicObject> rowList, boolean isClose) {
        LinkedHashMap<Long, Map<String, BigDecimal>> paramMap = new LinkedHashMap<Long, Map<String, BigDecimal>>(56);
        for (DynamicObject row : rowList) {
            String dsentryid = row.getString("dsentryid");
            if (dsentryid.isEmpty() || "0".equals(dsentryid)) continue;
            Long srcEntryId = Long.parseLong(dsentryid);
            Map<String, BigDecimal> rowDataMap = PurSalOutStockHelper.assembleMinQty(row, isClose);
            Map dataMap = (Map)paramMap.get(srcEntryId);
            if (dataMap != null) {
                dataMap.put("qty", ((BigDecimal)dataMap.get("qty")).add(rowDataMap.get("qty")));
                dataMap.put("basicqty", ((BigDecimal)dataMap.get("basicqty")).add(rowDataMap.get("basicqty")));
                paramMap.put(srcEntryId, dataMap);
                continue;
            }
            paramMap.put(srcEntryId, rowDataMap);
        }
        if (!paramMap.isEmpty()) {
            PurDeliveryScheduleHelper.updateRelateSalOutQty(paramMap);
        }
    }

    private static Map<String, BigDecimal> assembleMinQty(DynamicObject materialRow, Boolean ifClose) {
        BigDecimal qty = materialRow.getBigDecimal("qty");
        BigDecimal sumreceiptqty = materialRow.getBigDecimal("sumreceiptqty");
        sumreceiptqty = sumreceiptqty == null ? BigDecimal.ZERO : sumreceiptqty;
        BigDecimal suminstockqty = materialRow.getBigDecimal("suminstockqty");
        suminstockqty = suminstockqty == null ? BigDecimal.ZERO : suminstockqty;
        BigDecimal subtract1 = qty.subtract(suminstockqty);
        BigDecimal subtract2 = qty.subtract(sumreceiptqty);
        BigDecimal minSubtract = subtract1.min(subtract2);
        DynamicObject unitObj = materialRow.getDynamicObject("unit");
        DynamicObject basicUnitObj = materialRow.getDynamicObject("basicunit");
        DynamicObject materialObj = materialRow.getDynamicObject("material");
        BigDecimal minBaseSubtract = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)minSubtract, (DynamicObject)basicUnitObj);
        HashMap<String, BigDecimal> rowMap = new HashMap<String, BigDecimal>(2);
        rowMap.put("qty", ifClose != false ? minSubtract.negate() : minSubtract);
        rowMap.put("basicqty", ifClose != false ? minBaseSubtract.negate() : minBaseSubtract);
        return rowMap;
    }

    public static Map<String, BigDecimal> getSalOutStockBasicQty(List<String> pmOrderEntryIds) {
        HashMap<String, BigDecimal> haveStockBasicQtyMap = new HashMap<String, BigDecimal>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"pur_order", (String)"materialentry.poentryid poentryid,materialentry.sumoutstockbaseqty sumoutstockbaseqty", (QFilter[])new QFilter[]{new QFilter("materialentry.poentryid", "in", pmOrderEntryIds).and(new QFilter("billstatus", "=", (Object)"C").and(new QFilter("entrystatus", "=", (Object)"A")))}, (String)"id");){
            DataSet groupDataSet = dataSet.groupBy(new String[]{"poentryid", "sumoutstockbaseqty"}).sum("poentryid").finish();
            while (groupDataSet.hasNext()) {
                Row row = groupDataSet.next();
                String poentryid = row.getString("poentryid");
                BigDecimal basicQty = (BigDecimal)haveStockBasicQtyMap.get(poentryid);
                if (basicQty == null) {
                    basicQty = BigDecimal.ZERO;
                }
                basicQty = basicQty.add(row.getBigDecimal("sumoutstockbaseqty"));
                haveStockBasicQtyMap.put(poentryid, basicQty);
            }
            groupDataSet.close();
        }
        return haveStockBasicQtyMap;
    }
}

