/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business.erp.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.scm.pur.business.erp.impl.PurOrderQtyService;

public class PurOrderEasQtyService
extends PurOrderQtyService {
    @Override
    public void qtyCalculate(DynamicObjectCollection entryList) {
        for (DynamicObject entrydyo : entryList) {
            BigDecimal qty = entrydyo.getBigDecimal("qty");
            if (qty == null || qty.compareTo(BigDecimal.ZERO) == 0 || !this.checkexcecuteQtyCal(entrydyo)) continue;
            this.entryQtyCalculate(entrydyo, qty);
        }
    }

    @Override
    protected void setQtyPropValue(DynamicObject entryDyn, BigDecimal qty, String qtyPropName, String baseQtyPropName) {
        if (StringUtils.isNotEmpty((CharSequence)qtyPropName)) {
            entryDyn.set(qtyPropName, (Object)qty);
        }
        if (StringUtils.isNotEmpty((CharSequence)baseQtyPropName)) {
            BigDecimal calBasicQty = this.getBaseQty(entryDyn, qty);
            if (calBasicQty == null || calBasicQty.compareTo(BigDecimal.ZERO) == 0) {
                BigDecimal big100 = new BigDecimal("100");
                BigDecimal salOutRate = BigDecimal.ZERO;
                BigDecimal basicQty = entryDyn.getBigDecimal("basicqty");
                if (basicQty != null && basicQty.compareTo(BigDecimal.ZERO) != 0) {
                    if ("saloutbaseqtydown".equals(baseQtyPropName)) {
                        salOutRate = entryDyn.getBigDecimal("saloutratedown");
                    } else if ("saloutbaseqtyup".equals(baseQtyPropName)) {
                        salOutRate = entryDyn.getBigDecimal("saloutrateup");
                    }
                    calBasicQty = basicQty.multiply(big100.subtract(salOutRate)).divide(big100, basicQty.scale() + 2, RoundingMode.HALF_UP);
                } else {
                    throw new KDException(new ErrorCode("SYSTEMJOINTEXECEPTION001", ResManager.loadKDString((String)"\u53c2\u4e0e\u96c6\u6210\u7684\u6570\u636e\u5305\u65e0\u6cd5\u8ba1\u7b97\u51fa\u6709\u6548\u7684\u7ed3\u679c\uff0c\u8bf7\u68c0\u67e5\u57fa\u672c\u6570\u91cf\u5b57\u6bb5\u6216\u8005\u7269\u6599\u57fa\u672c\u4fe1\u606f\u7684\u5355\u4f4d\u6362\u7b97\u5173\u7cfb\u3002", (String)"PurOrderEasQtyService_0", (String)"scm-pur-business", (Object[])new Object[0])), new Object[0]);
                }
            }
            entryDyn.set(baseQtyPropName, (Object)calBasicQty);
        }
    }
}

