/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business.erp.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.util.CommonUtil;
import kd.scm.pur.business.erp.IPurOrderQtyService;

public class PurOrderQtyService
implements IPurOrderQtyService {
    protected Log log = LogFactory.getLog(this.getClass());

    @Override
    public void qtyCalculate(DynamicObjectCollection entryList) {
    }

    protected void setQtyPropValue(DynamicObject entryDyn, BigDecimal qty, String qtyPropName, String baseQtyPropName) {
        if (StringUtils.isNotEmpty((CharSequence)qtyPropName)) {
            entryDyn.set(qtyPropName, (Object)qty);
        }
        if (StringUtils.isNotEmpty((CharSequence)baseQtyPropName)) {
            entryDyn.set(baseQtyPropName, (Object)this.getBaseQty(entryDyn, qty));
        }
    }

    protected void entryQtyCalculate(DynamicObject entrydyo, BigDecimal qty) {
        BigDecimal saloutratedown = entrydyo.getBigDecimal("saloutratedown");
        BigDecimal saloutqtydown = entrydyo.getBigDecimal("saloutqtydown");
        BigDecimal saloutrateup = entrydyo.getBigDecimal("saloutrateup");
        BigDecimal saloutqtyup = entrydyo.getBigDecimal("saloutqtyup");
        this.log.info("\u8d85\u53d1\u63a7\u5236\u4f20\u5165\u53c2\u6570:qty=" + qty + ";saloutrateup=" + saloutrateup + ";saloutqtyup=" + saloutqtyup + ";saloutratedown=" + saloutratedown + ";saloutqtydown=" + saloutqtydown);
        BigDecimal big100 = new BigDecimal("100");
        if (saloutratedown == null) {
            saloutratedown = BigDecimal.ZERO;
        }
        if (saloutqtydown == null || saloutqtydown.compareTo(BigDecimal.ZERO) == 0) {
            saloutqtydown = qty.multiply(big100.subtract(saloutratedown)).divide(big100, qty.scale() + 2, RoundingMode.HALF_UP);
            this.setQtyPropValue(entrydyo, saloutqtydown, "saloutqtydown", "saloutbaseqtydown");
        }
        if (saloutrateup == null) {
            saloutrateup = BigDecimal.ZERO;
        }
        if (saloutqtyup == null || saloutqtyup.compareTo(BigDecimal.ZERO) == 0) {
            saloutqtyup = qty.multiply(big100.add(saloutrateup)).divide(big100, qty.scale() + 2, RoundingMode.HALF_UP);
            this.setQtyPropValue(entrydyo, saloutqtyup, "saloutqtyup", "saloutbaseqtyup");
        }
    }

    protected final BigDecimal getBaseQty(DynamicObject entryDyn, BigDecimal qty) {
        DynamicObject materialObj = entryDyn.getDynamicObject("material");
        DynamicObject unitObj = entryDyn.getDynamicObject("unit");
        DynamicObject basicUnitObj = entryDyn.getDynamicObject("basicunit");
        return CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)qty, (DynamicObject)basicUnitObj);
    }

    protected boolean checkexcecuteQtyCal(DynamicObject entrydyo) {
        return entrydyo.getBoolean("iscontrolqty");
    }
}

