/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business.suppliercoll;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.scm.pur.business.suppliercoll.PurSupplierCollInitiateHelper;

final class PurSupplierCollInitializeHelper {
    private static final Log log = LogFactory.getLog(PurSupplierCollInitializeHelper.class);

    PurSupplierCollInitializeHelper() {
    }

    private IAppCache getAppCache() {
        return AppCache.get((String)PurSupplierCollInitiateHelper.BATCH_INITIALIZE_SUPPLIER_CONTROL);
    }

    public Boolean verifyNeedInitialize() {
        boolean supplierCollExist = QueryServiceHelper.exists((String)"pur_suppliercollinfo", (QFilter[])new QFilter[]{QFilter.of((String)"1==1", (Object[])new Object[0])});
        boolean supplierExist = QueryServiceHelper.exists((String)"bd_supplier", (QFilter[])new QFilter[]{new QFilter("issuppcolla", "=", (Object)"1")});
        return !supplierCollExist & supplierExist;
    }

    public Collection<Long> getUnLockSupplierIds(Collection<Long> supplierIds) {
        ArrayList<Long> unLockEntryIds = new ArrayList<Long>(supplierIds.size());
        PurSupplierCollInitializeHelper supplierCollInitializeHelper = new PurSupplierCollInitializeHelper();
        ArrayList<Map<String, Object>> lockInfoList = new ArrayList<Map<String, Object>>(1);
        for (Long failTaskId : supplierIds) {
            lockInfoList.add(supplierCollInitializeHelper.getMutexLockInfo(failTaskId));
        }
        DataMutex dataMutex = DataMutex.create();
        Map batchRequireMap = dataMutex.batchrequire(lockInfoList);
        if (batchRequireMap != null && !batchRequireMap.isEmpty()) {
            for (Map.Entry entry : batchRequireMap.entrySet()) {
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                unLockEntryIds.add(Long.parseLong((String)entry.getKey()));
            }
        }
        return unLockEntryIds;
    }

    public void clearSupplierLock(Collection<Long> supplierIds) {
        DataMutex dataMutex = DataMutex.create();
        PurSupplierCollInitializeHelper supplierCollInitializeHelper = new PurSupplierCollInitializeHelper();
        ArrayList<Map<String, Object>> lockInfoList = new ArrayList<Map<String, Object>>(supplierIds.size());
        Map<String, Object> lockInfo = null;
        for (Long entryId : supplierIds) {
            lockInfo = supplierCollInitializeHelper.getMutexLockInfo(entryId);
            lockInfoList.add(lockInfo);
        }
        dataMutex.batchRelease(lockInfoList);
    }

    public Map<String, Object> getMutexLockInfo(Long supplierId) {
        HashMap<String, Object> lockInfo = new HashMap<String, Object>(4);
        lockInfo.put("dataObjId", supplierId.toString());
        lockInfo.put("entityKey", "bd_supplier");
        lockInfo.put("operationKey", "modify");
        lockInfo.put("isStrict", Boolean.TRUE);
        lockInfo.put("groupId", "default_netctrl");
        return lockInfo;
    }

    public String dispatchTask(Map<String, Object> customParamMap) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setName(ResManager.loadKDString((String)"\u542f\u7528\u91c7\u8d2d\u534f\u540c\u6570\u636e\u540c\u6b65\u4efb\u52a1", (String)"PurSupplierCollInitializeHelper_0", (String)"scm-pur-business", (Object[])new Object[0]));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("pur");
        jobInfo.setTaskClassname("kd.scm.pur.business.task.PurSupplierCollInitializeTask");
        jobInfo.setParams(customParamMap);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId("");
        jobFormInfo.setRootPageId("");
        jobFormInfo.setClickClassName("");
        return ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
    }

    public boolean verifyInitializeButtonControl() {
        String initializeState = (String)this.getAppCache().get("initialize", String.class);
        boolean initializeFlag = Boolean.FALSE;
        if (initializeState == null || initializeState.isEmpty()) {
            initializeFlag = Boolean.TRUE;
            this.getAppCache().put("initialize", (Object)String.valueOf(Boolean.TRUE));
        } else {
            this.getAppCache().put("initialize", (Object)String.valueOf(Boolean.TRUE));
        }
        return initializeFlag;
    }

    public void removeInitializeButtonControl() {
        this.getAppCache().remove("initialize");
    }

    private List<Long> getCurrIds(List<Long> pkIds, int batchSize, int seq) {
        ArrayList<Long> ids = new ArrayList<Long>();
        int begin = seq * batchSize;
        int end = begin + batchSize;
        for (int i = begin; i < end && i < pkIds.size(); ++i) {
            ids.add(pkIds.get(i));
        }
        return ids;
    }
}

