/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business.suppliercoll;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.scm.common.helper.scdatahandle.ScDataHandleLogHelper;
import kd.scm.common.helper.scdatahandle.entity.ScDataHandleLogInfo;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.util.ParamUtil;
import kd.scm.pur.business.suppliercoll.PurSupplierAssignHelper;
import kd.scm.pur.business.suppliercoll.PurSupplierCollInactiveHelper;
import kd.scm.pur.business.suppliercoll.PurSupplierCollInitializeHelper;
import kd.scm.pur.business.suppliercoll.PurSupplierCollPermHelper;

public final class PurSupplierCollInitiateHelper {
    private static final Log log = LogFactory.getLog(PurSupplierCollInitiateHelper.class);
    public static ThreadPool INIT_WORKER_THREAD_POOL = null;
    public static String SUPPLIERIDS;
    public static String ORDERBILLIDS;
    public static String ORDERCHANGEBILLIDS;
    public static String ACCEPTBILLIDS;
    public static String RECEIPTBILLIDS;
    public static String INBILLBILLIDS;
    public static String EXECUTEBILLSTRING;
    public static String BATCHSIZE;
    public static String EXECUTECHANNEL;
    public static String PROCESSSOURCE;
    public static String BATCH_INITIALIZE_SUPPLIER_CONTROL;

    private static void getThreadPool() {
        if (INIT_WORKER_THREAD_POOL == null) {
            INIT_WORKER_THREAD_POOL = ThreadPools.newCachedThreadPool((String)"SCM_PUR_INITIALIZE_WORKER", (int)1, (int)32);
        }
    }

    public static String dispatchExecuteBillTask(Map<String, Collection<String>> executeBillMap, Map<String, String> customParamMap) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put(EXECUTEBILLSTRING, SerializationUtils.toJsonString(executeBillMap));
        paramMap.putAll(customParamMap);
        JobFormInfo jobFormInfo = PurSupplierCollInitiateHelper.buildJobFormInfo(paramMap);
        return ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
    }

    private static JobFormInfo buildJobFormInfo(Map<String, Object> paramMap) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setName(ResManager.loadKDString((String)"\u542f\u7528\u91c7\u8d2d\u534f\u540c\u5355\u636e\u540c\u6b65\u4efb\u52a1", (String)"PurSupplierCollInitiateHelper_3", (String)"scm-pur-business", (Object[])new Object[0]));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("pur");
        jobInfo.setTaskClassname("kd.scm.pur.business.task.PurBillJointInitiateTask");
        jobInfo.setParams(paramMap);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId("");
        jobFormInfo.setRootPageId("");
        jobFormInfo.setClickClassName("kd.scm.pur.formplugin.suppliercollenable.PurSupplierCollInitiatePlugin");
        return jobFormInfo;
    }

    public static Map<Long, Boolean> insertSupplierColl(Collection<Long> supplierIds, Map<String, String> customParamMap) {
        if (supplierIds == null || supplierIds.isEmpty()) {
            throw new KDException(new ErrorCode("", ResManager.loadKDString((String)"\u53c2\u6570:supplierIds\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u3002", (String)"PurSupplierCollInitiateHelper_1", (String)"scm-pur-business", (Object[])new Object[0])), new Object[0]);
        }
        if (log.isInfoEnabled()) {
            log.info("PurSupplierAssignHelper#query#supplierUpdateInfoMap:{},supplierIds:{}", (Object)SerializationUtils.toJsonString(supplierIds), (Object)SerializationUtils.toJsonString(customParamMap));
        }
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(64);
        PurSupplierAssignHelper supplierAssignHelper = new PurSupplierAssignHelper();
        customParamMap.put(PROCESSSOURCE, "process");
        resultMap.putAll(supplierAssignHelper.insertSupplierColl(supplierIds, customParamMap));
        return resultMap;
    }

    public static Map<Long, Boolean> insertExternalSupplierCollByEvent(Collection<Long> supplierIds, Map<String, String> customParamMap) {
        if (supplierIds == null || supplierIds.isEmpty()) {
            throw new KDException(new ErrorCode("", ResManager.loadKDString((String)"\u53c2\u6570:supplierIds\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u3002", (String)"PurSupplierCollInitiateHelper_1", (String)"scm-pur-business", (Object[])new Object[0])), new Object[0]);
        }
        if (log.isInfoEnabled()) {
            log.info("PurSupplierAssignHelper#query#supplierUpdateInfoMap:{},supplierIds:{}", (Object)SerializationUtils.toJsonString(supplierIds), (Object)SerializationUtils.toJsonString(customParamMap));
        }
        customParamMap.put(PROCESSSOURCE, "external");
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(64);
        PurSupplierAssignHelper supplierAssignHelper = new PurSupplierAssignHelper();
        resultMap.putAll(supplierAssignHelper.insertSupplierCollByEvent(supplierIds, customParamMap));
        return resultMap;
    }

    public static Map<Long, Boolean> insertExternalSupplierColl(Collection<Long> supplierIds, Map<String, String> customParamMap) {
        if (supplierIds == null || supplierIds.isEmpty()) {
            throw new KDException(new ErrorCode("", ResManager.loadKDString((String)"\u53c2\u6570:supplierIds\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u3002", (String)"PurSupplierCollInitiateHelper_1", (String)"scm-pur-business", (Object[])new Object[0])), new Object[0]);
        }
        if (log.isInfoEnabled()) {
            log.info("PurSupplierAssignHelper#query#supplierUpdateInfoMap:{},supplierIds:{}", (Object)SerializationUtils.toJsonString(supplierIds), (Object)SerializationUtils.toJsonString(customParamMap));
        }
        customParamMap.put(PROCESSSOURCE, "external");
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(64);
        PurSupplierAssignHelper supplierAssignHelper = new PurSupplierAssignHelper();
        resultMap.putAll(supplierAssignHelper.insertSupplierColl(supplierIds, customParamMap));
        return resultMap;
    }

    public static String dispatchInitializeSupplierCollTask() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(12);
        HashMap<String, String> customParamMap = new HashMap<String, String>(16);
        customParamMap.put(PROCESSSOURCE, "initialize");
        paramMap.put("customParamMap", SerializationUtils.toJsonString(customParamMap));
        PurSupplierCollInitializeHelper collInitializeHelper = new PurSupplierCollInitializeHelper();
        return collInitializeHelper.dispatchTask(paramMap);
    }

    public static String dispatchUpdateSupplierCollTask(Map<Long, Boolean> supplierUpdateInfoMap, Map<String, String> customParamMap) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(12);
        paramMap.put("supplierUpdateInfoMap", SerializationUtils.toJsonString(supplierUpdateInfoMap));
        paramMap.put("customParamMap", SerializationUtils.toJsonString(customParamMap));
        PurSupplierCollInitializeHelper collInitializeHelper = new PurSupplierCollInitializeHelper();
        return collInitializeHelper.dispatchTask(paramMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, Boolean> updateSupplierColl(Map<Long, Boolean> supplierUpdateInfoMap, Map<String, String> customParamMap) {
        if (supplierUpdateInfoMap == null || supplierUpdateInfoMap.isEmpty()) {
            throw new KDException(new ErrorCode("", ResManager.loadKDString((String)"\u53c2\u6570:supplierIds\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u3002", (String)"PurSupplierCollInitiateHelper_1", (String)"scm-pur-business", (Object[])new Object[0])), new Object[0]);
        }
        if (log.isInfoEnabled()) {
            log.info("PurSupplierAssignHelper#query#supplierUpdateInfoMap:{},supplierIds:{}", (Object)SerializationUtils.toJsonString(supplierUpdateInfoMap), (Object)SerializationUtils.toJsonString(customParamMap));
        }
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(64);
        PurSupplierCollInitializeHelper supplierCollInitializeHelper = new PurSupplierCollInitializeHelper();
        try {
            PurSupplierAssignHelper purSupplierAssignHelper = new PurSupplierAssignHelper();
            resultMap.putAll(purSupplierAssignHelper.updateSupplierColl(supplierUpdateInfoMap, customParamMap));
        }
        finally {
            supplierCollInitializeHelper.clearSupplierLock(supplierUpdateInfoMap.keySet());
        }
        return resultMap;
    }

    public static QFilter assembleAvailableSupplierQFilter() {
        PurSupplierCollPermHelper supplierCollPermHelper = new PurSupplierCollPermHelper();
        ArrayList<Long> ctrlPurOrg = new ArrayList<Long>(supplierCollPermHelper.assembleAvailableOrgUnits());
        ArrayList<Long> availableCtrlMap = new ArrayList<Long>(supplierCollPermHelper.assembleAvailableCtrl(ctrlPurOrg));
        return supplierCollPermHelper.assembleAvailableSupplierQFilter(availableCtrlMap);
    }

    public static Collection<Long> assembleAvailablePurOrgUnits() {
        PurSupplierCollPermHelper supplierCollPermHelper = new PurSupplierCollPermHelper();
        return supplierCollPermHelper.assembleAvailablePurOrgUnits();
    }

    public static Collection<Long> getUnLockSupplierIds(Collection<Long> supplierIds) {
        PurSupplierCollInitializeHelper collInitializeHelper = new PurSupplierCollInitializeHelper();
        return collInitializeHelper.getUnLockSupplierIds(supplierIds);
    }

    public static void clearSupplierLock(Collection<Long> supplierIds) {
        PurSupplierCollInitializeHelper collInitializeHelper = new PurSupplierCollInitializeHelper();
        collInitializeHelper.clearSupplierLock(supplierIds);
    }

    public static void storeInitiateSyncLog(String traceId, String configString, String paramString, String resultString) {
        ScDataHandleLogInfo scDataHandleLogInfo = new ScDataHandleLogInfo();
        scDataHandleLogInfo.setLogType("successlog");
        scDataHandleLogInfo.setState("success");
        scDataHandleLogInfo.setEntityDesc(ResManager.loadKDString((String)"\u542f\u7528\u91c7\u8d2d\u534f\u540c\u540c\u6b65\u65e5\u5fd7(pur_suppliercoll)", (String)"PurSupplierCollInitiateHelper_2", (String)"scm-pur-business", (Object[])new Object[0]));
        scDataHandleLogInfo.setOperateDesc("storeInitiateLog");
        scDataHandleLogInfo.setLogDim("supplierprocess");
        scDataHandleLogInfo.setLogAppId("pur");
        scDataHandleLogInfo.setConfig(configString);
        scDataHandleLogInfo.setConfigTag(configString);
        scDataHandleLogInfo.setParams(paramString);
        scDataHandleLogInfo.setParamsTag(paramString);
        scDataHandleLogInfo.setResult(resultString);
        scDataHandleLogInfo.setResultTag(resultString);
        scDataHandleLogInfo.setTraceId(traceId);
        scDataHandleLogInfo.setUserName(RequestContext.get().getUserName());
        scDataHandleLogInfo.setCreator(Long.valueOf(RequestContext.get().getCurrUserId()));
        ScDataHandleLogHelper.fireInfoScDataLog((ScDataHandleLogInfo)scDataHandleLogInfo);
    }

    public static Map<Long, String> querySuppplierTryColseInfo(Collection<Long> supplierIds) {
        HashMap<Long, String> verifySupplierCOllMap = new HashMap<Long, String>(supplierIds.size());
        PurSupplierCollInactiveHelper supplierCollInactiveHelper = new PurSupplierCollInactiveHelper();
        verifySupplierCOllMap.putAll(supplierCollInactiveHelper.querySupplierTryCloseInfo(supplierIds));
        return verifySupplierCOllMap;
    }

    public static Integer getMaxReturnData() {
        Integer defaultMaxReturnData = Integer.getInteger("100000");
        Integer maxReturnData = 0;
        try {
            Object billParam = ParamUtil.getBillParam((String)"pur_order", (String)"maxreturndata");
            if (billParam instanceof Integer) {
                maxReturnData = (Integer)billParam;
            } else if (billParam instanceof String) {
                maxReturnData = Integer.parseInt(billParam.toString());
            }
        }
        catch (RuntimeException runtimeException) {
            maxReturnData = defaultMaxReturnData;
            SRMStoreExceptionTraceHelper.saveWarnData((RuntimeException)runtimeException);
        }
        return maxReturnData;
    }

    public static Integer getOpBatchCount() {
        Integer defaultOpBatchCount = Integer.getInteger("100");
        Integer opBatchCount = 0;
        try {
            Object billParam = ParamUtil.getBillParam((String)"pur_order", (String)"opbatchcount");
            if (billParam instanceof Integer) {
                opBatchCount = (Integer)billParam;
            } else if (billParam instanceof String) {
                opBatchCount = Integer.parseInt(billParam.toString());
            }
        }
        catch (RuntimeException runtimeException) {
            opBatchCount = defaultOpBatchCount;
            SRMStoreExceptionTraceHelper.saveWarnData((RuntimeException)runtimeException);
        }
        return opBatchCount;
    }

    public static boolean verifyInitializeButtonControl() {
        PurSupplierCollInitializeHelper collInitializeHelper = new PurSupplierCollInitializeHelper();
        return collInitializeHelper.verifyInitializeButtonControl();
    }

    public static boolean verifyNeedInitialize() {
        PurSupplierCollInitializeHelper collInitializeHelper = new PurSupplierCollInitializeHelper();
        return collInitializeHelper.verifyNeedInitialize();
    }

    public static QFilter getSupplierInactiveCollMustQFilter() {
        PurSupplierCollInactiveHelper supplierCollInactiveHelper = new PurSupplierCollInactiveHelper();
        return supplierCollInactiveHelper.getMustInactiveQFilter();
    }

    static {
        PurSupplierCollInitiateHelper.getThreadPool();
        SUPPLIERIDS = "supplierIds";
        ORDERBILLIDS = "orderBillIds";
        ORDERCHANGEBILLIDS = "orderChangeBillIds";
        ACCEPTBILLIDS = "acceptBillIds";
        RECEIPTBILLIDS = "receiptBillIds";
        INBILLBILLIDS = "inBillBillIds";
        EXECUTEBILLSTRING = "executebillstring";
        BATCHSIZE = "batchsize";
        EXECUTECHANNEL = "executechannel";
        PROCESSSOURCE = "processsource";
        BATCH_INITIALIZE_SUPPLIER_CONTROL = "batchinitializesuppliercontrol";
    }
}

