/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business.suppliercoll;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pur.business.suppliercoll.PurSupplierCollPermHelper;

public final class PurSupplierJointControlHelper {
    private static final Log log = LogFactory.getLog(PurSupplierJointControlHelper.class);

    public static Map<Long, Boolean> querySupplierCollEnable(Collection<Long> supplierIds, Map<String, String> customParamMap) {
        if (supplierIds == null || supplierIds.isEmpty()) {
            throw new KDException(new ErrorCode("", ResManager.loadKDString((String)"\u53c2\u6570:supplierIds\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u3002", (String)"PurSupplierJointControlHelper_0", (String)"scm-pur-business", (Object[])new Object[0])), new Object[0]);
        }
        if (log.isInfoEnabled()) {
            log.info("PurSupplierAssignHelper#querySupplierEnableColl#supplierIds:{},customParamMap:{}", (Object)SerializationUtils.toJsonString(supplierIds), (Object)SerializationUtils.toJsonString(customParamMap));
        }
        QFilter supplierCollQFilter = new QFilter("supplier.id", "in", supplierIds);
        String billDateString = customParamMap.get("billDate");
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (billDateString != null) {
            try {
                Date date = sf.parse(billDateString);
                supplierCollQFilter.and(new QFilter("enabletime", "<=", (Object)date).or(new QFilter("disabletime", ">=", (Object)date).and(new QFilter("enabletime", "<=", (Object)date))));
            }
            catch (ParseException e) {
                log.warn((Throwable)e);
            }
        }
        Map supplierCollCaches = BusinessDataServiceHelper.loadFromCache((String)"pur_suppliercollinfo", (QFilter[])new QFilter[]{supplierCollQFilter});
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(64);
        HashSet<Long> needCheckSupplierIds = new HashSet<Long>(supplierIds.size());
        if (supplierCollCaches.isEmpty()) {
            needCheckSupplierIds.addAll(supplierIds);
        }
        for (Map.Entry entry : supplierCollCaches.entrySet()) {
            DynamicObject supplierData = ((DynamicObject)entry.getValue()).getDynamicObject("supplier");
            if (supplierData == null) continue;
            Long supplierId = supplierData.getLong("id");
            resultMap.put(supplierId, Boolean.TRUE);
            if (supplierIds.contains(supplierId)) continue;
            needCheckSupplierIds.add(supplierId);
        }
        PurSupplierCollPermHelper supplierCollPermHelper = new PurSupplierCollPermHelper();
        if (!needCheckSupplierIds.isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", needCheckSupplierIds);
            ArrayList<Long> ctrlPurOrg = new ArrayList<Long>(1);
            String mainOrgId = customParamMap.get("mainOrgId");
            if (mainOrgId != null) {
                ctrlPurOrg.add(Long.parseLong(mainOrgId));
                QFilter supplierQFilter = supplierCollPermHelper.assembleAvailableSupplierQFilter(ctrlPurOrg);
                supplierQFilter.and(new QFilter("masterid", "in", needCheckSupplierIds));
                qFilter.or(supplierQFilter);
            }
            Map supplierData = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_supplier"), (QFilter[])new QFilter[]{qFilter});
            for (Map.Entry entry : supplierData.entrySet()) {
                DynamicObject entryValue = (DynamicObject)entry.getValue();
                if (entryValue.getBoolean("issuppcolla")) {
                    supplierIds.forEach(row -> resultMap.put((Long)row, Boolean.TRUE));
                    continue;
                }
                supplierIds.forEach(row -> resultMap.put((Long)row, Boolean.FALSE));
            }
        }
        if (resultMap.isEmpty()) {
            supplierIds.forEach(row -> resultMap.put((Long)row, Boolean.FALSE));
        } else {
            Set keySet = resultMap.keySet();
            if (keySet.size() < supplierIds.size()) {
                supplierIds.forEach(row -> {
                    if (!keySet.contains(row)) {
                        resultMap.put((Long)row, Boolean.FALSE);
                    }
                });
            }
        }
        if (log.isInfoEnabled()) {
            log.info("PurSupplierAssignHelper#querySupplierEnableColl#resultMap:{}", (Object)SerializationUtils.toJsonString(resultMap));
        }
        return resultMap;
    }
}

