/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business.suppliercoll.jointbill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.pur.business.suppliercoll.PurSupplierCollInitiateHelper;
import kd.scm.pur.business.suppliercoll.jointbill.AbstractInitJointDataService;

final class InitCosmicJointDataService
extends AbstractInitJointDataService {
    private final List<OperationResult> operationResultList = new ArrayList<OperationResult>(1024);

    InitCosmicJointDataService() {
    }

    @Override
    protected void executeInitData(Collection<String> orderBillIdsParam, Collection<String> orderChangeBillIdsParam, Collection<String> acceptBillIdsParam, Collection<String> receiptBillIdsParam, Collection<String> inBillBillIdsParam) {
        this.executeCosmicBatchSync(orderBillIdsParam, orderChangeBillIdsParam, acceptBillIdsParam, receiptBillIdsParam, inBillBillIdsParam);
    }

    private void executeCosmicBatchSync(Collection<String> orderBillIdsParam, Collection<String> orderChangeBillIdsParam, Collection<String> acceptBillIdsParam, Collection<String> receiptBillIdsParam, Collection<String> inBillBillIdsParam) {
        OperationResult operationInBill;
        OperationResult operationReceipt;
        OperationResult operationAcceptReturn;
        OperationResult operationAccept;
        OperationResult operationOrderChange;
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        HashSet orderBillIds = new HashSet(1024);
        HashSet orderChangeBillIds = new HashSet(1024);
        HashSet acceptBillIds = new HashSet(1024);
        HashSet receiptBillIds = new HashSet(1024);
        HashSet inBillBillIds = new HashSet(1024);
        orderBillIdsParam.forEach(row -> orderBillIds.add(Long.parseLong(row)));
        orderChangeBillIdsParam.forEach(row -> orderChangeBillIds.add(Long.parseLong(row)));
        acceptBillIdsParam.forEach(row -> acceptBillIds.add(Long.parseLong(row)));
        receiptBillIdsParam.forEach(row -> receiptBillIds.add(Long.parseLong(row)));
        inBillBillIdsParam.forEach(row -> inBillBillIds.add(Long.parseLong(row)));
        OperationResult operationOrder = OperationServiceHelper.executeOperate((String)"autopushpurorder", (String)"pm_purorderbill", (Object[])orderBillIds.toArray(), (OperateOption)operateOption);
        if (operationOrder != null) {
            this.operationResultList.add(operationOrder);
        }
        if ((operationOrderChange = OperationServiceHelper.executeOperate((String)"autopushpurorderchange", (String)"pm_xpurorderbill", (Object[])orderChangeBillIds.toArray(), (OperateOption)operateOption)) != null) {
            this.operationResultList.add(operationOrderChange);
        }
        if ((operationAccept = OperationServiceHelper.executeOperate((String)"autopushpurreceipt", (String)"pm_puracceptbill", (Object[])acceptBillIds.toArray(), (OperateOption)operateOption)) != null) {
            this.operationResultList.add(operationAccept);
        }
        if ((operationAcceptReturn = OperationServiceHelper.executeOperate((String)"autopushpurreturn", (String)"pm_puracceptbill", (Object[])acceptBillIds.toArray(), (OperateOption)operateOption)) != null) {
            this.operationResultList.add(operationAcceptReturn);
        }
        if ((operationReceipt = OperationServiceHelper.executeOperate((String)"scpautopush", (String)"im_purreceivebill", (Object[])receiptBillIds.toArray(), (OperateOption)operateOption)) != null) {
            this.operationResultList.add(operationReceipt);
        }
        if ((operationInBill = OperationServiceHelper.executeOperate((String)"scpautopush", (String)"im_purinbill", (Object[])inBillBillIds.toArray(), (OperateOption)operateOption)) != null) {
            this.operationResultList.add(operationInBill);
        }
    }

    @Override
    protected void storeInitiateSyncLog(String traceId) {
        HashMap<String, String> configMap = new HashMap<String, String>(16);
        configMap.put(PurSupplierCollInitiateHelper.BATCHSIZE, String.valueOf(this.batchSize));
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        StringBuilder errorMessage = new StringBuilder();
        StringBuilder validMessage = new StringBuilder();
        StringBuilder successMessage = new StringBuilder();
        for (OperationResult operationResult : this.operationResultList) {
            Map resultBillNos = operationResult.getBillNos();
            if (resultBillNos != null) {
                for (Map.Entry entry : resultBillNos.entrySet()) {
                    successMessage.append((String)entry.getValue()).append(System.lineSeparator());
                }
            }
            List allErrorInfo = operationResult.getAllErrorInfo();
            allErrorInfo.forEach(row -> errorMessage.append(row.getMessage()).append(System.lineSeparator()));
            List validateResults = operationResult.getValidateResult().getValidateErrors();
            validateResults.forEach(row -> validMessage.append(row.getMessage()).append(System.lineSeparator()));
        }
        resultMap.put("successMessage", successMessage.toString());
        resultMap.put("validMessage", validMessage.toString());
        resultMap.put("errorMessage", errorMessage.toString());
        PurSupplierCollInitiateHelper.storeInitiateSyncLog(traceId, SerializationUtils.toJsonString(configMap), SerializationUtils.toJsonString((Object)this.executeBillMap), SerializationUtils.toJsonString(resultMap));
    }
}

