/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.checkmapping.PurCheckMappingUtils;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.pur.business.CreateAPBillSupportHelper;
import kd.scm.pur.business.PurInvoiceJointHelper;
import kd.scm.pur.business.PurInvoiceTransferHelper;
import kd.scm.pur.business.PurJointChannelHelper;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class PurInvoiceUtil {
    private static final Log log = LogFactory.getLog(PurInvoiceUtil.class);
    private static final String PUR_ENTRYENTITY = "entryentity1";
    private static final String PUR_ENTRYENTITY_SUFFIX = "1";
    private static final String SAL_ENTRYENTITY = "materialentry";
    private static final String INVOICEADDRESS = "invaddress";
    private static final String INVOICENO = "invoiceno";
    private static final String INVOICECODE = "invoicecode";
    private static final String INVOICEDATE = "invoicedate";
    private static final String BIZPARTNER = "bizpartner";
    private static final String SUPPLIER = "supplier";
    private static final String PAYABLENO = "payableno";
    private static final String PAYABLEAMT = "payableamt";
    private static final String CFMNOTE = "cfmnote";
    private static final String ISPAY = "ispay";
    private static final String SRCBILLID = "srcbillid";
    private static final String SRCBILLENTRYID = "srcentryid";
    private static final String SRCBILLTYPE = "srcbilltype";
    private static final String ENTRY_QTY = "qty";
    private static final String ENTRY_TAXAMOUNT = "taxamount";
    private static final String ENTRY_AMOUNT = "amount";
    private static final String ENTRY_POBILLID = "pobillid";
    private static final String ENTRY_POENTRYID = "poentryid";

    private static DynamicObject[] removeEntrys(DynamicObject[] invoiceObjs) {
        HashSet<DynamicObject> entrySet = new HashSet<DynamicObject>();
        for (DynamicObject bill : invoiceObjs) {
            DynamicObjectCollection entryCol = bill.getDynamicObjectCollection(PUR_ENTRYENTITY);
            for (DynamicObject entry : entryCol) {
                if (!PUR_ENTRYENTITY_SUFFIX.equals(entry.getString("isentrypay"))) continue;
                entrySet.add(entry);
            }
            for (DynamicObject entry : entrySet) {
                entryCol.remove((Object)entry);
            }
            entrySet.clear();
        }
        return invoiceObjs;
    }

    public static Map<String, Object> toInvoice(DynamicObject[] invoiceObjs, Map<String, String> botpNumbers) {
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("code", "200");
        param.put("billtype", "pur_invoice");
        param.put("action", "confirm");
        HashSet<Long> invoiceIDS = new HashSet<Long>((int)((double)invoiceObjs.length / 0.75));
        for (DynamicObject invoiceObj : invoiceObjs) {
            invoiceIDS.add(invoiceObj.getLong("id"));
        }
        QFilter prodfilter = new QFilter("id", "in", invoiceIDS);
        String selectors = DynamicObjectUtil.getSelectfields((String)"pur_invoice", (boolean)false) + "," + DynamicObjectUtil.getEntrySelectfields(null, (String)"pur_invoice", (String)PUR_ENTRYENTITY, (boolean)false) + "," + DynamicObjectUtil.getEntrySelectfields(null, (String)"pur_invoice", (String)SAL_ENTRYENTITY, (boolean)false) + "," + DynamicObjectUtil.getEntrySelectfields(null, (String)"pur_invoice", (String)"entryentity", (boolean)false);
        DynamicObject[] prodArray = BusinessDataServiceHelper.load((String)"pur_invoice", (String)selectors, (QFilter[])new QFilter[]{prodfilter});
        DynamicObject[] newinvoiceObjs = PurInvoiceUtil.removeEntrys(prodArray);
        Map<String, Object> billInfoMap = PurInvoiceUtil.getBillInfo(newinvoiceObjs);
        PurInvoiceUtil.getInvoiceDetailInfo(newinvoiceObjs);
        boolean enableWriteOffFlag = QueryServiceHelper.exists((String)"pur_updateparamconfig", (QFilter[])new QFilter[]{new QFilter("paramkey", "=", (Object)"writeoffkey").and(new QFilter("paramvalue", "=", (Object)"Y"))});
        boolean easWriteOffFlag = enableWriteOffFlag && ApiConfigUtil.hasEASConfig();
        for (Map.Entry<String, String> entry : botpNumbers.entrySet()) {
            Map infoMap = (Map)billInfoMap.get(entry.getKey());
            if (null == infoMap || easWriteOffFlag) continue;
            infoMap.put("botpNumber", entry.getValue());
        }
        String msg = null;
        if (ApiConfigUtil.hasEASScmConfig() && easWriteOffFlag) {
            if (null != billInfoMap.get("instock")) {
                billInfoMap.put("srcBillType", "instock");
            } else {
                billInfoMap.put("srcBillType", "receipt");
            }
            param.put("data", billInfoMap);
            msg = ApiUtil.doInvoiceToAP(param);
        } else {
            param.put("data", billInfoMap);
            msg = ApiUtil.purInvoiceConfirm(param);
        }
        Map<String, Object> handleAfterPay = PurInvoiceUtil.handleAfterPay(invoiceObjs, enableWriteOffFlag, msg);
        return handleAfterPay;
    }

    public static void toInvoice(DynamicObject[] invoiceObjs, Map<String, String> botpNumbers, IFormView view) {
        PurInvoiceUtil.toInvoice(invoiceObjs, botpNumbers);
        view.showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u5e94\u4ed8\u540e\u53f0\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u7a0d\u540e\u8bf7\u5237\u65b0\u001d\u67e5\u8be2\u3002", (String)"PurInvoiceUtil_8", (String)"scm-pur-business", (Object[])new Object[0]));
        view.updateView();
    }

    private static void getInvoiceDetailInfo(DynamicObject[] newinvoiceObjs) {
        List<Map<String, Object>> invoiceToAPBill = PurInvoiceTransferHelper.assembleInvoiceToAPBill(newinvoiceObjs);
    }

    private static Map<String, Object> handleAfterPay(DynamicObject[] invoiceObjs, Boolean enableWriteOffFlag, String msg) {
        StringBuilder msgSB = new StringBuilder();
        StringBuilder successMsg = new StringBuilder();
        HashSet<String> billNumberSet = new HashSet<String>();
        JSONObject orderID_payNumberMap = null;
        if (msg != null && !msg.isEmpty()) {
            Map typemap = (Map)JacksonJsonUtil.fromJson((String)msg, Map.class);
            for (Map.Entry entry : typemap.entrySet()) {
                Map map = (Map)entry.getValue();
                for (DynamicObject obj : invoiceObjs) {
                    String reasonStr;
                    Object easstatus;
                    Map info;
                    String billno = obj.getString("billno");
                    if (billNumberSet.add(billno)) {
                        String billnoLoadKDString = ResManager.loadKDString((String)"\u53d1\u7968\u5355\u53f7\uff1a", (String)"PurInvoiceUtil_0", (String)"scm-pur-business", (Object[])new Object[0]);
                        successMsg.append(billnoLoadKDString).append(billno);
                        String loadKDString = ResManager.loadKDString((String)"\u751f\u6210\u5e94\u4ed8\u5355\u5355\u636e\u7f16\u53f7\uff1a", (String)"PurInvoiceUtil_1", (String)"scm-pur-business", (Object[])new Object[0]);
                        successMsg.append(loadKDString);
                    }
                    if ((info = (Map)map.get(billno)) == null) continue;
                    Object reason = info.get("reason");
                    if (reason == null || reason.toString().isEmpty()) {
                        obj.set("cfmstatus", (Object)ConfirmStatusEnum.CONFIRM);
                        if (obj.getBigDecimal(PAYABLEAMT) != null && obj.getBigDecimal(PAYABLEAMT).compareTo(BigDecimal.ZERO) != 0) {
                            obj.set(PAYABLEAMT, (Object)obj.getBigDecimal(PAYABLEAMT).add(CommonUtil.getBigDecimalPro(info.get("sumAmount"))));
                        } else {
                            obj.set(PAYABLEAMT, (Object)CommonUtil.getBigDecimalPro(info.get("sumAmount")));
                        }
                        obj.set(CFMNOTE, (Object)"");
                        obj.set(ISPAY, (Object)PUR_ENTRYENTITY_SUFFIX);
                        orderID_payNumberMap = JSONObject.fromObject(info.get("billNumber"));
                        String payBillnos = PurInvoiceUtil.setEntryByOrderid(obj, (Map<String, Object>)orderID_payNumberMap, (String)entry.getKey());
                        if (payBillnos.length() <= 0) continue;
                        successMsg.append(' ');
                        successMsg.append(ResManager.loadKDString((String)"", (String)"PurInvoiceUtil_7", (String)"scm-pur-business", (Object[])new Object[0])).append(payBillnos);
                        successMsg.append(";");
                        continue;
                    }
                    if (enableWriteOffFlag.booleanValue() && "500".equals(String.valueOf(easstatus = info.get("status")))) {
                        DynamicObjectCollection entryCol = obj.getDynamicObjectCollection(PUR_ENTRYENTITY);
                        for (DynamicObject entry1 : entryCol) {
                            entry1.set("isentrypay", (Object)1);
                            entry1.set("entrypaytype", (Object)PUR_ENTRYENTITY_SUFFIX);
                        }
                    }
                    if ((reasonStr = String.valueOf(reason)).getBytes().length > 255) {
                        // empty if block
                    }
                    msgSB.append(reasonStr).append(";\n");
                }
            }
        } else {
            msgSB.append(ResManager.loadKDString((String)"\u672a\u8fd4\u56de\u6570\u636e\u3002", (String)"PurInvoiceUtil_2", (String)"scm-pur-business", (Object[])new Object[0]));
        }
        if (invoiceObjs.length > 0) {
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])invoiceObjs);
        }
        HashMap<String, Object> invoiceStr = new HashMap<String, Object>(8);
        if (msgSB.length() == 0) {
            invoiceStr.put("msg", successMsg.toString());
            invoiceStr.put("success", true);
        } else {
            invoiceStr.put("msg", msgSB.toString());
            invoiceStr.put("success", false);
        }
        return invoiceStr;
    }

    private static String setEntryByOrderid(DynamicObject obj, Map<String, Object> orderID_payNumberMap, String srctype) {
        DynamicObjectCollection entryCol = obj.getDynamicObjectCollection(PUR_ENTRYENTITY);
        Object billnos = null;
        StringBuilder strBuffer = new StringBuilder();
        HashSet<String> billnoSet = new HashSet<String>();
        if (srctype.equals("instockreturn")) {
            srctype = "return";
        }
        if (ApiConfigUtil.hasXKScmConfig()) {
            PurInvoiceUtil.setEntryByOrderIdByXkScm(orderID_payNumberMap, srctype, entryCol, billnoSet);
        } else {
            for (DynamicObject entry : entryCol) {
                billnos = orderID_payNumberMap.get(entry.get("poentryid1"));
                String srcBillType = entry.getString("srcbilltype1");
                if ("pur_instock".equals(srcBillType) || "scp_instock".equals(srcBillType) || "pur_return".equals(srcBillType) || "scp_return".equals(srcBillType)) {
                    srcBillType = "pur_instock";
                }
                if (null == billnos || !srcBillType.contains(srctype)) continue;
                entry.set("entrypaybillno", billnos);
                entry.set("isentrypay", (Object)1);
                entry.set("entrypaytype", (Object)PUR_ENTRYENTITY_SUFFIX);
                billnoSet.add(String.valueOf(billnos));
            }
        }
        for (String paybillno : billnoSet) {
            strBuffer.append(paybillno).append(',');
        }
        if (strBuffer.length() > 0) {
            return strBuffer.toString().substring(0, strBuffer.toString().length() - 1);
        }
        return strBuffer.toString();
    }

    private static void setEntryByOrderIdByXkScm(Map<String, Object> orderID_payNumberMap, String srctype, DynamicObjectCollection entryCol, Set<String> billnoSet) {
        DynamicObjectCollection col;
        HashSet<String> checkIdSet = new HashSet<String>(1024);
        for (DynamicObject entry : entryCol) {
            checkIdSet.add(entry.getString("srcentryid1"));
        }
        QFilter prodfilter = new QFilter("materialentry.srcentryid", "in", checkIdSet);
        String selectors = "id,materialentry.inbillno,materialentry.poentryid,materialentry.srcentryid,materialentry.srcbilltype";
        DynamicObject[] checkArray = BusinessDataServiceHelper.load((String)"pur_check", (String)selectors, (QFilter[])new QFilter[]{prodfilter});
        HashSet<String> instockIdSet = new HashSet<String>(1024);
        HashSet<String> receiptIdSet = new HashSet<String>(1024);
        HashSet<String> returnIdSet = new HashSet<String>(1024);
        if (checkArray.length > 0) {
            for (DynamicObject check : checkArray) {
                DynamicObjectCollection col2 = check.getDynamicObjectCollection(SAL_ENTRYENTITY);
                for (DynamicObject[] entry : col2) {
                    if ("pur_instock".equals(entry.getString(SRCBILLTYPE)) || "scp_instock".equals(entry.getString(SRCBILLTYPE))) {
                        instockIdSet.add(entry.getString(SRCBILLENTRYID));
                        continue;
                    }
                    if ("pur_return".equals(entry.getString(SRCBILLTYPE)) || "scp_return".equals(entry.getString(SRCBILLTYPE))) {
                        returnIdSet.add(entry.getString(SRCBILLENTRYID));
                        continue;
                    }
                    receiptIdSet.add(entry.getString(SRCBILLENTRYID));
                }
            }
        } else {
            for (DynamicObject invEntry : entryCol) {
                String srcEntryId = invEntry.getString("srcentryid1");
                String srcBillType = invEntry.getString("srcbilltype1");
                if ("pur_instock".equals(srcBillType)) {
                    instockIdSet.add(srcEntryId);
                    continue;
                }
                if (!"pur_receipt".equals(srcBillType)) continue;
                receiptIdSet.add(srcEntryId);
            }
        }
        HashMap<String, String> instockId_orderentryIdMap = new HashMap<String, String>(1024);
        HashMap<String, String> receiptId_orderentryIdMap = new HashMap<String, String>(1024);
        HashMap<String, String> returnId_orderentryIdMap = new HashMap<String, String>(1024);
        HashMap<String, String> receiptId_srcentryIdMap = new HashMap<String, String>(1024);
        if (instockIdSet.size() > 0) {
            DynamicObject[] instockArray;
            Set instockIdLongSet = instockIdSet.stream().map(Long::parseLong).collect(Collectors.toSet());
            prodfilter = new QFilter("materialentry.id", "in", instockIdLongSet);
            selectors = "id,materialentry.poentryid,materialentry.srcinsentryid,materialentry.srcentryid,materialentry.srcbilltype";
            for (DynamicObject instock : instockArray = BusinessDataServiceHelper.load((String)"pur_instock", (String)selectors, (QFilter[])new QFilter[]{prodfilter})) {
                col = instock.getDynamicObjectCollection(SAL_ENTRYENTITY);
                for (DynamicObject entry : col) {
                    instockId_orderentryIdMap.put(entry.getString("id"), entry.getString(SRCBILLENTRYID));
                }
            }
        }
        if (returnIdSet.size() > 0) {
            DynamicObject[] returnArray;
            Set returnIdLongSet = returnIdSet.stream().map(Long::parseLong).collect(Collectors.toSet());
            prodfilter = new QFilter("materialentry.id", "in", returnIdLongSet);
            selectors = "id,materialentry.inbillno,materialentry.poentryid,materialentry.srcentryid,materialentry.srcbilltype";
            for (DynamicObject purreturn : returnArray = BusinessDataServiceHelper.load((String)"pur_return", (String)selectors, (QFilter[])new QFilter[]{prodfilter})) {
                col = purreturn.getDynamicObjectCollection(SAL_ENTRYENTITY);
                for (DynamicObject entry : col) {
                    returnId_orderentryIdMap.put(entry.getString("id"), entry.getString(SRCBILLENTRYID));
                }
            }
        }
        if (receiptIdSet.size() > 0) {
            DynamicObject[] receiptArray;
            Set receiptIdLongSet = receiptIdSet.stream().map(Long::parseLong).collect(Collectors.toSet());
            prodfilter = new QFilter("materialentry.id", "in", receiptIdLongSet);
            selectors = "id,materialentry.inbillno,materialentry.poentryid,materialentry.srcentryid,materialentry.srcbilltype";
            for (DynamicObject receipt : receiptArray = BusinessDataServiceHelper.load((String)"pur_receipt", (String)selectors, (QFilter[])new QFilter[]{prodfilter})) {
                col = receipt.getDynamicObjectCollection(SAL_ENTRYENTITY);
                for (DynamicObject entry : col) {
                    if ("appurreced".equals(srctype)) {
                        receiptId_srcentryIdMap.put(entry.getString("id"), entry.getString(SRCBILLENTRYID));
                        continue;
                    }
                    receiptId_orderentryIdMap.put(entry.getString("id"), entry.getString(ENTRY_POENTRYID));
                }
            }
        }
        for (DynamicObject entry : entryCol) {
            String orderEntryId = "";
            String srcentryId = entry.getString("srcentryid1");
            orderEntryId = "instock".equals(srctype) || "propertyconvert".equals(srctype) ? (String)instockId_orderentryIdMap.get(srcentryId) : ("return".equals(srctype) ? (String)returnId_orderentryIdMap.get(srcentryId) : ("appurreced".equals(srctype) ? (String)receiptId_srcentryIdMap.get(srcentryId) : (String)receiptId_orderentryIdMap.get(srcentryId)));
            Object billnos = orderID_payNumberMap.get(orderEntryId);
            if (null == billnos || !entry.getString("srcbilltype1").contains(srctype) && !"appurreced".equals(srctype) && !"propertyconvert".equals(srctype)) continue;
            entry.set("entrypaybillno", billnos);
            entry.set("isentrypay", (Object)1);
            entry.set("entrypaytype", (Object)PUR_ENTRYENTITY_SUFFIX);
            billnoSet.add(String.valueOf(billnos));
        }
    }

    public static Map<String, Object> getBillInfo(DynamicObject[] objs) {
        Set deductBills = PurCheckMappingUtils.getDeductBill();
        HashMap<String, Object> type_billMap = new HashMap<String, Object>();
        HashMap<String, Map<Object, Object>> receiptbillMap = new HashMap<String, Map<Object, Object>>();
        HashMap<String, Map<Object, Object>> instockbillMap = new HashMap<String, Map<Object, Object>>();
        HashMap<String, Map<Object, Object>> instockReturnbillMap = new HashMap<String, Map<Object, Object>>();
        HashMap<String, Map<Object, Object>> receiveBillMap = new HashMap<String, Map<Object, Object>>();
        HashMap<String, Map<String, Object>> propertyConvertBillMap = new HashMap<String, Map<String, Object>>();
        for (DynamicObject obj : objs) {
            Map<String, Object> propertyConvertDetailMap;
            Map<Object, Object> receiptdetailMap = new HashMap();
            Map<Object, Object> instockdetailMap = new HashMap();
            receiptdetailMap = PurInvoiceUtil.getInfo(obj, "receipt", deductBills);
            instockdetailMap = PurInvoiceUtil.getInfo(obj, "instock", deductBills);
            if (null != receiptdetailMap) {
                receiptdetailMap.put("invoiceBillId", String.valueOf(obj.getPkValue()));
                receiptbillMap.put(obj.get("billno").toString(), receiptdetailMap);
            }
            if (null != instockdetailMap) {
                instockdetailMap.put("invoiceBillId", String.valueOf(obj.getPkValue()));
                instockbillMap.put(obj.get("billno").toString(), instockdetailMap);
            }
            if (!ApiConfigUtil.hasXKScmConfig()) continue;
            Map<Object, Object> instockReturndetailMap = new HashMap();
            instockReturndetailMap = PurInvoiceUtil.getInfo(obj, "instockreturn", deductBills);
            if (null != instockReturndetailMap) {
                instockReturndetailMap.put("invoiceBillId", String.valueOf(obj.getPkValue()));
                instockReturnbillMap.put(obj.get("billno").toString(), instockReturndetailMap);
            }
            Map<Object, Object> receivedetailMap = new HashMap();
            receivedetailMap = PurInvoiceUtil.getInfo(obj, "appurreced", deductBills);
            if (null != receivedetailMap) {
                receivedetailMap.put("invoiceBillId", String.valueOf(obj.getPkValue()));
                receiveBillMap.put(obj.get("billno").toString(), receivedetailMap);
            }
            if (null == (propertyConvertDetailMap = PurInvoiceUtil.getInfo(obj, "propertyconvert", deductBills))) continue;
            propertyConvertDetailMap.put("invoiceBillId", String.valueOf(obj.getPkValue()));
            propertyConvertBillMap.put(obj.get("billno").toString(), propertyConvertDetailMap);
        }
        if (receiptbillMap.size() > 0) {
            type_billMap.put("receipt", receiptbillMap);
        }
        if (instockbillMap.size() > 0) {
            type_billMap.put("instock", instockbillMap);
        }
        if (ApiConfigUtil.hasXKScmConfig()) {
            if (instockReturnbillMap.size() > 0) {
                type_billMap.put("instockreturn", instockReturnbillMap);
            }
            if (receiveBillMap.size() > 0) {
                type_billMap.put("appurreced", receiveBillMap);
            }
            if (propertyConvertBillMap.size() > 0) {
                type_billMap.put("propertyconvert", propertyConvertBillMap);
            }
        }
        return type_billMap;
    }

    public static Map<String, String> getBotpRule(DynamicObject[] invoiceObjs, String targetBillType) {
        DynamicObject jointChannelCache = PurJointChannelHelper.getBillSingleJointChannelCache(invoiceObjs, PUR_ENTRYENTITY);
        Map<String, Object> billInfoMap = PurInvoiceUtil.getBillIdInfo(invoiceObjs);
        String rules = "";
        HashMap<String, String> rulesMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> billEntry : billInfoMap.entrySet()) {
            if (billInfoMap.size() <= 0) continue;
            HashMap<String, Object> param = new HashMap<String, Object>();
            Map InfoMap = (Map)billEntry.getValue();
            InfoMap.put("srctype", billEntry.getKey());
            InfoMap.put("targetBillType", targetBillType);
            param.put("data", InfoMap);
            param.put("code", "200");
            rules = PurInvoiceJointHelper.queryJointBotpRuleString(param, jointChannelCache);
            if (StringUtils.isEmpty((String)rules) || "[]".equals(rules)) continue;
            if (rules.contains("error=")) {
                String[] errorMsgs;
                StringBuilder msgs = new StringBuilder();
                msgs.append("[{\"error\":\"");
                for (String errorMsg : errorMsgs = rules.split("}")) {
                    if (!errorMsg.contains("error=")) continue;
                    String[] oneMsg = errorMsg.split("error=");
                    msgs.append(oneMsg[1]).append(' ');
                }
                msgs.append("\"}]");
                rulesMap.put(billEntry.getKey(), msgs.toString());
                continue;
            }
            rulesMap.put(billEntry.getKey(), rules);
        }
        return rulesMap;
    }

    @Deprecated
    public static Map<String, Object> getInfo(DynamicObject bill, String type) {
        return PurInvoiceUtil.getInfo(bill, type, new HashSet<String>(8));
    }

    public static Map<String, Object> getInfo(DynamicObject bill, String type, Set<String> deductBills) {
        HashMap<String, Object> detailMap = new HashMap<String, Object>(8);
        DynamicObjectCollection invoiceCol = bill.getDynamicObjectCollection("entryentity");
        DynamicObject supplier = bill.getDynamicObject(SUPPLIER);
        ArrayList<String> invoiceNoList = new ArrayList<String>(1024);
        ArrayList<String> invoiceCodeList = new ArrayList<String>(1024);
        ArrayList invoiceDetailList = new ArrayList(invoiceCol.size());
        HashMap<String, Object> invoiceDetailMap = null;
        for (DynamicObject invoice : invoiceCol) {
            invoiceNoList.add(invoice.getString("invno"));
            invoiceCodeList.add(invoice.getString("invcode"));
            invoiceDetailMap = new HashMap<String, Object>();
            invoiceDetailMap.put("invoiceCode", invoice.getString("invcode"));
            invoiceDetailMap.put("invoiceNumber", invoice.getString("invno"));
            invoiceDetailMap.put("invoiceSaleName", supplier.getString("name"));
            invoiceDetailMap.put("invoiceOpenDate", invoice.getDate("invdate"));
            invoiceDetailMap.put("invoiceAmount", invoice.getBigDecimal("invoiceamount"));
            invoiceDetailMap.put("invoiceTaxAmount", invoice.getBigDecimal("invtax"));
            invoiceDetailMap.put("invoiceAllAmount", invoice.getBigDecimal("invamount"));
            invoiceDetailMap.put("serialNo", invoice.getString("invserialnum"));
            String invcheckstatus = invoice.getString("invcheckstatus");
            Boolean checkOut = Boolean.FALSE;
            if (invcheckstatus != null) {
                checkOut = PUR_ENTRYENTITY_SUFFIX.equals(invcheckstatus) ? Boolean.TRUE : ("2".equals(invcheckstatus) || "3".equals(invcheckstatus) ? Boolean.FALSE : Boolean.FALSE);
            }
            invoiceDetailMap.put("invoiceCheckout", checkOut);
            invoiceDetailList.add(invoiceDetailMap);
        }
        detailMap.put("invoicedetail", invoiceDetailList);
        detailMap.put("invoiceUrl", bill.get(INVOICEADDRESS));
        detailMap.put("invoiceNo", invoiceNoList);
        detailMap.put("invoiceCode", invoiceCodeList);
        if (bill.get(INVOICEDATE) != null) {
            detailMap.put("invoiceDate", DateUtil.date2str((Date)((Date)bill.get(INVOICEDATE)), null));
        }
        HashSet<String> srcEntryIDSet = new HashSet<String>(1024);
        HashMap<String, String> receiptIdMap = new HashMap<String, String>(1024);
        HashMap<String, String> receiptEntryIdMap = new HashMap<String, String>(1024);
        if (ApiConfigUtil.hasXKScmConfig()) {
            PurInvoiceUtil.getSrcEntryIDSet(new DynamicObject[]{bill}, srcEntryIDSet, receiptIdMap, receiptEntryIdMap);
        }
        DynamicObject org = bill.getDynamicObject("org");
        detailMap.put("supplierNumber", supplier.getString("number"));
        detailMap.put("companyNumber", org.getString("number"));
        DynamicObject sup = supplier;
        DynamicObjectCollection entry_bank = (DynamicObjectCollection)sup.get("entry_bank");
        if (entry_bank.size() > 0) {
            detailMap.put("xhf_yhzh", ((DynamicObject)entry_bank.get(0)).get("bankaccount"));
        } else {
            detailMap.put("xhf_yhzh", "3569896565646665666");
        }
        HashMap<String, BigDecimal> entryId_qty_map = new HashMap<String, BigDecimal>(8);
        HashMap<String, BigDecimal> entryId_taxAmount_map = new HashMap<String, BigDecimal>(8);
        HashMap<String, BigDecimal> entryId_Amount_map = new HashMap<String, BigDecimal>(8);
        HashMap<String, BigDecimal> entryId_CheckAmount_map = new HashMap<String, BigDecimal>(8);
        HashMap<String, BigDecimal> entryId_checkTaxAmount_map = new HashMap<String, BigDecimal>(8);
        HashMap<String, BigDecimal> entryId_checkTaxPirce_map = new HashMap<String, BigDecimal>(8);
        HashMap<String, BigDecimal> entryId_deductamount_map = new HashMap<String, BigDecimal>(8);
        HashMap<String, String> entryId_afterdeductdiscounttype_map = new HashMap<String, String>(8);
        HashMap<String, BigDecimal> entryId_afterdeductdctrate_map = new HashMap<String, BigDecimal>(8);
        HashMap<String, BigDecimal> entryId_afterdeductamount_map = new HashMap<String, BigDecimal>(8);
        HashMap<String, BigDecimal> entryId_afterdeducttaxamount_map = new HashMap<String, BigDecimal>(8);
        HashMap<String, BigDecimal> entryId_afterdeductdctamount_map = new HashMap<String, BigDecimal>(8);
        String suffix = PUR_ENTRYENTITY_SUFFIX;
        DynamicObjectCollection entryCol = bill.getDynamicObjectCollection(PUR_ENTRYENTITY);
        DynamicObject[] srcBillObjects = null;
        if (entryCol == null || entryCol.size() == 0) {
            entryCol = bill.getDynamicObjectCollection(SAL_ENTRYENTITY);
            suffix = "";
        } else {
            srcBillObjects = PurInvoiceUtil.querySrcBillInfo(entryCol, PUR_ENTRYENTITY, suffix);
        }
        HashMap entryMap = new HashMap();
        String erpSrcBilltype = null;
        for (DynamicObject entry : entryCol) {
            Object erpSrcBillId = null;
            Object erpSrcEntryId = null;
            if (suffix.isEmpty()) {
                erpSrcBillId = entry.get(ENTRY_POBILLID);
                erpSrcEntryId = entry.get(ENTRY_POENTRYID);
            } else {
                String srcbilltype = entry.getString(SRCBILLTYPE + suffix);
                String srcentryid = entry.getString(SRCBILLENTRYID + suffix);
                if (deductBills.contains(srcbilltype)) continue;
                if (srcbilltype.contains("receipt")) {
                    if ("instock".equals(type) || ApiConfigUtil.hasXKScmConfig() && ("instockreturn".equals(type) || entry.getBigDecimal("qty1").compareTo(BigDecimal.ZERO) < 0 || srcEntryIDSet.contains(srcentryid) && "appurreced".equals(type))) continue;
                    if (ApiConfigUtil.hasXKScmConfig()) {
                        if ("appurreced".equals(type)) {
                            if (srcEntryIDSet.contains(srcentryid)) continue;
                            erpSrcBillId = receiptIdMap.get(entry.get("srcbillid1"));
                            erpSrcEntryId = receiptEntryIdMap.get(entry.get("srcentryid1"));
                        } else {
                            if (srcEntryIDSet.size() <= 0 || !srcEntryIDSet.contains(srcentryid)) continue;
                            erpSrcBillId = entry.get("pobillid1");
                            erpSrcEntryId = entry.get("poentryid1");
                        }
                    } else {
                        erpSrcBillId = entry.get("pobillid1");
                        erpSrcEntryId = entry.get("poentryid1");
                    }
                } else {
                    erpSrcBillId = entry.get(SRCBILLID + suffix);
                    DynamicObject srcBillEntry = PurInvoiceUtil.getSrcBillEntry(srcBillObjects, erpSrcBillId, erpSrcEntryId = entry.get(SRCBILLENTRYID + suffix));
                    if (srcBillEntry != null) {
                        erpSrcBillId = srcBillEntry.get(SRCBILLID);
                        erpSrcEntryId = srcBillEntry.get(SRCBILLENTRYID);
                        erpSrcBilltype = srcBillEntry.getString(SRCBILLTYPE);
                    } else {
                        erpSrcBillId = null;
                        erpSrcEntryId = null;
                    }
                    if ("receipt".equals(type) || "appurreced".equals(type) || ApiConfigUtil.hasXKScmConfig() && ((!srcbilltype.contains("return") ? "instockreturn".equals(type) : "instock".equals(type)) || (!"PUR_PropertyConvert".equals(erpSrcBilltype) ? "propertyconvert".equals(type) : "instock".equals(type) || "instockreturn".equals(type)))) continue;
                }
            }
            if (erpSrcEntryId == null || erpSrcEntryId.toString().trim().isEmpty() || erpSrcBillId == null || erpSrcBillId.toString().trim().isEmpty()) continue;
            String srcBillId = erpSrcBillId.toString();
            String srcBillEntryId = erpSrcEntryId.toString();
            if (entryMap.get(srcBillId) != null) {
                ((HashSet)entryMap.get(srcBillId)).add(srcBillEntryId);
            } else {
                HashSet<String> list = new HashSet<String>(16);
                list.add(srcBillEntryId);
                entryMap.put(srcBillId, list);
            }
            BigDecimal qty = CommonUtil.getBigDecimalPro(entryId_qty_map.get(srcBillEntryId));
            entryId_qty_map.put(srcBillEntryId, qty.add(CommonUtil.getBigDecimalPro((Object)entry.get(ENTRY_QTY + suffix))));
            BigDecimal taxAmount = CommonUtil.getBigDecimalPro(entryId_taxAmount_map.get(srcBillEntryId));
            entryId_taxAmount_map.put(srcBillEntryId, taxAmount.add(CommonUtil.getBigDecimalPro((Object)entry.get(ENTRY_TAXAMOUNT + suffix))));
            BigDecimal amount = CommonUtil.getBigDecimalPro(entryId_Amount_map.get(srcBillEntryId));
            entryId_Amount_map.put(srcBillEntryId, amount.add(CommonUtil.getBigDecimalPro((Object)entry.get(ENTRY_AMOUNT + suffix))));
            BigDecimal checkTaxAmount = CommonUtil.getBigDecimalPro(entryId_checkTaxAmount_map.get(srcBillEntryId));
            entryId_checkTaxAmount_map.put(srcBillEntryId, checkTaxAmount.add(CommonUtil.getBigDecimalPro((Object)entry.get("actchecktaxamount"))));
            BigDecimal actcheckamount = CommonUtil.getBigDecimalPro(entryId_CheckAmount_map.get(srcBillEntryId));
            entryId_CheckAmount_map.put(srcBillEntryId, actcheckamount.add(CommonUtil.getBigDecimalPro((Object)entry.get("actcheckamount"))));
            BigDecimal checkTaxPrice = CommonUtil.getBigDecimalPro(entryId_checkTaxPirce_map.get(srcBillEntryId));
            entryId_checkTaxPirce_map.put(srcBillEntryId, checkTaxPrice.add(CommonUtil.getBigDecimalPro((Object)entry.get("actchecktaxprice"))));
            BigDecimal deductamount = CommonUtil.getBigDecimalPro((Object)entry.get("deductamount"));
            if (deductamount == null || deductamount.signum() == 0) continue;
            entryId_deductamount_map.put(srcBillEntryId, deductamount.add(CommonUtil.getBigDecimalPro(entryId_deductamount_map.get(srcBillEntryId))));
            String afterdeductdiscounttype = entry.getString("afterdeductdiscounttype");
            String afterdeductdiscounttypeOld = entryId_afterdeductdiscounttype_map.getOrDefault(srcBillEntryId, afterdeductdiscounttype);
            entryId_afterdeductdiscounttype_map.put(srcBillEntryId, afterdeductdiscounttypeOld);
            BigDecimal afterdeductdctrate = CommonUtil.getBigDecimalPro(entryId_afterdeductdctrate_map.get(srcBillEntryId));
            entryId_afterdeductdctrate_map.put(srcBillEntryId, afterdeductdctrate.add(CommonUtil.getBigDecimalPro((Object)entry.get("afterdeductdctrate"))));
            BigDecimal afterdeductamount = CommonUtil.getBigDecimalPro(entryId_afterdeductamount_map.get(srcBillEntryId));
            entryId_afterdeductamount_map.put(srcBillEntryId, afterdeductamount.add(CommonUtil.getBigDecimalPro((Object)entry.get("afterdeductamount"))));
            BigDecimal afterdeducttaxamount = CommonUtil.getBigDecimalPro(entryId_afterdeducttaxamount_map.get(srcBillEntryId));
            entryId_afterdeducttaxamount_map.put(srcBillEntryId, afterdeducttaxamount.add(CommonUtil.getBigDecimalPro((Object)entry.get("afterdeducttaxamount"))));
            BigDecimal afterdeductdctamount = CommonUtil.getBigDecimalPro(entryId_afterdeductdctamount_map.get(srcBillEntryId));
            entryId_afterdeductdctamount_map.put(srcBillEntryId, afterdeductdctamount.add(CommonUtil.getBigDecimalPro((Object)entry.get("afterdeductdctamount"))));
        }
        detailMap.put("checkTaxAmount", entryId_checkTaxAmount_map);
        detailMap.put("checkTaxPrice", entryId_checkTaxPirce_map);
        detailMap.put("invoiceQty", entryId_qty_map);
        detailMap.put("invoiceTaxAmount", entryId_checkTaxAmount_map);
        detailMap.put("invoiceAmount", entryId_CheckAmount_map);
        detailMap.put("srcBillType", type);
        detailMap.put("entry", entryMap);
        if (!CollectionUtils.isEmpty(entryId_afterdeductdiscounttype_map)) {
            detailMap.put("discountType", entryId_afterdeductdiscounttype_map);
        }
        if (!CollectionUtils.isEmpty(entryId_afterdeductdctrate_map)) {
            detailMap.put("discountRate", entryId_afterdeductdctrate_map);
        }
        if (!CollectionUtils.isEmpty(entryId_afterdeductdctamount_map)) {
            detailMap.put("discountAmount", entryId_afterdeductdctamount_map);
        }
        if (!CollectionUtils.isEmpty(entryId_afterdeducttaxamount_map)) {
            detailMap.put("finalTaxAmount", entryId_afterdeducttaxamount_map);
        }
        if (entryId_qty_map.size() == 0 || entryId_taxAmount_map.size() == 0) {
            return null;
        }
        detailMap.putAll(CreateAPBillSupportHelper.getAllExtendFields(bill));
        return detailMap;
    }

    private static void getSrcEntryIDSet(DynamicObject[] invoiceObjs, Set<String> srcEntryIDSet, Map<String, String> receipteIDMap, Map<String, String> receiptEntryIDMap) {
        DynamicObject[] receiptDyns;
        DynamicObjectCollection entryCol;
        DynamicObject[] checkDyns;
        HashSet<String> srcIdSet = new HashSet<String>(1024);
        HashSet<Long> srcIdSet_Long = new HashSet<Long>(1024);
        for (DynamicObject dynamicObject : invoiceObjs) {
            DynamicObjectCollection entryCol2 = dynamicObject.getDynamicObjectCollection(PUR_ENTRYENTITY);
            for (DynamicObject entry : entryCol2) {
                if (!entry.getString("srcbilltype1").contains("receipt")) continue;
                srcIdSet.add(entry.getString("srcentryid1"));
                srcIdSet_Long.add(entry.getLong("srcentryid1"));
            }
        }
        HashSet<Long> checkIdSet = new HashSet<Long>(1024);
        QFilter qFilter = new QFilter("materialentry.srcentryid", "in", srcIdSet);
        for (DynamicObject check : checkDyns = BusinessDataServiceHelper.load((String)"pur_check", (String)"id,materialentry.srcbillid,materialentry.srcentryid", (QFilter[])qFilter.toArray())) {
            checkIdSet.add(check.getLong("id"));
        }
        Map map = BFTrackerServiceHelper.findSourceBills((String)"pur_check", (Long[])checkIdSet.toArray(new Long[checkDyns.length]));
        Map scpOrderCheck = BFTrackerServiceHelper.findSourceBills((String)"scp_check", (Long[])checkIdSet.toArray(new Long[checkDyns.length]));
        HashSet orderCheckIdSet = new HashSet(1024);
        if (map.size() > 0) {
            orderCheckIdSet.addAll((Collection)map.get("pur_ordercheck"));
        }
        if (scpOrderCheck.size() > 0) {
            orderCheckIdSet.addAll((Collection)scpOrderCheck.get("scp_ordercheck"));
        }
        if (orderCheckIdSet.size() > 0) {
            DynamicObject[] orderchecks;
            qFilter = new QFilter("id", "in", orderCheckIdSet);
            for (DynamicObject orderCheck : orderchecks = BusinessDataServiceHelper.load((String)"pur_ordercheck", (String)"id,entryentity.srcbillid,entryentity.srcentryid", (QFilter[])qFilter.toArray())) {
                entryCol = orderCheck.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryCol) {
                    srcEntryIDSet.add(entry.getString(SRCBILLENTRYID));
                }
            }
        }
        qFilter = new QFilter("materialentry.id", "in", srcIdSet_Long);
        for (DynamicObject receipt : receiptDyns = BusinessDataServiceHelper.load((String)"pur_receipt", (String)"id,materialentry.id,materialentry.srcbillid,materialentry.srcentryid", (QFilter[])qFilter.toArray())) {
            entryCol = receipt.getDynamicObjectCollection(SAL_ENTRYENTITY);
            receipteIDMap.put(receipt.getString("id"), ((DynamicObject)entryCol.get(0)).getString(SRCBILLID));
            for (DynamicObject entry : entryCol) {
                receiptEntryIDMap.put(entry.getString("id"), entry.getString(SRCBILLENTRYID));
            }
        }
    }

    public static Map<String, Object> getBillIdInfo(DynamicObject[] invoiceObjs) {
        HashMap<String, Object> dataBySrcTypeMap = new HashMap<String, Object>();
        String suffix = PUR_ENTRYENTITY_SUFFIX;
        HashSet<String> srcEntryIDSet = new HashSet<String>(1024);
        HashMap<String, String> receiptIdMap = new HashMap<String, String>(1024);
        HashMap<String, String> receiptEntryIdMap = new HashMap<String, String>(1024);
        Set deductBill = PurCheckMappingUtils.getDeductBill();
        if (ApiConfigUtil.hasXKScmConfig()) {
            PurInvoiceUtil.getSrcEntryIDSet(invoiceObjs, srcEntryIDSet, receiptIdMap, receiptEntryIdMap);
        }
        for (DynamicObject invoice : invoiceObjs) {
            DynamicObjectCollection entryCol = invoice.getDynamicObjectCollection(PUR_ENTRYENTITY);
            DynamicObject[] srcBillObjects = null;
            if (entryCol == null || entryCol.size() == 0) {
                entryCol = invoice.getDynamicObjectCollection(SAL_ENTRYENTITY);
                suffix = "";
            } else {
                srcBillObjects = PurInvoiceUtil.querySrcBillInfo(entryCol, PUR_ENTRYENTITY, suffix);
            }
            String srcErpBillType = null;
            for (DynamicObject entry : entryCol) {
                String srcbilltype1;
                if (null == entry.get("entrypaybillno") || !StringUtils.isEmpty((String)entry.getString("entrypaybillno")) || deductBill.contains(srcbilltype1 = entry.getString("srcbilltype1"))) continue;
                HashSet<String> entryIdSet = new HashSet<String>();
                HashSet<String> billIdSet = new HashSet<String>();
                Object sb = null;
                Object sbei = null;
                if (suffix.isEmpty()) {
                    sb = entry.get(ENTRY_POBILLID);
                    sbei = entry.get(ENTRY_POENTRYID);
                } else {
                    sb = entry.get(SRCBILLID + suffix);
                    DynamicObject srcBillEntry = PurInvoiceUtil.getSrcBillEntry(srcBillObjects, sb, sbei = entry.get(SRCBILLENTRYID + suffix));
                    if (srcBillEntry != null) {
                        sb = srcBillEntry.get(SRCBILLID);
                        sbei = srcBillEntry.get(SRCBILLENTRYID);
                        srcErpBillType = srcBillEntry.getString(SRCBILLTYPE);
                    } else {
                        sb = null;
                        sbei = null;
                    }
                    if (entry.getString("srcbilltype1").contains("receipt")) {
                        sb = entry.get("pobillid1");
                        sbei = entry.get("poentryid1");
                    }
                }
                if (sbei == null || sbei.toString().trim().isEmpty() || sb == null || sb.toString().trim().isEmpty()) continue;
                String srcBillId = sb.toString();
                String srcBillEntryId = sbei.toString();
                if (entry.getString("srcbilltype1").contains("receipt")) {
                    if (ApiConfigUtil.hasXKScmConfig()) {
                        if (entry.getBigDecimal("qty1").compareTo(BigDecimal.ZERO) < 0) continue;
                        if (srcEntryIDSet.contains(entry.getString("srcentryid1"))) {
                            PurInvoiceUtil.getBillIdInfo("receipt", dataBySrcTypeMap, srcBillId, srcBillEntryId, entryIdSet, billIdSet);
                            continue;
                        }
                        srcBillId = (String)receiptIdMap.get(entry.getString("srcbillid1"));
                        srcBillEntryId = (String)receiptEntryIdMap.get(entry.getString("srcentryid1"));
                        PurInvoiceUtil.getBillIdInfo("appurreced", dataBySrcTypeMap, srcBillId, srcBillEntryId, entryIdSet, billIdSet);
                        continue;
                    }
                    PurInvoiceUtil.getBillIdInfo("receipt", dataBySrcTypeMap, srcBillId, srcBillEntryId, entryIdSet, billIdSet);
                    continue;
                }
                if (ApiConfigUtil.hasXKScmConfig()) {
                    if (entry.getString("srcbilltype1").contains("return")) {
                        PurInvoiceUtil.getBillIdInfo("instockreturn", dataBySrcTypeMap, srcBillId, srcBillEntryId, entryIdSet, billIdSet);
                        continue;
                    }
                    if ("PUR_PropertyConvert".equals(srcErpBillType)) {
                        PurInvoiceUtil.getBillIdInfo("propertyconvert", dataBySrcTypeMap, srcBillId, srcBillEntryId, entryIdSet, billIdSet);
                        continue;
                    }
                    PurInvoiceUtil.getBillIdInfo("instock", dataBySrcTypeMap, srcBillId, srcBillEntryId, entryIdSet, billIdSet);
                    continue;
                }
                PurInvoiceUtil.getBillIdInfo("instock", dataBySrcTypeMap, srcBillId, srcBillEntryId, entryIdSet, billIdSet);
            }
        }
        return dataBySrcTypeMap;
    }

    private static void getBillIdInfo(String srcType, Map<String, Object> dataBySrctypeMap, String srcBillId, String srcBillEntryId, Set<String> entryIdSet, Set<String> billIdSet) {
        if (null == dataBySrctypeMap.get(srcType)) {
            entryIdSet.add(srcBillEntryId);
            billIdSet.add(srcBillId);
            HashMap<String, Set<String>> dataMap = new HashMap<String, Set<String>>(8);
            dataMap.put("billId", billIdSet);
            dataMap.put("entryId", entryIdSet);
            dataBySrctypeMap.put(srcType, dataMap);
        } else {
            Map dataMap = (Map)dataBySrctypeMap.get(srcType);
            ((Set)dataMap.get("billId")).add(srcBillId);
            ((Set)dataMap.get("entryId")).add(srcBillEntryId);
        }
    }

    private static DynamicObject[] querySrcBillInfo(DynamicObjectCollection entryCol, String entryEntity, String suffix) {
        ArrayList<DynamicObject> allSrcDyObjList = new ArrayList<DynamicObject>();
        DynamicObject[] instockObjects = null;
        DynamicObject[] returnObjects = null;
        if (!suffix.isEmpty()) {
            String selectFields = "id,materialentry.id,materialentry.srcbillid,materialentry.srcentryid,materialentry.srcbilltype";
            HashMap paramMap = new HashMap(8);
            HashMap<String, Set<Object>> idMap = new HashMap<String, Set<Object>>(1);
            idMap.put("in", PurInvoiceUtil.getIdList(entryCol, entryEntity, suffix));
            paramMap.put("id", idMap);
            instockObjects = ORMUtil.load((String)"pur_instock", (String)selectFields, paramMap);
            allSrcDyObjList.addAll(Arrays.asList(instockObjects));
            returnObjects = ORMUtil.load((String)"pur_return", (String)selectFields, paramMap);
            allSrcDyObjList.addAll(Arrays.asList(returnObjects));
        }
        return allSrcDyObjList.toArray(new DynamicObject[0]);
    }

    private static DynamicObject getSrcBillEntry(DynamicObject[] srcBillObjs, Object srcBillId, Object srcBillEntryId) {
        DynamicObject entry = null;
        for (DynamicObject srcBill : srcBillObjs) {
            String billId = String.valueOf(srcBill.getPkValue());
            if (!srcBillId.equals(billId)) continue;
            DynamicObjectCollection entryCols = srcBill.getDynamicObjectCollection(SAL_ENTRYENTITY);
            for (DynamicObject entryCol : entryCols) {
                String billEntryId = String.valueOf(entryCol.getPkValue());
                if (!srcBillEntryId.equals(billEntryId)) continue;
                return entryCol;
            }
        }
        return entry;
    }

    private static Set<Object> getIdList(DynamicObjectCollection entryCol, String entryEntity, String suffix) {
        HashSet<Object> idList = new HashSet<Object>();
        for (DynamicObject entry : entryCol) {
            Object sb = null;
            Object sbi = null;
            if (!suffix.isEmpty()) {
                sb = entry.get(SRCBILLID + suffix);
                sbi = entry.get(SRCBILLENTRYID + suffix);
            }
            if (sbi == null || sbi.toString().trim().isEmpty() || sb == null || sb.toString().trim().isEmpty()) continue;
            Long srcBillId = Long.valueOf(sb.toString());
            idList.add(srcBillId);
        }
        return idList;
    }

    public static void showJdInvoiceLogistics(List<String> jdChildOrderIds, IFormView view) {
        if (null != jdChildOrderIds && jdChildOrderIds.size() > 0) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("pbd_logistics");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("LOGISTICS_TYPE", "invoice");
            paramMap.put("JDCHILDORDERIDS", jdChildOrderIds);
            paramMap.put("platform", EcPlatformEnum.ECPLATFORM_JD.getVal());
            showParameter.setCustomParams(paramMap);
            view.showForm(showParameter);
        }
    }

    public static Long getBizTypeId(DynamicObject purInvoiceDyn) {
        DynamicObjectCollection entryCol = purInvoiceDyn.getDynamicObjectCollection(PUR_ENTRYENTITY);
        Set deductBills = PurCheckMappingUtils.getDeductBill();
        List collectList = entryCol.stream().filter(e -> !deductBills.contains(e.getString("srcbilltype1"))).collect(Collectors.toList());
        if (!collectList.isEmpty()) {
            String pobillid = ((DynamicObject)collectList.get(0)).getString("pobillid1");
            return PurInvoiceUtil.getBizTypeIdByPoBillId(pobillid);
        }
        return 0L;
    }

    public static Long getBizTypeIdByPoBillId(String poBillId) {
        Long[] bizTypeId = new Long[]{0L};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)PurInvoiceUtil.class.getName(), (String)"pur_order", (String)"businesstype", (QFilter[])new QFilter[]{new QFilter("materialentry.pobillid", "=", (Object)poBillId)}, null, (int)1);){
            ds.forEach(row -> {
                bizTypeId[0] = row.getLong("businesstype");
            });
            Long l = bizTypeId[0];
            return l;
        }
    }

    public static boolean checkIsGoodsBizTypeId(String poBillId) {
        return MalNewOrderUtils.checkIsGoodsBizTypeId((Long)PurInvoiceUtil.getBizTypeIdByPoBillId(poBillId));
    }
}

