/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.scm.common.util.BatchCheckUtil;
import kd.scm.common.util.caldynamic.CalDynamicFactory;
import kd.scm.common.util.caldynamic.ICalDynamic;
import kd.scm.common.util.invoice.RelateInvoiceWriteBackUtil;

public class PurCheckBillSaveOp
extends AbstractOperationServicePlugIn {
    private static final String PUR_ENTRYENTITY = "materialentry";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("materialentry.qty");
        e.getFieldKeys().add("materialentry.srcbilltype");
        e.getFieldKeys().add("materialentry.srcentryid");
        e.getFieldKeys().add("materialentry.srcbillid");
        e.getFieldKeys().add("materialentry.taxamount");
        e.getFieldKeys().add("curr");
        e.getFieldKeys().add("materialentry.discounttype");
        e.getFieldKeys().add("materialentry.dctrate");
        e.getFieldKeys().add("materialentry.dctamount");
        e.getFieldKeys().add("deductsumtaxamount");
        e.getFieldKeys().add("materialentry.actchecktaxamount");
        e.getFieldKeys().add("inputamount");
        e.getFieldKeys().add("materialentry.unmatchamt");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] invoiceObjects = e.getDataEntities();
        BatchCheckUtil.writeBackSrcBill((DynamicObject[])invoiceObjects, (String)PUR_ENTRYENTITY, (String)"", (String)"audit", (boolean)true);
        RelateInvoiceWriteBackUtil.writeBackInvoiceAmtAndQty(Arrays.asList(invoiceObjects), (Boolean)RelateInvoiceWriteBackUtil.ADD_OP, (String)"from_check_op");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] invoiceObjects = e.getDataEntities();
        ICalDynamic iCalDynamic = new CalDynamicFactory().createCal();
        for (DynamicObject temp : invoiceObjects) {
            iCalDynamic.calEntryUnmatchAmt(temp, PUR_ENTRYENTITY);
            iCalDynamic.calEntryUnmatchAmount(temp, PUR_ENTRYENTITY);
        }
    }
}

