/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class PurCheckInvStatusUpgradePlugin
implements IUpgradeService {
    private static final int PAGE_SIZE = 2000;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog(ResManager.loadKDString((String)"\u5bf9\u8d26\u5355\u5f00\u7968\u72b6\u6001\u6570\u636e\u5347\u7ea7\u5f00\u59cb\u3002", (String)"ScpCheckInvStatusUpgradePlugin_0", (String)"scm-pur-opplugin", (Object[])new Object[0]));
            boolean upgradeResult = this.upgrade(pProcessInfo, dbKey);
            if (upgradeResult) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(pProcessInfo.toString());
            }
            result.setLog(pProcessInfo.append(ResManager.loadKDString((String)"\u5bf9\u8d26\u5355\u5f00\u7968\u72b6\u6001\u6570\u636e\u5347\u7ea7\u5b8c\u6210\u3002", (String)"ScpCheckInvStatusUpgradePlugin_1", (String)"scm-pur-opplugin", (Object[])new Object[0])).toString());
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    private boolean upgrade(StringBuilder pProcessInfo, String dbKey) {
        DBRoute dbRoute = new DBRoute("pur");
        String sqlAll = "select fid from T_PUR_CHECK";
        try (DataSet totalData = DB.queryDataSet((String)"PurCheckInvStatusUpgradePlugin.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)sqlAll, (Object[])null);){
            ArrayList idList = new ArrayList(16);
            totalData.forEach(rowx -> idList.add(String.valueOf(rowx.getLong("fid"))));
            pProcessInfo.append(ResManager.loadKDString((String)"\u83b7\u53d6\u603b\u6570\u636e\u91cf", (String)"ScpCheckInvStatusUpgradePlugin_3", (String)"scm-pur-opplugin", (Object[])new Object[0])).append(idList.size()).append("\n");
            int count = idList.size();
            int totalPages = count / 2000;
            if (count % 2000 != 0) {
                ++totalPages;
            }
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List<String> subIdList = (pageIndex + 1) * 2000 > idList.size() ? idList.subList(pageIndex * 2000, idList.size()) : idList.subList(pageIndex * 2000, (pageIndex + 1) * 2000);
                if (subIdList.isEmpty()) continue;
                HashMap<Long, String> idAndStatusMap = new HashMap<Long, String>(2000);
                for (Object e : subIdList) {
                    idAndStatusMap.put(Long.parseLong(e.toString()), "A");
                }
                List<Object[]> parms = this.selectData(dbRoute, subIdList, idAndStatusMap);
                if (parms.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
                dbRoute = new DBRoute(dbKey);
                this.updateData(dbRoute, parms);
            }
        }
        return true;
    }

    private List<Object[]> selectData(DBRoute dbRoute, List<String> subIdList, Map<Long, String> idAndStatusMap) {
        String ids = String.join((CharSequence)",", subIdList);
        String sql = " select a.fid,ABS(sum(a.finqty)) finqty,ABS(sum(b.FSumInvQty)) FSumInvQty  from T_PUR_CHECKENTRY2 a  left join T_PUR_CHECKENTRY2_A b on a.fentryid = b.fentryid where a.fid in (" + ids + ") group by a.fid;";
        DataSet ds = DB.queryDataSet((String)"PurSumTaxUpgradePlugin.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)sql, (Object[])null);
        Object object = null;
        try {
            if (ds != null) {
                for (Row row : ds) {
                    if (row == null || row.getBigDecimal("finqty") == null || row.getBigDecimal("FSumInvQty") == null || row.getBigDecimal("FSumInvQty").compareTo(row.getBigDecimal("finqty")) < 0) continue;
                    idAndStatusMap.put(row.getLong("fid"), "B");
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        ArrayList<Object[]> parms = new ArrayList<Object[]>(2000);
        for (Map.Entry entry : idAndStatusMap.entrySet()) {
            Object[] parm = new Object[]{entry.getValue(), entry.getKey()};
            parms.add(parm);
        }
        return parms;
    }

    private void updateData(DBRoute dbRoute, List<Object[]> parms) {
        DB.executeBatch((DBRoute)dbRoute, (String)"update T_PUR_CHECK set finvstatus = ? where fid = ?", parms);
    }
}

