/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.math.BigDecimal;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.scm.common.util.caldynamic.CalDynamicFactory;
import kd.scm.common.util.caldynamic.ICalDynamic;
import kd.scm.pur.opplugin.validator.PurCheckMatchQtyValidator;

public final class PurCheckSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(this.billEntityType.getAllFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new PurCheckMatchQtyValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dynamicObjects = e.getDataEntities();
        DynamicProperty unMatchQtyPro = null;
        RefObject result = new RefObject();
        ICalDynamic iCalDynamic = new CalDynamicFactory().createCal();
        for (DynamicObject bill : dynamicObjects) {
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
            unMatchQtyPro = rows.getDynamicObjectType().getProperty("unmatchqty");
            for (DynamicObject row : rows) {
                String needUpdateQtyString;
                String entryId = row.getString("id");
                if (!this.getOption().tryGetVariableValue(entryId, result) || (needUpdateQtyString = this.getOption().getVariableValue(entryId)) == null) continue;
                unMatchQtyPro.setValue((Object)row, (Object)new BigDecimal(needUpdateQtyString));
            }
            iCalDynamic.calEntryUnmatchAmt(bill, "materialentry");
            iCalDynamic.calEntryUnmatchAmount(bill, "materialentry");
        }
    }
}

