/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.scm.common.helper.scdatahandle.ScDataHandleServiceHelper;
import kd.scm.common.util.BatchCheckUtil;

public class PurCheckUnAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("cfmstatus");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("materialentry.poentryid");
        e.getFieldKeys().add("materialentry.srcEntryId");
        e.getFieldKeys().add("materialentry.actchecktaxamount");
        e.getFieldKeys().add("materialentry.taxamount");
        e.getFieldKeys().add("materialentry.srcbilltype");
        e.getFieldKeys().add("materialentry.srcbillid");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] Objs = e.getDataEntities();
        String billNo = "";
        for (DynamicObject obj : Objs) {
            obj.set("cfmstatus", (Object)" ");
            billNo = obj.getString("billno");
            String suffix = ResManager.loadKDString((String)"\u5df2\u6253\u56de", (String)"PurCheckUnAuditOp_0", (String)"scm-pur-opplugin", (Object[])new Object[0]);
            if (billNo.contains(suffix)) {
                billNo = billNo.replaceAll("[\\(" + suffix + "\\)]", "");
            }
            obj.set("billno", (Object)billNo);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] Objs = e.getDataEntities();
        HashMap<String, BigDecimal> orderEntryId_diffAmtMap = new HashMap<String, BigDecimal>(1024);
        HashMap<String, BigDecimal> instockEntryId_diffAmtMap = new HashMap<String, BigDecimal>(1024);
        HashMap<String, BigDecimal> returnEntryId_diffAmtMap = new HashMap<String, BigDecimal>(1024);
        HashMap<String, BigDecimal> receiveEntryId_diffAmtMap = new HashMap<String, BigDecimal>(1024);
        String orderEntryId = null;
        String srcEntryId = null;
        String srcBillType = null;
        BigDecimal diffAmt = BigDecimal.ZERO;
        for (DynamicObject obj : Objs) {
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entryCol) {
                orderEntryId = entry.getString("poentryid");
                srcEntryId = entry.getString("srcEntryId");
                diffAmt = entry.getBigDecimal("actchecktaxamount").subtract(entry.getBigDecimal("taxamount"));
                if (null != orderEntryId_diffAmtMap.get(orderEntryId)) {
                    BigDecimal oldDiffAmt = (BigDecimal)orderEntryId_diffAmtMap.get(orderEntryId);
                    orderEntryId_diffAmtMap.put(orderEntryId, oldDiffAmt.add(diffAmt));
                } else {
                    orderEntryId_diffAmtMap.put(orderEntryId, diffAmt);
                }
                if (entry.getBigDecimal("actchecktaxamount").compareTo(BigDecimal.ZERO) < 0) {
                    diffAmt = entry.getBigDecimal("taxamount").subtract(entry.getBigDecimal("actchecktaxamount"));
                }
                if ("pur_return".equals(srcBillType = entry.getString("srcbilltype"))) {
                    returnEntryId_diffAmtMap.put(srcEntryId, diffAmt);
                }
                if ("pur_instock".equals(srcBillType)) {
                    instockEntryId_diffAmtMap.put(srcEntryId, diffAmt);
                }
                if (!"pur_receipt".equals(srcBillType)) continue;
                receiveEntryId_diffAmtMap.put(srcEntryId, diffAmt);
            }
        }
        if (returnEntryId_diffAmtMap.size() > 0) {
            BatchCheckUtil.writeBackSrcBill(returnEntryId_diffAmtMap, (String)"pur_return", (String)"unAudit");
        }
        if (instockEntryId_diffAmtMap.size() > 0) {
            BatchCheckUtil.writeBackSrcBill(instockEntryId_diffAmtMap, (String)"pur_instock", (String)"unAudit");
        }
        if (receiveEntryId_diffAmtMap.size() > 0) {
            BatchCheckUtil.writeBackSrcBill(receiveEntryId_diffAmtMap, (String)"pur_receipt", (String)"unAudit");
        }
        if (orderEntryId_diffAmtMap.size() > 0) {
            BatchCheckUtil.writeBackSrcOrderBill(orderEntryId_diffAmtMap, (String)"unAudit");
        }
        ScDataHandleServiceHelper.executeHandle((String)"purcheckunaudit", (DynamicObject[])e.getDataEntities());
    }
}

