/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.scm.pur.business.PurDeliveryScheduleHelper;
import kd.scm.pur.business.PurOrderBillHelper;

public final class PurDeliveryScheduleRowUnCloseOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("qty");
        fieldKeys.add("basicqty");
        fieldKeys.add("poentryid");
        fieldKeys.add("pobillid");
        fieldKeys.add("srcentryid");
        fieldKeys.add("srcbillid");
        fieldKeys.add("entrystatus");
        fieldKeys.add("promisestatus");
        fieldKeys.add("promiseqty");
        fieldKeys.add("promisebasicqty");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String srcentryid;
        super.beforeExecuteOperationTransaction(e);
        LinkedHashMap<Long, BigDecimal> srcVerifyMap = new LinkedHashMap<Long, BigDecimal>(e.getValidExtDataEntities().size());
        ArrayList<Long> entryIds = new ArrayList<Long>(8);
        for (ExtendedDataEntity extendedDataEntity : e.getValidExtDataEntities()) {
            DynamicObject row = extendedDataEntity.getDataEntity();
            Object entryPrimaryKeyValue = row.getPkValue();
            entryIds.add((Long)entryPrimaryKeyValue);
            srcentryid = row.getString("srcentryid");
            if (srcentryid == null || srcentryid.isEmpty()) continue;
            Long parseLong = Long.parseLong(srcentryid);
            BigDecimal verifyQty = (BigDecimal)srcVerifyMap.get(parseLong);
            if (verifyQty != null) {
                verifyQty = verifyQty.add(row.getBigDecimal("qty"));
                srcVerifyMap.put(parseLong, verifyQty);
                continue;
            }
            verifyQty = row.getBigDecimal("qty");
            srcVerifyMap.put(parseLong, verifyQty);
        }
        if (!srcVerifyMap.isEmpty()) {
            Map verifySrcQty = PurOrderBillHelper.verifySrcQtyCanUnClose(srcVerifyMap);
            if (!verifySrcQty.isEmpty()) {
                Iterator dataEntityIterator = e.getValidExtDataEntities().iterator();
                while (dataEntityIterator.hasNext()) {
                    ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)dataEntityIterator.next();
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    srcentryid = dataEntity.getString("srcentryid");
                    Boolean canClose = (Boolean)verifySrcQty.get(Long.parseLong(srcentryid));
                    if (canClose.booleanValue()) continue;
                    dataEntityIterator.remove();
                }
                if (e.getValidExtDataEntities().isEmpty()) {
                    e.setCancel(true);
                    String errorMessage = ResManager.loadKDString((String)"\u5173\u8054\u4ea4\u8d27\u8ba1\u5212\u6570\u91cf\u5df2\u8d85\u51fa\u6570\u91cf\uff0c\u53cd\u5173\u95ed\u5931\u8d25\u3002", (String)"PurDeliveryScheduleRowUnCloseOp_0", (String)"scm-pur-opplugin", (Object[])new Object[0]);
                    e.setCancelMessage(errorMessage);
                }
            } else {
                e.setCancel(true);
                String errorMessage = ResManager.loadKDString((String)"\u5173\u8054\u4ea4\u8d27\u8ba1\u5212\u6570\u91cf\u5df2\u8d85\u51fa\u6570\u91cf\uff0c\u53cd\u5173\u95ed\u5931\u8d25\u3002", (String)"PurDeliveryScheduleRowUnCloseOp_0", (String)"scm-pur-opplugin", (Object[])new Object[0]);
                e.setCancelMessage(errorMessage);
            }
        }
        this.getOption().setVariableValue("deliveryScheduleSuccessRows", SerializationUtils.toJsonString(entryIds));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String deliveryScheduleSuccessRows = this.getOption().getVariableValue("deliveryScheduleSuccessRows");
        HashSet entryPrimaryKeyValues = new HashSet(8);
        if (!StringUtils.isEmpty((CharSequence)deliveryScheduleSuccessRows)) {
            List list = SerializationUtils.fromJsonStringToList((String)deliveryScheduleSuccessRows, Long.class);
            entryPrimaryKeyValues.addAll(list);
        }
        PurDeliveryScheduleHelper.writeBackScheduleQty((DynamicObject[])e.getDataEntities(), entryPrimaryKeyValues, (Boolean)Boolean.FALSE);
    }
}

