/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.helper.LanguageHelper;
import kd.scm.pur.common.PurInvoiceUtil;

public final class PurInvoiceGenerateApOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(PurInvoiceGenerateApOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("billno");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        ArrayList<Object> pkIds = new ArrayList<Object>(1024);
        for (DynamicObject bill : e.getDataEntities()) {
            pkIds.add(bill.get("id"));
        }
        String ruleMapStr = this.getOption().getVariableValue("ruleMap", "");
        log.info("\u751f\u6210\u5e94\u4ed8botp\u89c4\u5219\u4e3a\uff1a{}", (Object)ruleMapStr);
        Map ruleMap = (Map)SerializationUtils.fromJsonString((String)ruleMapStr, Map.class);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pur_invoice"));
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            StringBuilder errorMessage = new StringBuilder();
            Map invoiceResult = PurInvoiceUtil.toInvoice((DynamicObject[])dynamicObjects, (Map)ruleMap);
            log.info("\u8c03\u7528\u751f\u6210\u5e94\u4ed8\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)SerializationUtils.toJsonString((Object)invoiceResult));
            Object success = invoiceResult.get("success");
            String msg = (String)invoiceResult.get("msg");
            String name = LanguageHelper.getLocalValue(this.operateMeta.get("name"));
            if (success != null && ((Boolean)success).booleanValue()) {
                this.getOperationResult().setSuccessPkIds(pkIds);
            } else {
                errorMessage.append(ResManager.loadKDString((String)"\u751f\u6210\u5e94\u4ed8\u5931\u8d25\uff0c\u539f\u56e0\u5982\u4e0b\uff1a", (String)"PurInvoiceGenerateApOp_1", (String)"scm-pur-opplugin", (Object[])new Object[0])).append(msg);
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setTitle(name);
                operateErrorInfo.setLevel(ErrorLevel.Error);
                operateErrorInfo.setMessage(errorMessage.toString());
                this.getOperationResult().setSuccessPkIds(new ArrayList(8));
                this.getOperationResult().getAllErrorInfo().add(operateErrorInfo);
                this.getOperationResult().setSuccess(false);
            }
        }
    }
}

