/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.helper.scdatahandle.ScDataHandleServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ParamConfigUtil;

public class PurOrdChangeSupConfirmOp
extends AbstractOperationServicePlugIn {
    private final Boolean scconsistencyservice = ParamConfigUtil.getCacheBooleanParamConfig((String)"scconsistencyservice");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("cfmstatus");
        fieldKeys.add("cfm");
        fieldKeys.add("cfmdate");
        fieldKeys.add("pobillno");
        fieldKeys.add("materialentry.poentryid");
        fieldKeys.add("materialentry.chgtype");
        fieldKeys.add("materialentry.promiseday");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<String> scpOrderNumberSet = new HashSet<String>(dataEntities.length);
        HashMap<String, Date> changedOrderEntryId = new HashMap<String, Date>();
        for (DynamicObject dynamicObject : dataEntities) {
            dynamicObject.set("cfmstatus", (Object)ConfirmStatusEnum.CONFIRM.getVal());
            scpOrderNumberSet.add(dynamicObject.getString("pobillno"));
            DynamicObjectCollection materialEntry = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject material : materialEntry) {
                if (!StringUtils.isNotEmpty((CharSequence)material.getString("chgtype"))) continue;
                changedOrderEntryId.put(material.getString("poentryid"), material.getDate("promiseday"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        this.updateScpOrder(scpOrderNumberSet, changedOrderEntryId);
    }

    private void updateScpOrder(Set<String> scpOrderNumberSet, Map<String, Date> changedOrderEntryId) {
        DynamicObject[] scpOrderArray;
        for (DynamicObject dynamicObject : scpOrderArray = BusinessDataServiceHelper.load((String)"pur_order", (String)"id,materialentry.id,materialentry.pobillid,materialentry.poentryid,materialentry.promiseday", (QFilter[])new QFilter[]{new QFilter("billno", "in", scpOrderNumberSet)})) {
            DynamicObjectCollection materialEntry = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject material : materialEntry) {
                Date promiseDay = changedOrderEntryId.get(material.getString("poentryid"));
                if (promiseDay == null) continue;
                material.set("promiseday", (Object)promiseDay);
            }
        }
        SaveServiceHelper.save((DynamicObject[])scpOrderArray);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (this.scconsistencyservice.booleanValue()) {
            ScDataHandleServiceHelper.executeHandle((String)"purorderchangeconfirm", (DynamicObject[])e.getDataEntities());
        }
        if (!this.scconsistencyservice.booleanValue()) {
            HashSet<String> scpOrderNumberSet = new HashSet<String>(dataEntities.length);
            HashMap<String, Date> changedOrderEntryId = new HashMap<String, Date>();
            for (DynamicObject dynamicObject : dataEntities) {
                scpOrderNumberSet.add(dynamicObject.getString("pobillno"));
                DynamicObjectCollection materialEntry = dynamicObject.getDynamicObjectCollection("materialentry");
                for (DynamicObject material : materialEntry) {
                    if (!StringUtils.isNotEmpty((CharSequence)material.getString("chgtype"))) continue;
                    changedOrderEntryId.put(material.getString("poentryid"), material.getDate("promiseday"));
                }
            }
            this.updatePmOrder(scpOrderNumberSet, changedOrderEntryId);
        }
    }

    private void updatePmOrder(Set<String> scpOrderNumberSet, Map<String, Date> changedOrderEntryId) {
        HashMap params = new HashMap();
        DynamicObject[] scpOrderArray = BusinessDataServiceHelper.load((String)"pur_order", (String)"id,materialentry.id,materialentry.pobillid,materialentry.poentryid,materialentry.promiseday", (QFilter[])new QFilter[]{new QFilter("billno", "in", scpOrderNumberSet)});
        ArrayList batchBills = new ArrayList(scpOrderArray.length);
        for (DynamicObject dynamicObject : scpOrderArray) {
            HashMap<String, Serializable> batchBillsMap = new HashMap<String, Serializable>();
            DynamicObjectCollection materialEntry = dynamicObject.getDynamicObjectCollection("materialentry");
            ArrayList billEntry = new ArrayList();
            for (DynamicObject material : materialEntry) {
                Date promiseDay = changedOrderEntryId.get(material.getString("poentryid"));
                if (promiseDay == null) continue;
                batchBillsMap.put("orderBillId", Long.valueOf(material.getString("pobillid")));
                HashMap<String, Object> billEntryMap = new HashMap<String, Object>();
                billEntryMap.put("entryId", Long.valueOf(material.getString("poentryid")));
                billEntryMap.put("promiseDate", DateUtil.date2str((Date)material.getDate("promiseday"), (String)"yyyy-MM-dd"));
                billEntry.add(billEntryMap);
            }
            batchBillsMap.put("billEntry", billEntry);
            batchBills.add(batchBillsMap);
        }
        params.put("batchBills", batchBills);
        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurOrderService", (String)"changeOrderBillPromiseDate", (Object[])new Object[]{params});
    }
}

