/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.util.ExceptionUtil;

public class PurOrderQtyUpgradePlugin
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(PurOrderQtyUpgradePlugin.class);
    private static final int PAGE_SIZE = 500;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u534f\u540c\u91c7\u8d2d\u8ba2\u5355\u5206\u5f55\u65b0\u589e\u7684\u7d2f\u8ba1\u6570\u91cf\u5b57\u6bb5\u5347\u7ea7\u3002", (String)"PurOrderQtyUpgradePlugin_1", (String)"scm-pur-opplugin", (Object[])new Object[0]));
            boolean upgradeResult = this.upgrade(pProcessInfo, dbKey);
            this.setResultInfo(result, upgradeResult, pProcessInfo.toString());
            result.setLog(pProcessInfo.append(ResManager.loadKDString((String)"\u65e7\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5\u3002", (String)"PurOrderQtyUpgradePlugin_2", (String)"scm-pur-opplugin", (Object[])new Object[0])).toString());
            return result;
        }
        catch (Exception e) {
            this.setResultInfo(result, false, pProcessInfo.append(e.getMessage()).toString());
            logger.error(ResManager.loadKDString((String)"\u65e7\u6570\u636e\u5347\u7ea7\u6267\u884c\u5f02\u5e38\u3002", (String)"PurOrderQtyUpgradePlugin_3", (String)"scm-pur-opplugin", (Object[])new Object[0]), (Throwable)e);
            throw new KDBizException(ExceptionUtil.getStackTrace((Throwable)e));
        }
    }

    private void setResultInfo(UpgradeResult result, boolean success, String message) {
        result.setSuccess(success);
        result.setErrorInfo(message);
    }

    private boolean upgrade(StringBuilder pProcessInfo, String dbKey) {
        boolean flag;
        DBRoute dbRoute = new DBRoute(dbKey);
        String sqlAll = " select tp.fentryid from t_pur_orderentry tp,t_pur_orderentry_a tpa where tp.fid =tpa.fid and tp.fentryid =tpa.fentryid and tp.FUnitId = tpa.FBasicUnitID order by tp.fentryid ";
        HashMap<Long, DynamicObject> basicunitMap = new HashMap<Long, DynamicObject>(1024);
        try (DataSet dataSet1 = DB.queryDataSet((String)"PurOrderQtyUpgradePlugin.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)sqlAll, null);){
            ArrayList idList = new ArrayList();
            dataSet1.forEach(row -> idList.add(row.getLong("fentryid")));
            pProcessInfo.append(ResManager.loadKDString((String)"\u83b7\u53d6\u603b\u6570\u636e\u91cf", (String)"PurOrderQtyUpgradePlugin_4", (String)"scm-pur-opplugin", (Object[])new Object[0])).append(idList.size()).append("\n");
            int count = idList.size();
            int totalPages = count / 500;
            if (count % 500 != 0) {
                ++totalPages;
            }
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List<Object[]> params;
                List<Long> subIdList = (pageIndex + 1) * 500 > idList.size() ? idList.subList(pageIndex * 500, idList.size()) : idList.subList(pageIndex * 500, (pageIndex + 1) * 500);
                if (subIdList == null || subIdList.isEmpty() || (params = this.selectData(subIdList, dbRoute, basicunitMap)) == null || params.isEmpty() || params == null || params.isEmpty()) continue;
                this.updateData(dbRoute, params);
            }
            flag = true;
        }
        return flag;
    }

    private List<Object[]> selectData(List<Long> subIdList, DBRoute dbRoute, Map<Long, DynamicObject> basicunitMap) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(500);
        if (!subIdList.isEmpty()) {
            StringBuilder selectFields = new StringBuilder();
            selectFields.append("select ta.fentryid,te.fqty,ta.fsuminstockqty,ta.fsumreceiptqty,ta.fsumoutstockqty ");
            selectFields.append(",ta.fsumrecretqty,ta.fsuminstockretqty,te.fmaterialid,te.funitid ,ta.fbasicunitid ");
            selectFields.append(" from t_pur_orderentry te,t_pur_orderentry_a ta");
            selectFields.append(" where te.fentryid = ta.fentryid ");
            selectFields.append(" and te.fentryid in (").append(StringUtils.join((Object[])subIdList.toArray(new Long[subIdList.size()]), (String)",")).append(")");
            try (DataSet dataSet = DB.queryDataSet((String)"PurOrderQtyUpgradePlugin.selectData", (DBRoute)dbRoute, (String)selectFields.toString(), null);){
                if (dataSet != null && !dataSet.isEmpty()) {
                    dataSet.forEach(entry -> {
                        Long entryid = entry.getLong("fentryid");
                        BigDecimal sumoutstockqty = entry.getBigDecimal("fsumoutstockqty");
                        BigDecimal sumreceiptqty = entry.getBigDecimal("fsumreceiptqty");
                        BigDecimal suminstockqty = entry.getBigDecimal("fsuminstockqty");
                        BigDecimal sumrecretqty = entry.getBigDecimal("fsumrecretqty");
                        BigDecimal suminstockretqty = entry.getBigDecimal("fsuminstockretqty");
                        Long fmaterialid = entry.getLong("fmaterialid");
                        Long funitid = entry.getLong("funitid");
                        Long fbasicunitid = entry.getLong("fbasicunitid");
                        if (fmaterialid == null || funitid == null || fbasicunitid == null || funitid.longValue() == fbasicunitid.longValue()) {
                            BigDecimal sumoutstockbaseqty = sumoutstockqty;
                            BigDecimal sumreceiptbaseqty = sumreceiptqty;
                            BigDecimal suminstockbaseqty = suminstockqty;
                            BigDecimal sumrecretbaseqty = sumrecretqty;
                            BigDecimal suminstockretbaseqty = suminstockretqty;
                            Object[] param = new Object[]{sumoutstockbaseqty, sumoutstockbaseqty, sumreceiptbaseqty, suminstockbaseqty, sumrecretbaseqty, suminstockretbaseqty, entryid};
                            params.add(param);
                        } else {
                            DynamicObject basicUnitObj = PurOrderQtyUpgradePlugin.getBaseUnit(fbasicunitid, basicunitMap);
                            BigDecimal sumoutstockbaseqty = PurOrderQtyUpgradePlugin.getDesQtyConv(fmaterialid, funitid, sumoutstockqty, basicUnitObj);
                            BigDecimal sumreceiptbaseqty = PurOrderQtyUpgradePlugin.getDesQtyConv(fmaterialid, funitid, sumreceiptqty, basicUnitObj);
                            BigDecimal suminstockbaseqty = PurOrderQtyUpgradePlugin.getDesQtyConv(fmaterialid, funitid, suminstockqty, basicUnitObj);
                            BigDecimal sumrecretbaseqty = PurOrderQtyUpgradePlugin.getDesQtyConv(fmaterialid, funitid, sumrecretqty, basicUnitObj);
                            BigDecimal suminstockretbaseqty = PurOrderQtyUpgradePlugin.getDesQtyConv(fmaterialid, funitid, suminstockretqty, basicUnitObj);
                            Object[] param = new Object[]{sumoutstockbaseqty, sumoutstockbaseqty, sumreceiptbaseqty, suminstockbaseqty, sumrecretbaseqty, suminstockretbaseqty, entryid};
                            params.add(param);
                        }
                    });
                }
            }
        }
        return params;
    }

    public static DynamicObject getBaseUnit(Long desUnitId, Map<Long, DynamicObject> baseUnitMap) {
        DynamicObject dyn = baseUnitMap.get(desUnitId);
        if (dyn == null) {
            dyn = QueryServiceHelper.queryOne((String)"bd_measureunits", (String)"id,precision,precisionaccount", (QFilter[])new QFilter("id", "=", (Object)desUnitId).toArray());
            baseUnitMap.put(desUnitId, dyn);
        }
        return dyn;
    }

    public static BigDecimal getDesQtyConv(Long materialId, Long srcUnitId, BigDecimal srcQty, DynamicObject baseUnit) {
        BigDecimal qty = BigDecimal.ZERO;
        if (materialId == null || srcUnitId == null || baseUnit == null || srcQty == null) {
            qty = BigDecimal.ZERO;
        } else {
            Long baseUnitId = baseUnit.getLong("id");
            if (srcUnitId.longValue() == baseUnitId.longValue()) {
                qty = srcQty;
            } else {
                BigDecimal unitRate;
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)baseUnitId);
                if (muConv != null && muConv.getInt("numerator") != 0 && (unitRate = new BigDecimal(muConv.getInt("denominator")).divide(new BigDecimal(muConv.getInt("numerator")), 10, 4)) != null && unitRate.compareTo(BigDecimal.ZERO) != 0) {
                    int unitPrecision = baseUnit.getInt("precision");
                    if (StringUtils.isNotEmpty((CharSequence)baseUnit.getString("precisionaccount"))) {
                        int account = baseUnit.getInt("precisionaccount");
                        int unitPrecisionType = 4;
                        if (account == 2) {
                            unitPrecisionType = 1;
                        } else if (account == 3) {
                            unitPrecisionType = 0;
                        }
                        qty = srcQty.divide(unitRate, unitPrecision, unitPrecisionType);
                    }
                }
            }
        }
        return qty;
    }

    private void updateData(DBRoute dbRoute, List<Object[]> parms) {
        StringBuilder updateSb = new StringBuilder();
        updateSb.append(" update t_pur_orderentry_a set ").append("  fsumoutstockbaseqty = ?,frelateoutstockbaseqty = ?, ").append("  fsumreceiptbaseqty = ?,fsuminstockbaseqty = ?, fsumrecretbaseqty= ? , fsuminstockretbaseqty= ? ").append("  where  fentryid = ? ");
        DB.executeBatch((DBRoute)dbRoute, (String)updateSb.toString(), parms);
    }
}

