/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.MalOrderWriteBackUtil;
import kd.scm.common.util.ScmcUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.pur.business.PurInStockHelper;
import kd.scm.pur.business.PurJointChannelHelper;

public class PurReceiptAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(PurReceiptAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("poentryid");
        e.getFieldKeys().add("pobillid");
        e.getFieldKeys().add("cfmstatus");
        e.getFieldKeys().add("isreturn");
        e.getFieldKeys().add("materialentry");
        e.getFieldKeys().add("goods");
        e.getFieldKeys().add("goods.number");
        e.getFieldKeys().add("goodsdesc");
        e.getFieldKeys().add("billtype");
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("srcentryid");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("businesstype");
        e.getFieldKeys().add("materialentry.linetype");
        e.getFieldKeys().add("materialentry.taxamount");
        e.getFieldKeys().add("basicqty");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dyns = e.getDataEntities();
        this.saveGoodInfo(dyns);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        if (PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"self") || ApiConfigUtil.hasRepcConfig() || MalNewOrderUtils.checkIsGoodsBizType((DynamicObject)objs[0].getDynamicObject("businesstype"))) {
            String entityKey;
            log.info("###\u6267\u884c\u53cd\u5199!");
            if (objs != null && objs.length > 0 && "pur_receipt".equals(entityKey = objs[0].getDataEntityType().getName())) {
                PurInStockHelper.updateAutoConfirmStatus((DynamicObject[])objs);
                ScmcUtil.writeBackData((DynamicObject[])objs, (String)"audit");
                MalOrderWriteBackUtil.writeBackMalOrder((DynamicObject[])objs);
            }
        }
        if (objs != null && objs.length > 0) {
            for (DynamicObject dyn : objs) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("isStrict", "false");
                if (dyn.getBoolean("isreturn")) {
                    OperationServiceHelper.executeOperate((String)"sendretmsgtosup", (String)"pur_receipt_return", (DynamicObject[])new DynamicObject[]{dyn}, (OperateOption)option);
                    continue;
                }
                OperationServiceHelper.executeOperate((String)"sendmsgtosup", (String)"pur_receipt", (DynamicObject[])new DynamicObject[]{dyn}, (OperateOption)option);
            }
        }
    }

    private void saveGoodInfo(DynamicObject[] dyns) {
        HashSet<String> poEntryIds = new HashSet<String>(16);
        HashMap<String, DynamicObject> poEntryIdMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dyn : dyns) {
            DynamicObjectCollection entryCol = dyn.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entryCol) {
                String poEntryId = entry.getString("poentryid");
                if (!StringUtils.isNotBlank((CharSequence)poEntryId)) continue;
                poEntryIds.add(poEntryId);
                poEntryIdMap.put(poEntryId, entry);
            }
        }
        if (!poEntryIds.isEmpty()) {
            QFilter qFilter = new QFilter("materialentry.poentryid", "in", poEntryIds);
            qFilter.and("materialentry.goods.number", "is not null", null);
            String selectFields = "id,billno,materialentry.goods goods,materialentry.goodsdesc goodsdesc,materialentry.poentryid poentryid";
            DynamicObjectCollection dyos = QueryServiceHelper.query((String)"pur_order", (String)selectFields, (QFilter[])qFilter.toArray());
            if (dyos != null && !dyos.isEmpty()) {
                for (DynamicObject dyo : dyos) {
                    DynamicObject receive;
                    String poEntryId = dyo.getString("poentryid");
                    if (!StringUtils.isNotBlank((CharSequence)poEntryId) || (receive = (DynamicObject)poEntryIdMap.get(poEntryId)) == null) continue;
                    receive.set("goods", dyo.get("goods"));
                    receive.set("goodsdesc", dyo.get("goodsdesc"));
                }
            }
        }
    }
}

