/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BillPushAssistUtil;
import kd.scm.common.util.LineTypeUtil;
import kd.scm.common.util.OrderUtil;
import kd.scm.common.util.check.CheckRelationUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.pur.business.PurJointChannelHelper;
import kd.scm.pur.opplugin.util.PurReceiptReturnUtil;

public class PurReceiptReturnAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(PurReceiptReturnAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("poentryid");
        e.getFieldKeys().add("pobillid");
        e.getFieldKeys().add("cfmstatus");
        e.getFieldKeys().add("replenishtype");
        e.getFieldKeys().add("isreturn");
        e.getFieldKeys().add("materialentry");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("srcentryid");
        e.getFieldKeys().add("businesstype");
        e.getFieldKeys().add("materialentry.linetype");
        e.getFieldKeys().add("basicqty");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        if (PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])objs, (String)"self") || ApiConfigUtil.hasRepcConfig() || MalNewOrderUtils.checkIsGoodsBizType((DynamicObject)objs[0].getDynamicObject("businesstype"))) {
            log.info("###\u6267\u884c\u53cd\u5199!");
            ArrayList<DynamicObject> receipReturnDyns = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> receipReturnNotAcceptDyns = new ArrayList<DynamicObject>();
            HashSet<String> poEntryPks = new HashSet<String>();
            for (DynamicObject obj : objs) {
                DynamicObject row;
                DynamicObjectCollection entrys = obj.getDynamicObjectCollection("materialentry");
                boolean amountLineTypeControlCriterion = false;
                Iterator iterator = entrys.iterator();
                while (iterator.hasNext() && !(amountLineTypeControlCriterion = LineTypeUtil.isAmountLineTypeControlCriterion((DynamicObject)(row = (DynamicObject)iterator.next())))) {
                }
                if (obj.getBoolean("isreturn")) {
                    receipReturnDyns.add(obj);
                    if (!amountLineTypeControlCriterion) {
                        receipReturnNotAcceptDyns.add(obj);
                    }
                }
                for (DynamicObject item : entrys) {
                    poEntryPks.add(item.getString("poentryid"));
                }
            }
            if (receipReturnDyns.size() > 0) {
                DynamicObject[] purOrders;
                List tarDataList = BillPushAssistUtil.pushToTargetAuditBill(receipReturnDyns, (String)"scp_receipt", (String)"materialentry", (String)"scp_salreturn");
                CheckRelationUtil.createCheckRelation(receipReturnDyns, (List)tarDataList, (String)"pur_receipt");
                if (receipReturnNotAcceptDyns.size() > 0) {
                    PurReceiptReturnUtil.writeBackPoSumRecRetQty(receipReturnNotAcceptDyns, true);
                }
                if (!CollectionUtils.isEmpty(Arrays.asList(purOrders = OrderUtil.getOrdersByPoEntryIdS((String)PurReceiptReturnAuditOp.getSelectProperties(), poEntryPks)))) {
                    OrderUtil.updateMalOrderByOrder((DynamicObject[])purOrders);
                }
            }
        }
    }

    private static String getSelectProperties() {
        return "billno,billstatus,logstatus,srctype,cfmstatus,materialentry.qty,materialentry.srcentryid,materialentry.srcbillid,materialentry.suminstockretqty,materialentry.sumrecretqty,materialentry.poentryid,materialentry.sumoutstockqty,materialentry.sumreceiptqty,materialentry.suminstockqty,materialentry.entrystatus,materialentry.rowlogstatus";
    }
}

