/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.OrderUtil;
import kd.scm.common.util.ParamConfigUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.pur.business.PurJointChannelHelper;
import kd.scm.pur.opplugin.util.PurReceiptReturnUtil;
import kd.scm.pur.opplugin.util.PurReturnUtil;

public class PurReceiptReturnUnAuditOp
extends AbstractOperationServicePlugIn {
    private final Boolean scconsistencyservice = ParamConfigUtil.getBooleanParamConfig((String)"scconsistencyservice");
    private static final Log log = LogFactory.getLog(PurReceiptReturnUnAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("poentryid");
        e.getFieldKeys().add("pobillid");
        e.getFieldKeys().add("cfmstatus");
        e.getFieldKeys().add("replenishtype");
        e.getFieldKeys().add("isreturn");
        e.getFieldKeys().add("materialentry");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("srcentryid");
        e.getFieldKeys().add("businesstype");
        e.getFieldKeys().add("basicqty");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        if (PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])objs, (String)"self") || ApiConfigUtil.hasRepcConfig() || MalNewOrderUtils.checkIsGoodsBizType((DynamicObject)objs[0].getDynamicObject("businesstype"))) {
            log.info("###\u6267\u884c\u53cd\u5199!");
            ArrayList<DynamicObject> receipReturnDyns = new ArrayList<DynamicObject>();
            ArrayList<Long> billIds = new ArrayList<Long>();
            HashSet<String> poEntryPks = new HashSet<String>();
            for (DynamicObject obj : objs) {
                if (obj.getBoolean("isreturn")) {
                    receipReturnDyns.add(obj);
                    billIds.add((Long)obj.getPkValue());
                }
                DynamicObjectCollection entrys = obj.getDynamicObjectCollection("materialentry");
                for (DynamicObject item : entrys) {
                    poEntryPks.add(item.getString("poentryid"));
                }
            }
            if (receipReturnDyns.size() > 0) {
                PurReturnUtil.writeBackRefundApplyConfirmStatus(receipReturnDyns.toArray(new DynamicObject[0]), "G");
                this.deletTargetBill(billIds);
                this.deletCheckRelation(receipReturnDyns);
                PurReceiptReturnUtil.writeBackPoSumRecRetQty(receipReturnDyns, false);
                DynamicObject[] purOrders = OrderUtil.getOrdersByPoEntryIdS((String)PurReceiptReturnUnAuditOp.getSelectProperties(), poEntryPks);
                if (!CollectionUtils.isEmpty(Arrays.asList(purOrders))) {
                    OrderUtil.updateMalOrderByOrder((DynamicObject[])purOrders);
                }
            }
        }
    }

    private static String getSelectProperties() {
        return "billno,billstatus,logstatus,srctype,cfmstatus,materialentry.qty,materialentry.srcentryid,materialentry.srcbillid,materialentry.suminstockretqty,materialentry.sumrecretqty,materialentry.poentryid,materialentry.sumoutstockqty,materialentry.sumreceiptqty,materialentry.suminstockqty,materialentry.entrystatus,materialentry.rowlogstatus";
    }

    private void deletCheckRelation(List<DynamicObject> receipReturnDyns) {
        ArrayList<String> entryIdList = new ArrayList<String>();
        for (DynamicObject dyn : receipReturnDyns) {
            DynamicObjectCollection entryDyns = dyn.getDynamicObjectCollection("materialentry");
            for (DynamicObject entryDyn : entryDyns) {
                entryIdList.add(entryDyn.getPkValue().toString());
            }
        }
        QFilter filter = new QFilter("srcentryid", "in", entryIdList);
        DeleteServiceHelper.delete((String)"pur_checkrelation", (QFilter[])new QFilter[]{filter});
        log.info("\u5220\u9664\u5bf9\u8d26\u5173\u7cfbsrcentryid:" + entryIdList);
    }

    private void deletTargetBill(List<Long> billIds) {
        Map linkBills = BFTrackerServiceHelper.findTargetBills((String)"scp_receipt", (Long[])billIds.toArray(new Long[billIds.size()]));
        Set targetIdSet = (Set)linkBills.get("scp_salreturn");
        if (null != targetIdSet && targetIdSet.size() > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", String.valueOf(false));
            option.setVariableValue("ishasright", String.valueOf(true));
            OperationResult unAuditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"scp_salreturn", (Object[])targetIdSet.toArray(), (OperateOption)option);
            if (unAuditResult.isSuccess()) {
                OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"scp_salreturn", (Object[])targetIdSet.toArray(), (OperateOption)option);
                if (!deleteResult.isSuccess()) {
                    log.error("@@\u5220\u9664\u76ee\u6807\u5355\u9500\u552e\u9000\u8d27\u5931\u8d25\uff1a" + ExceptionUtil.getErrorInfoDetails((List)deleteResult.getAllErrorOrValidateInfo()));
                    throw new KDBizException(ExceptionUtil.getErrorInfoDetails((List)deleteResult.getAllErrorOrValidateInfo()));
                }
            } else {
                log.error("\u53cd\u5ba1\u6838\u9500\u552e\u9000\u8d27\u5355\u5931\u8d25\uff1a" + ExceptionUtil.getErrorInfoDetails((List)unAuditResult.getAllErrorOrValidateInfo()));
                throw new KDBizException(ExceptionUtil.getErrorInfoDetails((List)unAuditResult.getAllErrorOrValidateInfo()));
            }
            log.info("\u5220\u9664\u9500\u552e\u9000\u8d27\u5355\uff1a" + targetIdSet);
        }
    }
}

