/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.BillPushAssistUtil;
import kd.scm.common.util.ParamConfigUtil;
import kd.scm.common.util.check.CheckRelationUtil;
import kd.scm.pur.business.PurJointChannelHelper;
import kd.scm.pur.opplugin.util.PurReturnUtil;

public class PurReturnAuditOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(PurReturnAuditOp.class);
    private final Boolean scconsistencyservice = ParamConfigUtil.getCacheBooleanParamConfig((String)"scconsistencyservice");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("poentryid");
        e.getFieldKeys().add("pobillid");
        e.getFieldKeys().add("srcbilltype");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("srcentryid");
        e.getFieldKeys().add("replenishtype");
        e.getFieldKeys().add("basicqty");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] returnDyns = e.getDataEntities();
        if (PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"self")) {
            PurReturnUtil.writeBackRefundApplyConfirmStatus(returnDyns, "F");
            List tarDataList = BillPushAssistUtil.pushToTargetAuditBill(Arrays.asList(returnDyns), (String)"scp_return", (String)"materialentry", (String)"scp_salreturn");
            PurReturnUtil.writeBackPoSumReturnQty(returnDyns, true);
            CheckRelationUtil.createCheckRelation(Arrays.asList(returnDyns), (List)tarDataList, (String)"pur_return");
        }
        DynamicObject[] dyns = e.getDataEntities();
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        OperationServiceHelper.executeOperate((String)"sendmsgtosup", (String)"pur_return", (DynamicObject[])dyns, (OperateOption)option);
    }
}

