/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.scm.common.util.ParamConfigUtil;
import kd.scm.pur.business.PurInStockHelper;
import kd.scm.pur.business.PurJointChannelHelper;
import kd.scm.pur.opplugin.util.PurOrderStatusUtil;
import kd.scm.pur.opplugin.util.PurReturnUtil;

public class PurReturnDefaultOp
extends AbstractOperationServicePlugIn {
    private final Boolean scconsistencyservice = ParamConfigUtil.getCacheBooleanParamConfig((String)"scconsistencyservice");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("*");
        e.getFieldKeys().add("materialentry.*");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        for (DynamicObject bill : e.getDataEntities()) {
            PurInStockHelper.tryExecuteInStockUpdate((String)bill.getString("id"));
        }
        PurReturnUtil.handleBeforeExecute(e.getDataEntities(), PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"eas") || PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"xkcloud"));
        boolean iERPConfig = PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"ierp");
        this.handleBeforeExecute(this.dataEntities, iERPConfig);
    }

    private void handleBeforeExecute(DynamicObject[] dyns, boolean erpFlag) {
        if (erpFlag) {
            HashSet<String> poEntryIds = new HashSet<String>(16);
            for (DynamicObject dyn : dyns) {
                DynamicObjectCollection entryCol = dyn.getDynamicObjectCollection("materialentry");
                for (DynamicObject entry : entryCol) {
                    poEntryIds.add(entry.getString("poentryid"));
                }
            }
            DynamicObject[] poOrders = PurOrderStatusUtil.getPurOrders(poEntryIds);
            PurOrderStatusUtil.changePurOrderStatus(poOrders);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        boolean easConfig = PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"eas");
        boolean xkScmConfig = PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"xkcloud");
        boolean iERPConfig = PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"ierp");
        boolean flag = easConfig || xkScmConfig || iERPConfig;
        PurReturnUtil.handleAfterExecute(e.getDataEntities(), flag);
    }
}

