/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin.botp;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.scm.pur.business.PurAvailableStockBasicQtyHelper;
import kd.scm.pur.common.PurVerifyResult;
import kd.scm.pur.opplugin.operatehelper.PurOrderOperateHelper;
import kd.scm.pur.opplugin.util.PurSupplierContacterUtils;

public final class PurOrderToDeliveryScheduleConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(PurOrderToDeliveryScheduleConvertPlugin.class);

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        e.setCustFilterDesc(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5168\u90e8\u6267\u884c\u4ea4\u8d27\u8ba1\u5212\u3002", (String)"PurOrderToDeliveryScheduleConvertPlugin_0", (String)"scm-scp-opplugin", (Object[])new Object[0]));
        e.setCustFilterExpression(" ( ( materialentry.iscontrolqty=true and materialentry.saloutqtyup > ( materialentry.scheduleqty  - materialentry.sumrefundqty - materialentry.sumrejqty ) ) or ( materialentry.iscontrolqty=false and materialentry.qty > ( materialentry.scheduleqty  - materialentry.sumrefundqty - materialentry.sumrejqty ) ) ) ");
        QFilter qFilter = QFilter.of((String)"materialentry.iscontrolqty=true and materialentry.saloutqtyup > ( materialentry.scheduleqty - materialentry.sumrefundqty  - materialentry.sumrejqty )", (Object[])new Object[0]).or(QFilter.of((String)"materialentry.iscontrolqty=false and materialentry.qty > ( materialentry.scheduleqty - materialentry.sumrefundqty  - materialentry.sumrejqty )", (Object[])new Object[0]));
        PurVerifyResult purVerifyResult = PurOrderOperateHelper.verifyCanDeliverySchedule(e.getSelectedRows());
        Collection resultData = purVerifyResult.getData();
        if (!resultData.isEmpty()) {
            logger.info("message:" + purVerifyResult.getMessage() + "data:" + SerializationUtils.toJsonString((Object)purVerifyResult.getData()));
            e.setCustFilterDesc(purVerifyResult.getMessage());
            e.setCustFilterExpression("materialentry.id not in (" + StringUtils.join((Object[])resultData.toArray(new Long[resultData.size()]), (String)",") + ")");
            QFilter canDel = new QFilter("materialentry.id", "not in", (Object)resultData);
            e.getCustQFilters().add(canDel);
        }
        e.getCustQFilters().add(qFilter);
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("materialentry.id");
        e.addSrcField("qty");
        e.addSrcField("basicqty");
    }

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        super.afterGetSourceData(e);
        Map fldProperties = e.getFldProperties();
        DynamicProperty entryIdType = (DynamicProperty)fldProperties.get("materialentry.id");
        DynamicProperty qty = (DynamicProperty)fldProperties.get("qty");
        DynamicProperty basicQty = (DynamicProperty)fldProperties.get("basicqty");
        List sourceRows = e.getSourceRows();
        HashSet<Long> orderEntryIds = new HashSet<Long>(1024);
        for (DynamicObject dynamicObject : sourceRows) {
            orderEntryIds.add(Long.parseLong(entryIdType.getValue((Object)dynamicObject).toString()));
        }
        if (!orderEntryIds.isEmpty()) {
            HashMap<String, String> customParamMap = new HashMap<String, String>(6);
            customParamMap.put("tgtbilltype", "pur_deliveryschedule");
            customParamMap.put("getvaluescene", "function");
            customParamMap.put("valueproperty", "schedulebaseqty");
            Map orderAvailableDataMap = PurAvailableStockBasicQtyHelper.assembleOrderAvailableBasicQty(orderEntryIds, customParamMap);
            for (DynamicObject dynamicObject : sourceRows) {
                Long entryId = Long.parseLong(entryIdType.getValue((Object)dynamicObject).toString());
                Map availableQtyMap = (Map)orderAvailableDataMap.get(entryId);
                if (availableQtyMap == null) continue;
                qty.setValue((Object)dynamicObject, availableQtyMap.get("qty"));
                basicQty.setValue((Object)dynamicObject, availableQtyMap.get("basicqty"));
            }
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entities = entitySet.FindByEntityKey("pur_deliveryschedule");
        PurSupplierContacterUtils.setSupplierContacter(entities, "supplierlink", "supplierlink_id");
    }
}

