/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin.botp;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOptionPrivate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildGroupModeEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.caldynamic.CalDynamicFactory;
import kd.scm.common.util.caldynamic.ICalDynamic;

public final class PurScheduleDeliveryToSaloutstockPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(PurScheduleDeliveryToSaloutstockPlugin.class);

    public void beforeBuildGroupMode(BeforeBuildGroupModeEventArgs e) {
        super.beforeBuildGroupMode(e);
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("materialentry.id");
        e.addSrcField("materialentry.pobillno");
        e.addSrcField("materialentry.pobillid");
        e.addSrcField("materialentry.poentryid");
        e.addSrcField("materialentry.entryrcvorg");
        e.addSrcField("materialentry.warehouse");
    }

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        super.afterGetSourceData(e);
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        OperateOptionPrivate operation = (OperateOptionPrivate)this.getOption();
        Map paramMap = operation.getVariables();
        String srcOrderEntryIdsString = (String)paramMap.get("srcOrderEntryIds");
        HashMap<Long, DynamicObject> srcOrderEntryInfoMap = new HashMap<Long, DynamicObject>(1024);
        if (srcOrderEntryIdsString != null && !srcOrderEntryIdsString.isEmpty()) {
            srcOrderEntryInfoMap.putAll(this.getErpPoEntryInfoMap(srcOrderEntryIdsString));
        }
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey("scp_saloutstock");
        Object currentContacter = this.getCurrentContacter();
        for (ExtendedDataEntity extendedDataEntity : entitys) {
            DynamicObject bill = extendedDataEntity.getDataEntity();
            this.setDefaultValue(bill, currentContacter);
            Long settleOrg = bill.getLong("settleorg_id");
            BigDecimal sumQty = bill.getBigDecimal("sumqty");
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
            DynamicObjectType rowDynamicObjectType = rows.getDynamicObjectType();
            DynamicObjectCollection splitBillEntrys = new DynamicObjectCollection();
            long seq = 1L;
            DynamicObject srcorderInfo = null;
            for (DynamicObject row : rows) {
                BigDecimal qty;
                String entryId = row.getString("srcentryid");
                String entryParamStr = (String)paramMap.get(entryId);
                if (entryParamStr != null && !entryParamStr.isEmpty()) {
                    List entryParamList = (List)SerializationUtils.fromJsonString((String)entryParamStr, List.class);
                    for (Map map : entryParamList) {
                        DynamicObject splitEntry = (DynamicObject)OrmUtils.clone((IDataEntityBase)row, (boolean)false, (boolean)true);
                        splitEntry.setParent(row.getParent());
                        srcorderInfo = this.getSrcOrderInfo(entryId, map, srcOrderEntryInfoMap);
                        this.setRowPro(map, rowDynamicObjectType, splitEntry, srcorderInfo);
                        splitEntry.set("seq", (Object)seq);
                        splitBillEntrys.add((Object)splitEntry);
                        ++seq;
                    }
                } else {
                    srcorderInfo = (DynamicObject)srcOrderEntryInfoMap.get(Long.parseLong(entryId));
                    this.setRowProSrcOrder(rowDynamicObjectType, row, srcorderInfo);
                }
                if (null != settleOrg) {
                    row.set("entrysettleorg", (Object)settleOrg);
                }
                if ((qty = row.getBigDecimal("qty")) == null) {
                    qty = BigDecimal.ZERO;
                }
                sumQty = sumQty.add(qty);
            }
            if (!splitBillEntrys.isEmpty()) {
                bill.set("materialentry", (Object)splitBillEntrys);
            }
            this.setBillPro(bill, srcorderInfo);
            bill.set("sumqty", (Object)sumQty);
        }
        ICalDynamic iCalDynamic = new CalDynamicFactory().createCal();
        for (ExtendedDataEntity extendedDataEntity : entitys) {
            DynamicObject bill = extendedDataEntity.getDataEntity();
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
            for (int i = 0; i < rows.size(); ++i) {
                iCalDynamic.proChanged(bill, "materialentry", "qty", i);
            }
        }
    }

    private void setDefaultValue(DynamicObject dynamicObject, Object currentContacter) {
        if (dynamicObject.get("org") == null) {
            dynamicObject.set("org", (Object)RequestContext.get().getOrgId());
        }
        if (dynamicObject.get("contacter") == null) {
            dynamicObject.set("contacter_id", currentContacter);
        }
    }

    private Object getCurrentContacter() {
        QFilter qFilter = new QFilter("user", "=", (Object)UserServiceHelper.getCurrentUserId()).and(new QFilter("status", "=", (Object)"C"));
        DynamicObject[] operators = BusinessDataServiceHelper.load((String)"scp_bizperson", (String)"masterid,name,number", (QFilter[])new QFilter[]{qFilter});
        if (operators != null && operators.length > 0) {
            return operators[0].getPkValue();
        }
        return 0L;
    }

    private void setBillPro(DynamicObject bill, DynamicObject srcOrderInfo) {
        DynamicObjectType dynamicObjectType = bill.getDynamicObjectType();
        DynamicProperty businessTypePro = dynamicObjectType.getProperty("businesstype_id");
        if (srcOrderInfo != null) {
            Long businessTypeId = srcOrderInfo.getLong("businesstype");
            if (businessTypePro != null) {
                businessTypePro.setValue((Object)bill, (Object)businessTypeId);
            }
        }
    }

    private void setRowPro(Map<String, String> paramMap, DynamicObjectType dynamicObjectType, DynamicObject row, DynamicObject srcOrderInfo) {
        String srcOrderBillNo;
        String srcentryid = row.getString("srcentryid");
        DynamicObject material = row.getDynamicObject("material");
        DynamicObject basicunit = row.getDynamicObject("basicunit");
        DynamicProperty qtyPro = dynamicObjectType.getProperty("qty");
        DynamicProperty basicqtyPro = dynamicObjectType.getProperty("basicqty");
        DynamicProperty unitPro = dynamicObjectType.getProperty("unit_id");
        DynamicProperty pobillidPro = dynamicObjectType.getProperty("pobillid");
        DynamicProperty poentryidPro = dynamicObjectType.getProperty("poentryid");
        DynamicProperty pobillnoPro = dynamicObjectType.getProperty("pobillno");
        DynamicProperty jointdatachannelidpro = dynamicObjectType.getProperty("jointdatachannelid");
        String matchOrderBasicQtyString = paramMap.get("matchorderbasicqty_" + srcentryid);
        String unitId = paramMap.get("unit_" + srcentryid);
        BigDecimal qty = BigDecimal.ZERO;
        if (matchOrderBasicQtyString != null && unitId != null) {
            BigDecimal matchOrderBasicQty = new BigDecimal(matchOrderBasicQtyString);
            DynamicObject unit = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(unitId), (String)"bd_measureunits");
            unitPro.setValue((Object)row, (Object)unit.getLong("id"));
            qty = CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)basicunit, (BigDecimal)matchOrderBasicQty, (DynamicObject)unit);
            qtyPro.setValue((Object)row, (Object)qty);
            basicqtyPro.setValue((Object)row, (Object)matchOrderBasicQty);
        }
        if ((srcOrderBillNo = paramMap.get("billno_" + srcentryid)) != null && !srcOrderBillNo.isEmpty()) {
            pobillnoPro.setValue((Object)row, (Object)srcOrderBillNo);
        }
        if (srcOrderInfo != null) {
            pobillnoPro.setValue((Object)row, srcOrderInfo.get("billno"));
            pobillidPro.setValue((Object)row, srcOrderInfo.get("pobillid"));
            poentryidPro.setValue((Object)row, srcOrderInfo.get("poentryid"));
            jointdatachannelidpro.setValue((Object)row, srcOrderInfo.get("jointdatachannelid"));
        }
        this.setRowProSrcOrder(dynamicObjectType, row, srcOrderInfo);
    }

    private DynamicObject getSrcOrderInfo(String srcEntryId, Map<String, String> paramMap, Map<Long, DynamicObject> srcOrderMap) {
        String srcOrderEntryId = paramMap.get("entryid_" + srcEntryId);
        DynamicObject srcOrderInfo = null;
        if (srcOrderEntryId != null && !srcOrderEntryId.isEmpty()) {
            srcOrderInfo = srcOrderMap.get(Long.parseLong(srcOrderEntryId));
        }
        return srcOrderInfo;
    }

    private void setRowProSrcOrder(DynamicObjectType dynamicObjectType, DynamicObject row, DynamicObject srcOrderInfo) {
        DynamicProperty linetypePro = dynamicObjectType.getProperty("linetype_id");
        DynamicProperty pricePro = dynamicObjectType.getProperty("price");
        DynamicProperty taxPricePro = dynamicObjectType.getProperty("taxprice");
        DynamicProperty discountTypePro = dynamicObjectType.getProperty("discounttype");
        DynamicProperty dctratePro = dynamicObjectType.getProperty("dctrate");
        DynamicProperty actpricePro = dynamicObjectType.getProperty("actprice");
        DynamicProperty acttaxpricePro = dynamicObjectType.getProperty("acttaxprice");
        DynamicProperty loctaxPro = dynamicObjectType.getProperty("loctax");
        DynamicProperty locamountPro = dynamicObjectType.getProperty("locamount");
        DynamicProperty loctaxamountPro = dynamicObjectType.getProperty("loctaxamount");
        DynamicProperty taxrateidPro = dynamicObjectType.getProperty("taxrateid_id");
        DynamicProperty taxPro = dynamicObjectType.getProperty("tax");
        DynamicProperty taxratePro = dynamicObjectType.getProperty("taxrate");
        DynamicProperty pcbillnoPro = dynamicObjectType.getProperty("pcbillno");
        DynamicProperty pcbillidPro = dynamicObjectType.getProperty("pcbillid");
        DynamicProperty pcentryidPro = dynamicObjectType.getProperty("pcentryid");
        DynamicProperty projectPro = dynamicObjectType.getProperty("project");
        DynamicProperty tracePro = dynamicObjectType.getProperty("trace");
        DynamicProperty rcvpersonnamePro = dynamicObjectType.getProperty("rcvpersonname");
        DynamicProperty rcvpersontelPro = dynamicObjectType.getProperty("rcvpersontel");
        DynamicProperty deliaddrPro = dynamicObjectType.getProperty("deliaddr");
        DynamicProperty mftdirectPro = dynamicObjectType.getProperty("mftdirect");
        DynamicProperty mftsupplierPro = dynamicObjectType.getProperty("mftsupplier_id");
        DynamicProperty mftorderidPro = dynamicObjectType.getProperty("mftorderid");
        DynamicProperty mftordernumberPro = dynamicObjectType.getProperty("mftordernumber");
        DynamicProperty technoPro = dynamicObjectType.getProperty("techno");
        DynamicProperty oprentryseqPro = dynamicObjectType.getProperty("oprentryseq");
        DynamicProperty oproperationPro = dynamicObjectType.getProperty("oproperation");
        DynamicProperty oproperationnamePro = dynamicObjectType.getProperty("oproperationname");
        DynamicProperty oprdescriptionPro = dynamicObjectType.getProperty("oprdescription");
        DynamicProperty mftorderentryidPro = dynamicObjectType.getProperty("mftorderentryid");
        DynamicProperty mftorderentryseqPro = dynamicObjectType.getProperty("mftorderentryseq");
        DynamicProperty techidPro = dynamicObjectType.getProperty("techid");
        DynamicProperty oprentryidPro = dynamicObjectType.getProperty("oprentryid");
        DynamicProperty configuredcodePro = dynamicObjectType.getProperty("configuredcode_id");
        DynamicProperty processseqPro = dynamicObjectType.getProperty("processseq");
        DynamicProperty oproperationidPro = dynamicObjectType.getProperty("oproperationid");
        DynamicProperty srcbillid = dynamicObjectType.getProperty("srcbillid");
        DynamicProperty srcentryid = dynamicObjectType.getProperty("srcentryid");
        if (srcOrderInfo != null) {
            srcbillid.setValue((Object)row, (Object)String.valueOf(srcOrderInfo.get("id")));
            srcentryid.setValue((Object)row, (Object)String.valueOf(srcOrderInfo.get("entryid")));
            linetypePro.setValue((Object)row, srcOrderInfo.get("linetype"));
            pricePro.setValue((Object)row, srcOrderInfo.get("price"));
            taxPricePro.setValue((Object)row, srcOrderInfo.get("taxprice"));
            discountTypePro.setValue((Object)row, srcOrderInfo.get("discounttype"));
            dctratePro.setValue((Object)row, srcOrderInfo.get("dctrate"));
            actpricePro.setValue((Object)row, srcOrderInfo.get("actprice"));
            acttaxpricePro.setValue((Object)row, srcOrderInfo.get("acttaxprice"));
            loctaxPro.setValue((Object)row, srcOrderInfo.get("loctax"));
            locamountPro.setValue((Object)row, srcOrderInfo.get("locamount"));
            loctaxamountPro.setValue((Object)row, srcOrderInfo.get("loctaxamount"));
            taxrateidPro.setValue((Object)row, srcOrderInfo.get("taxrateid"));
            taxPro.setValue((Object)row, srcOrderInfo.get("tax"));
            taxratePro.setValue((Object)row, srcOrderInfo.get("taxrate"));
            pcbillnoPro.setValue((Object)row, srcOrderInfo.get("pcbillno"));
            pcbillidPro.setValue((Object)row, srcOrderInfo.get("pcbillid"));
            pcentryidPro.setValue((Object)row, srcOrderInfo.get("pcentryid"));
            projectPro.setValue((Object)row, srcOrderInfo.get("project"));
            tracePro.setValue((Object)row, srcOrderInfo.get("trace"));
            rcvpersonnamePro.setValue((Object)row, srcOrderInfo.get("rcvpersonname"));
            rcvpersontelPro.setValue((Object)row, srcOrderInfo.get("rcvpersontel"));
            deliaddrPro.setValue((Object)row, srcOrderInfo.get("deliaddr"));
            mftdirectPro.setValue((Object)row, srcOrderInfo.get("mftdirect"));
            mftsupplierPro.setValue((Object)row, srcOrderInfo.get("mftsupplier"));
            mftorderidPro.setValue((Object)row, srcOrderInfo.get("mftorderid"));
            mftordernumberPro.setValue((Object)row, srcOrderInfo.get("mftordernumber"));
            technoPro.setValue((Object)row, srcOrderInfo.get("techno"));
            oprentryseqPro.setValue((Object)row, srcOrderInfo.get("oprentryseq"));
            oproperationPro.setValue((Object)row, srcOrderInfo.get("oproperation"));
            oproperationnamePro.setValue((Object)row, srcOrderInfo.get("oproperationname"));
            oprdescriptionPro.setValue((Object)row, srcOrderInfo.get("oprdescription"));
            mftorderentryidPro.setValue((Object)row, srcOrderInfo.get("mftorderentryid"));
            mftorderentryseqPro.setValue((Object)row, srcOrderInfo.get("mftorderentryseq"));
            techidPro.setValue((Object)row, srcOrderInfo.get("techid"));
            oprentryidPro.setValue((Object)row, srcOrderInfo.get("oprentryid"));
            configuredcodePro.setValue((Object)row, srcOrderInfo.get("configuredcode"));
            processseqPro.setValue((Object)row, srcOrderInfo.get("processseq"));
            oproperationidPro.setValue((Object)row, srcOrderInfo.get("oproperationid"));
        }
    }

    private Map<Long, DynamicObject> getErpPoEntryInfoMap(String srcOrderEntryIdsString) {
        Set srcOrderEntryIds = (Set)SerializationUtils.fromJsonString((String)srcOrderEntryIdsString, Set.class);
        return this.getErpPoEntryInfoMap(srcOrderEntryIds);
    }

    private Map<Long, DynamicObject> getErpPoEntryInfoMap(Set<Long> srcOrderEntryIds) {
        HashMap<Long, DynamicObject> srcOrderInfoMap = new HashMap<Long, DynamicObject>(srcOrderEntryIds.size());
        if (!srcOrderEntryIds.isEmpty()) {
            String propertieString = "id,billno,businesstype,materialentry.id entryid,materialentry.linetype linetype,materialentry.ispresent ispresent,materialentry.taxrateid taxrateid,materialentry.price price,materialentry.taxprice taxprice,materialentry.actprice actprice,materialentry.acttaxprice acttaxprice,materialentry.discounttype discounttype,materialentry.dctrate dctrate,materialentry.pobillid pobillid,materialentry.poentryid poentryid,materialentry.jointdatachannelid jointdatachannelid,materialentry.loctax loctax,materialentry.locamount locamount,materialentry.loctaxamount loctaxamount,materialentry.tax tax,materialentry.taxrate taxrate,materialentry.rcvpersonname rcvpersonname,materialentry.rcvpersontel rcvpersontel,materialentry.deliaddr deliaddr,materialentry.pcbillno pcbillno,materialentry.pcbillid pcbillid,materialentry.pcentryid pcentryid,materialentry.project project,materialentry.trace trace,materialentry.mftdirect mftdirect,materialentry.mftsupplier mftsupplier,materialentry.mftorderid mftorderid,materialentry.mftordernumber mftordernumber,materialentry.techno techno,materialentry.oprentryseq oprentryseq,materialentry.oproperation oproperation,materialentry.oproperationname oproperationname,materialentry.oprdescription oprdescription,materialentry.mftorderentryid mftorderentryid,materialentry.mftorderentryseq mftorderentryseq,materialentry.techid techid,materialentry.oprentryid oprentryid,materialentry.configuredcode configuredcode,materialentry.processseq processseq,materialentry.oproperationid oproperationid";
            ORM orm = ORM.create();
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getErpPoEntryInfo", (String)"pur_order", (String)propertieString, (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", srcOrderEntryIds)}, (String)"id");){
                DynamicObjectCollection dynamicObjects = orm.toPlainDynamicObjectCollection(dataSet);
                for (DynamicObject bill : dynamicObjects) {
                    srcOrderInfoMap.put(bill.getLong("entryid"), bill);
                }
            }
            srcOrderEntryIds.clear();
        }
        return srcOrderInfoMap;
    }
}

