/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin.upgrade;

import java.util.HashMap;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.product.ICoreProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class MessageParamUpgradeImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(MessageParamUpgradeImpl.class);
    private static final String[] checktables = new String[]{" t_pur_order ", " t_mal_order ", " t_pur_auditorg ", " t_src_project ", " T_PUR_COMPARE ", " T_PUR_BIDBILL "};

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        ICoreProductSettingService settingService = (ICoreProductSettingService)ServiceFactory.getService(ICoreProductSettingService.class);
        settingService.clearAllCache();
        UpgradeResult result = new UpgradeResult();
        DBRoute dbRoute = new DBRoute("sys");
        String sql = "SELECT fid FROM T_BAS_SYSPARAMETER where fdata like '%issendoldmsg%' and fparamid= '03MIT72ROKNP'";
        String[] stringArray = null;
        try (DataSet ds = DB.queryDataSet((String)"PurIscSaveUpgradePlugin.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)sql);){
            Iterator it = ds.iterator();
            if (it.hasNext()) {
                UpgradeResult upgradeResult = result;
                return upgradeResult;
            }
        }
        catch (Throwable object) {
            stringArray = object;
            throw object;
        }
        StringBuilder exceptionMessage = new StringBuilder();
        for (String table : checktables) {
            if (!this.existsdata(table)) continue;
            try {
                this.update();
            }
            catch (Exception e) {
                exceptionMessage.append(e.getMessage());
                this.updateParam();
            }
            return result;
        }
        if (logger.isErrorEnabled() && exceptionMessage.length() > 0) {
            logger.error(exceptionMessage.toString());
        }
        return result;
    }

    private void update() {
        long orgid = 100000L;
        try {
            orgid = OrgUnitServiceHelper.getRootOrgId();
        }
        catch (Exception e) {
            orgid = 100000L;
            logger.error("\u4ee3\u7801\u5347\u7ea7updateParam\u5931\u8d25\uff0c\u7528\u811a\u672c\u5904\u7406\u53c2\u6570");
        }
        AppParam appParam = new AppParam();
        appParam.setViewType("15");
        appParam.setOrgId(Long.valueOf(orgid));
        appParam.setAppId("eae607fb000143ac");
        HashMap<String, Boolean> params = new HashMap<String, Boolean>(2);
        params.put("issendoldmsg", true);
        SystemParamServiceHelper.saveAppParameter((AppParam)appParam, params);
    }

    private void updateParam() {
        DBRoute dbRoute = new DBRoute("sys");
        long orgid = 100000L;
        try {
            orgid = OrgUnitServiceHelper.getRootOrgId();
        }
        catch (Exception e) {
            orgid = 100000L;
            logger.error("\u4ee3\u7801\u5347\u7ea7updateParam\u5931\u8d25\uff0c\u7528\u811a\u672c\u5904\u7406\u53c2\u6570");
        }
        String sql = "SELECT fid,FDATA FROM T_BAS_SYSPARAMETER where  forgid = ? and fparamid= '03MIT72ROKNP' and fviewtypeid = '15' ";
        try (DataSet ds = DB.queryDataSet((String)"PurIscSaveUpgradePlugin.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)sql, (Object[])new Object[]{orgid});){
            Iterator it = ds.iterator();
            if (it.hasNext()) {
                Row row = (Row)it.next();
                String data = row.getString("FDATA");
                String id = row.getString("fid");
                String subString = data.substring(0, data.length() - 1);
                subString = subString + ",\"issendoldmsg\":true}";
                String updatesql = "update T_BAS_SYSPARAMETER set FDATA =? where  fid=? ";
                DB.execute((DBRoute)dbRoute, (String)updatesql, (Object[])new Object[]{subString, id});
                ICoreProductSettingService settingService = (ICoreProductSettingService)ServiceFactory.getService(ICoreProductSettingService.class);
                settingService.clearAllCache();
            }
        }
    }

    private boolean existsdata(String tablename) {
        DBRoute dbRoute = new DBRoute("pur");
        String sql = "SELECT 1 FROM  " + tablename;
        try (DataSet ds = DB.queryDataSet((String)"MessageParamUpgradeImpl.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)sql);){
            Iterator it = ds.iterator();
            if (it.hasNext()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }
}

