/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class PurSupOrdChangeEntryIdUpgradePluginImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(PurSupOrdChangeEntryIdUpgradePluginImpl.class);
    private static int Page_Index_Max = 5000;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u8ba2\u5355\u53d8\u66f4\u5355\u5206\u5f55id\u5347\u7ea7\u3002", (String)"PurSupOrdChangeEntryIdUpgradePluginImpl_0", (String)"scm-pur-opplugin", (Object[])new Object[0]));
            boolean upgradeResult = this.upgrade(dbKey, pProcessInfo);
            if (upgradeResult) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(pProcessInfo.toString());
            }
            result.setLog(ResManager.loadKDString((String)"\u6267\u884c\u8ba2\u5355\u53d8\u66f4\u5355\u5206\u5f55id\u7ed3\u675f\u3002", (String)"PurSupOrdChangeEntryIdUpgradePluginImpl_1", (String)"scm-pur-opplugin", (Object[])new Object[0]));
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            String errorInfo = ResManager.loadKDString((String)"\u6267\u884c\u8ba2\u5355\u53d8\u66f4\u5355\u5206\u5f55id\u5347\u7ea7\u5f02\u5e38\u3002", (String)"PurSupOrdChangeEntryIdUpgradePluginImpl_2", (String)"scm-pur-opplugin", (Object[])new Object[0]);
            logger.warn(errorInfo, (Throwable)e);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    private boolean upgrade(String dbKey, StringBuilder pProcessInfo) {
        int pageIndex;
        Object row2;
        DBRoute dbRoute = new DBRoute(dbKey);
        String ordChangeSql = "select fid from t_pur_ordchange_a where forigin = '1'";
        ArrayList<String> ordChangeIds = new ArrayList<String>();
        try (DataSet dataSet = DB.queryDataSet((String)"kd.scm.pur.opplugin.upgrade.PurSupOrdChangeEntryIdUpgradePluginImpl", (DBRoute)DBRoute.of((String)"pur"), (String)ordChangeSql);){
            for (Object row2 : dataSet) {
                ordChangeIds.add(row2.getString("fid"));
            }
        }
        if (ordChangeIds.isEmpty()) {
            return true;
        }
        StringBuilder ordChangeEntrySql = new StringBuilder("select fpoentryid from t_pur_ordchangentry_a where fid in (");
        this.spliceSql(ordChangeEntrySql, ordChangeIds);
        ArrayList<String> ordEntryIds = new ArrayList<String>();
        DataSet dataSet = DB.queryDataSet((String)"kd.scm.pur.opplugin.upgrade.PurSupOrdChangeEntryIdUpgradePluginImpl", (DBRoute)DBRoute.of((String)"pur"), (String)ordChangeEntrySql.toString());
        row2 = null;
        try {
            for (Row row3 : dataSet) {
                ordEntryIds.add(row3.getString("fpoentryid"));
            }
        }
        catch (Throwable throwable) {
            row2 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (row2 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)row2).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (ordEntryIds.isEmpty()) {
            return true;
        }
        ArrayList<Object[]> entryParams = new ArrayList<Object[]>(ordEntryIds.size() * 2);
        ArrayList<Object[]> headParams = new ArrayList<Object[]>(ordEntryIds.size() * 2);
        StringBuilder orderEntrySql = new StringBuilder("select fid,fentryid,fpobillid,fpoentryid from t_pur_orderentry_a where fentryid in (");
        this.spliceSql(orderEntrySql, ordEntryIds);
        try (DataSet dataSet2 = DB.queryDataSet((String)"kd.scm.pur.opplugin.upgrade.PurSupOrdChangeEntryIdUpgradePluginImpl", (DBRoute)DBRoute.of((String)"pur"), (String)orderEntrySql.toString());){
            for (Row row4 : dataSet2) {
                Object[] entryParam = new Object[]{row4.getString("fpoentryid"), row4.getString("fentryid")};
                entryParams.add(entryParam);
                Object[] headParam = new Object[]{row4.getString("fpobillid"), row4.getString("fentryid")};
                headParams.add(headParam);
            }
        }
        int pageSize = entryParams.size() / Page_Index_Max;
        if (entryParams.size() % Page_Index_Max != 0) {
            ++pageSize;
        }
        pProcessInfo.append(ResManager.loadKDString((String)"\u83b7\u53d6\u9700\u66f4\u65b0\u5206\u5f55\u603b\u91cf\uff1a{0}\u3002", (String)"PurSupOrdChangeEntryIdUpgradePluginImpl_3", (String)"scm-pur-opplugin", (Object[])new Object[]{entryParams.size()}));
        for (pageIndex = 0; pageIndex < pageSize; ++pageIndex) {
            List<Object> headParamsSubList = (pageIndex + 1) * Page_Index_Max > headParams.size() ? headParams.subList(pageIndex * Page_Index_Max, headParams.size()) : headParams.subList(pageIndex * Page_Index_Max, (pageIndex + 1) * Page_Index_Max);
            if (headParamsSubList.isEmpty()) continue;
            this.updateOrdChangeOrderId(dbRoute, headParamsSubList);
        }
        for (pageIndex = 0; pageIndex < pageSize; ++pageIndex) {
            List<Object> entryParamsSubList = (pageIndex + 1) * Page_Index_Max > entryParams.size() ? entryParams.subList(pageIndex * Page_Index_Max, entryParams.size()) : entryParams.subList(pageIndex * Page_Index_Max, (pageIndex + 1) * Page_Index_Max);
            if (entryParamsSubList.isEmpty()) continue;
            this.updateOrdChangeOrderEntryId(dbRoute, entryParamsSubList);
        }
        return true;
    }

    private void spliceSql(StringBuilder sql, List<String> ids) {
        for (int i = 0; i < ids.size(); ++i) {
            String id = ids.get(i);
            if (!StringUtils.isNotBlank((CharSequence)id)) continue;
            sql.append(id);
            if (i == ids.size() - 1) continue;
            sql.append(",");
        }
        if (sql.toString().endsWith(",")) {
            sql.setLength(sql.length() - 1);
        }
        sql.append(")");
    }

    private void updateOrdChangeOrderId(DBRoute dbRoute, List<Object[]> headParamsSubList) {
        String updateSql = "update t_pur_ordchange_a set fpobillid = ? where fid in (select fid from t_pur_ordchangentry_a where fpoentryid = ?)";
        DB.executeBatch((DBRoute)dbRoute, (String)updateSql, headParamsSubList);
    }

    private void updateOrdChangeOrderEntryId(DBRoute dbRoute, List<Object[]> entryParamsSubList) {
        String updateSql = "update t_pur_ordchangentry_a set fpoentryid = ? where fpoentryid = ?";
        DB.executeBatch((DBRoute)dbRoute, (String)updateSql, entryParamsSubList);
    }
}

