/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.isc.util.PurInstockSaveUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pur.business.PurInStockHelper;

public class PurInstockUtil {
    private static Log logger = LogFactory.getLog(PurInstockUtil.class);

    public static void handleBeforeExecute(DynamicObject[] dyns, boolean erpFlag, boolean easFlag) {
        if (erpFlag) {
            HashMap<String, Map> headDataMap = new HashMap<String, Map>((int)((double)dyns.length / 0.75));
            HashMap<String, Map> entryDataMap = new HashMap<String, Map>();
            DynamicObjectCollection entryCol = null;
            for (DynamicObject dyn : dyns) {
                String number = dyn.getString("billno").toLowerCase();
                headDataMap.put(number, DynamicObjectUtil.plainObject2Map((DynamicObject)dyn));
                entryCol = dyn.getDynamicObjectCollection("materialentry");
                for (DynamicObject entry : entryCol) {
                    entryDataMap.put(number + "_" + entry.get("seq"), DynamicObjectUtil.plainObject2Map((DynamicObject)entry));
                }
            }
            PurInstockSaveUtil helper = new PurInstockSaveUtil();
            if (easFlag) {
                helper.beforeAddEntity(Arrays.asList(dyns), headDataMap, entryDataMap);
            }
            helper.afterAddEntity(Arrays.asList(dyns), headDataMap, entryDataMap);
        }
    }

    public static void handleAfterExecute(DynamicObject[] dyns, boolean erpFlag) {
        if (erpFlag) {
            for (DynamicObject dyn : dyns) {
                try {
                    dyn.set("modifier", (Object)dyn.getDynamicObject("creator"));
                }
                catch (Exception e2) {
                    dyn.set("modifier", (Object)dyn.getLong("creator"));
                }
            }
        }
    }

    @Deprecated
    public static void handleSaveUpdate(DynamicObject[] dyns, boolean erpFlag) {
        if (erpFlag) {
            PurInStockHelper.proxySaveKeyUpdate((String)"pur_instock", (DynamicObject[])dyns);
        }
    }
}

