/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.pur.opplugin.util.PurSaloutstockUtil;

public class PurSaloutstockRowcloseValidator
extends AbstractValidator {
    private static final String MATERIALENTRY = "materialentry";
    private static Log log = LogFactory.getLog(PurSaloutstockRowcloseValidator.class);

    public void validate() {
        ExtendedDataEntity[] extendedDataEntities;
        log.info("@@@kd.scm.pur.opplugin.validator.PurSaloutstockRowcloseValidator.validate");
        String selectedRowCollection = this.getOption().getVariableValue("bos_listselectedrowcollection", "");
        ArrayList<Object> selectedIdSet = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)selectedRowCollection)) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)SerializationUtils.fromJsonString((String)selectedRowCollection, ListSelectedRowCollection.class);
            for (ListSelectedRow row : rows) {
                Object epkv = row.getEntryPrimaryKeyValue();
                selectedIdSet.add(epkv);
            }
        }
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        List<ExtendedDataEntity> dataList = Arrays.stream(dataEntities).collect(Collectors.toList());
        HashSet<Long> srcIdSet = new HashSet<Long>();
        HashMap<Long, BigDecimal> minvalueMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, Long> relationMap = new HashMap<Long, Long>();
        this.dealParamForValid(dataList, srcIdSet, minvalueMap, relationMap, selectedIdSet);
        DynamicObject[] purOrders = PurSaloutstockUtil.queryOrder(srcIdSet);
        HashSet<Long> validSet = new HashSet<Long>();
        HashMap<Long, List<Long>> reverseRelatonMap = this.reverseMap(relationMap);
        this.getUnValidIds(minvalueMap, reverseRelatonMap, purOrders, validSet);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = this.getExtendedDataEntitySet().FindByEntityKey(MATERIALENTRY)) {
            DynamicObject entity = extendedDataEntity.getDataEntity();
            long salEntryId = entity.getLong("id");
            if (!validSet.contains(salEntryId) || !selectedIdSet.contains(salEntryId)) continue;
            String errorMsg = ResManager.loadKDString((String)"\u201c{0}\u201d\u7b2c\u201c{1}\u201d\u884c\uff0c\u53d1\u8d27\u6570\u91cf\u5c06\u8d85\u51fa\u8ba2\u5355\u6570\u91cf\uff0c\u4e0d\u80fd\u53cd\u5173\u95ed\u3002", (String)"PurSaloutstockRowcloseValidator", (String)"scm-pur-opplugin", (Object[])new Object[]{entity.getDataEntityType().getDisplayName(), entity.get("seq").toString()});
            this.addErrorMessage(extendedDataEntity, errorMsg);
        }
    }

    private <K, V> HashMap<V, List<K>> reverseMap(Map<K, V> map) {
        HashMap result = new HashMap();
        map.forEach((key, value) -> {
            List keys = result.getOrDefault(value, new ArrayList());
            keys.add(key);
            result.put(value, keys);
        });
        return result;
    }

    private void getUnValidIds(HashMap<Long, BigDecimal> minvalueMap, HashMap<Long, List<Long>> relationMap, DynamicObject[] purOrders, HashSet<Long> validSet) {
        for (DynamicObject purOrder : purOrders) {
            DynamicObjectCollection materialentry = purOrder.getDynamicObjectCollection(MATERIALENTRY);
            for (DynamicObject col : materialentry) {
                long entryid = col.getLong("id");
                if (!minvalueMap.containsKey(entryid)) continue;
                BigDecimal shortHarvestValue = minvalueMap.get(entryid);
                BigDecimal sumoutstockqty = col.getBigDecimal("sumoutstockqty");
                BigDecimal relateoutstockqty = col.getBigDecimal("relateoutstockqty");
                sumoutstockqty = sumoutstockqty.add(shortHarvestValue);
                relateoutstockqty = relateoutstockqty.add(shortHarvestValue);
                BigDecimal qty = col.getBigDecimal("qty");
                if (sumoutstockqty.compareTo(qty) <= 0 && relateoutstockqty.compareTo(qty) <= 0) continue;
                validSet.addAll((Collection<Long>)relationMap.get(entryid));
            }
        }
    }

    private void dealParamForValid(List<ExtendedDataEntity> dataEntities, HashSet<Long> srcIdSet, HashMap<Long, BigDecimal> minvalueMap, HashMap<Long, Long> relationMap, ArrayList<Object> arr) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObjectCollection materialentrys = entity.getDynamicObjectCollection(MATERIALENTRY);
            for (DynamicObject materialentry : materialentrys) {
                if (!arr.contains(materialentry.get("id"))) continue;
                PurSaloutstockUtil.assembleParam(srcIdSet, minvalueMap, materialentry, relationMap);
            }
        }
    }
}

