/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin.vmi;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.scm.common.util.CommonUtil;

public final class PurImInventorySaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("material");
        fieldKeys.add("qty");
        fieldKeys.add("unit");
        fieldKeys.add("basicunit");
        fieldKeys.add("basicqty");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dynamicObjects = e.getDataEntities();
        IDataEntityProperty qtyProperty = (IDataEntityProperty)this.billEntityType.getProperties().get((Object)"qty");
        BigDecimal qty = null;
        BigDecimal basicQty = null;
        DynamicObject material = null;
        DynamicObject unit = null;
        DynamicObject basicUnit = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            qty = dynamicObject.getBigDecimal("qty");
            if (qty == null || qty.compareTo(BigDecimal.ZERO) != 0) continue;
            material = dynamicObject.getDynamicObject("material");
            basicUnit = dynamicObject.getDynamicObject("basicunit");
            unit = dynamicObject.getDynamicObject("unit");
            basicQty = dynamicObject.getBigDecimal("basicqty");
            if (material == null || basicUnit == null || unit == null || basicQty == null || BigDecimal.ZERO.compareTo(basicQty) == 0) break;
            if (unit.getPkValue().equals(basicUnit.getPkValue())) {
                qtyProperty.setValue((Object)dynamicObject, (Object)basicQty);
                continue;
            }
            qty = CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)basicUnit, (BigDecimal)basicQty, (DynamicObject)unit);
            qtyProperty.setValue((Object)dynamicObject, (Object)qty);
        }
    }
}

