/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.report.deliver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.scm.pur.report.deliver.AgeGroup;
import kd.scm.pur.report.deliver.PurDeliveryRptParam;

public class PurDeliveryForm
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
BeforeFilterF7SelectListener,
HyperLinkClickListener {
    private volatile boolean changed;

    public void setMergeColums(List<String> columns) {
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        this.changed = true;
        int[] ageSegment = this.buildAgeSegment(scheme);
        this.initAgeEntry(ageSegment);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        List<Long> orgIds = this.getHasPermissionOrg("02");
        Long orgId = RequestContext.getOrCreate().getOrgId();
        if (orgIds.contains(orgId)) {
            model.setValue("mulorg", (Object)new Long[]{orgId});
        }
        this.initAgeEntry();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        DynamicObjectCollection orgs = filter.getDynamicObjectCollection("mulorg");
        if (orgs == null || orgs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurDeliveryForm_0", (String)"scm-pur-report", (Object[])new Object[0]));
            return false;
        }
        Date startdate = filter.getDate("startdate");
        if (startdate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d77\u59cb\u65e5\u671f\u3002", (String)"PurDeliveryForm_1", (String)"scm-pur-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("combodate".equals(name)) {
            Object value = this.getModel().getValue(name);
            if ("4".equals(value)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"ageconf"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"ageconf"});
            }
        }
        if ("ageval".equals(name)) {
            this.initAgeEntry();
        }
    }

    private void initAgeEntry() {
        if (!this.changed) {
            this.changed = true;
            this.initAgeEntry(this.buildAgeSegment());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object value = this.getModel().getValue("combodate");
        if ("4".equals(value)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"ageconf"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ageconf"});
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if ("ageentry".equals(name)) {
            this.delterAgeEntryRow();
        }
    }

    private void delterAgeEntryRow() {
        this.initAgeEntry();
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        PurDeliveryRptParam param = new PurDeliveryRptParam();
        FilterInfo filterInfo = queryParam.getFilter();
        param.setOrgs(PurDeliveryForm.getIdList((Collection<DynamicObject>)filterInfo.getDynamicObjectCollection("mulorg")));
        param.setMulrecorgs(PurDeliveryForm.getIdList((Collection<DynamicObject>)filterInfo.getDynamicObjectCollection("mulrecorg")));
        param.setMulmaterials(PurDeliveryForm.getIdList((Collection<DynamicObject>)filterInfo.getDynamicObjectCollection("mulmaterial")));
        param.setMulsuppliers(PurDeliveryForm.getIdList((Collection<DynamicObject>)filterInfo.getDynamicObjectCollection("mulsupplier")));
        param.setMulpurpersons(PurDeliveryForm.getIdList((Collection<DynamicObject>)filterInfo.getDynamicObjectCollection("mulpurperson")));
        param.setStartdate(filterInfo.getDate("startdate"));
        param.setBillstatus(filterInfo.getString("billstatus"));
        param.setEntrystatus(filterInfo.getString("entrystatus"));
        param.setDatetype(filterInfo.getString("combodate"));
        if ("4".equals(filterInfo.getString("combodate"))) {
            String groupStr = this.getPageCache().get("groups");
            param.setGroup(groupStr);
        }
        queryParam.getCustomParam().put("param", param);
    }

    public static List<Long> getIdList(Collection<DynamicObject> objs) {
        if (objs == null) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> pks = new ArrayList<Long>(objs.size());
        for (DynamicObject obj : objs) {
            pks.add(obj.getLong("id"));
        }
        return pks;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit mulorg = (BasedataEdit)this.getControl("mulorg");
        mulorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mulrecorg = (BasedataEdit)this.getControl("mulrecorg");
        mulrecorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        List<Long> orgIds;
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if ("mulorg".equals(name)) {
            orgIds = this.getHasPermissionOrg("02");
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", orgIds));
        }
        if ("mulrecorg".equals(name)) {
            orgIds = this.getHasPermissionOrg("05");
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", orgIds));
        }
    }

    private List<Long> getHasPermissionOrg(String type) {
        ArrayList<Long> ids = new ArrayList<Long>(1024);
        List allPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)"pur_deliveryschedule", (String)type);
        Long tempId = null;
        for (int i = 0; i < allPermissionOrgs.size(); ++i) {
            tempId = Long.valueOf((String)((Map)allPermissionOrgs.get(i)).get("id"));
            ids.add(tempId);
        }
        return ids;
    }

    private void initAgeEntry(int[] ages) {
        IDataModel model = this.getModel();
        model.deleteEntryData("ageentry");
        int[] idxs = this.getModel().batchCreateNewEntryRow("ageentry", ages.length);
        ArrayList<AgeGroup> ageList = new ArrayList<AgeGroup>(2024);
        for (int i = 0; i < ages.length; ++i) {
            AgeGroup age = new AgeGroup();
            if (i == ages.length - 1) {
                model.setValue("agename", (Object)this.buildAgeLastName(ages[i]), idxs[i]);
                model.setValue("ageval", null, idxs[i]);
                age.setBeginDay(ages[i]);
            } else {
                model.setValue("agename", (Object)this.buildAgeName(ages[i], ages[i + 1]), idxs[i]);
                model.setValue("ageval", (Object)(ages[i + 1] - ages[i]), idxs[i]);
                age.setBeginDay(ages[i]);
                age.setEndDay(ages[i + 1] - 1);
            }
            ageList.add(age);
            this.getView().setEnable(Boolean.FALSE, idxs[i], new String[]{"agename"});
        }
        this.getPageCache().put("groups", SerializationUtils.toJsonString(ageList));
    }

    public String buildAgeName(int from, int to) {
        return ResManager.loadResFormat((String)"%1\u5230%2\u5929", (String)"AgeRptUtil_0", (String)"scmc-im-report", (Object[])new Object[]{from, to - 1});
    }

    public String buildAgeLastName(int from) {
        return ResManager.loadResFormat((String)"%1\u5929\u53ca\u4ee5\u4e0a", (String)"AgeRptUtil_1", (String)"scmc-im-report", (Object[])new Object[]{from});
    }

    private int[] buildAgeSegment() {
        return this.buildAgeSegment(this.getModel().getDataEntity(true));
    }

    private int[] buildAgeSegment(DynamicObject data) {
        DynamicObjectCollection ageSetting = data.getDynamicObjectCollection("ageentry");
        ArrayList<Integer> ages = new ArrayList<Integer>(ageSetting.size());
        ages.add(0);
        int age = 0;
        for (int i = 0; i < ageSetting.size(); ++i) {
            age = ((DynamicObject)ageSetting.get(i)).getInt("ageval");
            if (age <= 0) continue;
            ages.add(age);
        }
        if (ages.size() < 2) {
            return new int[]{0, 7};
        }
        int[] ageSegment = new int[ages.size()];
        for (int i = 0; i < ageSegment.length; ++i) {
            ageSegment[i] = i == 0 ? 0 : ageSegment[i - 1] + (Integer)ages.get(i);
        }
        return ageSegment;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
    }
}

