/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.report.deliveryrate;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.pur.report.common.PurOrderBaseForm;
import kd.scm.pur.report.deliveryrate.PurOrderDeliveryParam;

public class PurOrderDeliveryForm
extends PurOrderBaseForm
implements ItemClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.getRptForm().register(this, "purorg", "bdsupplier", "bdmaterial");
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        ReportList reportList = (ReportList)evt.getSource();
        int rowIndex = evt.getRowIndex();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        IDataModel model = this.getModel();
        HashMap<String, String> paramMap = new HashMap<String, String>(2);
        paramMap.put("fromdate", DateUtil.date2str((Date)((Date)model.getValue("startdate")), (String)"yyyy-MM-dd"));
        paramMap.put("todate", DateUtil.date2str((Date)DateUtil.addYear((Date)((Date)model.getValue("enddate")), (int)1), (String)"yyyy-MM-dd"));
        DynamicObject org = rowData.getDynamicObject("org");
        paramMap.put("purOrgId", org.getString("id"));
        switch (fieldName = evt.getFieldName()) {
            case "orderqty": {
                String billsattus = (String)model.getValue("billstatus");
                ArrayList<String> statusList = new ArrayList<String>(4);
                if (StringUtils.isEmpty((CharSequence)billsattus) || "A".equals(billsattus)) {
                    statusList.add("C");
                    statusList.add("D");
                    statusList.add("Z");
                    statusList.add("E");
                } else {
                    statusList.add(billsattus);
                }
                paramMap.put("billstatus", StringUtils.join((Object[])statusList.toArray(new String[statusList.size()]), (String)","));
                OpenFormUtil.openListPage((IFormView)this.getView(), (String)"pur_order", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)this.getQFilter(rowData), null);
                break;
            }
            case "ontimeqty": {
                OpenFormUtil.openListPage((IFormView)this.getView(), (String)((String)this.getModel().getValue("entitytype")), (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)this.getQFilter(rowData, false), null);
                break;
            }
            case "delayqty": {
                OpenFormUtil.openListPage((IFormView)this.getView(), (String)((String)this.getModel().getValue("entitytype")), (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)this.getQFilter(rowData, true), null);
                break;
            }
        }
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        boolean flag = super.verifyQuery(queryParam);
        if (!flag) {
            return false;
        }
        FilterInfo filter = queryParam.getFilter();
        String entitytype = filter.getString("entitytype");
        if (StringUtils.isEmpty((CharSequence)entitytype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u4f9d\u636e\u3002", (String)"PurOrderDeliveryForm_0", (String)"scm-scp-report", (Object[])new Object[0]));
            return false;
        }
        ReportQueryParam param = this.getQueryParam();
        PurOrderDeliveryParam orderParam = this.buildReportParms();
        param.getCustomParam().put(PurOrderDeliveryParam.class.getName(), orderParam);
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        switch (key) {
            case "purorg": {
                if (newValue == null || !newValue.equals(oldValue)) {
                    model.setValue("bdsupplier", null);
                    model.setValue("bdmaterial", null);
                }
                return;
            }
        }
    }

    private PurOrderDeliveryParam buildReportParms() {
        PurOrderDeliveryParam param = new PurOrderDeliveryParam();
        this.getRptForm().buildRptParam(param);
        param.setEntitytype((String)this.getModel().getValue("entitytype"));
        return param;
    }

    private QFilter getQFilter(DynamicObject rowData, boolean delayFlag) {
        QFilter qFilter = this.getHyperLinkQFilter(rowData);
        this.log.info("\u91c7\u8d2d\u8ba2\u5355\u6761\u4ef6\uff1a" + qFilter);
        DynamicObjectCollection dynList = QueryServiceHelper.query((String)"pur_order", (String)"id,materialentry.poentryid poentryid,materialentry.entrydelidate entrydelidate", (QFilter[])qFilter.toArray());
        HashMap poentryIdMap = new HashMap(10);
        dynList.forEach(t -> poentryIdMap.put(t.getString("poentryid"), t));
        String billNumber = (String)this.getModel().getValue("entitytype");
        DynamicObjectCollection instockList = QueryServiceHelper.query((String)billNumber, (String)"id,billdate,materialentry.poentryid poentryid", (QFilter[])new QFilter("materialentry.poentryid", "in", poentryIdMap.keySet()).toArray());
        HashSet poentryIds = new HashSet(poentryIdMap.size());
        instockList.forEach(t -> {
            String poentryid = t.getString("poentryid");
            Date billdate = t.getDate("billdate");
            Date entrydelidate = ((DynamicObject)poentryIdMap.get(poentryid)).getDate("entrydelidate");
            if (billdate != null && entrydelidate != null) {
                billdate = DateUtil.string2date((String)DateUtil.date2str((Date)billdate, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
                entrydelidate = DateUtil.string2date((String)DateUtil.date2str((Date)entrydelidate, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
                if (delayFlag) {
                    if (billdate.compareTo(entrydelidate) > 0) {
                        poentryIds.add(poentryid);
                    }
                } else if (billdate.compareTo(entrydelidate) <= 0) {
                    poentryIds.add(poentryid);
                }
            }
        });
        DynamicObject org = rowData.getDynamicObject("org");
        DynamicObject supplier = rowData.getDynamicObject("supplier");
        DynamicObject material = rowData.getDynamicObject("material");
        QFilter qFilters = new QFilter("purorg", "=", (Object)org.getLong("id"));
        qFilters.and("supplier", "=", (Object)supplier.getLong("id"));
        if (material != null) {
            qFilters.and("materialentry.material", "=", (Object)material.getLong("id"));
        } else {
            qFilters.and("materialentry.material", "=", (Object)0L);
        }
        qFilters.and("materialentry.poentryid", "in", poentryIds);
        this.log.info("\u91c7\u8d2d\u6536\u8d27/\u5165\u5e93\u8df3\u8f6c\u6761\u4ef6\uff1a" + qFilters);
        return qFilters;
    }

    private QFilter getQFilter(DynamicObject rowData) {
        QFilter qFilter = this.getHyperLinkQFilter(rowData);
        DynamicObjectCollection dynList = QueryServiceHelper.query((String)"pur_order", (String)"id,materialentry.poentryid poentryid", (QFilter[])qFilter.toArray());
        HashSet poentryIds = new HashSet(dynList.size());
        dynList.forEach(t -> poentryIds.add(t.getString("poentryid")));
        this.log.info("\u91c7\u8d2d\u8ba2\u5355\u8df3\u8f6c\u6761\u4ef6\uff1a" + dynList);
        return new QFilter("materialentry.poentryid", "in", poentryIds);
    }

    private QFilter getHyperLinkQFilter(DynamicObject rowData) {
        String billsattus;
        DynamicObject org = rowData.getDynamicObject("org");
        DynamicObject supplier = rowData.getDynamicObject("supplier");
        DynamicObject material = rowData.getDynamicObject("material");
        QFilter qFilters = new QFilter("org", "=", (Object)org.getLong("id"));
        qFilters.and("supplier", "=", (Object)supplier.getLong("id"));
        if (material != null) {
            qFilters.and("materialentry.material", "=", (Object)material.getLong("id"));
        } else {
            qFilters.and("materialentry.material", "=", (Object)0L);
        }
        IDataModel model = this.getView().getModel();
        Date startDate = (Date)model.getValue("startDate");
        Date endDate = (Date)model.getValue("endDate");
        if (startDate != null) {
            qFilters.and(new QFilter("materialentry.entrydelidate", ">=", (Object)startDate));
        }
        if (endDate != null) {
            qFilters.and(new QFilter("materialentry.entrydelidate", "<=", (Object)DateUtil.formatEndDate((Date)endDate)));
        }
        if (StringUtils.isEmpty((CharSequence)(billsattus = (String)model.getValue("billstatus"))) || "A".equals(billsattus)) {
            ArrayList<String> statusList = new ArrayList<String>(4);
            statusList.add("C");
            statusList.add("D");
            statusList.add("Z");
            statusList.add("E");
            qFilters.and(new QFilter("billstatus", "in", statusList));
        } else {
            qFilters.and(new QFilter("billstatus", "=", (Object)billsattus));
        }
        return qFilters;
    }
}

