/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.report.execute;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scm.common.util.DateUtil;
import kd.scm.pur.report.execute.PurOrderExecuteParam;
import kd.scm.pur.report.execute.trans.PurOrderCheckQtyTransform;
import kd.scm.pur.report.execute.trans.PurOrderSortTransform;

public class PurOrderExecuteHandle
implements IReportDataHandle {
    private PurOrderExecuteParam reportParam;

    public void setupCtx(ReportDataCtx ctx) {
        this.reportParam = (PurOrderExecuteParam)ctx.getParam(PurOrderExecuteParam.class.getName());
        this.setPageFs(ctx);
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        for (SrcBlockConf blockConf : blockCollector) {
            Map colMap = blockConf.getRepoColSrcColMap();
            colMap.put("id", "id");
            Map colMap1 = blockConf.getRepoColFullSrcColMap();
            colMap1.put("id", "id");
        }
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new PurOrderCheckQtyTransform());
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new PurOrderSortTransform());
    }

    private void setPageFs(ReportDataCtx ctx) {
        ArrayList<QFilter> pageFs = ctx.getPageFs();
        if (pageFs == null) {
            pageFs = new ArrayList<QFilter>();
            ctx.setPageFs(pageFs);
        }
        pageFs.addAll(this.getPageFilter());
    }

    private List<QFilter> getPageFilter() {
        String billsattus;
        List<Long> matIds;
        List<Long> billids;
        Date endDate;
        Date startDate;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org", "in", this.reportParam.getOrgs()));
        List<Long> spIds = this.reportParam.getSpIds();
        if (spIds != null && !spIds.isEmpty()) {
            qFilters.add(new QFilter("supplier", "in", spIds));
        }
        if ((startDate = this.reportParam.getStartdate()) != null) {
            qFilters.add(new QFilter("billdate", ">=", (Object)startDate));
        }
        if ((endDate = this.reportParam.getEnddate()) != null) {
            qFilters.add(new QFilter("billdate", "<=", (Object)DateUtil.formatEndDate((Date)endDate)));
        }
        if ((billids = this.reportParam.getBillIds()) != null && !billids.isEmpty()) {
            qFilters.add(new QFilter("id", "in", billids));
        }
        if ((matIds = this.reportParam.getMatIds()) != null && !matIds.isEmpty()) {
            qFilters.add(new QFilter("material", "in", matIds));
        }
        if (StringUtils.isEmpty((CharSequence)(billsattus = this.reportParam.getBillstatus())) || "A".equals(billsattus)) {
            ArrayList<String> statusList = new ArrayList<String>(4);
            statusList.add("C");
            statusList.add("D");
            statusList.add("Z");
            statusList.add("E");
            qFilters.add(new QFilter("billstatus", "in", statusList));
        } else {
            qFilters.add(new QFilter("billstatus", "=", (Object)billsattus));
        }
        return qFilters;
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> columns, ReportDataCtx ctx) {
        for (AbstractReportColumn col : columns) {
            ReportColumn reportCol = (ReportColumn)col;
            String field = reportCol.getFieldKey();
            if ("billno".equals(field) || "sumoutstockqty".equals(field) || "sumreceiptqty".equals(field) || "suminstockqty".equals(field) || "sumrecretqty".equals(field) || "suminstockretqty".equals(field) || "payableqty".equals(field) || "invoiceqty".equals(field)) {
                reportCol.setHyperlink(true);
            }
            if (!"id".equals(field) && !"curr".equals(field)) continue;
            reportCol.setHide(true);
        }
        return columns;
    }
}

