/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.report.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.IReportListModel;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.pur.report.util.RptParam;
import kd.scm.pur.report.util.RptUtil;

public class RptForm {
    private IReportView view;
    private static final String PUR_ORG = "purorg";
    private static final String BD_SUPPLIER = "bdsupplier";
    private static final String PUR_BILLNO = "purbillno";
    private static final String BD_MATERIAL = "bdmaterial";
    public static final String PERMISSION_PUR_ORG = "hasPermissionPurOrg";
    public static final String ID = "id";

    public RptForm(IReportView view) {
        this.view = view;
    }

    public void register(BeforeF7SelectListener selectListener, String ... f7Name) {
        AbstractFormPlugin loaclForm = (AbstractFormPlugin)selectListener;
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)loaclForm.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(selectListener);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        Long materialId;
        ReportList reportList = (ReportList)evt.getSource();
        int rowIndex = evt.getRowIndex();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        if (rowData == null) {
            return;
        }
        String billIdStr = rowData.getString(ID);
        String billno = rowData.getString("billno");
        DynamicObject material = rowData.getDynamicObject("material");
        Long l = materialId = material == null ? null : Long.valueOf(material.getLong(ID));
        if (billIdStr == null || StringUtils.isEmpty((CharSequence)billIdStr)) {
            return;
        }
        IDataModel model = this.view.getModel();
        HashMap<String, String> paramMap = new HashMap<String, String>(2);
        paramMap.put("fromdate", DateUtil.date2str((Date)((Date)model.getValue("startdate")), (String)"yyyy-MM-dd"));
        paramMap.put("todate", DateUtil.date2str((Date)DateUtil.addYear((Date)((Date)model.getValue("enddate")), (int)1), (String)"yyyy-MM-dd"));
        DynamicObject org = rowData.getDynamicObject("org");
        paramMap.put("purOrgId", org.getString(ID));
        Long billid = Long.valueOf(billIdStr);
        switch (fieldName = evt.getFieldName()) {
            case "billno": {
                OpenFormUtil.openBillPage((IFormView)this.view, (String)"pur_order", (Object)billid, (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, null, null);
                break;
            }
            case "sumoutstockqty": {
                OpenFormUtil.openListPage((IFormView)this.view, (String)"pur_saloutstock", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)this.getQFilter("materialentry.pobillno", billno, "materialentry.material", materialId), null);
                break;
            }
            case "sumreceiptqty": {
                OpenFormUtil.openListPage((IFormView)this.view, (String)"pur_receipt", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)this.getQFilter("materialentry.pobillno", billno, "materialentry.material", materialId), null);
                break;
            }
            case "suminstockqty": {
                OpenFormUtil.openListPage((IFormView)this.view, (String)"pur_instock", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)this.getQFilter("materialentry.pobillno", billno, "materialentry.material", materialId), null);
                break;
            }
            case "sumrecretqty": {
                OpenFormUtil.openListPage((IFormView)this.view, (String)"pur_receipt_return", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)this.getQFilter("materialentry.pobillno", billno, "materialentry.material", materialId), null);
                break;
            }
            case "suminstockretqty": {
                OpenFormUtil.openListPage((IFormView)this.view, (String)"pur_return", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)this.getQFilter("materialentry.pobillno", billno, "materialentry.material", materialId), null);
                break;
            }
            case "payableqty": {
                OpenFormUtil.openListPage((IFormView)this.view, (String)"pur_check", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)this.getQFilter("materialentry.pobillno", billno, "materialentry.material", materialId), null);
                break;
            }
            case "invoiceqty": {
                paramMap.put("fromdate", DateUtil.date2str((Date)((Date)model.getValue("startdate")), (String)"yyyy-MM-dd HH:mm:ss"));
                paramMap.put("todate", DateUtil.date2str((Date)DateUtil.addYear((Date)((Date)model.getValue("enddate")), (int)1), (String)"yyyy-MM-dd HH:mm:ss"));
                OpenFormUtil.openListPage((IFormView)this.view, (String)"pur_invoice", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)this.getQFilter("entryentity1.pobillno1", billno, "entryentity1.material1", materialId), null);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e, IDataModel model) {
        String fieldKey = e.getProperty().getName();
        List<Object> orgIds = new ArrayList(0);
        if ((BD_SUPPLIER.equals(fieldKey) || PUR_BILLNO.equals(fieldKey) || BD_MATERIAL.equals(fieldKey)) && ((orgIds = this.getOrgIds()) == null || orgIds.isEmpty())) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurOrderExecutePlugin_0", (String)"scm-pur-report", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        ListFilterParameter showParameter = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter();
        switch (fieldKey) {
            case "purorg": {
                showParameter.setFilter(new QFilter(ID, "in", this.getHasPermissionOrg()));
                break;
            }
            case "bdsupplier": {
                QFilter qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", orgIds, (boolean)false);
                showParameter.getQFilters().add(qFilter1);
                break;
            }
            case "bdmaterial": {
                QFilter qFilter2 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", orgIds, (boolean)false);
                showParameter.getQFilters().add(qFilter2);
                break;
            }
            case "purbillno": {
                Date endDate;
                Date startDate;
                showParameter.getQFilters().add(new QFilter("org", "in", orgIds));
                List<Long> spIds = this.getSpIds();
                if (spIds != null && !spIds.isEmpty()) {
                    showParameter.getQFilters().add(new QFilter("supplier", "in", spIds));
                }
                if ((startDate = (Date)model.getValue("startdate")) != null) {
                    showParameter.getQFilters().add(new QFilter("billdate", ">=", (Object)startDate));
                }
                if ((endDate = (Date)model.getValue("enddate")) == null) break;
                showParameter.getQFilters().add(new QFilter("billdate", "<=", (Object)DateUtil.formatEndDate((Date)endDate)));
                break;
            }
        }
    }

    public void initPage() {
        this.initOrg();
        IDataModel model = this.view.getModel();
        Object startdate = model.getValue("startdate");
        Object enddate = model.getValue("enddate");
        if (startdate == null && enddate == null) {
            Date today = TimeServiceHelper.today();
            today = DateUtil.formatEndDate((Date)today);
            model.setValue("enddate", (Object)today);
            today = DateUtil.formatStartDate((Date)DateUtil.addMonth((Date)today, (int)-1));
            model.setValue("startdate", (Object)today);
        }
    }

    public void initOrg() {
        List<Long> orgIds = this.getHasPermissionOrg();
        this.initOrg(orgIds);
    }

    public void initOrg(List<Long> orgIds) {
        Object[] ids = null;
        Long orgId = RequestContext.get().getOrgId();
        if (orgIds != null && orgIds.size() > 0 && orgIds.contains(orgId)) {
            ids = new Object[]{orgId};
        }
        IDataModel model = this.view.getModel();
        model.setValue(PUR_ORG, ids);
    }

    public List<Long> getOrgIds() {
        return RptUtil.getBaseDataLongIds(this.view, PUR_ORG);
    }

    public List<Long> getSpIds() {
        DynamicProperty sptemp = this.view.getModel().getDataEntity(true).getDynamicObjectType().getProperty(BD_SUPPLIER);
        if (sptemp != null) {
            return RptUtil.getBaseDataLongIds(this.view, BD_SUPPLIER);
        }
        return null;
    }

    public List<Long> getMatIds() {
        return RptUtil.getBaseDataLongIds(this.view, BD_MATERIAL);
    }

    public List<Long> getBillIds() {
        DynamicProperty sptemp = this.view.getModel().getDataEntity(true).getDynamicObjectType().getProperty(PUR_BILLNO);
        if (sptemp != null) {
            return RptUtil.getBaseDataLongIds(this.view, PUR_BILLNO);
        }
        return null;
    }

    public List<Long> getHasPermissionOrg() {
        List purOrgIds = null;
        String idStr = this.view.getPageCache().get(PERMISSION_PUR_ORG);
        if (StringUtils.isEmpty((CharSequence)idStr)) {
            purOrgIds = OrgUtil.getUserHasAllPurPermissionOrgs();
            this.view.getPageCache().put(PERMISSION_PUR_ORG, SerializationUtils.toJsonString((Object)purOrgIds));
        } else {
            purOrgIds = SerializationUtils.fromJsonStringToList((String)idStr, Long.class);
        }
        return purOrgIds;
    }

    private QFilter getQFilter(String billnoKey, String billnoValue, String materialKey, Long materialId) {
        QFilter qFilter = new QFilter(billnoKey, "=", (Object)billnoValue);
        if (materialId != null) {
            qFilter.and(materialKey, "=", (Object)materialId);
        }
        qFilter.and("billstatus", "=", (Object)"C");
        return qFilter;
    }

    public void buildRptParam(RptParam reportParam) {
        reportParam.setOrgs(this.getOrgIds());
        reportParam.setSpIds(this.getSpIds());
        reportParam.setMatIds(this.getMatIds());
        reportParam.setBillIds(this.getBillIds());
        IDataModel model = this.view.getModel();
        reportParam.setStartdate((Date)model.getValue("startDate"));
        reportParam.setEnddate((Date)model.getValue("endDate"));
        reportParam.setBillstatus((String)model.getValue("billstatus"));
    }
}

