/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillEntryStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.enums.OrgTypeEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExchangeHelper;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.WriteBackUtil;
import kd.scm.common.util.cal.Cal4DynamicObj;
import kd.scm.pur.common.helper.PurInquiryOpHelper;
import kd.scm.pur.common.pojo.CompareConfirmInfo;
import kd.scm.pur.common.pojo.QuoteQueryInfo;
import kd.scm.pur.common.utils.MetaDataUtils;
import kd.scm.pur.common.utils.MobileControlUtils;
import kd.scm.pur.common.utils.NumberUtils;
import kd.scm.pur.common.utils.SouPermUtils;
import kd.scm.pur.formplugin.mobile.compare.PurCompareToolMobEdit;

public class PurCompareHelper {
    private static final Log log = LogFactory.getLog(PurCompareToolMobEdit.class);
    private List<Long> quoEntryIds;
    private Map<String, BigDecimal> quoEntryIdToCompQty;
    private static final String[] BD_PROS = new String[]{"supplier", "material", "unit"};

    public void setViewByRowIdx(AbstractMobBillPlugIn mobBillPlugin, int currEntryIdx, int entryRows) {
        IFormView view = mobBillPlugin.getView();
        if (entryRows == 0) {
            return;
        }
        if (entryRows == 1) {
            view.setEnable(Boolean.valueOf(true), new String[]{"finish"});
            view.setEnable(Boolean.valueOf(false), new String[]{"last", "next"});
            view.setVisible(Boolean.valueOf(false), new String[]{"back"});
            view.setVisible(Boolean.valueOf(true), new String[]{"last", "next", "finish"});
            MobileControlUtils.controlSetFrontAndBackColor(mobBillPlugin.getControl("next"), "#FFFFFF", "#999999");
            MobileControlUtils.controlSetFrontAndBackColor(mobBillPlugin.getControl("last"), "#FFFFFF", "#999999");
            return;
        }
        if (currEntryIdx == 0) {
            view.setEnable(Boolean.valueOf(true), new String[]{"back", "next"});
            view.setEnable(Boolean.valueOf(false), new String[]{"last"});
            view.setVisible(Boolean.valueOf(false), new String[]{"finish"});
            view.setVisible(Boolean.valueOf(true), new String[]{"last", "next", "back"});
            MobileControlUtils.controlSetFrontAndBackColor(mobBillPlugin.getControl("last"), "#FFFFFF", "#999999");
            MobileControlUtils.controlSetFrontAndBackColor(mobBillPlugin.getControl("next"), "#FFFFFF", "#276FF5");
        } else if (currEntryIdx > 0 && currEntryIdx < entryRows - 1) {
            view.setVisible(Boolean.valueOf(false), new String[]{"finish"});
            view.setEnable(Boolean.valueOf(true), new String[]{"last", "back", "next"});
            view.setVisible(Boolean.valueOf(true), new String[]{"last", "next", "back"});
            MobileControlUtils.controlSetFrontAndBackColor(mobBillPlugin.getControl("last"), "#FFFFFF", "#276FF5");
            MobileControlUtils.controlSetFrontAndBackColor(mobBillPlugin.getControl("next"), "#FFFFFF", "#276FF5");
        } else {
            view.setVisible(Boolean.valueOf(true), new String[]{"last", "next", "finish"});
            view.setVisible(Boolean.valueOf(false), new String[]{"back"});
            view.setEnable(Boolean.valueOf(true), new String[]{"last", "finish"});
            view.setEnable(Boolean.valueOf(false), new String[]{"next"});
            MobileControlUtils.controlSetFrontAndBackColor(mobBillPlugin.getControl("last"), "#FFFFFF", "#276FF5");
            MobileControlUtils.controlSetFrontAndBackColor(mobBillPlugin.getControl("next"), "#FFFFFF", "#999999");
        }
    }

    public void compareConfirm(IFormView view) {
        List<Integer> withoutCompPriceIdxs;
        int withoutCompPriceCount;
        IDataModel model = view.getModel();
        CompareConfirmInfo compareCfmInfo = this.getCompareCfmInfo(view);
        DynamicObject compareBill = compareCfmInfo.getCompareBill();
        if (compareBill == null) {
            return;
        }
        int maxCompPriceCount = compareCfmInfo.getMaxCompPriceCount();
        int compPriceCount = maxCompPriceCount - (withoutCompPriceCount = (withoutCompPriceIdxs = compareCfmInfo.getWithoutCompPriceIdxs()).size());
        if (compPriceCount == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u91c7\u7eb3\u4e00\u4e2a\u7269\u6599\u3002", (String)"PurCompareHelper_0", (String)"scm-pur-mobile", (Object[])new Object[0]));
            return;
        }
        if (0 < compPriceCount && compPriceCount < maxCompPriceCount) {
            DynamicObjectCollection materialInfo = model.getEntryEntity("materialentry");
            StringBuilder warnMsg = new StringBuilder();
            int indexCount = withoutCompPriceIdxs.size();
            for (int i = 0; i < indexCount; ++i) {
                int index = withoutCompPriceIdxs.get(i);
                DynamicObject entryRow = (DynamicObject)materialInfo.get(index);
                DynamicObject material = entryRow.getDynamicObject("material");
                String materialName = material.getString("name");
                String loadKDString4 = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u7684\u3010{1}\u3011", (String)"PurCompareHelper_confirm1", (String)"scm-pur-mobile", (Object[])new Object[]{index + 1, materialName});
                warnMsg.append(loadKDString4);
                if (warnMsg.toString().length() > 50) {
                    warnMsg.append("...");
                    break;
                }
                if (i >= indexCount - 1) continue;
                warnMsg.append(ResManager.loadKDString((String)"\u3001", (String)"PurCompareHelper_confirm4", (String)"scm-pur-mobile", (Object[])new Object[0]));
            }
            warnMsg.append(ResManager.loadKDString((String)"\u7269\u6599\u62a5\u4ef7\u672a\u91c7\u7eb3\uff0c\u662f\u5426\u786e\u8ba4\u5b8c\u6210\uff1f", (String)"PurCompareHelper_confirm5", (String)"scm-pur-mobile", (Object[])new Object[0]));
            view.showConfirm(ResManager.loadKDString((String)String.format(" %s", warnMsg.toString()), (String)"PurCompareHelper_1", (String)"scm-pur-mobile", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("compareConfirmCB"));
            return;
        }
        this.createAndAuditCompBill(view, compareBill);
    }

    public CompareConfirmInfo getCompareCfmInfo(IFormView view) {
        IDataModel model = view.getModel();
        String inquiryNo = (String)model.getValue("billno");
        if (!this.validateCompare(view, inquiryNo)) {
            return null;
        }
        Long inquiryId = (Long)model.getValue("id");
        DynamicObject[] inquirys = this.getInquiryData(inquiryId);
        if (inquirys == null || inquirys.length == 0) {
            view.showConfirm(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u5f20\u8be2\u4ef7\u5355\u3002", (String)"PurCompareHelper_2", (String)"scm-pur-mobile", (Object[])new Object[0]), MessageBoxOptions.OK);
            return null;
        }
        return this.setCompareBillData(view, inquirys[0]);
    }

    private boolean validateCompare(IFormView view, String inquiryNo) {
        if (StringUtils.isEmpty((CharSequence)inquiryNo)) {
            view.showConfirm(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u8be2\u4ef7\u5355\u53f7\u3002", (String)"PurCompareHelper_3", (String)"scm-pur-mobile", (Object[])new Object[0]), MessageBoxOptions.OK);
            return false;
        }
        DynamicObjectCollection selectDatas = QueryServiceHelper.query((String)"sou_inquiry", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)inquiryNo)});
        if (!SouPermUtils.hasSouBillViewRightForOrg(((DynamicObject)selectDatas.get(0)).getLong("id"), "sou_inquiry", "sou_compare")) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709[\u6bd4\u4ef7\u5355]\u7684[\u67e5\u8be2]\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"PurCompareToolMobEdit_1", (String)"scm-pur-mobile", (Object[])new Object[0]));
            return false;
        }
        DynamicObject[] compareBills = PurInquiryOpHelper.getCompareData(inquiryNo);
        if (compareBills != null && compareBills.length >= 1) {
            view.showConfirm(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u6bd4\u4ef7\u5355\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6bd4\u4ef7\u3002", (String)"PurCompareToolMobEdit_2", (String)"scm-pur-mobile", (Object[])new Object[0]), MessageBoxOptions.OK);
            return false;
        }
        return true;
    }

    private CompareConfirmInfo setCompareBillData(IFormView view, DynamicObject inquiry) {
        CompareConfirmInfo compareCfmInfo = new CompareConfirmInfo();
        IPageCache pageCache = view.getPageCache();
        IDataModel model = view.getModel();
        DynamicObject compareBill = this.createCompareBillHead(inquiry);
        String inquiryNo = (String)model.getValue("billno");
        this.createCompareQuoEntry(inquiryNo, compareBill, "quoentry");
        DynamicObjectUtil.setBillEntrySeq((DynamicObject)compareBill, (String)"quoentry");
        DynamicObjectCollection compareEntry = compareBill.getDynamicObjectCollection("materialentry");
        DynamicObjectCollection materialInfo = model.getEntryEntity("materialentry");
        List<Integer> withoutCompPriceIdxs = this.createCompareBillEntry(pageCache, model, compareEntry);
        DynamicObjectUtil.setBillEntrySeq((DynamicObject)compareBill, (String)"materialentry");
        int maxCompPriceCount = materialInfo.size();
        this.calcCompBillData(model, compareBill);
        compareCfmInfo.setCompareBill(compareBill);
        compareCfmInfo.setMaxCompPriceCount(maxCompPriceCount);
        compareCfmInfo.setWithoutCompPriceIdxs(withoutCompPriceIdxs);
        return compareCfmInfo;
    }

    private void calcCompBillData(IDataModel model, DynamicObject compareBill) {
        this.calcQuoEntryAdoptAmt(compareBill);
        this.calcQuoDetailsPrice(model, compareBill, 24);
        Cal4DynamicObj.calByQty((DynamicObject)compareBill, (String)"materialentry");
    }

    public void createAndAuditCompBill(IFormView view, DynamicObject compareBill) {
        try (TXHandle tx = TX.requiresNew((String)"sou_compare");){
            SaveServiceHelper.save((IDataEntityType)compareBill.getDataEntityType(), (Object[])new Object[]{compareBill});
            List<Long> compareIds = Collections.singletonList(compareBill.getLong("id"));
            OperateOption operateOption = OperateOption.create();
            OperationResult submit = OperationServiceHelper.executeOperate((String)"submit", (String)"sou_compare", (Object[])compareIds.toArray(), (OperateOption)operateOption);
            if (!submit.isSuccess()) {
                tx.markRollback();
                this.showErrTips(view, submit);
                return;
            }
            OperationResult audit = OperationServiceHelper.executeOperate((String)"audit", (String)"sou_compare", (Object[])compareIds.toArray(), (OperateOption)operateOption);
            if (!audit.isSuccess()) {
                tx.markRollback();
                this.showErrTips(view, audit);
                return;
            }
            this.writeBackQuoData();
            view.showSuccessNotification(ResManager.loadKDString((String)"\u6bd4\u4ef7\u786e\u8ba4\u6210\u529f\u3002", (String)"PurCompareHelper_4", (String)"scm-pur-mobile", (Object[])new Object[0]));
            this.openCompareListPage(view);
            view.close();
        }
    }

    private void openCompareListPage(IFormView view) {
        MobileListShowParameter showParameter = new MobileListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setAppId("eae607fb000143ac");
        showParameter.setBillFormId("pur_compare_m_list");
        showParameter.setFormId("bos_moblist");
        view.showForm((FormShowParameter)showParameter);
    }

    private void writeBackQuoData() {
        HashMap writeBackProMap = new HashMap(16);
        ArrayList<String> proList = new ArrayList<String>(10);
        proList.add("sumcompareqty");
        writeBackProMap.put("materialentry", proList);
        WriteBackUtil.writeBackBill((String)"sou_quote", writeBackProMap, this.quoEntryIds, this.quoEntryIdToCompQty, (String)"audit");
    }

    private DynamicObject[] getInquiryData(Long inquiryId) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"sou_inquiry");
        return BusinessDataServiceHelper.load((Object[])new Object[]{inquiryId}, (DynamicObjectType)entityType);
    }

    private DynamicObject createCompareBillHead(DynamicObject inquiry) {
        DynamicObject billObj = ORMUtil.newDynamicObject((String)"sou_compare");
        List properties = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)billObj.getDataEntityType());
        Map inquiryMap = DynamicObjectUtil.plainObject2Map((DynamicObject)inquiry);
        for (String pro : properties) {
            Object val = inquiryMap.get(pro);
            if (null == val || pro.equals("remark")) continue;
            billObj.set(pro, val);
        }
        Date curDate = new Date();
        billObj.set("inquiryno", (Object)inquiry.getString("billno"));
        billObj.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        billObj.set("cfmstatus", (Object)ConfirmStatusEnum.UNCONFIRM.getVal());
        billObj.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
        billObj.set("createtime", (Object)curDate);
        billObj.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
        billObj.set("modifytime", (Object)curDate);
        billObj.set("auditor", (Object)0);
        billObj.set("auditdate", null);
        billObj.set("billdate", (Object)curDate);
        billObj.set("billno", null);
        DynamicObject org = billObj.getDynamicObject("org");
        String orgId = org == null ? "0" : String.valueOf(org.getLong("id"));
        String newCompareBillNo = CodeRuleServiceHelper.getNumber((String)"sou_compare", (DynamicObject)billObj, (String)orgId);
        billObj.set("billno", (Object)newCompareBillNo);
        boolean isExistSupCurrType = MetaDataUtils.isExistFieldKey(billObj, "supcurrtype");
        if (isExistSupCurrType) {
            billObj.set("supcurrtype", (Object)(inquiry.getString("supcurrtype").isEmpty() ? "1" : inquiry.getString("supcurrtype")));
        }
        return billObj;
    }

    private void createCompareQuoEntry(String inquiryNo, DynamicObject billObj, String entryKey) {
        DynamicObjectCollection entrys = billObj.getDynamicObjectCollection(entryKey);
        HashSet<Object> idset = new HashSet<Object>();
        ArrayList<DynamicObject> entryList = new ArrayList<DynamicObject>();
        HashMap<String, Date> maxmap = new HashMap<String, Date>();
        DynamicObjectCollection quoteCollections = QueryServiceHelper.query((String)"quo_quote", (String)"id,billno,supplier.id,remark,sumtaxamount,materialentry.taxprice,materialentry.taxrate,paycond.id,materialentry.delidate,materialentry.taxamount", (QFilter[])new QFilter[]{new QFilter("inquiryno", "=", (Object)inquiryNo).and(new QFilter("billstatus", "=", (Object)"C")).and(new QFilter("materialentry.entrystatus", "=", (Object)"A"))});
        if (quoteCollections == null) {
            return;
        }
        for (DynamicObject obj : quoteCollections) {
            String quoid = obj.get(0).toString();
            Date delidate = obj.getDate("materialentry.delidate");
            if (delidate == null) continue;
            if (maxmap.get(quoid) == null) {
                maxmap.put(quoid, delidate);
                continue;
            }
            if (!((Date)maxmap.get(quoid)).before(delidate)) continue;
            maxmap.put(quoid, delidate);
        }
        for (DynamicObject obj : quoteCollections) {
            if (obj.getBigDecimal("materialentry.taxprice").compareTo(BigDecimal.ZERO) <= 0) continue;
            DynamicObject entry = ORMUtil.newDynamicObject((String)("sou_compare." + entryKey));
            entry.set("quobillno", obj.get("billno"));
            entry.set("entrysupplier", obj.get("supplier.id"));
            entry.set("rate", obj.get("materialentry.taxrate"));
            entry.set("qoutaxamount", obj.get("sumtaxamount"));
            entry.set("paycondition", obj.get("paycond.id"));
            entry.set("deliverdate", maxmap.get(obj.get(0).toString()));
            entry.set("remarks", obj.get("remark"));
            if (!idset.add(obj.get(0))) continue;
            entryList.add(entry);
        }
        if (entryList.size() > 0) {
            entrys.addAll(entryList);
        }
    }

    private void calcQuoEntryAdoptAmt(DynamicObject billObj) {
        DynamicObjectCollection entrys = billObj.getDynamicObjectCollection("materialentry");
        DynamicObjectCollection quoentrs = billObj.getDynamicObjectCollection("quoentry");
        if (quoentrs == null) {
            return;
        }
        for (DynamicObject obj : quoentrs) {
            Long entrySupplier = obj.getLong("entrysupplier");
            if (entrySupplier == null || entrySupplier.equals(0L)) continue;
            long quosupid = obj.getLong("entrysupplier");
            obj.set("adoptamount", (Object)BigDecimal.ZERO);
            BigDecimal adoptAmt = obj.getBigDecimal("adoptamount");
            for (DynamicObject entry : entrys) {
                long sup = entry.getLong("supplier");
                if (sup != quosupid) continue;
                adoptAmt = adoptAmt.add((BigDecimal)entry.get("taxamount"));
            }
            obj.set("adoptamount", (Object)adoptAmt);
            if (obj.getBigDecimal("adoptamount").compareTo(BigDecimal.ZERO) > 0) {
                obj.set("isadopt", (Object)"1");
                continue;
            }
            obj.set("isadopt", (Object)"2");
        }
    }

    private List<Integer> createCompareBillEntry(IPageCache pageCache, IDataModel model, DynamicObjectCollection compareEntry) {
        compareEntry.clear();
        ArrayList<Long> quoEntryIdsTmp = new ArrayList<Long>(10);
        HashMap<String, BigDecimal> quoEntryIdToCompQtyTmp = new HashMap<String, BigDecimal>(16);
        Map idxToQuoInfo = (Map)SerializationUtils.fromJsonString((String)pageCache.get("quotecustomparams"), Map.class);
        ArrayList<DynamicObject> adoptedEntrys = new ArrayList<DynamicObject>();
        ArrayList<Integer> withoutCompPriceIdxs = new ArrayList<Integer>(10);
        for (Map.Entry indexQuoInfo : idxToQuoInfo.entrySet()) {
            boolean isNotCompared = true;
            int inqryIndex = Integer.parseInt((String)indexQuoInfo.getKey());
            List quoteEntry = (List)indexQuoInfo.getValue();
            for (Map quoEntryRow : quoteEntry) {
                String isAdopt = (String)quoEntryRow.get("isadopt");
                if (!"1".equals(isAdopt)) continue;
                isNotCompared = false;
                Long quoEntryId = Long.valueOf(quoEntryRow.get("entryid").toString());
                quoEntryIdsTmp.add(quoEntryId);
                BigDecimal cfmqty = CommonUtil.getBigDecimalPro(quoEntryRow.get("cfmqty"));
                quoEntryIdToCompQtyTmp.put(String.valueOf(quoEntryId), cfmqty);
                DynamicObject compareEntryRow = this.setCompareEntry(model, quoEntryRow);
                adoptedEntrys.add(compareEntryRow);
            }
            if (!isNotCompared) continue;
            withoutCompPriceIdxs.add(inqryIndex);
        }
        if (adoptedEntrys.size() > 0) {
            compareEntry.addAll(adoptedEntrys);
        }
        this.quoEntryIds = quoEntryIdsTmp;
        this.quoEntryIdToCompQty = quoEntryIdToCompQtyTmp;
        return withoutCompPriceIdxs;
    }

    private DynamicObject setCompareEntry(IDataModel model, Map<String, Object> quoEntryRow) {
        DynamicObject entry = ORMUtil.newDynamicObject((String)"sou_compare.materialentry");
        for (int i = 0; i < BD_PROS.length; ++i) {
            Object val = null;
            val = "material".equals(BD_PROS[i]) ? quoEntryRow.get("material") : quoEntryRow.get(BD_PROS[i]);
            if (val instanceof DynamicObject) {
                entry.set(BD_PROS[i], ((DynamicObject)val).getPkValue());
                continue;
            }
            entry.set(BD_PROS[i], val);
        }
        String materialDesc = (String)quoEntryRow.get("materialdesc");
        BigDecimal inquiryQty = CommonUtil.getBigDecimalPro((Object)quoEntryRow.get("inquiryqty"));
        BigDecimal qty = CommonUtil.getBigDecimalPro((Object)quoEntryRow.get("cfmqty"));
        BigDecimal basicqty = CommonUtil.getBigDecimalPro((Object)quoEntryRow.get("basicqty"));
        BigDecimal price = CommonUtil.getBigDecimalPro((Object)quoEntryRow.get("cfmprice"));
        BigDecimal amount = CommonUtil.getBigDecimalPro((Object)quoEntryRow.get("amount"));
        BigDecimal tax = CommonUtil.getBigDecimalPro((Object)quoEntryRow.get("tax"));
        BigDecimal taxPrice = CommonUtil.getBigDecimalPro((Object)quoEntryRow.get("cfmtaxprice"));
        Long taxRateId = Long.valueOf(quoEntryRow.get("cfmtaxrateid").toString());
        BigDecimal taxRate = CommonUtil.getBigDecimalPro((Object)quoEntryRow.get("cfmtaxrate"));
        BigDecimal taxAmount = CommonUtil.getBigDecimalPro((Object)quoEntryRow.get("taxamount"));
        entry.set("entrystatus", (Object)BillEntryStatusEnum.COMMON.getVal());
        Object curr = quoEntryRow.get("curr");
        Long quoteCurr = NumberUtils.getLong(curr);
        entry.set("materialdesc", (Object)materialDesc);
        entry.set("inquiryqty", (Object)inquiryQty);
        entry.set("qty", (Object)qty);
        entry.set("price", (Object)price);
        entry.set("amount", (Object)amount);
        entry.set("tax", (Object)tax);
        entry.set("taxamount", (Object)taxAmount);
        boolean isExistQuoCurr = MetaDataUtils.isExistFieldKey(entry, "quotecurr");
        if (isExistQuoCurr) {
            entry.set("quotecurr", (Object)quoteCurr);
        }
        entry.set("taxprice", (Object)taxPrice);
        entry.set("taxrate", (Object)taxRate);
        entry.set("taxrateid", (Object)taxRateId);
        entry.set("note", quoEntryRow.get("note"));
        entry.set("minorderqty", quoEntryRow.get("minorderqty"));
        entry.set("purleadday", quoEntryRow.get("purleadday"));
        entry.set("srcentryid", quoEntryRow.get("entryid"));
        entry.set("srcbillid", quoEntryRow.get("billid"));
        entry.set("prentryid", quoEntryRow.get("prentryid"));
        entry.set("prbillid", quoEntryRow.get("prbillid"));
        entry.set("basicqty", (Object)basicqty);
        entry.set("basicunit", quoEntryRow.get("basicunit"));
        entry.set("entryrcvorg", model.getValue("entryrcvorg"));
        entry.set("entryreqorg", model.getValue("entryreqorg"));
        return entry;
    }

    private void calcQuoDetailsPrice(IDataModel model, DynamicObject compareBill, int monthNum) {
        DynamicObjectCollection compareDetailsEntry = compareBill.getDynamicObjectCollection("materialentry");
        Map<String, BigDecimal> materialToMinPrice = this.getHisMinPrice(model, monthNum);
        Map<String, String> rcvIdMtToCompPriceInfo = this.getLastComparePrice(model, monthNum);
        String inquiryNo = (String)model.getValue("billno");
        Map<String, Object> dataMap = this.getQuoteByInquiry(inquiryNo);
        DynamicObjectCollection supplierCollections = (DynamicObjectCollection)dataMap.get("supplier");
        DynamicObjectCollection quoteCollections = (DynamicObjectCollection)dataMap.get("quote");
        Map<String, Map<String, BigDecimal>> quoEntryIdToPrices = null;
        if (quoteCollections != null) {
            quoEntryIdToPrices = this.getComparePriceData(quoteCollections);
        }
        for (DynamicObject entry : compareDetailsEntry) {
            Long material = entry.getLong("material");
            if (null == material || material.equals(0L)) continue;
            String materialId = String.valueOf(entry.getLong("material"));
            BigDecimal minTaxPrice = materialToMinPrice.get(materialId);
            entry.set("hisminprice", (Object)minTaxPrice);
            this.calcLastComparePrice(rcvIdMtToCompPriceInfo, entry, materialId);
            if (quoEntryIdToPrices == null || quoEntryIdToPrices.size() == 0) continue;
            String quoEntryId = entry.getString("srcentryid");
            Map<String, BigDecimal> priceMap = quoEntryIdToPrices.get(quoEntryId);
            BigDecimal minPrice = priceMap.get("minprice");
            BigDecimal maxPrice = priceMap.get("maxprice");
            BigDecimal newPrice = priceMap.get("newprice");
            BigDecimal avgPrice = priceMap.get("avgprice");
            entry.set("minprice", (Object)minPrice);
            entry.set("maxprice", (Object)maxPrice);
            entry.set("newprice", (Object)newPrice);
            entry.set("avgprice", (Object)avgPrice);
            for (int i = 0; i < supplierCollections.size() && i < 8; ++i) {
                DynamicObject suppllier = (DynamicObject)supplierCollections.get(i);
                String supplier = String.valueOf(suppllier.getLong("supplier"));
                BigDecimal taxPrice = priceMap.get(supplier);
                if (taxPrice == null) continue;
                int quoteNo = i + 1;
                String quoteKey = "quote" + quoteNo;
                entry.set(quoteKey, (Object)taxPrice);
            }
        }
    }

    private Map<String, Map<String, BigDecimal>> getComparePriceData(DynamicObjectCollection quoteCollections) {
        int j = 0;
        HashMap<String, Map<String, BigDecimal>> quoEntryIdToPriceMap = new HashMap<String, Map<String, BigDecimal>>(16);
        HashMap<String, QuoteQueryInfo> inqryEIdToQuoInfo = new HashMap<String, QuoteQueryInfo>(16);
        for (DynamicObject quoteEntry : quoteCollections) {
            Map objectMap;
            Date auditDate;
            String inqiryEntryId = quoteEntry.getString("srcentryid");
            String quoteEntryId = String.valueOf(quoteEntry.getLong("entryid"));
            QuoteQueryInfo quoInfo = (QuoteQueryInfo)inqryEIdToQuoInfo.get(inqiryEntryId);
            if (quoInfo == null) {
                quoInfo = new QuoteQueryInfo();
                quoInfo.setPriceMap(new HashMap<String, BigDecimal>(16));
                quoInfo.setQuoteEntryIds(new ArrayList<String>(10));
                quoInfo.setRecentQuoAuditAate(DateUtil.string2date((String)"1990-12-12 00:00:00", null));
                quoInfo.setSupplierIds(new ArrayList<Long>(10));
                inqryEIdToQuoInfo.put(inqiryEntryId, quoInfo);
            }
            List<String> quoteEntryIds = quoInfo.getQuoteEntryIds();
            Map<String, BigDecimal> priceMap = quoInfo.getPriceMap();
            Date recentQuoAuditAate = quoInfo.getRecentQuoAuditAate();
            List<Long> supplierIds = quoInfo.getSupplierIds();
            BigDecimal minPrice = priceMap.get("minprice");
            BigDecimal maxPrice = priceMap.get("maxprice");
            BigDecimal newPrice = priceMap.get("newprice");
            BigDecimal sumPrice = priceMap.get("sumPrice");
            if (minPrice == null) {
                minPrice = new BigDecimal(Integer.MAX_VALUE);
                priceMap.put("minprice", minPrice);
            }
            if (maxPrice == null) {
                maxPrice = BigDecimal.ZERO;
                priceMap.put("maxprice", maxPrice);
            }
            if (newPrice == null) {
                newPrice = BigDecimal.ZERO;
                priceMap.put("newprice", newPrice);
            }
            if (sumPrice == null) {
                sumPrice = BigDecimal.ZERO;
                priceMap.put("sumPrice", sumPrice);
            }
            BigDecimal taxPrice = CommonUtil.getBigDecimalPro((Object)quoteEntry.get("taxprice"));
            BigDecimal rate = quoteEntry.getBigDecimal("exchrate");
            int pricePrecision = quoteEntry.getInt("priceprecision");
            if (null == rate || BigDecimal.ZERO.compareTo(rate) >= 0) {
                rate = BigDecimal.ONE;
            }
            taxPrice = taxPrice.multiply(rate).setScale(pricePrecision, 4);
            sumPrice = sumPrice.add(taxPrice);
            priceMap.put("sumPrice", sumPrice);
            if (minPrice.compareTo(taxPrice) > 0) {
                minPrice = taxPrice;
                priceMap.put("minprice", minPrice);
            }
            if (maxPrice.compareTo(taxPrice) < 0) {
                maxPrice = taxPrice;
                priceMap.put("maxprice", maxPrice);
            }
            if (null != (auditDate = quoteEntry.getDate("auditdate")) && auditDate.after(recentQuoAuditAate)) {
                newPrice = taxPrice;
                priceMap.put("newprice", newPrice);
                recentQuoAuditAate = auditDate;
                quoInfo.setRecentQuoAuditAate(recentQuoAuditAate);
            }
            if ((objectMap = DynamicObjectUtil.plainObject2Map((DynamicObject)quoteEntry)).get("price") == null || taxPrice.compareTo(BigDecimal.ZERO) != 0) {
                ++j;
            }
            Long supplier = quoteEntry.getLong("supplier");
            if (supplier != null && !supplier.equals(0L)) {
                priceMap.put(String.valueOf(supplier), taxPrice);
                supplierIds.add(supplier);
            }
            quoteEntryIds.add(quoteEntryId);
        }
        for (QuoteQueryInfo quoInfo : inqryEIdToQuoInfo.values()) {
            List<Long> suppliers = quoInfo.getSupplierIds();
            Map<String, BigDecimal> priceMap = quoInfo.getPriceMap();
            List<String> quoteEntryIds = quoInfo.getQuoteEntryIds();
            int supllierCount = suppliers.size();
            BigDecimal sumPrice = priceMap.get("sumPrice");
            if (supllierCount > 0) {
                priceMap.put("avgprice", sumPrice.divide(new BigDecimal(supllierCount), sumPrice.scale(), RoundingMode.HALF_UP));
            }
            for (String quoEntryId : quoteEntryIds) {
                quoEntryIdToPriceMap.put(quoEntryId, priceMap);
            }
        }
        return quoEntryIdToPriceMap;
    }

    private void calcLastComparePrice(Map<String, String> rcvIdMtToCompPriceInfo, DynamicObject compDetailsEntryRow, String materialId) {
        DynamicObject rcvOrg = compDetailsEntryRow.getDynamicObject("entryrcvorg");
        String rcvId = rcvOrg == null ? "0" : String.valueOf(rcvOrg.getLong("id"));
        String billIdToPriceStr = rcvIdMtToCompPriceInfo.get(rcvId + "_" + materialId);
        if (StringUtils.isEmpty((CharSequence)billIdToPriceStr) || "0".equals(rcvId)) {
            Iterator<Map.Entry<String, String>> iterator = rcvIdMtToCompPriceInfo.entrySet().iterator();
            Map.Entry<String, String> tail = null;
            while (iterator.hasNext()) {
                Map.Entry<String, String> temp = iterator.next();
                if (!materialId.equals(temp.getKey().split("_")[1])) continue;
                tail = temp;
                break;
            }
            if (tail != null) {
                billIdToPriceStr = (String)tail.getValue();
            }
        }
        if (!StringUtils.isEmpty((CharSequence)billIdToPriceStr) && billIdToPriceStr.split("_").length == 2) {
            String[] billIdToPrice = billIdToPriceStr.split("_");
            compDetailsEntryRow.set("lastcompareid", (Object)billIdToPrice[0]);
            compDetailsEntryRow.set("lastcompareprice", (Object)billIdToPrice[1]);
        }
    }

    public Map<String, BigDecimal> getHisMinPrice(IDataModel model, int monthNum) {
        List<Long> materialIdList = this.getInquiryMaterialIds(model);
        String selectFields = "org,curr,materialentry.material material,materialentry.taxprice taxprice";
        HashMap<String, BigDecimal> matPriceMap = new HashMap<String, BigDecimal>();
        try (DataSet compareDataSet = QueryServiceHelper.queryDataSet((String)"PurCompareHelper.getHisMinPrice", (String)"sou_compare", (String)selectFields, (QFilter[])new QFilter[]{this.buildMinFilter(materialIdList, monthNum)}, (String)"billdate");){
            GroupbyDataSet groupDataSet = compareDataSet.groupBy(new String[]{"material", "curr"});
            DynamicObjectCollection compareCols = ORM.create().toPlainDynamicObjectCollection(groupDataSet.min("taxprice").finish());
            Object settCurr = model.getValue("curr");
            Object purOrg = model.getValue("org");
            if (null == purOrg || null == settCurr) {
                HashMap<String, BigDecimal> hashMap = matPriceMap;
                return hashMap;
            }
            DynamicObject purOrgObj = (DynamicObject)purOrg;
            DynamicObject settCurrObj = (DynamicObject)settCurr;
            for (DynamicObject compareCol : compareCols) {
                Object material = compareCol.get("material");
                Object curr = compareCol.get("curr");
                if (null == material || null == curr) continue;
                BigDecimal taxPrice = CommonUtil.getBigDecimalPro((Object)compareCol.get("taxprice"));
                if (settCurrObj.getPkValue().toString().equals(curr.toString())) {
                    BigDecimal price = (BigDecimal)matPriceMap.get(material.toString());
                    if (null != price && taxPrice.compareTo(price) >= 0) continue;
                    matPriceMap.put(material.toString(), taxPrice);
                    continue;
                }
                List companyids = OrgUtil.getToOrg((String)OrgTypeEnum.PURCHASE.getVal(), (String)OrgTypeEnum.ACCOUNTING.getVal(), (Long)((Long)purOrgObj.getPkValue()));
                BigDecimal exchange = ExchangeHelper.getExChangeRateByOrg((Long)Long.valueOf(settCurrObj.getPkValue().toString()), (Long)((Long)curr), (Long)(!companyids.isEmpty() ? (Long)companyids.get(0) : Long.valueOf(0L)));
                if (exchange == null || exchange.compareTo(BigDecimal.ZERO) == 0) {
                    exchange = BigDecimal.ONE;
                }
                taxPrice = taxPrice.multiply(exchange);
                BigDecimal price = (BigDecimal)matPriceMap.get(material.toString());
                if (null == price || taxPrice.compareTo(price) < 0) {
                    matPriceMap.put(material.toString(), taxPrice);
                }
                compareCol.set("taxprice", (Object)taxPrice);
            }
        }
        return matPriceMap;
    }

    public List<Long> getInquiryMaterialIds(IDataModel model) {
        DynamicObjectCollection inquiryEntryCols = model.getEntryEntity("materialentry");
        return DynamicObjectUtil.col2ListId((DynamicObjectCollection)inquiryEntryCols, (String)"material");
    }

    private QFilter buildMinFilter(List<Long> materialIds, int monthNum) {
        QFilter filter = new QFilter("materialentry.material", "in", materialIds);
        filter.and("materialentry.taxprice", ">", (Object)0);
        filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        filter.and("org", "in", (Object)OrgUtil.getAllPurViewPermissionOrgs((String)"sou_compare"));
        Date date = new Date();
        int monthParam = monthNum > 0 ? monthNum - 1 : 24;
        filter.and("billdate", "<=", (Object)DateUtil.getFormatDateEndMaxDate((Date)date));
        filter.and("billdate", ">=", (Object)DateUtil.getPreviousSomeMonth((Date)date, (int)monthParam));
        return filter;
    }

    public Map<String, String> getLastComparePrice(IDataModel model, int monthNum) {
        long extableId;
        DynamicObject extable;
        LinkedHashMap<String, String> matToLastPrice = new LinkedHashMap<String, String>();
        List<Long> materialIds = this.getInquiryMaterialIds(model);
        String selectFields = "id,billno,org,curr,materialentry.material.id,materialentry.taxprice,materialentry.entryrcvorg.id,curr.id,curr.name";
        DynamicObject inquiryCurr = (DynamicObject)model.getValue("curr");
        long[] inquiryCurrId = new long[]{0L};
        String[] inquiryCurrName = new String[]{""};
        if (inquiryCurr != null) {
            inquiryCurrId[0] = inquiryCurr.getLong("id");
            inquiryCurrName[0] = inquiryCurr.getString("name");
        }
        if ((extable = (DynamicObject)model.getValue("exchtype")) == null) {
            log.info("\u83b7\u53d6\u4e0a\u4e00\u6b21\u6bd4\u4ef7\u5355\u8fc7\u7a0b\u4e2d\u83b7\u53d6\u6c47\u7387\u8868\u4e3a\u7a7a\u3002");
            extableId = 0L;
        } else {
            extableId = extable.getLong("id");
        }
        HashMap compareCurrMap = new HashMap();
        HashMap currNameMap = new HashMap();
        HashMap compareBillnoMap = new HashMap();
        DynamicObject purOrg = (DynamicObject)model.getValue("org");
        try (DataSet compareDataSet = QueryServiceHelper.queryDataSet((String)"PurCompareHelper.getLastComparePrice", (String)"sou_compare", (String)selectFields, (QFilter[])new QFilter[]{this.buildLastComparePriceFilter(materialIds, monthNum, purOrg)}, (String)"billdate,materialentry.seq desc");){
            compareDataSet.forEach(row -> {
                Long compareCurrId = row.getLong("curr.id");
                String materialId = row.getString("materialentry.material.id");
                String rcv = row.getString("materialentry.entryrcvorg.id");
                String key = rcv + "_" + materialId;
                compareBillnoMap.put(row.getString("id"), row.getString("billno"));
                if (compareCurrId != null) {
                    compareCurrMap.put(row.getString("id"), compareCurrId);
                    currNameMap.put(compareCurrId, row.getString("curr.name"));
                }
                BigDecimal taxprice = row.getBigDecimal("materialentry.taxprice");
                matToLastPrice.remove(key);
                matToLastPrice.put(key, row.getString("id") + "_" + taxprice);
            });
        }
        HashMap<Long, BigDecimal> cacheRateMap = new HashMap<Long, BigDecimal>(16);
        String inquiryNo = (String)model.getValue("billno");
        for (Map.Entry entry : matToLastPrice.entrySet()) {
            String comToprice = (String)entry.getValue();
            String[] comTopriceArr = comToprice.split("_");
            BigDecimal taxprice = new BigDecimal(comTopriceArr[1]);
            Long compareCurrId = (Long)compareCurrMap.get(comTopriceArr[0]);
            if (compareCurrMap.size() == 0 || compareCurrId == null || compareCurrId.equals(0L)) {
                entry.setValue(comTopriceArr[0] + "_" + taxprice);
                continue;
            }
            taxprice = this.exchangeTaxprice(compareCurrId, inquiryCurrId[0], extableId, taxprice, cacheRateMap);
            if (null == taxprice) {
                String compareBillno = (String)compareBillnoMap.get(comTopriceArr[0]);
                String msg = MessageFormat.format(ResManager.loadKDString((String)"\u6839\u636e\u6bd4\u4ef7\u5355\u201c{0}\u201d\u7ed3\u7b97\u5e01\u201c{1}\u201d\u548c\u8be2\u4ef7\u5355\u201c{2}\u201d\u7ed3\u7b97\u5e01\u201c{3}\u201d\u8f6c\u6362\u4e0a\u6b21\u6bd4\u4ef7\u5355\u4ef7\u683c\u9519\u8bef\uff0c\u8bf7\u5230\u6c47\u7387\u8868\u4e2d\u7ef4\u62a4\u76f8\u5173\u5e01\u79cd\u6362\u7b97\u5173\u7cfb\u3002", (String)"PurCompareHelper_5", (String)"scm-pur-mobile", (Object[])new Object[0]), compareBillno, currNameMap.get(compareCurrId), inquiryNo, inquiryCurrName[0]);
                throw new KDBizException(msg);
            }
            entry.setValue(comTopriceArr[0] + "_" + taxprice);
        }
        return matToLastPrice;
    }

    private QFilter buildLastComparePriceFilter(List<Long> materialIds, int monthNum, DynamicObject purOrg) {
        QFilter filter = new QFilter("materialentry.material", "in", materialIds);
        filter.and("billstatus", "=", (Object)"C");
        Date date = TimeServiceHelper.now();
        int monthParam = monthNum > 0 ? monthNum - 1 : 24;
        filter.and("billdate", "<=", (Object)date);
        filter.and("billdate", ">=", (Object)DateUtil.getPreviousSomeMonth((Date)date, (int)monthParam));
        if (null == purOrg) {
            return null;
        }
        filter.and("org", "=", purOrg.getPkValue());
        return filter;
    }

    public BigDecimal exchangeTaxprice(long compareCurrId, long inquiryCurrId, long extableId, BigDecimal taxprice, Map<Long, BigDecimal> cacheRateMap) {
        BigDecimal exchangeRate = null;
        if (inquiryCurrId == compareCurrId) {
            exchangeRate = BigDecimal.ONE;
        } else {
            BigDecimal exchangeRateT = cacheRateMap.get(compareCurrId);
            BigDecimal bigDecimal = exchangeRate = exchangeRateT == null ? BaseDataServiceHelper.getExchangeRate((Long)extableId, (Long)compareCurrId, (Long)inquiryCurrId, (Date)TimeServiceHelper.now()) : exchangeRateT;
            if (exchangeRateT == null && exchangeRate != null) {
                cacheRateMap.put(compareCurrId, exchangeRate);
            }
        }
        if (exchangeRate == null || BigDecimal.ZERO.compareTo(exchangeRate) >= 0) {
            return null;
        }
        taxprice = taxprice.multiply(exchangeRate);
        return taxprice;
    }

    private void showErrTips(IFormView view, OperationResult opResult) {
        ValidateResultCollection validateResults = opResult.getValidateResult();
        int size = validateResults.errorSize();
        if (size == 0) {
            view.showOperationResult(opResult, "");
            return;
        }
        List valResults = validateResults.getValidateErrors();
        StringBuilder sb = new StringBuilder();
        for (ValidateResult valResult : valResults) {
            List allOpErrors = valResult.getAllErrorInfo();
            for (OperateErrorInfo opError : allOpErrors) {
                String message = opError.getMessage();
                sb.append(message);
            }
        }
        view.showTipNotification(sb.toString());
    }

    private Map<String, Object> getQuoteByInquiry(String inquiryNo) {
        Map<String, Map<String, Object>> quoParams = this.buildCondition();
        HashMap<String, String> inquiryNoMap = new HashMap<String, String>(16);
        inquiryNoMap.put("=", inquiryNo);
        quoParams.put("inquiryno", inquiryNoMap);
        HashMap<String, String> entryStatusMap = new HashMap<String, String>(16);
        entryStatusMap.put("=", "A");
        quoParams.put("materialentry.entrystatus", entryStatusMap);
        HashMap<String, String> statusMap = new HashMap<String, String>(16);
        statusMap.put("=", "C");
        quoParams.put("billstatus", statusMap);
        String orderBys = "materialentry.taxprice,sumtaxamount,materialentry.price";
        return this.getQuoteByInquiry("sou_quote", quoParams, orderBys);
    }

    private Map<String, Map<String, Object>> buildCondition() {
        HashMap<String, Map<String, Object>> paramMap = new HashMap<String, Map<String, Object>>();
        HashMap<String, String> statusMap = new HashMap<String, String>(16);
        statusMap.put("=", BillStatusEnum.AUDIT.getVal());
        paramMap.put("billstatus", statusMap);
        return paramMap;
    }

    public Map<String, Object> getQuoteByInquiry(String entityName, Map<String, Map<String, Object>> params, String orderBys) {
        ORM orm = ORM.create();
        StringBuilder selectFieldsSB = new StringBuilder();
        selectFieldsSB.append("id billid,exchrate exchrate,billno,inquiryno,turns,supplier.name supplierName,supplier.simplename simplename,supplier.id supplier,curr.id curr,billdate,sumtax,sumtaxamount,sumamount,sumcost,totalamount,").append("materialentry.id entryid,materialentry.material material,materialentry.unit unit,materialentry.qty qty,materialentry.price price,materialentry.basicqty basicqty,materialentry.basicunit basicunit,materialentry.minorderqty minorderqty,materialentry.purleadday purleadday,").append("materialentry.prbillid prbillid,materialentry.srcbillid srcbillid,materialentry.srcentryid srcentryid,materialentry.prentryid prentryid,materialentry.materialdesc materialdesc,materialentry.entryrcvorg entryrcvorg, materialentry.entryreqorg entryreqorg,").append("materialentry.taxprice taxprice,materialentry.taxrateid taxrateid,materialentry.taxrate taxrate,materialentry.taxamount taxamount,loccurr.amtprecision amtprecision,loccurr.priceprecision priceprecision,auditdate");
        DataSet dataSet = ORMUtil.queryDataSet((String)entityName, (String)selectFieldsSB.toString(), params, (String)orderBys);
        DataSet dataSetForSup = dataSet.copy();
        GroupbyDataSet groupDateSet = dataSetForSup.groupBy(new String[]{"supplier", "supplierName", "simplename"});
        groupDateSet.sum("taxamount");
        DynamicObjectCollection supplierCols = orm.toPlainDynamicObjectCollection(groupDateSet.finish().orderBy(new String[]{"taxamount"}));
        DynamicObjectCollection cols = orm.toPlainDynamicObjectCollection(dataSet);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        dataMap.put("supplier", supplierCols);
        dataMap.put("quote", cols);
        return dataMap;
    }
}

