/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;

public class BigDecimalUtils {
    public static String getMicquartBigDecimal(BigDecimal bigDecimal, boolean isTailZero) {
        if (bigDecimal == null) {
            return "";
        }
        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            if (!isTailZero) {
                return "0";
            }
            return bigDecimal.toString();
        }
        String bigDecimalStr = bigDecimal.toString();
        if (!isTailZero) {
            bigDecimalStr = bigDecimal.stripTrailingZeros().toPlainString();
        }
        BigDecimal toBigDecimal = new BigDecimal(bigDecimalStr);
        int scale = toBigDecimal.scale();
        StringBuilder decimalFormatStr = new StringBuilder();
        decimalFormatStr.append(",###");
        if (scale > 0) {
            decimalFormatStr.append(".");
        }
        for (int i = 0; i < scale; ++i) {
            decimalFormatStr.append("#");
        }
        DecimalFormat decimalFt = new DecimalFormat(decimalFormatStr.toString());
        String toValue = decimalFt.format(toBigDecimal);
        if (scale == 0) {
            return toValue;
        }
        if (!isTailZero) {
            return toValue;
        }
        if (!toValue.contains(".")) {
            StringBuilder toStrBuilder = new StringBuilder();
            toStrBuilder.append(toValue);
            toStrBuilder.append(".");
            for (int i = 0; i < scale; ++i) {
                toStrBuilder.append("0");
            }
            return toStrBuilder.toString();
        }
        int dotIndex = toValue.indexOf(".");
        int scaleT = toValue.substring(dotIndex + 1, toValue.length()).length();
        if (scale > scaleT) {
            StringBuilder toStrBuilder = new StringBuilder();
            toStrBuilder.append(toValue);
            int dValue = scale - scaleT;
            for (int i = 0; i < dValue; ++i) {
                toStrBuilder.append("0");
            }
            return toStrBuilder.toString();
        }
        return toValue;
    }
}

