/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;

public class MobileControlUtils {
    public static void billListRefresh(BillList control, QFilter ... filters) {
        if (filters != null && filters.length != 0) {
            int length = filters.length;
            ArrayList<QFilter> tbFilters = new ArrayList<QFilter>(length);
            for (int i = 0; i < length; ++i) {
                tbFilters.add(filters[i]);
            }
            FilterParameter filterParameter = new FilterParameter();
            filterParameter.setQFilters(tbFilters);
            control.setQueryFilterParameter(filterParameter);
        }
        control.refresh();
    }

    public static void labelSetValue(Label control, Object value) {
        String text = "";
        text = value instanceof BigDecimal ? ((BigDecimal)value).stripTrailingZeros().toPlainString() : value.toString();
        control.setText(text);
    }

    public static void controlSetFrontAndBackColor(Control control, String fc, String bc) {
        String key = control.getKey();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(key);
        list.add(dataMap);
        dataMap.put("fc", fc);
        dataMap.put("bc", bc);
        IClientViewProxy proxy = (IClientViewProxy)control.getView().getService(IClientViewProxy.class);
        proxy.addAction("updateControlMetadata", list);
    }

    public static void setCardEntryRowProperty(CardEntry cardEntry, String key, int rowIndex, Map<String, Object> proData) {
        if (proData == null || proData.size() == 0) {
            return;
        }
        HashMap<String, Map<String, Object>> keyToProData = new HashMap<String, Map<String, Object>>(16);
        keyToProData.put(key, proData);
        cardEntry.setCustomProperties(key, rowIndex, keyToProData);
    }

    public static void setCardEntryRowProperties(CardEntry cardEntry, int rowIndex, Map<String, Object> proData, String ... keys) {
        if (proData == null || proData.size() == 0) {
            return;
        }
        for (String key : keys) {
            HashMap<String, Map<String, Object>> keyToProData = new HashMap<String, Map<String, Object>>(16);
            keyToProData.put(key, proData);
            cardEntry.setCustomProperties(key, rowIndex, keyToProData);
        }
    }

    public static void setCardEntryRowProperty(CardEntry cardEntry, int rowIndex, String proKey, Object proValue, String key) {
        HashMap keyToProData = new HashMap(16);
        HashMap<String, Object> proData = new HashMap<String, Object>(16);
        proData.put(proKey, proValue);
        keyToProData.put(key, proData);
        cardEntry.setCustomProperties(key, rowIndex, keyToProData);
    }
}

