/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.mobile.compare;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.scm.pur.common.helper.PurCompareHelper;
import kd.scm.pur.common.utils.NumberUtils;

public class PurCompareToolMobEdit
extends AbstractMobBillPlugIn {
    private static final Map<String, String> resultMap = new HashMap<String, String>(16);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"last", "next", "back", "finish"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object inquiryId = param.get("inquiryid");
        Object inquiryno = param.get("inquiryno");
        String currInqryEIdx = (String)param.get("currentryrowindex");
        Map indexToInquiryInfo = (Map)param.get("inquirycustomparams");
        Map inquiryInfo = (Map)indexToInquiryInfo.get(currInqryEIdx);
        Map idxToQuoInfo = (Map)param.get("quotecustomparams");
        Map<String, Object> entryIdxOrSeqInfo = this.getEntryIdxOrSeqInfo(idxToQuoInfo);
        int currEntryIdxSeq = this.getSeqByEntryIdx(entryIdxOrSeqInfo, currInqryEIdx);
        model.setValue("inquiryno", inquiryno);
        model.setValue("inquiryid", inquiryId);
        this.setInquiryInfo(model, inquiryInfo);
        this.setRelatQuoteData(idxToQuoInfo, currInqryEIdx, currEntryIdxSeq);
        pageCache.put("currentryrowindex", currInqryEIdx);
        pageCache.put("quotecustomparams", SerializationUtils.toJsonString((Object)idxToQuoInfo));
        pageCache.put("inquirycustomparams", SerializationUtils.toJsonString((Object)indexToInquiryInfo));
    }

    private int getSeqByEntryIdx(Map<String, Object> entryIdxOrSeqInfo, String currInqryEIdx) {
        Map idxToSeq = (Map)entryIdxOrSeqInfo.get("idxToSeq");
        int currInqryEIdxSeq = (Integer)idxToSeq.get(currInqryEIdx);
        return currInqryEIdxSeq;
    }

    private int getEntryIdxBySeq(Map<String, Object> entryIdxOrSeqInfo, int currInqryEIdxSeq) {
        Map seqToIdx = (Map)entryIdxOrSeqInfo.get("seqToIdx");
        int currInqryEIdx = (Integer)seqToIdx.get(currInqryEIdxSeq);
        return currInqryEIdx;
    }

    private Map<String, Object> getEntryIdxOrSeqInfo(Map<String, List<Map<String, Object>>> idxToQuoInfo) {
        HashMap<String, Object> entryIdxOrSeqInfo = new HashMap<String, Object>(16);
        TreeSet<String> sortSet = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int secondIdx;
                int firstIdx = Integer.parseInt(o1);
                if (firstIdx < (secondIdx = Integer.parseInt(o2))) {
                    return -1;
                }
                if (firstIdx == secondIdx) {
                    return 0;
                }
                return 1;
            }
        });
        sortSet.addAll(idxToQuoInfo.keySet());
        int indexSeq = 0;
        HashMap<String, Integer> idxToSeq = new HashMap<String, Integer>(16);
        HashMap<Integer, Integer> seqToIdx = new HashMap<Integer, Integer>(16);
        for (String index : sortSet) {
            idxToSeq.put(index, indexSeq);
            seqToIdx.put(indexSeq, Integer.valueOf(index));
            ++indexSeq;
        }
        entryIdxOrSeqInfo.put("idxToSeq", idxToSeq);
        entryIdxOrSeqInfo.put("seqToIdx", seqToIdx);
        return entryIdxOrSeqInfo;
    }

    private void setInquiryInfo(IDataModel model, Map<String, Object> inquiryInfo) {
        String materialModel = (String)inquiryInfo.get("materialmodel");
        String materialDesc = (String)inquiryInfo.get("materialdesc");
        BigDecimal inquiryQty = (BigDecimal)inquiryInfo.get("qty");
        model.setValue("materialmodel", (Object)materialModel);
        model.setValue("materialdesc", (Object)materialDesc);
        model.setValue("inquiryqty", (Object)inquiryQty);
        model.setValue("inquiryunit", (Object)Long.valueOf(inquiryInfo.get("unit").toString()));
        model.setValue("entryrcvorg", (Object)Long.valueOf(inquiryInfo.get("entryrcvorg").toString()));
        model.setValue("entryreqorg", (Object)Long.valueOf(inquiryInfo.get("entryreqorg").toString()));
        model.setValue("material", (Object)Long.valueOf(inquiryInfo.get("material").toString()));
    }

    private void setRelatQuoteData(Map<String, List<Map<String, Object>>> idxToQuoInfo, String currIndex, int currIdxSeq) {
        IDataModel model = this.getModel();
        PurCompareHelper compareHelper = new PurCompareHelper();
        compareHelper.setViewByRowIdx(this, currIdxSeq, idxToQuoInfo.size());
        List<Map<String, Object>> quoteInfos = idxToQuoInfo.get(currIndex);
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        model.deleteEntryData("entryentity");
        int totalRowCount = quoteInfos.size();
        model.batchCreateNewEntryRow("entryentity", totalRowCount);
        for (int i = 0; i < totalRowCount; ++i) {
            Map<String, Object> quoteBillParam = quoteInfos.get(i);
            Long supplier = Long.valueOf(quoteBillParam.get("supplier").toString());
            Long curr = Long.valueOf(quoteBillParam.get("curr").toString());
            BigDecimal taxPrice = (BigDecimal)quoteBillParam.get("taxprice");
            BigDecimal taxAmount = (BigDecimal)quoteBillParam.get("taxamount");
            BigDecimal qty = (BigDecimal)quoteBillParam.get("qty");
            Long unit = Long.valueOf(quoteBillParam.get("unit").toString());
            String resultTmp = (String)quoteBillParam.get("result");
            Long quoBillId = (Long)quoteBillParam.get("billid");
            Long quoEntryId = (Long)quoteBillParam.get("entryid");
            Object material = quoteBillParam.get("material");
            Long materialId = NumberUtils.getLong(material);
            BigDecimal cfmQty = (BigDecimal)quoteBillParam.get("cfmqty");
            BigDecimal basicQty = (BigDecimal)quoteBillParam.get("basicqty");
            BigDecimal cfmPrice = (BigDecimal)quoteBillParam.get("cfmprice");
            BigDecimal cfmTaxPrice = (BigDecimal)quoteBillParam.get("cfmtaxprice");
            BigDecimal cfmTaxRate = (BigDecimal)quoteBillParam.get("cfmtaxrate");
            Object cfmTaxRateObj = quoteBillParam.get("cfmtaxrateid");
            Long cfmTaxRateId = NumberUtils.getLong(cfmTaxRateObj);
            String note = (String)quoteBillParam.get("note");
            BigDecimal minOrderQty = (BigDecimal)quoteBillParam.get("minorderqty");
            int purLeadDay = (Integer)quoteBillParam.get("purleadday");
            String prBillId = (String)quoteBillParam.get("prbillid");
            String prEntryId = (String)quoteBillParam.get("prentryid");
            Object basicUnit = quoteBillParam.get("basicunit");
            Long basicUnitId = NumberUtils.getLong(basicUnit);
            String isadopt = (String)quoteBillParam.get("isadopt");
            model.setValue("supplier", (Object)supplier, i);
            model.setValue("curr", (Object)curr, i);
            model.setValue("taxprice", (Object)taxPrice, i);
            model.setValue("taxamount", (Object)taxAmount, i);
            model.setValue("qty", (Object)qty, i);
            model.setValue("unit", (Object)unit, i);
            model.setValue("entryresult", (Object)resultTmp, i);
            HashMap keyToResult = new HashMap(16);
            HashMap<String, String> resultData = new HashMap<String, String>(16);
            String resultT = resultMap.get(resultTmp);
            String resultVal = resultT == null ? "" : resultT;
            resultData.put("text", resultVal);
            keyToResult.put("result", resultData);
            cardEntry.setCustomProperties("result", i, keyToResult);
            model.setValue("billid", (Object)quoBillId, i);
            model.setValue("entryid", (Object)quoEntryId, i);
            model.setValue("material2", (Object)materialId, i);
            model.setValue("cfmqty", (Object)cfmQty, i);
            model.setValue("basicqty", (Object)basicQty, i);
            model.setValue("cfmprice", (Object)cfmPrice, i);
            model.setValue("cfmtaxprice", (Object)cfmTaxPrice, i);
            model.setValue("cfmtaxrate", (Object)cfmTaxRate, i);
            model.setValue("cfmtaxrateid", (Object)cfmTaxRateId, i);
            model.setValue("note", (Object)note, i);
            model.setValue("minorderqty", (Object)minOrderQty, i);
            model.setValue("purleadday", (Object)purLeadDay, i);
            model.setValue("prbillid", (Object)prBillId, i);
            model.setValue("prentryid", (Object)prEntryId, i);
            model.setValue("basicunit", (Object)basicUnitId, i);
            model.setValue("isadopt", (Object)isadopt, i);
        }
    }

    public void click(EventObject e) {
        super.click(e);
        IPageCache pageCache = this.getPageCache();
        Control source = (Control)e.getSource();
        String opKey = source.getKey();
        int currIndex = Integer.parseInt(pageCache.get("currentryrowindex"));
        Map idxToInqryInfo = (Map)SerializationUtils.fromJsonString((String)pageCache.get("inquirycustomparams"), Map.class);
        Map idxToQuoInfo = (Map)SerializationUtils.fromJsonString((String)pageCache.get("quotecustomparams"), Map.class);
        Map<String, Object> entryIdxOrSeqInfo = this.getEntryIdxOrSeqInfo(idxToQuoInfo);
        switch (opKey) {
            case "last": {
                int lastIdxSeq = this.getSeqByEntryIdx(entryIdxOrSeqInfo, String.valueOf(currIndex)) - 1;
                int lastIndex = this.getEntryIdxBySeq(entryIdxOrSeqInfo, lastIdxSeq);
                this.lastOrNextOp(pageCache, idxToInqryInfo, idxToQuoInfo, currIndex, lastIndex, lastIdxSeq);
                break;
            }
            case "next": {
                int nextIdxSeq = this.getSeqByEntryIdx(entryIdxOrSeqInfo, String.valueOf(currIndex)) + 1;
                int nextIndex = this.getEntryIdxBySeq(entryIdxOrSeqInfo, nextIdxSeq);
                this.lastOrNextOp(pageCache, idxToInqryInfo, idxToQuoInfo, currIndex, nextIndex, nextIdxSeq);
                break;
            }
            case "back": 
            case "finish": {
                this.closeCurrPageOp(currIndex);
                break;
            }
        }
    }

    private void lastOrNextOp(IPageCache pageCache, Map<String, Map<String, Object>> idxToInqryInfo, Map<String, List<Map<String, Object>>> idxToQuoInfo, int currIndex, int lastOrNextIdx, int lastOrNextIdxSeq) {
        this.clickReCacheQuoteInfo(pageCache, currIndex, idxToQuoInfo);
        String lastOrNextIdxT = String.valueOf(lastOrNextIdx);
        this.setInquiryInfo(this.getModel(), idxToInqryInfo.get(lastOrNextIdxT));
        this.setRelatQuoteData(idxToQuoInfo, lastOrNextIdxT, lastOrNextIdxSeq);
        pageCache.put("currentryrowindex", lastOrNextIdxT);
    }

    private void clickReCacheQuoteInfo(IPageCache pageCache, int currIndex, Map<String, List<Map<String, Object>>> idxToQuoInfo) {
        List<Map<String, Object>> quoteInfo = idxToQuoInfo.get(String.valueOf(currIndex));
        this.backFillQuoParams(quoteInfo);
        pageCache.put("quotecustomparams", SerializationUtils.toJsonString(idxToQuoInfo));
    }

    private void backFillQuoParams(List<Map<String, Object>> quoteInfo) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entrys = model.getEntryEntity("entryentity");
        HashMap<Long, Boolean> entryToIsadopt = new HashMap<Long, Boolean>(16);
        for (DynamicObject entry : entrys) {
            Boolean isadopt = entry.getBoolean("isadopt");
            entryToIsadopt.put(entry.getLong("entryid"), isadopt);
        }
        for (Map<String, Object> quoMap : quoteInfo) {
            Object entryId = quoMap.get("entryid");
            Long quoEntryId = NumberUtils.getLong(entryId);
            String newIsadopt = (Boolean)entryToIsadopt.get(quoEntryId) != false ? "1" : "2";
            quoMap.put("isadopt", newIsadopt);
        }
    }

    private void closeCurrPageOp(int currIndex) {
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        HashMap<String, String> idxToIsComparePrice = new HashMap<String, String>(16);
        Map idxToQuoInfo = (Map)SerializationUtils.fromJsonString((String)pageCache.get("quotecustomparams"), Map.class);
        this.clickReCacheQuoteInfo(pageCache, currIndex, idxToQuoInfo);
        for (Map.Entry idxQuoInfo : idxToQuoInfo.entrySet()) {
            String index = (String)idxQuoInfo.getKey();
            String isComparePrice = "0";
            List quoteInfo = (List)idxQuoInfo.getValue();
            for (Map quoteMap : quoteInfo) {
                String isadopt = (String)quoteMap.get("isadopt");
                if (!"1".equals(isadopt)) continue;
                isComparePrice = "1";
                break;
            }
            idxToIsComparePrice.put(index, isComparePrice);
        }
        HashMap<String, Map> returnData = new HashMap<String, Map>(16);
        returnData.put("idxToQuoInfo", idxToQuoInfo);
        returnData.put("idxToIsComparePrice", idxToIsComparePrice);
        view.returnDataToParent(returnData);
        view.close();
    }

    static {
        resultMap.put("1", ResManager.loadKDString((String)"\u91c7\u7eb3", (String)"PurQuoteAsitQueryMobEdit_0", (String)"scm-pur-mobile", (Object[])new Object[0]));
        resultMap.put("2", ResManager.loadKDString((String)"\u672a\u91c7\u7eb3", (String)"PurQuoteAsitQueryMobEdit_1", (String)"scm-pur-mobile", (Object[])new Object[0]));
    }
}

