/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.mobile.inquiry;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.InquiryUtil;

public class PurAlertDateMobEdit
extends AbstractMobBillPlugIn {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        IDataModel model = this.getModel();
        Map param = parameter.getCustomParams();
        model.setValue("srcdate", param.get("enddate"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String operateKey;
        super.afterDoOperation(event);
        String msg = event.getOperationResult().getMessage();
        if (null != msg) {
            return;
        }
        switch (operateKey = ((AbstractOperate)event.getSource()).getOperateKey()) {
            case "confirm": {
                this.confirmAlert();
                break;
            }
        }
    }

    private void confirmAlert() {
        Object[] objs;
        IFormView view = this.getView();
        DynamicObject inquiryBill = this.getSouInquiryBill();
        if (null == inquiryBill) {
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8be2\u4ef7\u5355\u3002", (String)"PurAlertDateMobEdit_0", (String)"scm-pur-mobile", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        Object alertDate = model.getValue("alertdate");
        inquiryBill.set("enddate", alertDate);
        DynamicObjectCollection supplierEntry = inquiryBill.getDynamicObjectCollection("entryentity");
        if (supplierEntry != null) {
            supplierEntry.forEach(info -> {
                if (StringUtils.equals((CharSequence)inquiryBill.getString("turns"), (CharSequence)info.getString("entryturns"))) {
                    info.set("deadline", alertDate);
                }
            });
        }
        DynamicObjectCollection logs = inquiryBill.getDynamicObjectCollection("entrylog");
        Date oldDeadLine = null;
        if (logs != null) {
            for (DynamicObject info2 : logs) {
                if (!StringUtils.equals((CharSequence)inquiryBill.getString("turns"), (CharSequence)info2.getString("turns_log"))) continue;
                oldDeadLine = info2.getDate("logdeadline");
                info2.set("logdeadline", alertDate);
            }
        }
        if ((objs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{inquiryBill})).length > 0) {
            this.updateNoticeDate((Long)inquiryBill.getPkValue(), oldDeadLine);
            view.showSuccessNotification(ResManager.loadKDString((String)"\u53d8\u66f4\u65f6\u95f4\u6210\u529f\u3002", (String)"PurAlertDateMobEdit_1", (String)"scm-pur-mobile", (Object[])new Object[0]));
            view.close();
        }
        this.updateQuoteBill(inquiryBill);
    }

    private void updateQuoteBill(DynamicObject inquiryBill) {
        DynamicObject[] quoteBills;
        String billno = inquiryBill.getString("billno");
        int turns = inquiryBill.getInt("turns");
        ArrayList<String> billnos = new ArrayList<String>();
        billnos.add(billno);
        for (DynamicObject quoBill : quoteBills = InquiryUtil.getNormalQuoteBillByInquiryBill(billnos)) {
            if (turns != quoBill.getInt("turns")) continue;
            quoBill.set("enddate", (Object)inquiryBill.getDate("enddate"));
        }
        SaveServiceHelper.save((DynamicObject[])quoteBills);
    }

    private void updateNoticeDate(Long inquiryId, Date oldDeadLine) {
        Map targetDataMap = BFTrackerServiceHelper.findTargetBills((String)"sou_inquiry", (Long[])new Long[]{inquiryId});
        Set noticeSet = (Set)targetDataMap.get("sou_notice");
        if (null != noticeSet) {
            Object alertDate = this.getModel().getValue("alertdate");
            String selectProperties = "id,duedate";
            QFilter filter = new QFilter("id", "in", (Object)noticeSet);
            if (oldDeadLine != null) {
                filter.and("duedate", "=", (Object)oldDeadLine);
            }
            DynamicObject[] noticeObjs = BusinessDataServiceHelper.load((String)"sou_notice", (String)selectProperties, (QFilter[])new QFilter[]{filter});
            for (int i = 0; i < noticeObjs.length; ++i) {
                DynamicObject noticeObj = noticeObjs[i];
                noticeObj.set("duedate", alertDate);
            }
            SaveServiceHelper.save((DynamicObject[])noticeObjs);
        }
    }

    private DynamicObject getSouInquiryBill() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object inquiryBillIdObj = param.get("billid");
        if (inquiryBillIdObj == null) {
            return null;
        }
        QFilter qFilter = new QFilter("id", "=", inquiryBillIdObj);
        String selectFields = "id,billno,enddate,bizstatus,turns,entryentity.canshow,entryentity.deadline,entryentity.entryturns,entrylog.turns_log,entrylog.logdeadline";
        return BusinessDataServiceHelper.loadSingle((String)"sou_inquiry", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }
}

