/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.helper.multisystemjoint.business.MultiDataChannelHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.ScmcUtil;
import kd.scm.pur.business.PurBatchStockHelper;
import kd.scm.pur.business.PurModuleListHelper;
import kd.scm.pur.business.PurOrderBillHelper;
import kd.scm.pur.business.PurReceiptDeleteHelper;
import kd.scm.pur.business.PurSalStockPushHelper;
import kd.scm.pur.common.util.PurOrderBillActiveToPurOrderOpUtil;
import kd.scm.pur.opplugin.util.PurReceiptReturnUtil;
import kd.scm.pur.opplugin.util.PurReturnUtil;
import kd.scm.pur.service.IBillGenericService;

public class BillGenericService
implements IBillGenericService {
    private static Log log = LogFactory.getLog(BillGenericService.class);
    private IAppCache appCache = AppCache.get((String)"scm-pur-billgenericservice");
    private static final String IM_PURINBILL = "im_purinbill";
    private static final String IM_PURRECEIVEBILL = "im_purreceivebill";
    private static final String IM_PURINBILL_ENTRY = "billentry";
    private static final String PM_PURACCEPTBILL = "pm_puracceptbill";

    public boolean isCQConfig() throws Exception {
        String cosmicJointDataChannelId = MultiDataChannelHelper.getCosmicJointDataChannelId();
        return cosmicJointDataChannelId != null && !cosmicJointDataChannelId.isEmpty();
    }

    public boolean isEASConfig() throws Exception {
        return ApiConfigUtil.hasEASConfig();
    }

    public String getConnectErp() throws Exception {
        Object obj = ParamUtil.getParamObj((String)"eae607fb000143ac", (String)"connecterp");
        if (StringUtils.isNotBlank((Object)obj)) {
            return String.valueOf(obj);
        }
        return "";
    }

    public Map<String, Object> unAuditAndDeletePurModuleList(Map<String, Object> param) throws Exception {
        log.info("@@@\u8c03\u7528\u7ec4\u4ef6\u6e05\u5355\u5220\u9664\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)SerializationUtils.toJsonString(param));
        List mftorderentryid = (List)param.get("ids");
        String entityName = (String)param.get("entityName");
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        String message = null;
        boolean success = true;
        if (entityName == null || mftorderentryid == null || mftorderentryid.size() == 0) {
            success = false;
            message = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6240\u4f20\u9012\u7684\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"BillGenericService_0", (String)"scm-pur-mservice", (Object[])new Object[0]);
        }
        if ("pur_modulelist".equals(entityName)) {
            Map result0 = PurModuleListHelper.unAuditAndDeletePurModuleList((List)mftorderentryid);
            return result0;
        }
        log.info("@@@\u8c03\u7528" + entityName + "\u53cd\u5ba1\u6838\u5220\u9664\u63a5\u53e3\u7ed3\u679c-->" + message);
        result.put("success", success);
        result.put("message", message);
        return result;
    }

    public Map<String, Object> unAuditAndDeleteBill(Map<String, Object> param) throws Exception {
        log.info("\u53cd\u5ba1\u6838\u5220\u9664\u5355\u636e\u63a5\u53e3\u8c03\u7528\u53c2\u6570:" + param);
        List ids = (List)param.get("ids");
        String entityName = (String)param.get("entityName");
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        String message = null;
        boolean success = true;
        if (entityName == null || ids == null || ids.size() == 0) {
            success = false;
            message = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6240\u4f20\u9012\u7684\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"BillGenericService_0", (String)"scm-pur-mservice", (Object[])new Object[0]);
        } else {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", String.valueOf(false));
            option.setVariableValue("ishasright", String.valueOf(true));
            OperationResult deleteResult = null;
            OperationResult unAuditResult = null;
            if ("pur_pay".equals(entityName) || "pur_payapply".equals(entityName)) {
                Throwable throwable;
                TXHandle h;
                try {
                    h = TX.requiresNew();
                    throwable = null;
                    try {
                        unAuditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)entityName, (Object[])ids.toArray(), (OperateOption)option);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (h != null) {
                            if (throwable != null) {
                                try {
                                    h.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                h.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.error("@@@BillGenericService.unAuditAndDeleteBil\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u5b9e\u4f53" + entityName + ExceptionUtil.getStackTrace((Throwable)e));
                    message = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u62a5\u9519\uff0c\u8bf7\u67e5\u8be2\u65e5\u5fd7", (String)"BillGenericService_1", (String)"scm-pur-mservice", (Object[])new Object[0]);
                    success = false;
                }
                if (null != unAuditResult) {
                    try {
                        h = TX.requiresNew();
                        throwable = null;
                        try {
                            deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)entityName, (Object[])ids.toArray(), (OperateOption)option);
                            if (!deleteResult.isSuccess()) {
                                success = false;
                                message = ResManager.loadKDString((String)"\u66f4\u65b0\u91c7\u8d2d\u534f\u540c\u91c7\u8d2d\u8ba2\u5355\u7684\u786e\u8ba4\u72b6\u6001\u6210\u529f %1$s", (String)"BillGenericService_4", (String)"scm-pur-mservice", (Object[])new Object[]{ExceptionUtil.getErrorInfoDetails((List)deleteResult.getAllErrorOrValidateInfo())});
                            }
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (h != null) {
                                if (throwable != null) {
                                    try {
                                        h.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    h.close();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("@@@BillGenericService.unAuditAndDeleteBill\u5220\u9664\u5931\u8d25\uff0c\u5b9e\u4f53" + entityName + ExceptionUtil.getStackTrace((Throwable)e));
                        message = ResManager.loadKDString((String)"\u5220\u9664\u62a5\u9519\uff0c\u8bf7\u67e5\u8be2\u65e5\u5fd7", (String)"BillGenericService_2", (String)"scm-pur-mservice", (Object[])new Object[0]);
                        success = false;
                    }
                }
            } else {
                try {
                    unAuditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)entityName, (Object[])ids.toArray(), (OperateOption)option);
                }
                catch (Exception e) {
                    log.error("@@@BillGenericService.unAuditAndDeleteBil\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u5b9e\u4f53" + entityName + ExceptionUtil.getStackTrace((Throwable)e));
                    message = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u62a5\u9519\uff0c\u8bf7\u67e5\u8be2\u65e5\u5fd7", (String)"BillGenericService_1", (String)"scm-pur-mservice", (Object[])new Object[0]);
                    success = false;
                }
                if (null != unAuditResult) {
                    try {
                        deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)entityName, (Object[])ids.toArray(), (OperateOption)option);
                        if (!deleteResult.isSuccess()) {
                            success = false;
                            message = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5220\u9664\u5355\u636e\u63a5\u53e3\u5728\u5220\u9664\u65f6\u5931\u8d25\uff1a%1$s", (String)"BillGenericService_3", (String)"scm-pur-mservice", (Object[])new Object[]{ExceptionUtil.getErrorInfoDetails((List)deleteResult.getAllErrorOrValidateInfo())});
                        }
                    }
                    catch (Exception e) {
                        log.error("@@@BillGenericService.unAuditAndDeleteBill\u5220\u9664\u5931\u8d25\uff0c\u5b9e\u4f53" + entityName + ExceptionUtil.getStackTrace((Throwable)e));
                        message = ResManager.loadKDString((String)"\u5220\u9664\u62a5\u9519\uff0c\u8bf7\u67e5\u8be2\u65e5\u5fd7", (String)"BillGenericService_2", (String)"scm-pur-mservice", (Object[])new Object[0]);
                        success = false;
                    }
                }
                if ("pur_modulelist".equals(entityName) && null != deleteResult) {
                    result.put("ids", deleteResult.getSuccessPkIds());
                }
            }
        }
        log.info("@@@\u8c03\u7528" + entityName + "\u53cd\u5ba1\u6838\u5220\u9664\u63a5\u53e3\u7ed3\u679c-->" + message);
        result.put("success", success);
        result.put("message", message);
        return result;
    }

    public Map<String, Object> upPurOrderCfmstatus(Map<String, Object> map) throws Exception {
        log.info("\u65b0\u91c7\u8d2d\u534f\u540c-\u91c7\u8d2d\u8ba2\u5355\u7684\u786e\u8ba4\u72b6\u6001\u63a5\u53e3\u8c03\u7528\u53c2\u6570\uff1a" + map);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String message = null;
        boolean success = true;
        if (map != null && !map.isEmpty() && map.containsKey("ids") && map.containsKey("status")) {
            log.info("\u66f4\u65b0\u91c7\u8d2d\u534f\u540c-\u91c7\u8d2d\u8ba2\u5355\u7684\u786e\u8ba4\u72b6\u6001\u63a5\u53e3\u53c2\u6570  --> " + map);
            if (ApiConfigUtil.hasCQScmConfig()) {
                List orderPks = (List)map.get("ids");
                DynamicObject[] availableOrderS = PurOrderBillActiveToPurOrderOpUtil.getAvailableOrderS((List)orderPks, (String)"cfmstatus");
                if (availableOrderS != null) {
                    String status = (String)map.get("status");
                    for (DynamicObject bill : availableOrderS) {
                        bill.set("cfmstatus", (Object)status);
                    }
                    Object[] save = SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])availableOrderS);
                    log.info("\u66f4\u65b0\u91c7\u8d2d\u534f\u540c-\u91c7\u8d2d\u8ba2\u5355\u7684\u786e\u8ba4\u72b6\u6001\u6210\u529f\u3002\u6570\u636e\u5982\u4e0b" + Arrays.toString(save));
                    success = true;
                    message = ResManager.loadKDString((String)"\u66f4\u65b0\u91c7\u8d2d\u534f\u540c\u91c7\u8d2d\u8ba2\u5355\u7684\u786e\u8ba4\u72b6\u6001\u6210\u529f", (String)"BillGenericService_21", (String)"scm-pur-mservice", (Object[])new Object[0]);
                } else {
                    log.info("\u65e0\u53ef\u7528\u6570\u636e\u5904\u7406\uff0c\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
                    success = false;
                    message = ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u6570\u636e\u5904\u7406\uff0c\u66f4\u65b0\u72b6\u6001\u5931\u8d25", (String)"BillGenericService_5", (String)"scm-pur-mservice", (Object[])new Object[0]);
                }
            }
        } else {
            log.info("\u53c2\u6570\u4e0d\u5408\u6cd5");
            success = false;
            message = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6240\u4f20\u9012\u7684\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"BillGenericService_0", (String)"scm-pur-mservice", (Object[])new Object[0]);
        }
        resultMap.put("success", success);
        resultMap.put("message", message);
        return resultMap;
    }

    public Map<String, Object> purOrderBillActiveToPurOrderOp(Map<String, Object> map) throws Exception {
        log.info("\u534f\u540c\u8ba2\u5355\u53d8\u66f4\u5355\u751f\u6548\u540e\u66f4\u65b0\u534f\u540c\u8ba2\u5355\u7684\u503c\u63a5\u53e3\u8c03\u7528\u53c2\u6570\uff1a" + map);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String message = null;
        boolean success = false;
        if (ApiConfigUtil.hasCQScmConfig() && null != map) {
            Set<Map.Entry<String, Object>> entries = map.entrySet();
            Iterator<Map.Entry<String, Object>> iterator = entries.iterator();
            DynamicObject changebill = null;
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                Long id = (Long)((Object)entry.getKey());
                DynamicObject bill = (DynamicObject)entry.getValue();
                changebill = QueryServiceHelper.queryOne((String)"pur_ordchange", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", (Object)bill.getPkValue().toString())});
                bill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)bill.getDynamicObjectType().getName());
                ArrayList<Long> pkS = new ArrayList<Long>(1);
                pkS.add(id);
                DynamicObject[] srcBill = PurOrderBillActiveToPurOrderOpUtil.getAvailableOrderS(pkS, null);
                if (srcBill != null) {
                    PurOrderBillActiveToPurOrderOpUtil.updatepurorder((DynamicObject)bill, (DynamicObject)srcBill[0]);
                    PurOrderBillActiveToPurOrderOpUtil.updateOrderLogstatus((DynamicObject)srcBill[0]);
                }
                if (changebill == null) continue;
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("isStrict", String.valueOf(false));
                OperationServiceHelper.executeOperate((String)"active", (String)"pur_ordchange", (Object[])new Object[]{changebill.get("id")}, (OperateOption)option);
            }
            success = true;
            message = ResManager.loadKDString((String)"\u66f4\u65b0\u5b8c\u6210", (String)"BillGenericService_6", (String)"scm-pur-mservice", (Object[])new Object[0]);
        } else {
            success = false;
            message = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6240\u4f20\u9012\u7684\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"BillGenericService_0", (String)"scm-pur-mservice", (Object[])new Object[0]);
        }
        resultMap.put("success", success);
        resultMap.put("message", message);
        return resultMap;
    }

    public Map<String, Object> pushBillToPurPayApply(Map<String, Object> map) throws Exception {
        log.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0b\u63a8\u4ed8\u6b3e\u7533\u8bf7\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u53c2\u6570\uff1a" + map);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        PushArgs pushArgs = new PushArgs();
        Object id = map.get("id");
        List entryids = (List)map.get("entryids");
        String srcEntityKey = "ap_payapply";
        String targetEntityKey = "pur_payapply";
        pushArgs.setSourceEntityNumber(srcEntityKey);
        pushArgs.setTargetEntityNumber(targetEntityKey);
        pushArgs.setRuleId("850607165197528064");
        pushArgs.setBuildConvReport(false);
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(entryids.size());
        for (Object entryid : entryids) {
            ListSelectedRow row = new ListSelectedRow(id);
            row.setEntryEntityKey("entry");
            row.setEntryPrimaryKeyValue(entryid);
            selectedRowList.add(row);
        }
        pushArgs.setSelectedRows(selectedRowList);
        ConvertOperationResult result = null;
        try {
            result = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (result.isSuccess()) {
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetEntityKey);
                List targetData = result.loadTargetDataObjects(new IRefrencedataProvider(){

                    public void fillReferenceData(Object[] objects, IDataEntityType iDataEntityType) {
                        BusinessDataServiceHelper.loadRefence((Object[])objects, (IDataEntityType)iDataEntityType);
                    }
                }, mainType);
                this.handleTargetdata(targetData);
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("isStrict", String.valueOf(false));
                OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)targetEntityKey, (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)option);
                if (!saveResult.isSuccess()) {
                    log.info("@@\u76ee\u6807\u5355\u636e\u4fdd\u5b58\u62a5\u9519\uff1a" + saveResult.getMessage());
                    resultMap.put("message", ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u4fdd\u5b58\u62a5\u9519", (String)"BillGenericService_7", (String)"scm-pur-mservice", (Object[])new Object[0]));
                    resultMap.put("success", Boolean.FALSE);
                    return resultMap;
                }
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)targetEntityKey, (Object[])saveResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option);
                if (!submitResult.isSuccess()) {
                    log.info("@@\u76ee\u6807\u5355\u636e\u63d0\u4ea4\u62a5\u9519\uff1a" + submitResult.getMessage());
                    resultMap.put("message", submitResult.getMessage());
                    resultMap.put("success", Boolean.FALSE);
                    return resultMap;
                }
                OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)targetEntityKey, (Object[])submitResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option);
                if (!auditResult.isSuccess()) {
                    log.info("@@\u76ee\u6807\u5355\u636e\u5ba1\u6838\u62a5\u9519\uff1a" + auditResult.getMessage());
                    resultMap.put("message", auditResult.getMessage());
                    resultMap.put("success", Boolean.FALSE);
                    return resultMap;
                }
                log.info("\u4ed8\u6b3e\u7533\u8bf7\u67e5\u8be2\u4e0b\u63a8\u6210\u529f");
                resultMap.put("message", ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u67e5\u8be2\u4e0b\u63a8\u6210\u529f", (String)"BillGenericService_8", (String)"scm-pur-mservice", (Object[])new Object[0]));
                resultMap.put("success", Boolean.TRUE);
            } else {
                log.info("@@@\u4e0b\u63a8\u53d1\u751f\u4e86\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + result.getMessage());
                resultMap.put("message", result.getMessage());
                resultMap.put("success", Boolean.FALSE);
            }
        }
        catch (Exception e) {
            String message = "";
            if (result != null) {
                message = result.getMessage();
            }
            log.error("\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0b\u63a8\u4ed8\u6b3e\u7533\u8bf7\u67e5\u8be2\u5931\u8d25\u539f\u56e0\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
            throw new KDException(new ErrorCode("push error", ResManager.loadKDString((String)"\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef", (String)"BillGenericService_9", (String)"scm-pur-mservice", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        return resultMap;
    }

    public void handleTargetdata(List<DynamicObject> targetData) {
        if (targetData.size() > 1) {
            DynamicObject bill = targetData.get(0);
            String billno = bill.getString("billno");
            if (billno.isEmpty()) {
                billno = CodeRuleServiceHelper.readNumber((String)"pur_payapply", (DynamicObject)bill, (String)String.valueOf(OrgUnitServiceHelper.getRootOrgId()));
            }
            if (!billno.isEmpty()) {
                int suffixno = 1;
                for (DynamicObject dynamicObject : targetData) {
                    dynamicObject.set("billno", (Object)(billno + "_" + suffixno));
                    ++suffixno;
                }
            }
        }
    }

    public Boolean isEcPlatform(long malOrderId) throws Exception {
        return this.isFromEc(malOrderId);
    }

    public Map<Long, Boolean> getOrderSource(List<Long> malOrderIds) throws Exception {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(8);
        if (null == malOrderIds || malOrderIds.size() <= 0) {
            return result;
        }
        log.info("\u5224\u65ad\u662f\u5426\u6765\u81ea\u7535\u5546\u5e73\u53f0\u7684\u8ba2\u5355\u63a5\u53e3\u8c03\u7528\u53c2\u6570\uff1a" + malOrderIds);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"mal_order", (String)"id,platform", (QFilter[])new QFilter[]{new QFilter("id", "in", malOrderIds)});
        col.forEach(dyo -> result.put(dyo.getLong("id"), ProductSourceEnum.PRODUCTSOURCE_JD.getVal().equals(dyo.getString("platform"))));
        return result;
    }

    public Map<String, Object> updateSouStatus(Map<String, Object> map) throws Exception {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (!map.isEmpty() && map.containsKey("entitykey") && map.containsKey("data")) {
            log.info("\u66f4\u65b0\u8be2\u4ef7\u4e0e\u7ade\u4ef7\uff0c\u62a5\u4ef7\u4e0e\u7ade\u4ef7\u72b6\u6001\u63a5\u53e3\u8c03\u7528\u53c2\u6570\uff1a" + map);
            String entitykey = String.valueOf(map.get("entitykey"));
            Map dataMap = (Map)map.get("data");
            if (!dataMap.isEmpty()) {
                switch (entitykey) {
                    case "sou_compare": {
                        this.updateInquiryStatus(dataMap, resultMap);
                        break;
                    }
                    case "sou_bidbillcfm": {
                        this.updateBidBillBidStatus(dataMap, resultMap);
                        break;
                    }
                    default: {
                        resultMap.put("message", ResManager.loadKDString((String)"%1$s %2$s \u4e0d\u5728\u5904\u7406\u8303\u56f4\u5185\u3002", (String)"BillGenericService_10", (String)"scm-pur-mservice", (Object[])new Object[]{"entitykey\uff1a", entitykey}));
                        resultMap.put("success", Boolean.FALSE);
                        break;
                    }
                }
            } else {
                resultMap.put("message", ResManager.loadKDString((String)"\u65e0\u5408\u6cd5\u6570\u636e\u3002", (String)"BillGenericService_11", (String)"scm-pur-mservice", (Object[])new Object[0]));
                resultMap.put("success", Boolean.FALSE);
            }
        } else {
            resultMap.put("message", ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u7981\u6b62\u4f7f\u7528\u670d\u52a1\u3002", (String)"BillGenericService_12", (String)"scm-pur-mservice", (Object[])new Object[0]));
            resultMap.put("success", Boolean.FALSE);
        }
        return resultMap;
    }

    private boolean updateBidBillBidStatus(Map<Long, Object> dataMap, Map<String, Object> map) {
        log.info("\u66f4\u65b0\u5b9a\u6807\u5355(\u53d1\u5e03\u5355)\u72b6\u6001\u63a5\u53e3\u53c2\u6570:" + map);
        try {
            HashSet<Long> availablePks = new HashSet<Long>();
            DynamicObject[] dynamicObjectArray = null;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"sou_bidbillcfm", (String)"id,entryentity.id entryid", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", dataMap.keySet())}, (String)"id");){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long id = row.getLong("id");
                    Long entryId = row.getLong("entryid");
                    if (!dataMap.containsKey(entryId)) continue;
                    availablePks.add(id);
                }
            }
            catch (Throwable object) {
                dynamicObjectArray = object;
                throw object;
            }
            if (!availablePks.isEmpty()) {
                DynamicObject[] bidBillCfmDyns;
                for (DynamicObject bidBillCfmDyn : bidBillCfmDyns = BusinessDataServiceHelper.load((String)"sou_bidbillcfm", (String)"bidstatus,entryentity.sumorderqty", (QFilter[])new QFilter[]{new QFilter("id", "in", availablePks)})) {
                    StringBuilder status = new StringBuilder();
                    DynamicObjectCollection entryentity = bidBillCfmDyn.getDynamicObjectCollection("entryentity");
                    for (DynamicObject row : entryentity) {
                        Long entryPk = row.getLong("id");
                        Object dataObj = dataMap.get(entryPk);
                        if (dataObj == null) continue;
                        row.set("sumorderqty", (Object)row.getBigDecimal("sumorderqty").add(new BigDecimal(dataObj.toString())));
                        if (row.getBigDecimal("sumorderqty").compareTo(BigDecimal.ZERO) > 0) {
                            if (status.toString().contains("F")) continue;
                            status.append('F');
                            continue;
                        }
                        if (status.toString().contains("E")) continue;
                        status.append('E');
                    }
                    bidBillCfmDyn.set("bidstatus", (Object)status.toString());
                }
                SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])bidBillCfmDyns);
                map.put("success", Boolean.TRUE);
                map.put("message", ResManager.loadKDString((String)"\u66f4\u65b0\u5b9a\u6807\u5355(\u53d1\u5e03\u5355)\u72b6\u6001\u6210\u529f", (String)"BillGenericService_13", (String)"scm-pur-mservice", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            map.put("success", Boolean.FALSE);
            map.put("message", e.getMessage());
            log.error(ExceptionUtil.getStackTrace((Throwable)e));
            return false;
        }
        return true;
    }

    private boolean updateInquiryStatus(Map<Long, Object> dataMap, Map<String, Object> map) {
        log.info("\u66f4\u65b0\u5173\u8054\u8be2\u4ef7\u5355\u9879\u76ee\u72b6\u6001\u63a5\u53e3\u53c2\u6570:" + map);
        try {
            HashSet<String> availableInquiry = new HashSet<String>();
            HashSet<Long> availableEntryPks = new HashSet<Long>();
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"sou_compare", (String)"inquiryno,materialentry.id entryid", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", dataMap.keySet())}, (String)"id");){
                while (dataSet.hasNext()) {
                    DynamicObject[] row = dataSet.next();
                    String inquiryno = row.getString("inquiryno");
                    Long entryId = row.getLong("entryid");
                    if (!dataMap.containsKey(entryId)) continue;
                    availableInquiry.add(inquiryno);
                    availableEntryPks.add(entryId);
                }
            }
            if (!availableInquiry.isEmpty() && !availableEntryPks.isEmpty()) {
                DynamicObject[] inquiryBills;
                DynamicObject[] compareBills = BusinessDataServiceHelper.load((String)"sou_compare", (String)"inquiryno,materialentry.sumorderqty", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", availableEntryPks)});
                HashMap<String, String> billNoMapOfStatus = new HashMap<String, String>((int)((double)compareBills.length / 0.75));
                for (DynamicObject compareBill : compareBills) {
                    String billno = compareBill.getString("inquiryno");
                    StringBuilder status = new StringBuilder();
                    DynamicObjectCollection entryentity = compareBill.getDynamicObjectCollection("materialentry");
                    BigDecimal sumTotalOrderQty = BigDecimal.ZERO;
                    for (DynamicObject row : entryentity) {
                        sumTotalOrderQty = sumTotalOrderQty.add(row.getBigDecimal("sumorderqty"));
                    }
                    for (DynamicObject row : entryentity) {
                        Long entryPk = row.getLong("id");
                        Object dataObj = dataMap.get(entryPk);
                        if (dataObj == null) continue;
                        BigDecimal sumOrderQty = new BigDecimal(dataObj.toString());
                        row.set("sumorderqty", (Object)row.getBigDecimal("sumorderqty").add(sumOrderQty));
                        if (sumTotalOrderQty.add(sumOrderQty).compareTo(BigDecimal.ZERO) > 0) {
                            sumTotalOrderQty = sumTotalOrderQty.add(sumOrderQty);
                            if (status.toString().contains("D")) continue;
                            status.setLength(0);
                            status.append('D');
                            continue;
                        }
                        if (status.toString().contains("C")) continue;
                        status.setLength(0);
                        status.append('C');
                    }
                    billNoMapOfStatus.put(billno, status.toString());
                }
                SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])compareBills);
                for (DynamicObject bill : inquiryBills = BusinessDataServiceHelper.load((String)"sou_inquiry", (String)"billno,bizstatus", (QFilter[])new QFilter[]{new QFilter("billno", "in", availableInquiry)})) {
                    String billno = bill.getString("billno");
                    String billnoStr = (String)billNoMapOfStatus.get(billno);
                    if (billnoStr == null) continue;
                    bill.set("bizstatus", (Object)billnoStr);
                }
                SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])inquiryBills);
                map.put("success", Boolean.TRUE);
                map.put("message", ResManager.loadKDString((String)"\u66f4\u65b0\u5b9a\u6807\u5355(\u53d1\u5e03\u5355)\u72b6\u6001\u6210\u529f", (String)"BillGenericService_13", (String)"scm-pur-mservice", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            map.put("success", Boolean.FALSE);
            map.put("message", e.getMessage());
            log.error(ExceptionUtil.getStackTrace((Throwable)e));
            return false;
        }
        return true;
    }

    public Boolean isFromEc(long malOrderId) {
        log.info("\u5224\u65ad\u662f\u5426\u6765\u81ea\u7535\u5546\u5e73\u53f0\u7684\u8ba2\u5355\u63a5\u53e3\u8c03\u7528\u53c2\u6570\uff1a" + malOrderId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"mal_order", (String)"platform", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)malOrderId)});
        if (dynamicObject == null) {
            return false;
        }
        return !StringUtils.equals((CharSequence)EcPlatformEnum.ECPLATFORM_SELF.getVal(), (CharSequence)dynamicObject.getString("platform"));
    }

    public Boolean updateReturnReqCfmStatus(Map<String, Object> map) throws Exception {
        log.info("\u66f4\u65b0\u552e\u540e\u7533\u8bf7\u5355\u786e\u8ba4\u72b6\u6001\u53c2\u6570" + map);
        if (map == null || map.size() < 1) {
            log.info("\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a");
            return Boolean.FALSE;
        }
        List IDs = (List)map.get("ids");
        if (IDs == null || IDs.size() < 1) {
            log.info("\u552e\u540e\u7533\u8bf7\u5355ids\u4e3a\u7a7a");
            return Boolean.FALSE;
        }
        QFilter[] q = new QFilter[]{new QFilter("id", "in", (Object)IDs)};
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"mal_returnreq", (String)"id,cfmstatus", (QFilter[])q);
        if (loads == null || loads.length < 1) {
            log.info("\u552e\u540e\u7533\u8bf7\u5355\u4e2d\u67e5\u8be2\u4e0d\u5230\u5355\u636e  --> " + IDs);
            return Boolean.TRUE;
        }
        String status = (String)map.get("status");
        ArrayList<DynamicObject> retrunReqDyns = new ArrayList<DynamicObject>(loads.length);
        for (DynamicObject retrunReqDyn : loads) {
            retrunReqDyn.set("cfmstatus", (Object)status);
            retrunReqDyns.add(retrunReqDyn);
        }
        Object[] save = SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])retrunReqDyns.toArray(new DynamicObject[0]));
        log.info("\u66f4\u65b0\u91c7\u8d2d\u9000\u8d27\u7533\u8bf7\u7684\u786e\u8ba4\u72b6\u6001\u7ed3\u679c --> " + Arrays.toString(save));
        return Boolean.TRUE;
    }

    public void updatePurInvoiceEntry(Map<String, Object> map) throws Exception {
        log.info("BillGenericService#updatePurInvoiceEntry#begin");
        if (map != null && !map.isEmpty()) {
            Map imInstockList = (Map)map.get(IM_PURINBILL);
            Map imPurreceiveList = (Map)map.get(IM_PURRECEIVEBILL);
            Map pmPurAcceptBillList = (Map)map.get(PM_PURACCEPTBILL);
            Map imMdcOmcmplinbillBillList = (Map)map.get("im_mdc_omcmplinbill");
            HashSet<Long> purinvoiceSrcEntryIdSet = new HashSet<Long>();
            if (imInstockList != null && !imInstockList.isEmpty()) {
                purinvoiceSrcEntryIdSet.addAll(this.getPurEntryIdSet(purinvoiceSrcEntryIdSet, IM_PURINBILL, imInstockList));
            }
            if (imPurreceiveList != null && !imPurreceiveList.isEmpty()) {
                purinvoiceSrcEntryIdSet.addAll(this.getPurEntryIdSet(purinvoiceSrcEntryIdSet, IM_PURRECEIVEBILL, imPurreceiveList));
            }
            if (pmPurAcceptBillList != null && !pmPurAcceptBillList.isEmpty()) {
                purinvoiceSrcEntryIdSet.addAll(this.getPurEntryIdSet(purinvoiceSrcEntryIdSet, PM_PURACCEPTBILL, pmPurAcceptBillList));
            }
            if (imMdcOmcmplinbillBillList != null && !imMdcOmcmplinbillBillList.isEmpty()) {
                purinvoiceSrcEntryIdSet.addAll(this.getPurEntryIdSet(purinvoiceSrcEntryIdSet, "im_mdc_omcmplinbill", imMdcOmcmplinbillBillList));
            }
            log.info("BillGenericService#updatePurInvoiceEntry#purinvoiceSrcEntryIdSet:" + purinvoiceSrcEntryIdSet);
            if (!purinvoiceSrcEntryIdSet.isEmpty()) {
                HashSet<String> purinvoiceEntryidSet = new HashSet<String>((int)((double)purinvoiceSrcEntryIdSet.size() / 0.75));
                for (Long entryId : purinvoiceSrcEntryIdSet) {
                    purinvoiceEntryidSet.add(entryId.toString());
                }
                try (TXHandle h = TX.requiresNew();){
                    DynamicObject[] invoices;
                    QFilter filter = new QFilter("entryentity1.srcentryid1", "in", purinvoiceEntryidSet);
                    for (DynamicObject bill : invoices = BusinessDataServiceHelper.load((String)"pur_invoice", (String)"id,entryentity1.srcentryid1,entryentity1.isentrypay,entryentity1.entrypaytype,entryentity1.entrypaybillno", (QFilter[])new QFilter[]{filter})) {
                        DynamicObjectCollection entryDyoCol = bill.getDynamicObjectCollection("entryentity1");
                        for (DynamicObject entryRow : entryDyoCol) {
                            String srcentryid1 = entryRow.getString("srcentryid1");
                            if (!purinvoiceEntryidSet.contains(srcentryid1)) continue;
                            entryRow.set("isentrypay", (Object)"2");
                            entryRow.set("entrypaybillno", (Object)"");
                            entryRow.set("entrypaytype", (Object)"");
                        }
                    }
                    SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])invoices);
                }
                catch (Exception e) {
                    log.warn("@@@kd.scm.pur.service.BillGenericService#updatePurInvoiceEntry\u5904\u7406\u5355\u636e\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0" + ExceptionUtil.getStackTrace((Throwable)e));
                }
            }
        } else {
            log.warn("\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff0c\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684(Map<String, Object>");
            throw new KDException(new ErrorCode("", ""), new Object[0]);
        }
    }

    private Set<Long> getPurEntryIdSet(Set<Long> purinvoiceSrcEntryIdSet, String entityname, Map<Long, List<Long>> listMap) {
        ArrayList listEntryIds = new ArrayList(1024);
        for (Map.Entry<Long, List<Long>> entry : listMap.entrySet()) {
            listEntryIds.addAll(entry.getValue());
        }
        List bfRowList = BFTrackerServiceHelper.loadTargetRowIds((String)entityname, (String)IM_PURINBILL_ENTRY, (Long[])listMap.keySet().toArray(new Long[0]), (Long[])listEntryIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
        for (BFRow bfRow : bfRowList) {
            Long entryId = bfRow.getSId().getEntryId();
            if (!listEntryIds.contains(entryId)) continue;
            purinvoiceSrcEntryIdSet.add(bfRow.getId().getEntryId());
        }
        return purinvoiceSrcEntryIdSet;
    }

    @Deprecated
    public void updatePurInvoice(Map<String, Object> map) throws Exception {
        List imInstockList = (List)map.get(IM_PURINBILL);
        List imPurreceiveList = (List)map.get(IM_PURRECEIVEBILL);
        Set<Long> purinvoiceSrcIdSet = new HashSet<Long>();
        purinvoiceSrcIdSet = this.getPurBillidSet(purinvoiceSrcIdSet, IM_PURINBILL, imInstockList, "pur_instock", "pur_return");
        purinvoiceSrcIdSet = this.getPurBillidSet(purinvoiceSrcIdSet, IM_PURRECEIVEBILL, imPurreceiveList, "pur_receipt", "pur_receipt_return");
        HashSet<String> purinvoiceentryidSet = new HashSet<String>((int)((double)purinvoiceSrcIdSet.size() / 0.75));
        for (Long id : purinvoiceSrcIdSet) {
            purinvoiceentryidSet.add(((Object)id).toString());
        }
        try (TXHandle h = TX.requiresNew();){
            if (purinvoiceSrcIdSet.size() > 0) {
                QFilter filter = new QFilter("entryentity1.srcbillid1", "in", purinvoiceentryidSet);
                DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"pur_invoice", (String)"id,entryentity1.srcbillid1,entryentity1.isentrypay,entryentity1.entrypaytype,entryentity1.entrypaybillno", (QFilter[])new QFilter[]{filter});
                if (null != invoices && invoices.length > 0) {
                    for (DynamicObject dyo : invoices) {
                        DynamicObjectCollection entryDyoCol = dyo.getDynamicObjectCollection("entryentity1");
                        entryDyoCol.forEach(entryDyo -> {
                            if (purinvoiceentryidSet.contains(entryDyo.getString("srcbillid1"))) {
                                entryDyo.set("isentrypay", (Object)"2");
                                entryDyo.set("entrypaybillno", (Object)"");
                                entryDyo.set("entrypaytype", (Object)"");
                            }
                        });
                    }
                }
                SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])invoices);
            }
        }
        catch (Exception e) {
            log.error("@@@kd.scm.pur.service.BillGenericService\u5904\u7406\u5355\u636e\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0" + ExceptionUtil.getStackTrace((Throwable)e));
        }
    }

    @Deprecated
    private Set<Long> getPurBillidSet(Set<Long> purinvoiceSrcIdSet, String entityname, List<Long> imList, String billName, String returnBillName) {
        if (imList == null || imList.size() == 0) {
            return purinvoiceSrcIdSet;
        }
        if (imList != null && imList.size() > 0) {
            HashSet returnset;
            Map billmap = BFTrackerServiceHelper.findTargetBills((String)entityname, (Long[])imList.toArray(new Long[0]));
            HashSet set = (HashSet)billmap.get(billName);
            if (set != null) {
                purinvoiceSrcIdSet.addAll(set);
            }
            if ((returnset = (HashSet)billmap.get(returnBillName)) != null) {
                purinvoiceSrcIdSet.addAll(returnset);
            }
        }
        return purinvoiceSrcIdSet;
    }

    public List<Long> getLongList(Object poEntryIdList) {
        ArrayList srcList = null;
        srcList = poEntryIdList instanceof List ? (ArrayList)poEntryIdList : (poEntryIdList instanceof Set ? new ArrayList((Set)poEntryIdList) : new ArrayList(1024));
        ArrayList<Long> list = new ArrayList<Long>(srcList.size());
        for (Object poentryid : srcList) {
            list.add(Long.parseLong(String.valueOf(poentryid)));
        }
        return list;
    }

    public Map<String, Object> updatePurCloseStatus(Map<String, Object> paramMap) throws Exception {
        log.info("\u4f9b\u5e94\u94fe\u5173\u95ed\u4fe1\u606f\u540c\u6b65\u53c2\u6570\uff1a" + paramMap);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        resultMap.put("success", Boolean.FALSE);
        if (null == paramMap || 0 == paramMap.size()) {
            resultMap.put("message", ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"BillGenericService_16", (String)"scm-pur-mservice", (Object[])new Object[0]));
            return resultMap;
        }
        QFilter orderQFilter = new QFilter("materialentry.pobillid", "in", paramMap.keySet());
        DynamicObject[] orders = BusinessDataServiceHelper.load((String)"pur_order", (String)"billstatus, closer, closereason, closedate, materialentry.pobillid, materialentry.poentryid, materialentry.entrystatus, materialentry.rowcloser, materialentry.rowclosereason, materialentry.rowclosedate", (QFilter[])new QFilter[]{orderQFilter});
        if (null == orders || 0 == orders.length) {
            resultMap.put("message", ResManager.loadKDString((String)"\u6839\u636e\u5165\u53c2\u6ca1\u6709\u67e5\u8be2\u5230\u534f\u540c\u8ba2\u5355\u6570\u636e\u3002", (String)"BillGenericService_14", (String)"scm-pur-mservice", (Object[])new Object[0]));
            return resultMap;
        }
        for (DynamicObject order : orders) {
            DynamicObjectCollection tempMaterialentry = order.getDynamicObjectCollection("materialentry");
            if (null == tempMaterialentry || tempMaterialentry.size() == 0) continue;
            String orderId = ((DynamicObject)tempMaterialentry.get(0)).getString("pobillid");
            Object mapObj = paramMap.get(orderId);
            Map imOrder = null;
            if (null == mapObj) continue;
            if (mapObj instanceof Map) {
                imOrder = (Map)mapObj;
            }
            if (null == imOrder || 0 == imOrder.size()) continue;
            Object closeStatusObj = imOrder.get("closeStatus");
            Object alertDateObj = imOrder.get("alertDate");
            Object closerObj = imOrder.get("closer");
            Date alertDate = null;
            Long closerId = 0L;
            if (null != closerObj) {
                closerId = Long.parseLong(closerObj.toString());
            }
            if (null != alertDateObj) {
                alertDate = DateUtil.string2date((String)alertDateObj.toString(), (String)"yyyy-MM-dd HH:mm:ss");
            }
            String closeStatus = "";
            if (null == closeStatusObj) continue;
            closeStatus = closeStatusObj.toString();
            if ("0".equals(closeStatus)) {
                order.set("billstatus", (Object)"D");
                order.set("closer_id", (Object)closerId);
                order.set("closedate", (Object)alertDate);
            } else if ("1".equals(closeStatus)) {
                order.set("billstatus", (Object)"C");
                order.set("closer_id", (Object)0L);
                order.set("closedate", null);
            }
            DynamicObjectCollection materialentry = order.getDynamicObjectCollection("materialentry");
            if (null == materialentry) continue;
            for (DynamicObject entry : materialentry) {
                String poentryid = entry.getString("poentryid");
                Object entryCloseStatusObj = imOrder.get(poentryid);
                if (StringUtils.isBlank(entryCloseStatusObj)) continue;
                String entryCloseStatus = entryCloseStatusObj.toString();
                if ("0".equals(entryCloseStatus)) {
                    entry.set("entrystatus", (Object)"B");
                    entry.set("rowcloser_id", (Object)closerId);
                    entry.set("rowclosedate", (Object)alertDate);
                    continue;
                }
                if (!"1".equals(entryCloseStatus)) continue;
                entry.set("entrystatus", (Object)"A");
                entry.set("rowcloser_id", null);
                entry.set("rowclosedate", null);
            }
        }
        try {
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])orders);
        }
        catch (Exception e) {
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("message", e.getMessage());
            log.error("\u4f9b\u5e94\u94fe\u5173\u95ed\u4fe1\u606f\u540c\u6b65\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
        }
        resultMap.put("success", Boolean.TRUE);
        resultMap.put("message", ResManager.loadKDString((String)"\u4f9b\u5e94\u94fe\u5173\u95ed\u4fe1\u606f\u540c\u6b65\u6210\u529f\u3002", (String)"BillGenericService_15", (String)"scm-pur-mservice", (Object[])new Object[0]));
        return resultMap;
    }

    public Map<String, Object> updatePurWriteOffStatus(Map<String, Object> paramMap) throws Exception {
        log.info("\u4f9b\u5e94\u94fe\u540c\u6b65\u534f\u540c\u51b2\u9500\u4fe1\u606f\u53c2\u6570\uff1a" + paramMap);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        resultMap.put("success", Boolean.FALSE);
        if (null == paramMap || 0 == paramMap.size()) {
            resultMap.put("message", ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"BillGenericService_16", (String)"scm-pur-mservice", (Object[])new Object[0]));
            return resultMap;
        }
        if (!paramMap.containsKey("type") || !paramMap.containsKey("dataMap")) {
            resultMap.put("message", ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u7684\u7ed3\u6784\u4e0d\u7b26\u5408\u63a5\u53e3\u8981\u6c42", (String)"BillGenericService_17", (String)"scm-pur-mservice", (Object[])new Object[0]));
            return resultMap;
        }
        Object typeObj = paramMap.get("type");
        String type = "";
        if (null != typeObj) {
            type = typeObj.toString();
        }
        if (!"0".equals(type) && !"1".equals(type)) {
            resultMap.put("message", ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u4e2d\u7684\u51b2\u9500\u7c7b\u578b\u4e0d\u5728\u534f\u540c\u9650\u5b9a\u7684\u8303\u56f4\u5185", (String)"BillGenericService_18", (String)"scm-pur-mservice", (Object[])new Object[0]));
            return resultMap;
        }
        Map dataMap = (Map)paramMap.get("dataMap");
        if (null == dataMap || dataMap.size() == 0) {
            resultMap.put("message", ResManager.loadKDString((String)"\u4f20\u5165\u7684\u5f85\u5904\u7406\u5355\u636e\u96c6\u5408\u4e3a\u7a7a", (String)"BillGenericService_19", (String)"scm-pur-mservice", (Object[])new Object[0]));
            return resultMap;
        }
        try (TXHandle h = TX.required();){
            HashSet<String> purInOrRevIdSet = new HashSet<String>(1024);
            for (Map.Entry entry : dataMap.entrySet()) {
                Set<String> tempSet = this.updateWriteOffBillByImId((String)entry.getKey(), (Set)entry.getValue(), type);
                if (null == tempSet || tempSet.size() <= 0) continue;
                purInOrRevIdSet.addAll(tempSet);
            }
            if (purInOrRevIdSet.size() > 0) {
                this.updateWriteOffBillByImId("pur_check", purInOrRevIdSet, type);
                this.updateWriteOffBillByImId("pur_invoice", purInOrRevIdSet, type);
            }
        }
        catch (Exception e) {
            log.error("@@@kd.scm.pur.service.BillGenericService\u5904\u7406\u5355\u636e\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0" + ExceptionUtil.getStackTrace((Throwable)e));
        }
        resultMap.put("success", Boolean.TRUE);
        resultMap.put("message", ResManager.loadKDString((String)"\u4f9b\u5e94\u94fe\u540c\u6b65\u534f\u540c\u51b2\u9500\u4fe1\u606f\u6210\u529f", (String)"BillGenericService_20", (String)"scm-pur-mservice", (Object[])new Object[0]));
        return resultMap;
    }

    private Set<String> updateWriteOffBillByImId(String entityKey, Set list, String type) {
        HashSet<String> retSet = new HashSet<String>(1024);
        if (StringUtils.isEmpty((CharSequence)entityKey) || null == list || list.size() == 0 || StringUtils.isEmpty((CharSequence)type)) {
            return retSet;
        }
        String filterNameStr = "materialentry.srcbillid";
        String selectStr = "id,writeoffflag";
        if ("pur_invoice".equals(entityKey)) {
            filterNameStr = "entryentity1.srcbillid1";
            selectStr = "id,entryentity1.srcbillid1,entryentity1.writeoffflag";
        }
        if ("pur_check".equals(entityKey)) {
            selectStr = "id,materialentry.srcbillid,materialentry.writeoffflag";
        }
        HashSet<String> setList = new HashSet<String>(list.size());
        for (Object temp : list) {
            if (null == temp) continue;
            setList.add(String.valueOf(temp));
        }
        QFilter filter = new QFilter(filterNameStr, "in", setList);
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)entityKey, (String)selectStr, (QFilter[])new QFilter[]{filter});
        if (null == bills || 0 == bills.length) {
            return retSet;
        }
        for (DynamicObject tempBill : bills) {
            retSet.add(tempBill.getString("id"));
            if (!"pur_invoice".equals(entityKey) && !"pur_check".equals(entityKey)) {
                tempBill.set("writeoffflag", (Object)type);
                continue;
            }
            String entryKeyStr = "materialentry";
            String srcBillIdStr = "srcbillid";
            if ("pur_invoice".equals(entityKey)) {
                entryKeyStr = "entryentity1";
                srcBillIdStr = "srcbillid1";
            }
            DynamicObjectCollection materialentry = tempBill.getDynamicObjectCollection(entryKeyStr);
            for (DynamicObject entry : materialentry) {
                String srcBillId = entry.getString(srcBillIdStr);
                if (!list.contains(srcBillId)) continue;
                entry.set("writeoffflag", (Object)type);
            }
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])bills);
        if ("pur_moduledelivery".equals(entityKey)) {
            return new HashSet<String>(1);
        }
        DynamicObjectType dynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)entityKey).getDynamicObjectType();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])retSet.toArray(), (DynamicObjectType)dynamicObjectType);
        if (0 != dynamicObjects.length) {
            String writeoffFlag = (String)this.appCache.get(dynamicObjects[0].getString("billno"), String.class);
            switch (type) {
                case "1": {
                    if (!"writeoff".equals(writeoffFlag)) {
                        this.writeBack(entityKey, dynamicObjects, "delete", false, false);
                    }
                    this.appCache.put(dynamicObjects[0].getString("billno"), (Object)"writeoff");
                    break;
                }
                case "0": {
                    if (!"backwriteoff".equals(writeoffFlag) && writeoffFlag != null) {
                        this.writeBack(entityKey, dynamicObjects, "audit", true, true);
                    }
                    this.appCache.put(dynamicObjects[0].getString("billno"), (Object)"backwriteoff");
                    break;
                }
            }
        }
        return retSet;
    }

    private void writeBack(String entityKey, DynamicObject[] dynamicObjects, String receiptStatus, Boolean receiptReturnIsAdd, Boolean returnIsAdd) {
        if ("pur_receipt".equals(entityKey) || "pur_instock".equals(entityKey)) {
            ScmcUtil.writeBackData((DynamicObject[])dynamicObjects, (String)receiptStatus);
        }
        if ("pur_receipt_return".equals(entityKey)) {
            List dyns = Arrays.stream(dynamicObjects).collect(Collectors.toList());
            PurReceiptReturnUtil.writeBackPoSumRecRetQty(dyns, (boolean)receiptReturnIsAdd);
        }
        if ("pur_return".equals(entityKey)) {
            PurReturnUtil.writeBackPoSumReturnQty((DynamicObject[])dynamicObjects, (boolean)returnIsAdd);
        }
    }

    public void clearSaloutEntryAutoRecBillno(Set<String> paramSet) throws Exception {
        if (paramSet != null && !paramSet.isEmpty()) {
            PurReceiptDeleteHelper.cleanAutoReceiveBillNo(paramSet);
        }
    }

    public void clearSaloutEntryAutoAcceptBillNo(Set<String> paramSet) throws Exception {
        if (paramSet != null && !paramSet.isEmpty()) {
            PurReceiptDeleteHelper.cleanAutoAcceptBillNo(paramSet);
        }
    }

    @Deprecated
    public List<DynamicObject> pushAcceptBillByPurSaloutstock(List<DynamicObject> entitys, Map<String, String> paramMap) {
        List bills = PurSalStockPushHelper.pushAcceptBillByPurSaloutstock(entitys, paramMap);
        return bills;
    }

    public Map<String, String> getStockExtPro() throws Exception {
        LinkedHashMap<String, String> extPro = new LinkedHashMap<String, String>(PurBatchStockHelper.assembleBatchExtEntryPro());
        if (log.isInfoEnabled()) {
            log.info("kd.scm.pur.business.PurBatchStockHelper.assembleBatchExtEntryPro" + ((Object)extPro).toString());
        }
        extPro.putAll((Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"scp", (String)"IScpTransferEntryProService", (String)"getStockExtPro", (Object[])new Object[0]));
        if (log.isInfoEnabled()) {
            log.info("kd.scm.scp.business.ScpSalOutStockBillHelper.assembleAutoExtStockBill" + ((Object)extPro).toString());
        }
        return extPro;
    }

    public Map<String, String> getOrderBillExtPro() throws Exception {
        return PurOrderBillHelper.assembleCreateOrderExtEntryPro();
    }

    public Map<String, Object> updatePurModulereceiptDownStreamData(Map<Long, Map<String, Object>> paramMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        if (CollectionUtils.isEmpty(paramMap)) {
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("message", "param error");
            return resultMap;
        }
        String selectProperties = "id,materialentry.id,materialentry.downstreambilltype,materialentry.downstreambillno,materialentry.downstreambillid,materialentry.downstreambillentryid";
        Set<Long> keySet = paramMap.keySet();
        QFilter qf = new QFilter("materialentry.id", "in", keySet);
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"pur_modulereceipt", (String)selectProperties, (QFilter[])new QFilter[]{qf});
        if (loads != null && loads.length > 0) {
            for (DynamicObject dy : loads) {
                DynamicObjectCollection materialentrys = dy.getDynamicObjectCollection("materialentry");
                for (DynamicObject materialentry : materialentrys) {
                    Object entryid;
                    Object billid;
                    Object billno;
                    Long entryId = (Long)materialentry.getPkValue();
                    Map<String, Object> map = paramMap.get(entryId);
                    if (map == null) continue;
                    Object billtype = map.get("billtype");
                    if (billtype != null) {
                        if (billtype instanceof DynamicObject) {
                            DynamicObject billtypeDy = (DynamicObject)billtype;
                            materialentry.set("downstreambilltype", (Object)billtypeDy.getString("number"));
                        } else {
                            materialentry.set("downstreambilltype", billtype);
                        }
                    }
                    if ((billno = map.get("billno")) != null) {
                        materialentry.set("downstreambillno", billno);
                    }
                    if ((billid = map.get("billid")) != null) {
                        materialentry.set("downstreambillid", (Object)String.valueOf(billid));
                    }
                    if ((entryid = map.get("entryid")) == null) continue;
                    materialentry.set("downstreambillentryid", (Object)String.valueOf(entryid));
                }
            }
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])loads);
            resultMap.put("success", Boolean.TRUE);
            resultMap.put("message", "success");
            return resultMap;
        }
        resultMap.put("success", Boolean.FALSE);
        resultMap.put("message", "param error");
        return resultMap;
    }

    public Map<String, Object> updatePurModuleConsumeDownStreamData(Map<Long, Map<String, Object>> paramMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        if (CollectionUtils.isEmpty(paramMap)) {
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("message", "param error");
            return resultMap;
        }
        Set<Long> keySet = paramMap.keySet();
        QFilter qf = new QFilter("materialentry.subentryentity.id", "in", keySet);
        HashSet<Long> ids = new HashSet<Long>(8);
        DynamicObjectCollection queryData = QueryServiceHelper.query((String)"pur_moduleconsume", (String)"id", (QFilter[])new QFilter[]{qf});
        for (DynamicObject dy : queryData) {
            ids.add(dy.getLong("id"));
        }
        DynamicObject poduleConsumeDyn = BusinessDataServiceHelper.newDynamicObject((String)"pur_moduleconsume");
        DynamicObject[] loads = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)poduleConsumeDyn.getDynamicObjectType());
        if (loads != null && loads.length > 0) {
            for (DynamicObject dy : loads) {
                DynamicObjectCollection materialentrys = dy.getDynamicObjectCollection("materialentry");
                for (DynamicObject materialentry : materialentrys) {
                    DynamicObjectCollection subentryentitys = materialentry.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject subentryentity : subentryentitys) {
                        Object entryid;
                        Object billid;
                        Object billno;
                        Long entryId = (Long)subentryentity.getPkValue();
                        Map<String, Object> map = paramMap.get(entryId);
                        if (map == null) continue;
                        Object billtype = map.get("billtype");
                        if (billtype != null) {
                            if (billtype instanceof DynamicObject) {
                                DynamicObject billtypeDy = (DynamicObject)billtype;
                                subentryentity.set("downstreambilltype", (Object)billtypeDy.getString("number"));
                            } else {
                                subentryentity.set("downstreambilltype", billtype);
                            }
                        }
                        if ((billno = map.get("billno")) != null) {
                            subentryentity.set("downstreambillno", billno);
                        }
                        if ((billid = map.get("billid")) != null) {
                            subentryentity.set("downstreambillid", (Object)String.valueOf(billid));
                        }
                        if ((entryid = map.get("entryid")) == null) continue;
                        subentryentity.set("downstreambillentryid", (Object)String.valueOf(entryid));
                    }
                }
            }
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])loads);
            resultMap.put("success", Boolean.TRUE);
            resultMap.put("message", "success");
            return resultMap;
        }
        resultMap.put("success", Boolean.FALSE);
        resultMap.put("message", "param error");
        return resultMap;
    }
}

