/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.pur.common.PurInvoiceUtil;
import kd.scm.pur.common.ecinvoice.EcInvoiceFactory;
import kd.scm.pur.common.ecinvoice.service.impl.GenericEcInvoiceService;
import kd.scm.pur.service.IPurInvoiceService;
import kd.scm.pur.service.entity.PurInvoiceRelateErpublicReimburse;

public class PurInvoiceService
implements IPurInvoiceService {
    private static final Log log = LogFactory.getLog((String)PurInvoiceService.class.getName());

    public ConvertOperationResult generatePublicReimburseBill(List<Long> purInvoiceIds) {
        log.info("@@purInvoiceIds:" + purInvoiceIds);
        String invSelectFields = "billno,supplier.id,entryentity1.srcbillid1,entryentity1.inbillno1,entryentity1.entrypaybillno,entryentity1.srcentryid1";
        HashSet supplierIdSet = new HashSet(purInvoiceIds.size());
        HashSet<String> purReceiptIds = new HashSet<String>(purInvoiceIds.size());
        HashSet<Long> purReceiptEntryIds = new HashSet<Long>(purInvoiceIds.size());
        try (DataSet purInvDs = QueryServiceHelper.queryDataSet((String)PurInvoiceUtil.class.getName(), (String)"pur_invoice", (String)invSelectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", purInvoiceIds)}, null);){
            purInvDs.forEach(row -> {
                purReceiptIds.add(row.getString("entryentity1.srcbillid1"));
                purReceiptEntryIds.add(row.getLong("entryentity1.srcentryid1"));
                supplierIdSet.add(row.getLong("supplier.id"));
            });
        }
        if (supplierIdSet.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u4e2a\u4f9b\u5e94\u5546\u7684\u53d1\u7968\u7b7e\u6536\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PurInvoiceService_3", (String)"scm-pur-mservice", (Object[])new Object[0]));
        }
        return this.doPush(purReceiptIds, purReceiptEntryIds);
    }

    private ConvertOperationResult doPush(Set<String> idSet, Set<Long> purReceiptEntryIds) {
        Set ids = idSet.stream().map(Long::parseLong).collect(Collectors.toSet());
        ArrayList listSelectedRows = new ArrayList(idSet.size());
        String receiptSelectFields = "id,materialentry.id";
        try (DataSet purReceiptDs = QueryServiceHelper.queryDataSet((String)PurInvoiceUtil.class.getName(), (String)"pur_receipt", (String)receiptSelectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", ids).and(new QFilter("materialentry.id", "in", purReceiptEntryIds))}, null);){
            purReceiptDs.forEach(row -> {
                ListSelectedRow listSelectedRow = new ListSelectedRow(row.get("id"));
                listSelectedRow.setEntryEntityKey("materialentry");
                listSelectedRow.setEntryPrimaryKeyValue(row.get("materialentry.id"));
                listSelectedRows.add(listSelectedRow);
            });
        }
        if (listSelectedRows.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e94\u4ed8\u53d1\u7968\u4ef7\u7a0e\u5408\u8ba1\u4e3a\u8d1f\uff0c\u4e0d\u5141\u8bb8\u4e0b\u63a8\u5bf9\u516c\u62a5\u9500\u5355\u3002", (String)"PurInvoiceService_2", (String)"scm-pur-mservice", (Object[])new Object[0]));
        }
        PushArgs pushArgs = new PushArgs("pur_receipt", "er_publicreimbursebill", listSelectedRows);
        ConvertOperationResult convertOperationResult = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
        if (!convertOperationResult.getTargetBillIds().isEmpty()) {
            DynamicObject[] dynamicObjects;
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((Object[])convertOperationResult.getTargetBillIds().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"er_publicreimbursebill"))) {
                new PurInvoiceRelateErpublicReimburse(dynamicObject).related().handleAfterPush();
            }
            return convertOperationResult;
        }
        throw new KDBizException((convertOperationResult.getMessage() == null ? "" : convertOperationResult.getMessage()) + " " + convertOperationResult.getBillReports().toString());
    }

    public void writeBackPurInvAfterDelErPublicReimburse(String erBillno) {
        log.info("@@writeBackPurInvAfterDelErPublicReimburse.erBillno:" + erBillno);
        ArrayList<String> erBillnos = new ArrayList<String>();
        erBillnos.add(erBillno);
        new PurInvoiceRelateErpublicReimburse().writeBackPurInvAfterDelErPublicReimburse(erBillnos);
    }

    public void updateEcInvoice(Map<String, Object> markIdMap) {
        log.info("@@updateEcInvoice.markIdMap:" + markIdMap);
        if (markIdMap.isEmpty()) {
            return;
        }
        HashMap<String, Object> failInvoiceMap = new HashMap<String, Object>(markIdMap.size() << 2);
        String source = "";
        HashSet<String> markIdSet = new HashSet<String>(markIdMap.size() << 2);
        for (Map.Entry<String, Object> entry : markIdMap.entrySet()) {
            Map valueMap = (Map)entry.getValue();
            source = (String)valueMap.get("source");
            if ((EcPlatformEnum.ECPLATFORM_CG.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_SUNING.getVal().equals(source)) && "2".equals(valueMap.get("status"))) {
                failInvoiceMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            markIdSet.add(entry.getKey());
        }
        this.updateInvoiceAfterFail(failInvoiceMap, source);
        EcInvoiceFactory.getEcInvoiceServiceBySource((String)source).updatePurInvoiceAndEcOrder(this.queryEcChildOrderSet(markIdSet, source));
    }

    private Set<String> queryEcChildOrderSet(Set<String> markIdSet, String source) {
        HashSet<String> res = new HashSet<String>(markIdSet.size() << 2);
        DynamicObjectCollection ecOrderCol = EcPlatformEnum.ECPLATFORM_JD.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(source) ? QueryServiceHelper.query((String)MalNewOrderUtils.getPlatformId((String)source), (String)"number orderid", (QFilter[])new QFilter[]{new QFilter("markid", "in", markIdSet)}) : QueryServiceHelper.query((String)MalNewOrderUtils.getPlatformId((String)source), (String)"orderid", (QFilter[])new QFilter[]{new QFilter("markid", "in", markIdSet)});
        ecOrderCol.forEach(ecOrder -> res.add(ecOrder.getString("orderid")));
        return res;
    }

    private void updateInvoiceAfterFail(Map<String, Object> failInvoiceMap, String source) {
        DynamicObject[] ecOrders = this.loadCgOrderByMarkId(failInvoiceMap.keySet(), source);
        HashSet<Long> ecOrderPkSet = new HashSet<Long>();
        for (DynamicObject ecOrder : ecOrders) {
            String markId = ecOrder.getString("markid");
            if (!StringUtils.isNotEmpty((CharSequence)markId)) continue;
            ecOrderPkSet.add(ecOrder.getLong("id"));
            Map valueMap = (Map)failInvoiceMap.get(markId);
            ecOrder.set("markid", (Object)"");
            ecOrder.set("invoiceresult", valueMap.get("msg"));
            ecOrder.set("invoicestate", (Object)PurEcInvoiceEnum.INVOICEFAILED.getVal());
        }
        if (ecOrders.length > 0) {
            log.info("@@updateInvoiceAfterFail.save:" + ecOrders.length);
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])ecOrders);
        }
        this.deletePurInvoiceByEcOrderIds(ecOrderPkSet);
    }

    private void deletePurInvoiceByEcOrderIds(Set<Long> ecOrderPkSet) {
        log.info("deletePurInvoiceByEcOrderIds.ecOrderPkSet:" + ecOrderPkSet);
        GenericEcInvoiceService genericEcInvoiceService = new GenericEcInvoiceService();
        DynamicObjectCollection malOrderCol = new GenericEcInvoiceService().queryMalOrder(new ArrayList<Long>(ecOrderPkSet));
        DynamicObjectCollection purOrderEntityCol = genericEcInvoiceService.queryPurOrder(malOrderCol);
        HashSet<String> poEntryIdSet = new HashSet<String>();
        for (DynamicObject dyo : purOrderEntityCol) {
            poEntryIdSet.add(dyo.getString("materialentry.poentryid"));
        }
        DynamicObjectCollection purInvoiceCol = QueryServiceHelper.query((String)"pur_invoice", (String)"id", (QFilter[])new QFilter[]{new QFilter("entryentity1.poentryid1", "in", poEntryIdSet)});
        HashSet<Long> purInvoiceIdSet = new HashSet<Long>();
        for (DynamicObject purInvoiceDyn : purInvoiceCol) {
            purInvoiceIdSet.add(purInvoiceDyn.getLong("id"));
        }
        log.info("@@purInvoiceIdSet:" + purInvoiceIdSet);
        if (purInvoiceIdSet.isEmpty()) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("WF", String.valueOf(false));
        OperationServiceHelper.executeOperate((String)"delete", (String)"pur_invoice", (Object[])purInvoiceIdSet.toArray(), (OperateOption)option);
    }

    private DynamicObject[] loadCgOrderByMarkId(Set<String> markIdSet, String source) {
        return BusinessDataServiceHelper.load((String)MalNewOrderUtils.getPlatformId((String)source), (String)"id,markid,invoiceresult,invoicestate", (QFilter[])new QFilter[]{new QFilter("markid", "in", markIdSet)});
    }
}

