/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.helper.multisystemjoint.MultiDataHandleResult;
import kd.scm.common.helper.multisystemjoint.ScMultiDataHandleServiceHelper;
import kd.scm.common.helper.multisystemjoint.ScMultiJointSceneVerifyHelper;
import kd.scm.common.helper.multisystemjoint.business.MultiDataChannelHelper;
import kd.scm.common.helper.multisystemjoint.business.MultiDataExecuteSchemeConfigHelper;
import kd.scm.pur.service.IPurMultiDataHandleService;

public final class PurMultiDataHandleService
implements IPurMultiDataHandleService {
    private static final Log log = LogFactory.getLog(PurMultiDataHandleService.class);

    public Map<Long, Long> executeValidService(String executeSceneId, Set<String> verifySceneIds, Map<Long, String> billJointDataMap, Map<String, String> customParam) {
        if (log.isInfoEnabled()) {
            log.info("PurMultiDataHandleService#executeService,executeSceneId:{},verifySceneIds:{},billJointDataMap:{},customParam:{}", new Object[]{executeSceneId, verifySceneIds, SerializationUtils.toJsonString(billJointDataMap), SerializationUtils.toJsonString(customParam)});
        }
        return ScMultiJointSceneVerifyHelper.executeSceneVerify((String)executeSceneId, verifySceneIds, billJointDataMap, customParam);
    }

    public Boolean verifyOperationService(String entityNumber, String operateKey, String executeInterface) throws RuntimeException {
        if (log.isInfoEnabled()) {
            log.info("PurMultiDataHandleService#executeService,entityNumber:{},operateKey:{},executeInterface:{}", new Object[]{entityNumber, operateKey, executeInterface});
        }
        return MultiDataExecuteSchemeConfigHelper.verifyExecuteScheme((String)entityNumber, (String)operateKey, (String)executeInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeService(String entityNumber, String operateKey, String executeInterface, Map<Long, String> billJointDataMap, Map<String, String> customParam) {
        if (log.isInfoEnabled()) {
            log.info("PurMultiDataHandleService#executeService,entityNumber:{},operateKey:{},executeInterface:{},pkIds:{},customParam:{}", new Object[]{entityNumber, operateKey, executeInterface, billJointDataMap, SerializationUtils.toJsonString(customParam)});
        }
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>(50);
        try {
            MultiDataHandleResult multiDataHandleResult = ScMultiDataHandleServiceHelper.executeOperationHandle((String)entityNumber, (String)operateKey, (String)executeInterface, billJointDataMap, customParam);
            resultMap.put("message", multiDataHandleResult.getMessage());
            resultMap.put("exception", multiDataHandleResult.getExceptionMessage());
        }
        catch (RuntimeException runtimeException) {
            resultMap.put("exception", String.valueOf(runtimeException.getMessage()));
        }
        finally {
            log.info("execute PurMultiDataHandleService#executeService end");
        }
        return SerializationUtils.toJsonString(resultMap);
    }

    public String getCosmicJointDataChannelId() throws RuntimeException {
        return MultiDataChannelHelper.getCosmicJointDataChannelId();
    }

    public String getMultiJointDataChannelId(Long iscDataSourceId) {
        return MultiDataChannelHelper.getChannelDataId((Long)iscDataSourceId);
    }

    public String getMultiJointDataChannelId(Long iscDataSourceId, Long iscLinkId) {
        return MultiDataChannelHelper.getChannelDataId((Long)iscDataSourceId, (Long)iscLinkId);
    }
}

