/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.invoke.CommonDtxResponse;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.pur.common.consts.APVerifyEntryVo;
import kd.scm.pur.common.util.StoreVerifyServiceDataLocalUtil;
import kd.scm.pur.common.util.StoreVerifyServiceDataUtil;
import kd.scm.pur.common.util.StoreVerifyServiceXkDataUtil;
import kd.scm.pur.service.IVerifyService;

public class VerifyService
extends BaseECService
implements IVerifyService {
    private static final Log log = LogFactory.getLog(VerifyService.class);

    protected DtxResponse doExecute(Object param, Object lastReturn) throws Exception {
        log.info("VerifyService#doExecute");
        CommonDtxResponse result = new CommonDtxResponse();
        if (param instanceof CommonParam) {
            Map mapAll = ((CommonParam)param).getAll();
            Object disposelist = mapAll.get("disposelist");
            Object isverify = mapAll.get("isverify");
            if (isverify instanceof Boolean) {
                if (((Boolean)isverify).booleanValue()) {
                    this.apVerify((List)disposelist);
                } else {
                    this.apUnVerify((List)disposelist);
                }
                result.put((Object)"success", (Object)true);
                result.put((Object)"message", (Object)"ok");
            }
        } else {
            String errorMessage = ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u5f02\u5e38", (String)"VerifyService_0", (String)"scm-pur-mservice", (Object[])new Object[0]);
            log.warn("VerifyService#apVerify" + errorMessage + "\u53c2\u6570\u5fc5\u987b\u662f\u4e00\u4e2akd.bos.kdtx.common.CommonParam");
            throw new KDException(new ErrorCode("VERIFYSERVICE_CODE_002", errorMessage), new Object[0]);
        }
        return result;
    }

    public void apVerify(List<Map<String, Object>> disposeList) throws KDException {
        log.info("VerifyService#apVerify");
        if (disposeList != null && !disposeList.isEmpty()) {
            Map<String, Object> dataChannelMap = disposeList.get(disposeList.size() - 1);
            Object dataChannel = dataChannelMap.get("dataChannel");
            if (dataChannel != null) {
                this.handleVerifyData(disposeList, dataChannel.toString(), true);
            } else {
                this.handleVerifyData(disposeList, "cosmic", true);
            }
        } else {
            String errorMessage = ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u5f02\u5e38", (String)"VerifyService_0", (String)"scm-pur-mservice", (Object[])new Object[0]);
            log.warn("VerifyService#apVerify" + errorMessage + "\u4f20\u5165\u7684\u6570\u636e\u5305\u4e3a\u7a7a\u6216\u8005\u96c6\u5408\u5143\u7d20\u4e3a\u7a7a");
            throw new KDException(new ErrorCode("VERIFYSERVICE_CODE_002", errorMessage), new Object[0]);
        }
    }

    public void execVerifyData(String disposeList, Boolean isVerify) throws KDException {
        log.info("VerifyService#apVerify");
        if (disposeList != null && !disposeList.isEmpty()) {
            try {
                List mapList = (List)SerializationUtils.fromJsonString((String)disposeList, List.class);
                this.handleVerifyData(mapList, "XkCloud", isVerify);
            }
            catch (Exception e) {
                String errorMessage = MessageFormat.format(ResManager.loadKDString((String)"\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570{0}\u3002", (String)"VerifyService_1", (String)"scm-pur-mservice", (Object[])new Object[0]), e.getMessage());
                log.warn("VerifyService#apVerify" + errorMessage + "\u4f20\u5165\u7684\u6570\u636e\u5305\u4e3a\u7a7a\u6216\u8005\u96c6\u5408\u5143\u7d20\u4e3a\u7a7a");
                throw new KDException(new ErrorCode("VERIFYSERVICE_CODE_002", errorMessage), new Object[0]);
            }
        } else {
            String errorMessage = ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u5f02\u5e38", (String)"VerifyService_0", (String)"scm-pur-mservice", (Object[])new Object[0]);
            log.warn("VerifyService#apVerify" + errorMessage + "\u4f20\u5165\u7684\u6570\u636e\u5305\u4e3a\u7a7a\u6216\u8005\u96c6\u5408\u5143\u7d20\u4e3a\u7a7a");
            throw new KDException(new ErrorCode("VERIFYSERVICE_CODE_002", errorMessage), new Object[0]);
        }
    }

    public void apUnVerify(List<Map<String, Object>> disposeList) throws KDException {
        log.info("VerifyService#apUnVerify");
        if (disposeList != null && !disposeList.isEmpty()) {
            Map<String, Object> dataChannelMap = disposeList.get(disposeList.size() - 1);
            Object dataChannel = dataChannelMap.get("dataChannel");
            if (dataChannel != null) {
                this.handleVerifyData(disposeList, dataChannel.toString(), false);
            } else {
                this.handleVerifyData(disposeList, "cosmic", false);
            }
        } else {
            String errorMessage = ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u5f02\u5e38", (String)"VerifyService_0", (String)"scm-pur-mservice", (Object[])new Object[0]);
            log.info("VerifyService#apUnVerify" + errorMessage + "\u4f20\u5165\u7684\u6570\u636e\u5305\u4e3a\u7a7a\u6216\u8005\u96c6\u5408\u5143\u7d20\u4e3a\u7a7a");
            throw new KDException(new ErrorCode("VERIFYSERVICE_CODE_002", errorMessage), new Object[0]);
        }
    }

    private void handleVerifyData(List<Map<String, Object>> disposeList, String dataChannel, boolean isAdd) {
        if (log.isInfoEnabled()) {
            log.info("handleVerifyData#disposeList{}", (Object)SerializationUtils.toJsonString(disposeList));
        }
        HashMap<Long, APVerifyEntryVo> verifyEntryModelMap = new HashMap<Long, APVerifyEntryVo>(disposeList.size());
        String verifyRelationParam = "purself";
        HashSet<Long> bills = new HashSet<Long>(disposeList.size());
        for (Map<String, Object> map : disposeList) {
            Object verifyrelation = map.get("verifyrelation");
            if (verifyrelation == null || !StoreVerifyServiceDataLocalUtil.checkVerifyRelation((String)((String)verifyrelation)).booleanValue()) continue;
            Long entrypk = Long.valueOf(map.get("entrypk").toString());
            APVerifyEntryVo apVerifyEntryVo = (APVerifyEntryVo)verifyEntryModelMap.get(entrypk);
            Object verifyqty = map.get("verifyqty");
            Object verifybaseqty = map.get("verifybaseqty");
            if (apVerifyEntryVo != null) {
                if (verifyqty != null) {
                    apVerifyEntryVo.setVerifyQty(apVerifyEntryVo.getVerifyQty().add(new BigDecimal(verifyqty.toString())));
                }
                if (verifybaseqty != null) {
                    apVerifyEntryVo.setVerifyBaseQty(apVerifyEntryVo.getVerifyBaseQty().add(new BigDecimal(verifybaseqty.toString())));
                }
            } else {
                apVerifyEntryVo = new APVerifyEntryVo();
                apVerifyEntryVo.setEntity((String)map.get("entity"));
                apVerifyEntryVo.setEntityId(Long.valueOf(map.get("pk").toString()));
                apVerifyEntryVo.setEntryPk(Long.valueOf(map.get("entrypk").toString()));
                apVerifyEntryVo.setVerifyRelation((String)verifyrelation);
                Object iswrittenoffverify = map.get("iswrittenoffverify");
                if (iswrittenoffverify != null) {
                    apVerifyEntryVo.setIswrittenoffverify(((Boolean)iswrittenoffverify).booleanValue());
                }
                if (verifyqty != null) {
                    apVerifyEntryVo.setVerifyQty(new BigDecimal(verifyqty.toString()));
                }
                if (verifybaseqty != null) {
                    apVerifyEntryVo.setVerifyBaseQty(new BigDecimal(verifybaseqty.toString()));
                }
                verifyEntryModelMap.put(apVerifyEntryVo.getEntryPk(), apVerifyEntryVo);
            }
            bills.add(apVerifyEntryVo.getEntityId());
            verifyRelationParam = apVerifyEntryVo.getVerifyRelation();
        }
        log.info("VerifyService#handleVerifyData#verifyEntryModelMap" + verifyEntryModelMap);
        if ("cosmic".equals(dataChannel)) {
            log.info("VerifyService#handleVerifyData#bills:after" + bills);
            log.info("VerifyService#handleVerifyData#verifyEntryModelMap:after" + verifyEntryModelMap);
            StoreVerifyServiceDataUtil.storeVerifyDataFactory((String)verifyRelationParam, bills, verifyEntryModelMap, (Boolean)isAdd);
        } else if ("XkCloud".equals(dataChannel)) {
            HashMap verifyrelationMap = new HashMap(disposeList.size());
            for (Map.Entry entry : verifyEntryModelMap.entrySet()) {
                HashMap verifyEntryXkModelMap = (HashMap)verifyrelationMap.get(((APVerifyEntryVo)entry.getValue()).getVerifyRelation());
                if (verifyEntryXkModelMap != null) {
                    verifyEntryXkModelMap.putIfAbsent(String.valueOf(entry.getKey()), entry.getValue());
                } else {
                    verifyEntryXkModelMap = new HashMap(disposeList.size());
                    verifyEntryXkModelMap.putIfAbsent(String.valueOf(entry.getKey()), entry.getValue());
                }
                verifyrelationMap.putIfAbsent(((APVerifyEntryVo)entry.getValue()).getVerifyRelation(), verifyEntryXkModelMap);
            }
            for (Map.Entry entry : verifyrelationMap.entrySet()) {
                StoreVerifyServiceXkDataUtil.storeVerifyDataFactory((String)((String)entry.getKey()), bills, (Map)((Map)entry.getValue()), (Boolean)isAdd);
            }
        } else if ("ierp".equals(dataChannel)) {
            log.info("VerifyService#handleVerifyData#bills:after" + bills);
            log.info("VerifyService#handleVerifyData#verifyEntryModelMap:after" + verifyEntryModelMap);
            StoreVerifyServiceDataLocalUtil.storeVerifyDataFactory((String)verifyRelationParam, bills, verifyEntryModelMap, (Boolean)isAdd);
        }
    }
}

