/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service.autopush;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pur.service.IPurAcceptApplyToPuracceptbillService;

public final class PurAcceptApplyToPuracceptbillService
implements IPurAcceptApplyToPuracceptbillService {
    private static final String PM_PURACCEPTBILL = "pm_puracceptbill";
    private static final String PM_PURORDER_ENTRY = "billentry";
    private static final Log log = LogFactory.getLog((String)PurAcceptApplyToPuracceptbillService.class.getName());

    public Map<String, Object> acceptApplyToPuracceptbill(Map<String, Object> paramMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        String sourceEntity = paramMap.get("sourceEntity").toString();
        String targetEntity = paramMap.get("targetEntity").toString();
        Map pushOrderData = (Map)paramMap.get("pushOrderData");
        Set salOutEntryIds = (Set)paramMap.get("salOutEntryIds");
        Map salOutInfoMap = (Map)paramMap.get("salOutInfoMap");
        LinkedHashMap rowSalOutInfoMap = (LinkedHashMap)paramMap.get("rowSalOutInfoMap");
        ConvertRuleElement convertRuleElementParam = new ConvertRuleElement();
        convertRuleElementParam.setSourceEntityNumber(sourceEntity);
        convertRuleElementParam.setTargetEntityNumber(targetEntity);
        List ruleList = ConvertMetaServiceHelper.loadRules((String)sourceEntity, (String)targetEntity);
        if (ruleList != null && !ruleList.isEmpty()) {
            if (rowSalOutInfoMap != null && !rowSalOutInfoMap.isEmpty()) {
                resultMap.putAll(PurAcceptApplyToPuracceptbillService.pushPurAcceptBill(convertRuleElementParam, (Map<Long, Collection<Long>>)pushOrderData, rowSalOutInfoMap));
                this.saveAutoRecBillNo(resultMap, targetEntity, salOutEntryIds);
            }
            if (salOutInfoMap != null && !salOutInfoMap.isEmpty()) {
                resultMap.putAll(PurAcceptApplyToPuracceptbillService.pushPurAcceptBill(convertRuleElementParam, (Map<Long, Collection<Long>>)pushOrderData, salOutInfoMap));
                this.saveAutoRecBillNo(resultMap, targetEntity, salOutEntryIds);
            }
        } else {
            String errorMessage = ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\uff0c\u81ea\u52a8\u9a8c\u6536\u5931\u8d25\u3002", (String)"PurAcceptApplyToPuracceptbillService_0", (String)"scm-pur-mservice", (Object[])new Object[0]);
            throw new KDException(new ErrorCode("SRMERRORCODE005", errorMessage), new Object[]{errorMessage});
        }
        return resultMap;
    }

    private void saveAutoRecBillNo(Map<String, Object> resultMap, String targetEntity, Set<String> salOutEntryIds) {
        HashMap<String, String> autoNoOfMap = new HashMap<String, String>(16);
        Set<Long> convertIds = this.convertIds(salOutEntryIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"acceptApplyToPuracceptbill", (String)targetEntity, (String)"billno,billentry.soubillentryid soubillentryid", (QFilter[])new QFilter[]{new QFilter("billentry.soubillentryid", "in", convertIds)}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row2 = dataSet.next();
                autoNoOfMap.put(row2.getString("soubillentryid"), row2.getString("billno"));
            }
        }
        if (!autoNoOfMap.isEmpty()) {
            resultMap.put("message", ((Object)autoNoOfMap).toString());
        }
        HashSet salOutLongEntryIds = new HashSet(16);
        salOutEntryIds.forEach(row -> salOutLongEntryIds.add(Long.valueOf(row)));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"pur_saloutstock", (String)"id,billno,materialentry.autorecbillno", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", salOutLongEntryIds)});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject bill : dynamicObjects) {
                DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
                for (DynamicObject row3 : rows) {
                    String entryId = row3.getString("id");
                    String autoBillNo = (String)autoNoOfMap.get(entryId);
                    if (autoBillNo == null || autoBillNo.isEmpty()) continue;
                    row3.set("autorecbillno", (Object)autoBillNo);
                }
            }
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])dynamicObjects);
    }

    private Set<Long> convertIds(Set<String> salOutEntryIds) {
        if (CollectionUtils.isEmpty(salOutEntryIds)) {
            return new HashSet<Long>(8);
        }
        HashSet<Long> salOutEntryIdLongIds = new HashSet<Long>(salOutEntryIds.size());
        for (String entryIdStrs : salOutEntryIds) {
            salOutEntryIdLongIds.add(Long.valueOf(entryIdStrs));
        }
        return salOutEntryIdLongIds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, Object> acceptApplyDelPuracceptbill(Map<String, Object> paramMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        Set imReceiveBillIds = (Set)paramMap.get("imReceiveBillIds");
        Set numberSet = (Set)paramMap.get("imReceiveBillNo");
        if (!imReceiveBillIds.isEmpty()) {
            OperationResult operationResult = null;
            try {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
                operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)PM_PURACCEPTBILL, (Object[])imReceiveBillIds.toArray(), (OperateOption)operateOption);
                if (operationResult == null) return resultMap;
                if (!operationResult.isSuccess() || operationResult.getSuccessPkIds().size() <= 0) {
                    resultMap.put("succed", Boolean.FALSE);
                    StringBuilder messageError = new StringBuilder();
                    String message = operationResult.getMessage();
                    if (StringUtils.isNotBlank((CharSequence)message) && !"null".equalsIgnoreCase(message)) {
                        messageError.append(message).append(System.lineSeparator());
                    }
                    operationResult.getAllErrorOrValidateInfo().forEach(row -> messageError.append(row.getMessage()).append(System.lineSeparator()));
                    resultMap.put("message", messageError.toString());
                    throw new KDException(new ErrorCode("SRMERRORCODE002", messageError.toString()), new Object[]{messageError.toString()});
                }
                if (numberSet.isEmpty()) return resultMap;
                DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"clearSaloutEntryAutoAcceptBillNo", (Object[])new Object[]{numberSet});
                return resultMap;
            }
            catch (Throwable throwable) {
                log.error(throwable);
                resultMap.put("succed", Boolean.FALSE);
                resultMap.put("message", ExceptionUtil.getStackTrace((Throwable)throwable));
                String errorMessage = throwable.getMessage() != null ? throwable.getMessage() : ResManager.loadKDString((String)"\u53d1\u751f\u4e86\u610f\u6599\u4e4b\u5916\u7684\u5f02\u5e38\u3002", (String)"PurAcceptApplyToPuracceptbillService_1", (String)"scm-pur-mservice", (Object[])new Object[0]);
                throw new KDException(new ErrorCode("SRMERRORCODE003", errorMessage), new Object[]{errorMessage});
            }
        } else {
            if (numberSet.isEmpty()) return resultMap;
            DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"clearSaloutEntryAutoAcceptBillNo", (Object[])new Object[]{numberSet});
        }
        return resultMap;
    }

    public static Map<String, Object> pushPurAcceptBill(ConvertRuleElement element, Map<Long, Collection<Long>> pushOrderData, Map<String, String> salOutInfoMap) {
        String srcEntity = element.getSourceEntityNumber();
        String tarEntity = element.getTargetEntityNumber();
        PushArgs pushArgs = new PushArgs();
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        pushArgs.setSourceEntityNumber(srcEntity);
        pushArgs.setTargetEntityNumber(tarEntity);
        pushArgs.setBuildConvReport(true);
        for (Map.Entry<Long, Collection<Long>> entry : pushOrderData.entrySet()) {
            Long entryKey = entry.getKey();
            for (Long next : entry.getValue()) {
                ListSelectedRow listSelectedRow = new ListSelectedRow();
                listSelectedRow.setPrimaryKeyValue((Object)entryKey);
                listSelectedRow.setEntryEntityKey(PM_PURORDER_ENTRY);
                listSelectedRow.setEntryPrimaryKeyValue((Object)next);
                selectedRowList.add(listSelectedRow);
            }
        }
        pushArgs.setSelectedRows(selectedRowList);
        pushArgs.addCustomParam("splitstrategy", "splitbill");
        pushArgs.addCustomParam("ispur", "true");
        for (Map.Entry<Object, Object> entry : salOutInfoMap.entrySet()) {
            pushArgs.addCustomParam((String)entry.getKey(), (String)entry.getValue());
        }
        return PurAcceptApplyToPuracceptbillService.pushPurAcceptBill(pushArgs);
    }

    public static Map<String, Object> pushPurAcceptBill(ConvertRuleElement element, Map<Long, Collection<Long>> pushOrderData, LinkedHashMap<String, List<Map<String, String>>> rowSalOutInfoMap) {
        String srcEntity = element.getSourceEntityNumber();
        String tarEntity = element.getTargetEntityNumber();
        PushArgs pushArgs = new PushArgs();
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        pushArgs.setSourceEntityNumber(srcEntity);
        pushArgs.setTargetEntityNumber(tarEntity);
        pushArgs.setBuildConvReport(true);
        for (Map.Entry<Long, Collection<Long>> entry : pushOrderData.entrySet()) {
            Long entryKey = entry.getKey();
            for (Long next : entry.getValue()) {
                ListSelectedRow listSelectedRow = new ListSelectedRow();
                listSelectedRow.setPrimaryKeyValue((Object)entryKey);
                listSelectedRow.setEntryEntityKey(PM_PURORDER_ENTRY);
                listSelectedRow.setEntryPrimaryKeyValue((Object)next);
                selectedRowList.add(listSelectedRow);
            }
        }
        pushArgs.setSelectedRows(selectedRowList);
        pushArgs.addCustomParam("splitstrategy", "splitrow");
        pushArgs.addCustomParam("ispur", "true");
        for (Map.Entry<Object, Collection<Object>> entry : rowSalOutInfoMap.entrySet()) {
            pushArgs.addCustomParam((String)entry.getKey(), SerializationUtils.toJsonString(entry.getValue()));
        }
        return PurAcceptApplyToPuracceptbillService.pushPurAcceptBill(pushArgs);
    }

    private static Map<String, Object> pushPurAcceptBill(PushArgs pushArgs) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        returnMap.put("succed", Boolean.FALSE);
        returnMap.put("message", ResManager.loadKDString((String)"\u6ca1\u6709\u6d88\u606f", (String)"PurAcceptApplyToPuracceptbillService_2", (String)"scm-pur-mservice", (Object[])new Object[0]));
        pushArgs.setBuildConvReport(true);
        pushArgs.addCustomParam("botp_outformula", String.valueOf(Boolean.TRUE));
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!result.isSuccess()) {
            returnMap.put("succed", Boolean.FALSE);
            StringBuilder message = new StringBuilder();
            message.append(ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u4e0b\u63a8\u5355\u636e\u5f02\u5e38\u3002", (String)"PurAcceptApplyToPuracceptbillService_3", (String)"scm-pur-mservice", (Object[])new Object[0])).append("\t\n");
            message.append(result.getMessage());
            result.getBillReports().forEach(row -> message.append(row.getFailMessage()));
            returnMap.put("message", message.toString());
            log.info("@@@\u91c7\u8d2d\u8ba2\u5355\u4e0b\u63a8\u91c7\u8d2d\u7ba1\u7406\u9a8c\u6536\u5355\u5f02\u5e38\uff1a" + result.getMessage());
            return returnMap;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)pushArgs.getTargetEntityNumber());
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
            }
        };
        List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
        result.release(refDataProvider, mainType);
        ArrayList pkIds = new ArrayList(targetData.size());
        try {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
            OperationResult operationResult = SaveServiceHelper.saveOperate((String)pushArgs.getTargetEntityNumber(), (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)operateOption);
            if (operationResult != null) {
                if (operationResult.isSuccess() && operationResult.getSuccessPkIds().size() > 0) {
                    pkIds.addAll(operationResult.getSuccessPkIds());
                    returnMap.put("data", pkIds);
                    returnMap.put("targetData", targetData);
                    returnMap.put("message", "ok");
                    returnMap.put("succed", Boolean.TRUE);
                } else {
                    returnMap.put("succed", Boolean.FALSE);
                    StringBuilder messageError = new StringBuilder();
                    messageError.append(operationResult.getMessage()).append("\t\n");
                    operationResult.getAllErrorOrValidateInfo().forEach(row -> messageError.append(row.getMessage()).append("\t\n"));
                    returnMap.put("message", messageError.toString());
                }
            }
        }
        catch (Throwable throwable) {
            log.error(throwable);
            returnMap.put("succed", Boolean.FALSE);
            returnMap.put("message", ExceptionUtil.getStackTrace((Throwable)throwable));
        }
        return returnMap;
    }
}

