/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service.bill;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.pur.business.PurAvailableCheckBasicQtyHelper;
import kd.scm.pur.business.PurAvailableStockBasicQtyHelper;
import kd.scm.pur.service.IPurAvailableStockBasicQtyService;
import kd.scm.sccore.business.OrderAvailableStockQtyHelper;

public final class PurAvailableStockBasicQtyService
implements IPurAvailableStockBasicQtyService {
    private static final Log log = LogFactory.getLog(PurAvailableStockBasicQtyService.class);

    public Map<String, String> queryOrderStockBasicQty(Collection<String> erpOrderEntryIdsParam, Map<String, String> customParamsMap) {
        HashMap<String, String> orderQtyMap = new HashMap<String, String>(1024);
        if (erpOrderEntryIdsParam == null || erpOrderEntryIdsParam.isEmpty()) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u53c2\u6570:erpOrderEntryIdsParam\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u3002", (String)"PurAvailableStockBasicQtyService_0", (String)"scm-pur-mservice", (Object[])new Object[0]));
        }
        String zeroString = BigDecimal.ZERO.toPlainString();
        Map maxOrderStockBasicQtyMap = PurAvailableStockBasicQtyHelper.queryMaxOrderStockBasicQty(erpOrderEntryIdsParam, customParamsMap);
        if (maxOrderStockBasicQtyMap.isEmpty()) {
            erpOrderEntryIdsParam.forEach(row -> orderQtyMap.put((String)row, zeroString));
        } else {
            for (Map.Entry entry : maxOrderStockBasicQtyMap.entrySet()) {
                orderQtyMap.put((String)entry.getKey(), ((BigDecimal)entry.getValue()).toPlainString());
            }
            Set maxOrderStockKeys = maxOrderStockBasicQtyMap.keySet();
            if (maxOrderStockKeys.size() < erpOrderEntryIdsParam.size()) {
                erpOrderEntryIdsParam.forEach(row -> {
                    if (!maxOrderStockKeys.contains(row)) {
                        orderQtyMap.put((String)row, zeroString);
                    }
                });
            }
        }
        if (log.isInfoEnabled()) {
            log.info("PurAvailableStockBasicQtyService#queryEASMaxOrderStockBasicQty#orderQtyMap:{}", (Object)SerializationUtils.toJsonString(orderQtyMap));
        }
        return orderQtyMap;
    }

    public Map<String, String> querySalOutStockBasicQty(Collection<String> salOutStockEntryIdsParam, Map<String, String> customParamsMap) {
        HashMap<String, String> salOutStockBasicQtyMap = new HashMap<String, String>(1024);
        if (salOutStockEntryIdsParam == null || salOutStockEntryIdsParam.isEmpty()) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u53c2\u6570:salOutStockEntryIdsParam\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u3002", (String)"PurAvailableStockBasicQtyService_3", (String)"scm-pur-mservice", (Object[])new Object[0]));
        }
        HashSet salOutEntryIds = new HashSet(1024);
        salOutStockEntryIdsParam.forEach(row -> {
            if (row != null && !row.trim().isEmpty()) {
                salOutEntryIds.add(Long.parseLong(row));
            }
        });
        Map maxOrderStockBasicQtyMap = PurAvailableStockBasicQtyHelper.querySalOutStockBasicQty(salOutEntryIds, customParamsMap);
        String zeroString = BigDecimal.ZERO.toPlainString();
        if (maxOrderStockBasicQtyMap.isEmpty()) {
            salOutStockEntryIdsParam.forEach(row -> salOutStockBasicQtyMap.put((String)row, zeroString));
        } else {
            for (Map.Entry entry : maxOrderStockBasicQtyMap.entrySet()) {
                salOutStockBasicQtyMap.put(((Long)entry.getKey()).toString(), ((BigDecimal)entry.getValue()).toPlainString());
            }
            Set maxOrderStockKeys = maxOrderStockBasicQtyMap.keySet();
            if (maxOrderStockKeys.size() < salOutEntryIds.size()) {
                salOutEntryIds.forEach(row -> {
                    if (!maxOrderStockKeys.contains(row)) {
                        salOutStockBasicQtyMap.put(row.toString(), zeroString);
                    }
                });
            }
        }
        if (log.isInfoEnabled()) {
            log.info("PurAvailableStockBasicQtyService#queryEASMaxOrderStockBasicQty#orderQtyMap:{}", (Object)SerializationUtils.toJsonString(salOutStockBasicQtyMap));
        }
        return salOutStockBasicQtyMap;
    }

    public Map<Long, Map<String, BigDecimal>> getOrderStockBasicQty(Collection<Long> orderEntryIds, Map<String, String> customParamMap) {
        if (orderEntryIds == null || orderEntryIds.isEmpty()) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u53c2\u6570:orderEntryIds\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u3002", (String)"PurAvailableStockBasicQtyService_1", (String)"scm-pur-mservice", (Object[])new Object[0]));
        }
        if (log.isInfoEnabled()) {
            log.info("PurAvailableStockBasicQtyService#queryEASMaxOrderStockBasicQty#orderEntryIds:{},customParamMap:{}", (Object)SerializationUtils.toJsonString(orderEntryIds), (Object)SerializationUtils.toJsonString(customParamMap));
        }
        customParamMap.put("valueproperty", OrderAvailableStockQtyHelper.getTargetWriteBasicQtyProperty((String)customParamMap.get("tgtbilltype")));
        customParamMap.put("getvaluescene", "function");
        Map orderAvailableDataMap = PurAvailableStockBasicQtyHelper.assembleOrderAvailableBasicQty(orderEntryIds, customParamMap);
        if (log.isInfoEnabled()) {
            log.info("PurAvailableStockBasicQtyService#queryEASMaxOrderStockBasicQty#orderAvailableDataMap:{}", (Object)SerializationUtils.toJsonString((Object)orderAvailableDataMap));
        }
        return orderAvailableDataMap;
    }

    public Map<String, BigDecimal> getCoreEntityAvailableBasicQty(Map<String, BigDecimal> coreEntryIdBasicQtyMap, Map<String, String> customParamMap) {
        if (coreEntryIdBasicQtyMap == null || coreEntryIdBasicQtyMap.isEmpty()) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u53c2\u6570:coreEntryIdBasicQtyMap\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u3002", (String)"PurAvailableStockBasicQtyService_2", (String)"scm-pur-mservice", (Object[])new Object[0]));
        }
        if (log.isInfoEnabled()) {
            log.info("PurAvailableStockBasicQtyService#queryEASMaxOrderStockBasicQty#coreEntryIds:{},customParamMap:{}", (Object)SerializationUtils.toJsonString(coreEntryIdBasicQtyMap), (Object)SerializationUtils.toJsonString(customParamMap));
        }
        customParamMap.put("getvaluescene", "validator");
        Map coreEntryBasicQty = PurAvailableStockBasicQtyHelper.assembleOrderVerifyBasicQty(coreEntryIdBasicQtyMap, customParamMap);
        if (log.isInfoEnabled()) {
            log.info("PurAvailableStockBasicQtyService#queryEASMaxOrderStockBasicQty#coreEntryBasicQty:{}", (Object)SerializationUtils.toJsonString((Object)coreEntryBasicQty));
        }
        return coreEntryBasicQty;
    }

    public Collection<String> getTargetWriteProperty(String targetEntity) {
        return PurAvailableStockBasicQtyHelper.getTargetWriteBasicProperty((String)targetEntity, (String)"basicqty");
    }

    public Map<String, String> getValidatorAvailableOperate(String entityNumber) {
        HashMap<String, String> availableOperateMap = new HashMap<String, String>(2);
        Map validatorAvailableOperateMap = PurAvailableStockBasicQtyHelper.getValidatorAvailableOperate((String)entityNumber);
        for (Map.Entry entry : validatorAvailableOperateMap.entrySet()) {
            availableOperateMap.put((String)entry.getKey(), SerializationUtils.toJsonString(entry.getValue()));
        }
        return availableOperateMap;
    }

    public Collection<String> getAvailableQtyField(String entityNumber) {
        return PurAvailableStockBasicQtyHelper.getAvailableQtyField((String)entityNumber, (String)"basicqty");
    }

    public Map<Long, Map<String, BigDecimal>> getAvailableMatchBasicQty(Collection<Long> checkEntryIds, Map<String, String> customParamMap) {
        if (checkEntryIds == null || checkEntryIds.isEmpty()) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u53c2\u6570:checkEntryIds\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u3002", (String)"PurAvailableStockBasicQtyService_4", (String)"scm-pur-mservice", (Object[])new Object[0]));
        }
        if (log.isInfoEnabled()) {
            log.info("PurAvailableStockBasicQtyService#queryEASMaxOrderStockBasicQty#orderEntryIds:{},customParamMap:{}", (Object)SerializationUtils.toJsonString(checkEntryIds), (Object)SerializationUtils.toJsonString(customParamMap));
        }
        Map orderAvailableDataMap = PurAvailableCheckBasicQtyHelper.assembleMatchAvailableBasicQty(checkEntryIds, customParamMap);
        if (log.isInfoEnabled()) {
            log.info("PurAvailableStockBasicQtyService#queryEASMaxOrderStockBasicQty#orderAvailableDataMap:{}", (Object)SerializationUtils.toJsonString((Object)orderAvailableDataMap));
        }
        return orderAvailableDataMap;
    }

    public Map<String, BigDecimal> getAvailableMatchQty(Map<String, Collection<Long>> checkData, Map<String, String> customParamMap) {
        if (checkData == null || checkData.isEmpty()) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u53c2\u6570:checkData\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u3002", (String)"PurAvailableStockBasicQtyService_5", (String)"scm-pur-mservice", (Object[])new Object[0]));
        }
        if (log.isInfoEnabled()) {
            log.info("PurAvailableStockBasicQtyService#queryEASMaxOrderStockBasicQty#orderEntryIds:{},customParamMap:{}", (Object)SerializationUtils.toJsonString(checkData), (Object)SerializationUtils.toJsonString(customParamMap));
        }
        Map orderAvailableDataMap = PurAvailableCheckBasicQtyHelper.assembleAvailableMatchQty(checkData, customParamMap);
        if (log.isInfoEnabled()) {
            log.info("PurAvailableStockBasicQtyService#queryEASMaxOrderStockBasicQty#orderAvailableDataMap:{}", (Object)SerializationUtils.toJsonString((Object)orderAvailableDataMap));
        }
        return orderAvailableDataMap;
    }
}

