/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.ExchangeHelper;
import kd.scm.common.util.mal.MalNewOrderUtils;

public class PurInvoiceRelateErpublicReimburse {
    private static final Log log = LogFactory.getLog((String)PurInvoiceRelateErpublicReimburse.class.getName());
    private static final String ER_PUBLICREIMBURSEBILL = "er_publicreimbursebill";
    private String expenseEntryId;
    private DynamicObject expenseEntry;
    private String invoiceEntryId;
    private String purReceiptEntryId;
    private String purOrderEntryId;
    private Long ecOrderPk;
    private String invoiceType;
    private String invoiceCode;
    private String invoiceNo;
    private BigDecimal invoiceTax;
    private BigDecimal invoiceAmount;
    private String platform;
    private DynamicObject erPublicReimburseDyn;
    private final Map<String, PurInvoiceRelateErpublicReimburse> expenseEntryIdInvoiceRelatedMap = new HashMap<String, PurInvoiceRelateErpublicReimburse>();

    public PurInvoiceRelateErpublicReimburse() {
    }

    public PurInvoiceRelateErpublicReimburse(DynamicObject erPublicReimburseDyn) {
        this.erPublicReimburseDyn = erPublicReimburseDyn;
        DynamicObjectCollection expenseEntryCol = erPublicReimburseDyn.getDynamicObjectCollection("expenseentryentity");
        if (expenseEntryCol.isEmpty()) {
            return;
        }
        HashSet<Long> purReceiptEntryIdSet = new HashSet<Long>();
        HashSet<String> purReceiptEntryIdStrSet = new HashSet<String>();
        for (DynamicObject expEntry : expenseEntryCol) {
            PurInvoiceRelateErpublicReimburse invoiceRelated2 = new PurInvoiceRelateErpublicReimburse();
            invoiceRelated2.expenseEntryId = expEntry.getString("id");
            invoiceRelated2.expenseEntry = expEntry;
            invoiceRelated2.purReceiptEntryId = expEntry.getString("wbsrcentryid");
            purReceiptEntryIdSet.add(Long.valueOf(invoiceRelated2.purReceiptEntryId));
            purReceiptEntryIdStrSet.add(invoiceRelated2.purReceiptEntryId);
            this.expenseEntryIdInvoiceRelatedMap.put(invoiceRelated2.expenseEntryId, invoiceRelated2);
        }
        DynamicObjectCollection purInvoiceCol = this.queryRelatedPurInvoice(purReceiptEntryIdStrSet);
        this.insertErInvoiceEntry(purInvoiceCol, erPublicReimburseDyn);
        DynamicObjectCollection purReceiptEntryCol = this.queryPurReceiptEntry(purReceiptEntryIdSet);
        HashSet<String> purOrderEntryIdSet = new HashSet<String>();
        for (DynamicObject purReceiptEntry : purReceiptEntryCol) {
            this.expenseEntryIdInvoiceRelatedMap.forEach((expEntryId, invoiceRelated) -> {
                if (purReceiptEntry.getString("materialentry.id").equals(invoiceRelated.purReceiptEntryId)) {
                    invoiceRelated.purOrderEntryId = purReceiptEntry.getString("materialentry.poentryid");
                    purOrderEntryIdSet.add(invoiceRelated.purOrderEntryId);
                }
            });
        }
        DynamicObjectCollection purInvoiceEntryCol = this.queryPurInvoiceEntry(purOrderEntryIdSet);
        if (purInvoiceEntryCol.isEmpty()) {
            return;
        }
        HashSet<Long> ecOrderPkSet = new HashSet<Long>();
        for (DynamicObject purInvoiceEntry : purInvoiceEntryCol) {
            this.expenseEntryIdInvoiceRelatedMap.forEach((expEntryId, invoiceRelated) -> {
                if (purInvoiceEntry.getString("entryentity1.poentryid1").equals(invoiceRelated.purOrderEntryId)) {
                    invoiceRelated.ecOrderPk = purInvoiceEntry.getLong("entryentity1.ecorder");
                    invoiceRelated.invoiceType = purInvoiceEntry.getString("invtypeid.number");
                    if (invoiceRelated.ecOrderPk != null && invoiceRelated.ecOrderPk != 0L) {
                        ecOrderPkSet.add(invoiceRelated.ecOrderPk);
                    }
                }
            });
        }
        String source = EcPlatformEnum.ECPLATFORM_SELF.getVal();
        if (ecOrderPkSet.stream().findFirst().isPresent()) {
            source = MalNewOrderUtils.getPlatformByEcOrderPk((Long)((Long)ecOrderPkSet.stream().findFirst().get()));
        }
        this.platform = source;
        String ecEntityKey = MalNewOrderUtils.getPlatformId((String)source);
        if (ecEntityKey == null) {
            return;
        }
        DynamicObjectCollection ecOrderDynCol = this.queryEcOrderDynCol(ecOrderPkSet, ecEntityKey);
        for (DynamicObject ecOrderDyn : ecOrderDynCol) {
            this.expenseEntryIdInvoiceRelatedMap.forEach((expEntryId, invoiceRelated) -> {
                if (invoiceRelated.ecOrderPk != null && ecOrderDyn.getLong("id") == invoiceRelated.ecOrderPk.longValue()) {
                    invoiceRelated.invoiceCode = ecOrderDyn.getString("invoicecode");
                    invoiceRelated.invoiceNo = ecOrderDyn.getString("invoiceid");
                    invoiceRelated.invoiceAmount = ecOrderDyn.getBigDecimal("invoiceamount");
                    invoiceRelated.invoiceTax = ecOrderDyn.getBigDecimal("invoicetax");
                }
            });
        }
        DynamicObjectCollection erInvoiceEntryCol = erPublicReimburseDyn.getDynamicObjectCollection("invoiceentry");
        for (DynamicObject erInvoiceEntry : erInvoiceEntryCol) {
            this.expenseEntryIdInvoiceRelatedMap.forEach((expEntryId, invoiceRelated) -> {
                if (erInvoiceEntry.getString("invoiceno").equals(invoiceRelated.invoiceNo)) {
                    invoiceRelated.invoiceEntryId = erInvoiceEntry.getString("id");
                }
            });
        }
    }

    public PurInvoiceRelateErpublicReimburse related() {
        if (this.erPublicReimburseDyn == null) {
            throw new KDBizException("can not related");
        }
        this.processInvoiceAndExpenseEntry(BusinessDataServiceHelper.loadSingle((Object)this.erPublicReimburseDyn.getPkValue(), (String)ER_PUBLICREIMBURSEBILL));
        return this;
    }

    public PurInvoiceRelateErpublicReimburse handleAfterPush() {
        if (this.erPublicReimburseDyn == null) {
            throw new KDBizException("can not handleAfterPush");
        }
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(this.platform)) {
            this.recalForReceiptReturn();
        } else {
            this.recalForReceiptReturnEc();
        }
        this.handleAccountEntry();
        this.handleErInvoiceEntry();
        this.saveErPublicReimburseBill(this.erPublicReimburseDyn);
        return this;
    }

    private void recalForReceiptReturnEc() {
        Map<String, Map<String, BigDecimal>> purReceiptEntryIdRetMap = this.queryReceiptEntryIdToFiledMap();
        BigDecimal[] approveamount = new BigDecimal[]{this.erPublicReimburseDyn.getBigDecimal("approveamount")};
        purReceiptEntryIdRetMap.forEach((purReceiptEntry, retMap) -> this.expenseEntryIdInvoiceRelatedMap.forEach((expEntryId, invoiceRelated) -> {
            if (invoiceRelated.purReceiptEntryId.equals(purReceiptEntry)) {
                approveamount[0] = approveamount[0].subtract((BigDecimal)retMap.get("sumrecretloctaxamount"));
                BigDecimal expenseamount = invoiceRelated.expenseEntry.getBigDecimal("expenseamount");
                invoiceRelated.expenseEntry.set("expenseamount", (Object)expenseamount.subtract((BigDecimal)retMap.get("sumrecrettaxamount")));
                BigDecimal currexpenseamount = invoiceRelated.expenseEntry.getBigDecimal("currexpenseamount");
                invoiceRelated.expenseEntry.set("currexpenseamount", (Object)currexpenseamount.subtract((BigDecimal)retMap.get("sumrecretloctaxamount")));
                BigDecimal expeapproveamount = invoiceRelated.expenseEntry.getBigDecimal("expeapproveamount");
                invoiceRelated.expenseEntry.set("expeapproveamount", (Object)expeapproveamount.subtract((BigDecimal)retMap.get("sumrecrettaxamount")));
                BigDecimal expeapprovecurramount = invoiceRelated.expenseEntry.getBigDecimal("expeapprovecurramount");
                invoiceRelated.expenseEntry.set("expeapprovecurramount", (Object)expeapprovecurramount.subtract((BigDecimal)retMap.get("sumrecretloctaxamount")));
                BigDecimal orientryamount = invoiceRelated.expenseEntry.getBigDecimal("orientryamount");
                invoiceRelated.expenseEntry.set("orientryamount", (Object)orientryamount.subtract((BigDecimal)retMap.get("sumrecretamount")));
                BigDecimal taxamount = invoiceRelated.expenseEntry.getBigDecimal("taxamount");
                invoiceRelated.expenseEntry.set("taxamount", (Object)taxamount.subtract((BigDecimal)retMap.get("sumrecrettax")));
                BigDecimal price = invoiceRelated.expenseEntry.getBigDecimal("price");
                invoiceRelated.expenseEntry.set("price", (Object)price.subtract((BigDecimal)retMap.get("sumrecretamount")));
                BigDecimal curprice = invoiceRelated.expenseEntry.getBigDecimal("curprice");
                invoiceRelated.expenseEntry.set("curprice", (Object)curprice.subtract((BigDecimal)retMap.get("sumrecretlocamount")));
                BigDecimal approvetax = invoiceRelated.expenseEntry.getBigDecimal("approvetax");
                invoiceRelated.expenseEntry.set("approvetax", (Object)approvetax.subtract((BigDecimal)retMap.get("sumrecrettax")));
            }
        }));
        this.erPublicReimburseDyn.set("reimburseamount", (Object)approveamount[0]);
        this.erPublicReimburseDyn.set("approveamount", (Object)approveamount[0]);
        this.erPublicReimburseDyn.set("payamount", (Object)approveamount[0]);
        this.erPublicReimburseDyn.set("notpayamount", (Object)approveamount[0]);
        DynamicObjectCollection erEntryCol = this.erPublicReimburseDyn.getDynamicObjectCollection("expenseentryentity");
        erEntryCol.clear();
        Collection<PurInvoiceRelateErpublicReimburse> invoiceRelateds = this.expenseEntryIdInvoiceRelatedMap.values();
        for (PurInvoiceRelateErpublicReimburse invoiceRelated : invoiceRelateds) {
            if (invoiceRelated.expenseEntry == null || invoiceRelated.expenseEntry.getBigDecimal("expenseamount").compareTo(BigDecimal.ZERO) <= 0) continue;
            erEntryCol.add((Object)invoiceRelated.expenseEntry);
        }
        if (erEntryCol.isEmpty()) {
            this.rollback();
            throw new KDBizException(ResManager.loadKDString((String)"\u5173\u8054\u6536\u8d27\u884c\u5df2\u5168\u90e8\u9000\u8d27\uff0c\u65e0\u6cd5\u751f\u6210\u5bf9\u516c\u62a5\u9500\u5355\u3002", (String)"PurInvoiceRelateErpublicReimburse_0", (String)"scm-pur-mservice", (Object[])new Object[0]));
        }
    }

    private Map<String, Map<String, BigDecimal>> queryReceiptEntryIdToFiledMap() {
        HashSet purReceiptEntryIdSet = new HashSet(this.expenseEntryIdInvoiceRelatedMap.size());
        this.expenseEntryIdInvoiceRelatedMap.forEach((expEntryId, invoiceRelated) -> purReceiptEntryIdSet.add(invoiceRelated.purReceiptEntryId));
        QFilter filter = new QFilter("materialentry.srcentryid", "in", purReceiptEntryIdSet).and("isreturn", "=", (Object)true);
        String selectFields = "isreturn,id,loccurr.id,curr.id,purorg.id,materialentry.srcentryid,materialentry.qty,materialentry.taxprice,materialentry.price";
        HashMap<String, Map<String, BigDecimal>> purReceiptEntryIdRetMap = new HashMap<String, Map<String, BigDecimal>>(purReceiptEntryIdSet.size());
        HashMap receiptEntryIdExChangeRateMap = new HashMap(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)PurInvoiceRelateErpublicReimburse.class.getName(), (String)"pur_receipt_return", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);){
            ds.forEach(row -> {
                String receiptEntryId = row.getString("materialentry.srcentryid");
                purReceiptEntryIdRetMap.putIfAbsent(receiptEntryId, new HashMap(16));
                Map filedToValueMap = (Map)purReceiptEntryIdRetMap.get(receiptEntryId);
                BigDecimal qty = row.getBigDecimal("materialentry.qty");
                BigDecimal alreadyQty = (BigDecimal)filedToValueMap.get("qty");
                if (alreadyQty != null) {
                    qty = qty.add(alreadyQty);
                }
                filedToValueMap.put("qty", qty);
                BigDecimal exChangeRate = (BigDecimal)receiptEntryIdExChangeRateMap.get(receiptEntryId);
                if (exChangeRate == null) {
                    exChangeRate = ExchangeHelper.getExChangeRateByOrg((Long)row.getLong("loccurr.id"), (Long)row.getLong("curr.id"), (Long)row.getLong("purorg.id"));
                    receiptEntryIdExChangeRateMap.putIfAbsent(receiptEntryId, exChangeRate);
                }
                BigDecimal taxprice = row.getBigDecimal("materialentry.taxprice");
                filedToValueMap.put("taxprice", taxprice);
                BigDecimal price = row.getBigDecimal("materialentry.price");
                filedToValueMap.put("price", price);
            });
        }
        for (Map.Entry entry : purReceiptEntryIdRetMap.entrySet()) {
            String receiptEntryId = (String)entry.getKey();
            Map filedToValueMap = (Map)entry.getValue();
            BigDecimal exChangeRate = (BigDecimal)receiptEntryIdExChangeRateMap.get(receiptEntryId);
            BigDecimal qty = (BigDecimal)filedToValueMap.get("qty");
            BigDecimal taxprice = (BigDecimal)filedToValueMap.get("taxprice");
            BigDecimal price = (BigDecimal)filedToValueMap.get("price");
            BigDecimal sumrecrettaxamount = taxprice.multiply(qty);
            filedToValueMap.putIfAbsent("sumrecrettaxamount", sumrecrettaxamount);
            BigDecimal sumrecretloctaxamount = sumrecrettaxamount.multiply(exChangeRate);
            filedToValueMap.putIfAbsent("sumrecretloctaxamount", sumrecretloctaxamount);
            BigDecimal sumrecretamount = price.multiply(qty);
            filedToValueMap.putIfAbsent("sumrecretamount", sumrecretamount);
            BigDecimal sumrecretlocamount = sumrecretamount.multiply(exChangeRate);
            filedToValueMap.putIfAbsent("sumrecretlocamount", sumrecretlocamount);
            BigDecimal sumrecrettax = sumrecrettaxamount.subtract(sumrecretamount);
            filedToValueMap.putIfAbsent("sumrecrettax", sumrecrettax);
        }
        return purReceiptEntryIdRetMap;
    }

    private void rollback() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationServiceHelper.executeOperate((String)"delete", (String)ER_PUBLICREIMBURSEBILL, (Object[])new Object[]{this.erPublicReimburseDyn.getPkValue()}, (OperateOption)option);
    }

    private void recalForReceiptReturn() {
        HashSet purReceiptEntryIdSet = new HashSet(this.expenseEntryIdInvoiceRelatedMap.size());
        this.expenseEntryIdInvoiceRelatedMap.forEach((expEntryId, invoiceRelated) -> purReceiptEntryIdSet.add(Long.parseLong(invoiceRelated.purReceiptEntryId)));
        QFilter filter = new QFilter("materialentry.id", "in", purReceiptEntryIdSet).and("isreturn", "=", (Object)true);
        String selectFields = "materialentry.id";
        DynamicObjectCollection returnOrderRows = QueryServiceHelper.query((String)"pur_receipt_return", (String)selectFields, (QFilter[])new QFilter[]{filter});
        Set returnOrderEntryIds = returnOrderRows.stream().map(row -> row.getString("materialentry.id")).collect(Collectors.toSet());
        BigDecimal approveamount = BigDecimal.ZERO;
        for (Map.Entry<String, PurInvoiceRelateErpublicReimburse> invoiceRelatedEntry : this.expenseEntryIdInvoiceRelatedMap.entrySet()) {
            PurInvoiceRelateErpublicReimburse invoiceRelated2 = invoiceRelatedEntry.getValue();
            String purReceiptEntryId = invoiceRelated2.purReceiptEntryId;
            if (returnOrderEntryIds.contains(purReceiptEntryId)) {
                BigDecimal expenseamount = invoiceRelated2.expenseEntry.getBigDecimal("expenseamount");
                invoiceRelated2.expenseEntry.set("expenseamount", (Object)expenseamount.negate());
                BigDecimal currexpenseamount = invoiceRelated2.expenseEntry.getBigDecimal("currexpenseamount");
                invoiceRelated2.expenseEntry.set("currexpenseamount", (Object)currexpenseamount.negate());
                BigDecimal expeapproveamount = invoiceRelated2.expenseEntry.getBigDecimal("expeapproveamount");
                invoiceRelated2.expenseEntry.set("expeapproveamount", (Object)expeapproveamount.negate());
                BigDecimal expeapprovecurramount = invoiceRelated2.expenseEntry.getBigDecimal("expeapprovecurramount");
                invoiceRelated2.expenseEntry.set("expeapprovecurramount", (Object)expeapprovecurramount.negate());
                BigDecimal orientryamount = invoiceRelated2.expenseEntry.getBigDecimal("orientryamount");
                invoiceRelated2.expenseEntry.set("orientryamount", (Object)orientryamount.negate());
                BigDecimal taxamount = expenseamount.negate().subtract(orientryamount.negate());
                invoiceRelated2.expenseEntry.set("taxamount", (Object)taxamount);
                invoiceRelated2.expenseEntry.set("approvetax", (Object)taxamount);
                approveamount = approveamount.subtract(currexpenseamount);
                continue;
            }
            BigDecimal currexpenseamount = invoiceRelated2.expenseEntry.getBigDecimal("currexpenseamount");
            approveamount = approveamount.add(currexpenseamount);
        }
        this.erPublicReimburseDyn.set("reimburseamount", (Object)approveamount);
        this.erPublicReimburseDyn.set("approveamount", (Object)approveamount);
        this.erPublicReimburseDyn.set("payamount", (Object)approveamount);
        this.erPublicReimburseDyn.set("notpayamount", (Object)approveamount);
    }

    private void handleAccountEntry() {
        DynamicObjectCollection accountEntryCol = this.erPublicReimburseDyn.getDynamicObjectCollection("accountentry");
        BigDecimal approveAmount = this.erPublicReimburseDyn.getBigDecimal("approveamount");
        BigDecimal expenseAmount = BigDecimal.ZERO;
        for (PurInvoiceRelateErpublicReimburse purInvoiceRelateErpublicReimburse : this.expenseEntryIdInvoiceRelatedMap.values()) {
            if (purInvoiceRelateErpublicReimburse.expenseEntry == null) continue;
            expenseAmount = expenseAmount.add(purInvoiceRelateErpublicReimburse.expenseEntry.getBigDecimal("expenseamount"));
        }
        if (!accountEntryCol.isEmpty()) {
            DynamicObject accountEntry = (DynamicObject)accountEntryCol.get(0);
            accountEntry.set("orireceiveamount", (Object)approveAmount);
            accountEntry.set("receiveamount", (Object)expenseAmount);
            accountEntry.set("accnotpayamount", (Object)approveAmount);
            accountEntry.set("oriaccnotpayamount", (Object)expenseAmount);
            String payeraccount = accountEntry.getString("payeraccount");
            if (StringUtils.isNotBlank((CharSequence)payeraccount) && payeraccount.length() > 4) {
                String payeraccount01 = payeraccount.substring(0, 4) + "******" + payeraccount.substring(payeraccount.length() - 5);
                accountEntry.set("payeraccount01", (Object)payeraccount01);
            }
            accountEntryCol.clear();
            accountEntryCol.add((Object)accountEntry);
        }
    }

    private void handleErInvoiceEntry() {
        DynamicObjectCollection erInvoiceEntryCol = this.erPublicReimburseDyn.getDynamicObjectCollection("invoiceentry");
        for (DynamicObject erInvoiceEntry : erInvoiceEntryCol) {
            for (PurInvoiceRelateErpublicReimburse purInvoiceRelateErpublicReimburse : this.expenseEntryIdInvoiceRelatedMap.values()) {
                if (!erInvoiceEntry.getString("id").equals(purInvoiceRelateErpublicReimburse.invoiceEntryId) || BigDecimal.ZERO.compareTo(purInvoiceRelateErpublicReimburse.invoiceAmount) == 0) continue;
                erInvoiceEntry.set("alltaxrate", (Object)purInvoiceRelateErpublicReimburse.invoiceTax.divide(purInvoiceRelateErpublicReimburse.invoiceAmount, 4).multiply(new BigDecimal("100")).toPlainString());
            }
        }
    }

    private void processInvoiceAndExpenseEntry(DynamicObject erPublicReimburseDyn) {
        Objects.requireNonNull(erPublicReimburseDyn);
        DynamicObjectCollection invoiceAndExpenseEntryCol = erPublicReimburseDyn.getDynamicObjectCollection("invoiceandexpense");
        DynamicObjectCollection expenseEntryCol = erPublicReimburseDyn.getDynamicObjectCollection("expenseentryentity");
        for (DynamicObject expEntry : expenseEntryCol) {
            this.expenseEntryIdInvoiceRelatedMap.forEach((expEntryId, invoiceRelated) -> {
                if (expEntry.getString("id").equals(expEntryId)) {
                    expEntry.set("invoicetypeitem", (Object)invoiceRelated.invoiceType);
                    expEntry.set("invoicelink", (Object)invoiceRelated.invoiceCode);
                    expEntry.set("invoiceno_entry", (Object)invoiceRelated.invoiceNo);
                }
            });
        }
        this.expenseEntryIdInvoiceRelatedMap.forEach((expEntryId, invoiceRelated) -> {
            DynamicObject invoiceAndExpense = new DynamicObject(invoiceAndExpenseEntryCol.getDynamicObjectType());
            invoiceAndExpense.set("expenseentryid", expEntryId);
            invoiceAndExpense.set("invoiceentryid", (Object)invoiceRelated.invoiceEntryId);
            invoiceAndExpenseEntryCol.add((Object)invoiceAndExpense);
        });
        this.saveErPublicReimburseBill(erPublicReimburseDyn);
    }

    private OperationResult saveErPublicReimburseBill(DynamicObject erPublicReimburseDyn) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)ER_PUBLICREIMBURSEBILL, (DynamicObject[])new DynamicObject[]{erPublicReimburseDyn}, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            log.warn("\u4fdd\u5b58\u5bf9\u516c\u62a5\u9500\u5355\u5931\u8d25\uff1a" + ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo()));
        }
        return operationResult;
    }

    private void insertErInvoiceEntry(DynamicObjectCollection purInvoiceCol, DynamicObject erPublicReimburseDyn) {
        DynamicObjectCollection erInvoiceEntryCol = erPublicReimburseDyn.getDynamicObjectCollection("invoiceentry");
        long[] pks = DBServiceHelper.genLongIds((String)"t_er_pubinvoiceandexpense", (int)purInvoiceCol.size());
        int index = 0;
        boolean isHasInvAddr = erInvoiceEntryCol.getDynamicObjectType().getProperties().containsKey((Object)"invaddr");
        for (DynamicObject purInvoiceEntry : purInvoiceCol) {
            DynamicObject erInvoiceEntry = new DynamicObject(erInvoiceEntryCol.getDynamicObjectType());
            erInvoiceEntry.set("id", (Object)pks[index++]);
            erInvoiceEntry.set("invoicetype", (Object)purInvoiceEntry.getString("invtypeid.number"));
            erInvoiceEntry.set("invoicecode", (Object)purInvoiceEntry.getString("entryentity.invcode"));
            erInvoiceEntry.set("invoiceno", (Object)purInvoiceEntry.getString("entryentity.invno"));
            erInvoiceEntry.set("serialno", (Object)purInvoiceEntry.getString("entryentity.invserialnum"));
            erInvoiceEntry.set("invoicedate", (Object)purInvoiceEntry.getDate("entryentity.invdate"));
            erInvoiceEntry.set("totalamount", (Object)purInvoiceEntry.getString("entryentity.invamount"));
            erInvoiceEntry.set("taxamount_invoice", (Object)purInvoiceEntry.getString("entryentity.invtax"));
            erInvoiceEntry.set("invoicenotaxamount", (Object)purInvoiceEntry.getString("entryentity.invoiceamount"));
            erInvoiceEntry.set("invoicefrom", (Object)"5");
            erInvoiceEntry.set("count", (Object)BigDecimal.ONE);
            String invremark = purInvoiceEntry.getString("entryentity.invremark");
            erInvoiceEntry.set("remark_invoice", (Object)(invremark == null || invremark.length() <= 255 ? invremark : invremark.substring(0, 255)));
            if (isHasInvAddr) {
                erInvoiceEntry.set("invaddr", (Object)purInvoiceEntry.getString("entryentity.invaddr"));
            }
            erInvoiceEntryCol.add((Object)erInvoiceEntry);
        }
    }

    private DynamicObjectCollection queryRelatedPurInvoice(Set<String> purReceiptEntryIdSet) {
        if (purReceiptEntryIdSet == null || purReceiptEntryIdSet.isEmpty()) {
            return new DynamicObjectCollection();
        }
        String selectField = "invtypeid.number,entryentity.invcode,entryentity.invno,entryentity.invamount,entryentity.invtax,entryentity.invoiceamount,entryentity.invdate,entryentity.invaddr,entryentity.invremark,entryentity.invserialnum";
        HashSet invCodeSet = new HashSet(purReceiptEntryIdSet.size());
        QFilter qFilter = new QFilter("entryentity1.srcentryid1", "in", purReceiptEntryIdSet);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        DynamicObjectCollection res = QueryServiceHelper.query((String)"pur_invoice", (String)selectField, (QFilter[])qFilter.toArray());
        res.removeIf(purInvoiceEntry -> !invCodeSet.add(purInvoiceEntry.getString("entryentity.invcode")));
        return res;
    }

    private DynamicObjectCollection queryEcOrderDynCol(Set<Long> ecOrderPkSet, String ecEntityKey) {
        return QueryServiceHelper.query((String)ecEntityKey, (String)"id,invoicecode,invoiceid,invoiceamount,invoicetax", (QFilter[])new QFilter[]{new QFilter("id", "in", ecOrderPkSet)});
    }

    private DynamicObjectCollection queryPurInvoiceEntry(Set<String> purOrderEntryIdSet) {
        return QueryServiceHelper.query((String)"pur_invoice", (String)"invtypeid.number,supplier.id,entryentity1.ecorder,entryentity1.poentryid1", (QFilter[])new QFilter[]{new QFilter("entryentity1.poentryid1", "in", purOrderEntryIdSet)});
    }

    private DynamicObjectCollection queryPurReceiptEntry(Set<Long> purReceiptEntryIdSet) {
        return QueryServiceHelper.query((String)"pur_receipt", (String)"id,materialentry.id,materialentry.poentryid", (QFilter[])new QFilter[]{new QFilter("materialentry", "in", purReceiptEntryIdSet)});
    }

    public void writeBackPurInvAfterDelErPublicReimburse(List<String> erBillnos) {
        String selectFields = "billno,entryentity1.isentrypay,entryentity1.entrypaytype,entryentity1.entrypaybillno";
        DynamicObject[] purInvoiceDyns = BusinessDataServiceHelper.load((String)"pur_invoice", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("entryentity1.entrypaytype", "=", (Object)"2").and("entryentity1.entrypaybillno", "in", erBillnos)}, null);
        ArrayList<String> billNos = new ArrayList<String>(purInvoiceDyns.length);
        if (purInvoiceDyns.length > 0) {
            for (DynamicObject purInvoiceDyn : purInvoiceDyns) {
                DynamicObjectCollection entryCol = purInvoiceDyn.getDynamicObjectCollection("entryentity1");
                for (DynamicObject entry : entryCol) {
                    entry.set("isentrypay", (Object)"");
                    entry.set("entrypaytype", (Object)"");
                    entry.set("entrypaybillno", (Object)"");
                }
                billNos.add(purInvoiceDyn.getString("billno"));
            }
            log.info("\u5bf9\u516c\u62a5\u9500\u5355" + erBillnos + "\u5220\u9664\u53cd\u5199\u53d1\u7968\u7b7e\u6536\u5355\uff1a" + billNos);
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])purInvoiceDyns);
        }
    }

    public void writeBackPurInvAfterSaveErPublicReimburse(List<Long> erPks) {
        HashMap<String, String> receiptEntryIdErBillNoMap = new HashMap<String, String>(32);
        try (DataSet erDs = QueryServiceHelper.queryDataSet((String)PurInvoiceRelateErpublicReimburse.class.getName(), (String)ER_PUBLICREIMBURSEBILL, (String)"billno,expenseentryentity.wbsrcbillid,expenseentryentity.wbsrcentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", erPks).and("expenseentryentity.wbsrcbilltype", "=", (Object)"pur_receipt")}, null);){
            erDs.forEach(row -> receiptEntryIdErBillNoMap.put(row.getString("expenseentryentity.wbsrcentryid"), row.getString("billno")));
        }
        log.info("\u53cd\u5199\u6570\u636ereceiptEntryIdErBillnoMap\uff1a" + receiptEntryIdErBillNoMap);
        if (receiptEntryIdErBillNoMap.isEmpty()) {
            return;
        }
        this.writeBackPurInvByPoentryIdErBillNoMap(receiptEntryIdErBillNoMap);
    }

    public void writeBackPurInvByPoentryIdErBillNoMap(Map<String, String> purReceiptIdErBillNoMap) {
        log.info("\u53cd\u5199\u6570\u636epurReceiptIdErBillNoMap\uff1a" + purReceiptIdErBillNoMap);
        if (purReceiptIdErBillNoMap.isEmpty()) {
            return;
        }
        String selectFields = "entryentity1.isentrypay,entryentity1.entrypaytype,entryentity1.entrypaybillno,entryentity1.srcentryid1";
        DynamicObject[] purInvoiceDyns = BusinessDataServiceHelper.load((String)"pur_invoice", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("cfmstatus", "=", (Object)"B").and("entryentity1.srcentryid1", "in", purReceiptIdErBillNoMap.keySet())}, null);
        if (purInvoiceDyns.length > 0) {
            for (DynamicObject purInvoiceDyn : purInvoiceDyns) {
                DynamicObjectCollection entryCol = purInvoiceDyn.getDynamicObjectCollection("entryentity1");
                for (DynamicObject entry : entryCol) {
                    entry.set("isentrypay", (Object)"1");
                    entry.set("entrypaytype", (Object)"2");
                    entry.set("entrypaybillno", (Object)purReceiptIdErBillNoMap.get(entry.getString("srcentryid1")));
                }
            }
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])purInvoiceDyns);
        }
    }
}

