/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.ExceptionUtil;

public class ActivePurOrderChangeEventService
implements IEventServicePlugin {
    private static final Log log = LogFactory.getLog(ActivePurOrderChangeEventService.class);

    public Object handleEvent(KDBizEvent e) {
        if (e instanceof EntityEvent) {
            EntityEvent event = (EntityEvent)e;
            String entityNumber = event.getEntityNumber();
            String operation = event.getOperation();
            List businesskeys = event.getBusinesskeys();
            if (StringUtils.isBlank((CharSequence)entityNumber) || StringUtils.isBlank((CharSequence)operation) || businesskeys == null || businesskeys.size() == 0) {
                log.info("\u4e8b\u4ef6\u8ba2\u9605\u7684\u53c2\u6570\u4e3a\u7a7a");
                return e.getEventId();
            }
            if ("pm_xpurorderbill".equals(entityNumber) && "active".equals(operation) || "pm_xspurorderbill".equals(entityNumber) && "bizvalid".equals(operation)) {
                OperationResult bills;
                List<Long> ids = businesskeys.stream().map(item -> Long.parseLong(item)).collect(Collectors.toList());
                if (ids == null) {
                    log.info("\u4e8b\u4ef6\u8ba2\u9605\u7684\u53c2\u6570\u4e3a\u7a7a");
                    return e.getEventId();
                }
                HashSet purOrdChangesSet = null;
                AtomicInteger atomicInteger = new AtomicInteger(1);
                int maxRetry = 3;
                long sleepMillis = 2000L;
                StringBuilder exceptionMessage = new StringBuilder();
                while (atomicInteger.getAndIncrement() <= maxRetry && (purOrdChangesSet == null || purOrdChangesSet.size() != ids.size())) {
                    Map findTargetPurOrdChanges = BFTrackerServiceHelper.findTargetBills((String)"pm_xpurorderbill", (Long[])ids.toArray(new Long[0]));
                    HashSet hashSet = purOrdChangesSet = findTargetPurOrdChanges == null ? null : (HashSet)findTargetPurOrdChanges.get("pur_ordchange");
                    if (log.isDebugEnabled()) {
                        log.debug("@@@ActivePurOrderChangeEventService\uff0c\u7b2c\u51e0\u6b21\u91cd\u8bd5\uff1a" + atomicInteger.get());
                    }
                    try {
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException ex) {
                        exceptionMessage.append(ex.getMessage());
                    }
                }
                if (log.isWarnEnabled()) {
                    log.warn("exceptionMessage:{}", (Object)exceptionMessage);
                }
                QFilter qFilter = new QFilter("id", "in", (Object)purOrdChangesSet);
                qFilter.and("cfmstatus", "=", (Object)"A");
                DynamicObject[] scpOrdChangeDynArray = BusinessDataServiceHelper.load((String)"pur_ordchange", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (scpOrdChangeDynArray != null && scpOrdChangeDynArray.length > 0) {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("isStrict", "false");
                    option.setVariableValue("ishasright", String.valueOf(true));
                    ArrayList<Long> idList = new ArrayList<Long>(scpOrdChangeDynArray.length);
                    DynamicObject[] dynamicObjectArray = scpOrdChangeDynArray;
                    int n = dynamicObjectArray.length;
                    for (int i = 0; i < n; ++i) {
                        DynamicObject dynamicObject = dynamicObjectArray[i];
                        idList.add(dynamicObject.getLong("id"));
                    }
                    OperationResult confirmPurOrder = OperationServiceHelper.executeOperate((String)"agreeorderchange", (String)"scp_ordchange", (Object[])idList.toArray(), (OperateOption)option);
                    if (!confirmPurOrder.isSuccess()) {
                        String errorInfoDetails = ExceptionUtil.getErrorInfoDetails((List)confirmPurOrder.getAllErrorOrValidateInfo());
                        log.info("@@@ActivePurOrderChangeEventService:purOrdChange failed to confirm,reason:" + errorInfoDetails);
                    }
                }
                HashMap param = new HashMap();
                for (DynamicObject bill : bills = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"pm_xpurorderbill").getDynamicObjectType())) {
                    HashSet hashSet;
                    long sourceId;
                    if (!"B".equals(bill.getString("confirmstatus")) || 0L == (sourceId = bill.getLong("sourceid"))) continue;
                    Map findTargetBills = BFTrackerServiceHelper.findTargetBills((String)"pm_purorderbill", (Long[])new Long[]{sourceId});
                    HashSet hashSet2 = hashSet = findTargetBills == null ? null : (HashSet)findTargetBills.get("pur_order");
                    if (hashSet == null || hashSet.size() <= 0) continue;
                    ArrayList orderIDs = new ArrayList(hashSet);
                    param.put(orderIDs.get(0), bill);
                }
                if (param != null && param.size() > 0) {
                    boolean success;
                    log.info("\u8c03\u7528\u63a5\u53e3 IBillGenericService.purOrderBillActiveToPurOrderOp \u53c2\u6570 --> " + param);
                    Map result = new HashMap();
                    try {
                        result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"purOrderBillActiveToPurOrderOp", (Object[])new Object[]{param});
                    }
                    catch (Exception excep) {
                        log.info(excep.getMessage());
                        log.info("\u8c03\u7528\u534f\u540c\u5fae\u670d\u52a1IBillGenericService.purOrderBillActiveToPurOrderOp\u5f02\u5e38");
                        return e.getEventId();
                    }
                    log.info("\u8c03\u7528\u63a5\u53e3 IBillGenericService.purOrderBillActiveToPurOrderOp \u7ed3\u679c --> " + result);
                    if (result != null && !(success = ((Boolean)result.get("success")).booleanValue())) {
                        log.info("\u8c03\u7528\u534f\u540c\u5fae\u670d\u52a1IBillGenericService.purOrderBillActiveToPurOrderOp\u8fd4\u56de\u7ed3\u679c\u5931\u8d25\uff1a" + result);
                        throw new KDBizException((String)result.get("message"));
                    }
                }
            }
        } else {
            log.info("\u4e8b\u4ef6\u8ba2\u9605\u7ed1\u5b9a\u7684\u4e8b\u4ef6\u5b9a\u4e49\u4e0d\u662f\u64cd\u4f5c\u4e8b\u4ef6");
        }
        return e.getEventId();
    }
}

