/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class DeletePurReceiptEventService
implements IEventServicePlugin {
    private static final Log log = LogFactory.getLog(DeletePurReceiptEventService.class);

    public Object handleEvent(KDBizEvent e) {
        List<String> acceptBillIds = this.getAcceptBillIds(e);
        if (acceptBillIds == null || acceptBillIds.isEmpty()) {
            log.info("\u83b7\u53d6\u9a8c\u6536\u5355id\u5931\u8d25\uff0c\u7ed3\u675f\u9a8c\u6536\u5355\u53cd\u5ba1\u6838\u4e8b\u4ef6");
            return e.getEventId();
        }
        log.info("\u91c7\u8d2d\u9a8c\u6536\u5355\u53cd\u5ba1\u6838\uff1a" + acceptBillIds);
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"pm_puracceptbill", (Long[])((Long[])acceptBillIds.stream().map(Long::parseLong).toArray(Long[]::new)));
        if (targetBills == null || targetBills.isEmpty()) {
            log.info("\u91c7\u8d2d\u9a8c\u6536\u5355\u65e0\u4e0b\u6e38\u5355\u636e\uff0c\u7ed3\u675f\u9a8c\u6536\u5355\u53cd\u5ba1\u6838\u4e8b\u4ef6");
            return e.getEventId();
        }
        this.deletePurBill("pur_receipt", targetBills);
        this.deletePurBill("pur_receipt_return", targetBills);
        return e.getEventId();
    }

    private List<String> getAcceptBillIds(KDBizEvent e) {
        if (!(e instanceof EntityEvent)) {
            log.info("\u4e8b\u4ef6\u8ba2\u9605\u7ed1\u5b9a\u7684\u4e8b\u4ef6\u5b9a\u4e49\u4e0d\u662f\u64cd\u4f5c\u4e8b\u4ef6");
            return null;
        }
        EntityEvent event = (EntityEvent)e;
        String entityNumber = event.getEntityNumber();
        String operation = event.getOperation();
        if (!"pm_puracceptbill".equals(entityNumber) || !"unaudit".equals(operation)) {
            log.info("\u975e\u91c7\u8d2d\u9a8c\u6536\u5355\u53cd\u5ba1\u6838\u4e8b\u4ef6");
            return null;
        }
        return event.getBusinesskeys();
    }

    private void deletePurBill(String billName, Map<String, HashSet<Long>> targetBills) {
        Set toDeleteBills = targetBills.get(billName);
        if (toDeleteBills == null || toDeleteBills.isEmpty()) {
            log.info("\u9a8c\u6536\u5355\u4e0b\u6e38\u5355\u636e\u65e0\uff1a" + billName);
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("ids", new ArrayList(toDeleteBills));
        param.put("entityName", billName);
        log.info("\u8c03\u7528\u63a5\u53e3 IBillGenericService.unAuditAndDeleteBill \u53c2\u6570 --> " + param);
        try {
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"unAuditAndDeleteBill", (Object[])new Object[]{param});
            log.info("\u8c03\u7528\u63a5\u53e3 IBillGenericService.unAuditAndDeleteBill \u7ed3\u679c --> " + result);
            if (result == null) {
                return;
            }
            Boolean success = (Boolean)result.get("success");
            if (success != null && !success.booleanValue()) {
                log.info("\u8c03\u7528\u534f\u540c\u5fae\u670d\u52a1IBillGenericService.unAuditAndDeleteBill\u8fd4\u56de\u7ed3\u679c\u5931\u8d25\uff1a" + result);
                throw new KDBizException((String)result.get("message"));
            }
        }
        catch (Exception ex) {
            log.info("\u8c03\u7528\u534f\u540c\u5fae\u670d\u52a1IBillGenericService.unAuditAndDeleteBill\u5f02\u5e38", (Object)ex);
        }
    }
}

