/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service.jointplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.scm.common.helper.multisystemjoint.business.MultiJointParamServiceProxyHelper;
import kd.scm.common.helper.multisystemjoint.entity.ScDataMultiJointChannelInfo;
import kd.scm.common.helper.multisystemjoint.param.ScMultiCosmicIscParamArgs;
import kd.scm.common.helper.multisystemjoint.param.ScMultiParamArgs;
import kd.scm.common.helper.multisystemjoint.param.plugin.AbstractCustomParamPlugin;
import kd.scm.common.systemjoint.SystemJointChannelHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.pur.business.PurBatchStockHelper;

public final class PurBatchStockReceiveForEasStdPlugin
extends AbstractCustomParamPlugin {
    public ScMultiParamArgs assembleJointParam(List<DynamicObject> dynamicObjects) {
        ScMultiCosmicIscParamArgs multiCosmicIscParamArgs = new ScMultiCosmicIscParamArgs();
        String botpNumber = (String)this.getMultiCustomParam().get((Object)"botpNumber");
        Map batchExtEntryPro = PurBatchStockHelper.assembleBatchExtEntryPro();
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        HashMap<String, String> org_IdMap = new HashMap<String, String>(1024);
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, Object> detailMap = new HashMap<String, Object>();
            Object srcEntryId = dynamicObject.get("poentryid1");
            if (srcEntryId == null || srcEntryId.toString().trim().isEmpty()) continue;
            DynamicObject orgDyn = dynamicObject.getDynamicObject("org1");
            org_IdMap.put(orgDyn.getString("number"), orgDyn.getString("id"));
            BigDecimal recieveQty = CommonUtil.getBigDecimalPro((Object)dynamicObject.get("receiveqty1"));
            String entryIdStr = dynamicObject.getString("entryid1");
            String billIdStr = dynamicObject.getString("billid1");
            String billNoStr = dynamicObject.getString("billno1");
            Date proddate = dynamicObject.getDate("proddate1");
            Date duedate = dynamicObject.getDate("duedate1");
            String lot1 = dynamicObject.getString("lot1");
            String suplot1 = dynamicObject.getString("suplot1");
            detailMap.put("entryId", srcEntryId);
            detailMap.put("billid", dynamicObject.get("pobillid1"));
            detailMap.put("qty", recieveQty);
            detailMap.put("srcEntryId", entryIdStr);
            detailMap.put("srcBillId", billIdStr);
            detailMap.put("srcBillNo", billNoStr);
            detailMap.put("proddate", proddate == null ? "" : DateUtil.date2str((Date)proddate, (String)"yyyy-MM-dd"));
            detailMap.put("mfg", proddate == null ? "" : proddate);
            detailMap.put("duedate", duedate == null ? "" : DateUtil.date2str((Date)duedate, (String)"yyyy-MM-dd"));
            detailMap.put("exp", duedate == null ? "" : duedate);
            detailMap.put("lot", lot1);
            detailMap.put("suplot", suplot1);
            if (SystemJointChannelHelper.hasSpecJointType((String)this.getScDataChannelInfo().getChannelId(), (String)"eas")) {
                detailMap.put("extFieldSet", batchExtEntryPro.values());
            }
            detailMap.putAll(PurBatchStockHelper.assembleExtStockData((DynamicObject)dynamicObject, (Map)batchExtEntryPro));
            dataMap.put(entryIdStr, detailMap);
        }
        if (!dataMap.isEmpty()) {
            HashMap groupedData = new HashMap();
            dataMap.forEach((key, val) -> {
                Map data = (Map)val;
                String srcBillId = String.valueOf(data.get("srcBillId"));
                ArrayList<Map> list = (ArrayList<Map>)groupedData.get(srcBillId);
                if (list == null) {
                    list = new ArrayList<Map>();
                }
                list.add(data);
                groupedData.put(srcBillId, list);
            });
            dataMap.put("billstatus1", org_IdMap);
            dataMap.put("billstatus", ParamUtil.getParam((String)"eae607fb000143ac", (String)"recbillstatus"));
            dataMap.put("botpNumber", botpNumber);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tobilltype", "receive");
            param.put("billtype", "pur_outstock");
            param.put("data", groupedData);
            param.put("action", "receive");
            param.put("code", "200");
            multiCosmicIscParamArgs.getStdDelegate().setCloudId("isc");
            multiCosmicIscParamArgs.getStdDelegate().setAppId("iscb");
            multiCosmicIscParamArgs.setIscLinkNumber(this.getScDataChannelInfo().getIscLinkNumber());
            multiCosmicIscParamArgs.setIscSourceNumber(this.getScDataChannelInfo().getIscDataSourceNumber());
            String facdeService = "facade://com.kingdee.eas.scm.nsrm.app.BizDealFacade:doIerp2Receive";
            MultiJointParamServiceProxyHelper.modifyIscJointParamArgs((ScMultiCosmicIscParamArgs)multiCosmicIscParamArgs, (ScDataMultiJointChannelInfo)this.getScDataChannelInfo(), (String)facdeService);
            multiCosmicIscParamArgs.putCustomMap("data", param);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ScpOrderConfirmForEasPlugin#multiCosmicIscParamArgs:{}", (Object)SerializationUtils.toJsonString((Object)multiCosmicIscParamArgs));
        }
        return multiCosmicIscParamArgs;
    }
}

